/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PropertyPane {
    private final BindingContext bindingContext;

    public PropertyPane(PropertySet propertySet) {
        this(new BindingContext(propertySet));
    }

    public PropertyPane(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public JPanel createPanel() {
        PropertySet propertyContainer = this.bindingContext.getPropertySet();
        Property[] properties = propertyContainer.getProperties();
        boolean displayUnitColumn = this.wantDisplayUnitColumn(properties);
        TableLayout layout = new TableLayout(displayUnitColumn ? 3 : 2);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(3, 3);
        JPanel panel = new JPanel(layout);
        int rowIndex = 0;
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        for (Property property : properties) {
            PropertyDescriptor descriptor = property.getDescriptor();
            if (this.isInvisible(descriptor)) continue;
            PropertyEditor propertyEditor = registry.findPropertyEditor(descriptor);
            JComponent[] components = propertyEditor.createComponents(descriptor, this.bindingContext);
            if (components.length == 2) {
                layout.setCellWeightX(rowIndex, 0, 0.0);
                panel.add((Component)components[1], TableLayout.cell(rowIndex, 0));
                layout.setCellWeightX(rowIndex, 1, 1.0);
                if (components[0] instanceof JScrollPane) {
                    layout.setRowWeightY(rowIndex, 1.0);
                    layout.setRowFill(rowIndex, TableLayout.Fill.BOTH);
                }
                panel.add((Component)components[0], TableLayout.cell(rowIndex, 1));
            } else {
                layout.setCellColspan(rowIndex, 0, 2);
                layout.setCellWeightX(rowIndex, 0, 1.0);
                panel.add((Component)components[0], TableLayout.cell(rowIndex, 0));
            }
            if (displayUnitColumn) {
                JLabel label = new JLabel("");
                if (descriptor.getUnit() != null) {
                    label.setText(descriptor.getUnit());
                }
                layout.setCellWeightX(rowIndex, 2, 0.0);
                panel.add((Component)label, TableLayout.cell(rowIndex, 2));
            }
            ++rowIndex;
        }
        layout.setCellColspan(rowIndex, 0, 2);
        layout.setCellWeightX(rowIndex, 0, 1.0);
        layout.setCellWeightY(rowIndex, 0, 0.5);
        panel.add(new JPanel());
        return panel;
    }

    private boolean isInvisible(PropertyDescriptor descriptor) {
        return Boolean.FALSE.equals(descriptor.getAttribute("visible")) || descriptor.isDeprecated();
    }

    private boolean wantDisplayUnitColumn(Property[] models) {
        boolean showUnitColumn = false;
        for (Property model : models) {
            String unit;
            PropertyDescriptor descriptor = model.getDescriptor();
            if (this.isInvisible(descriptor) || (unit = descriptor.getUnit()) == null || unit.length() == 0) continue;
            showUnitColumn = true;
            break;
        }
        return showUnitColumn;
    }
}

