/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.core.runtime.RuntimeContext;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.RepositoryScanner;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleManager;
import com.bc.ceres.swing.update.ModuleSyncRunner;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class DefaultModuleManager
implements ModuleManager {
    private ModuleContext context;
    private URL repositoryUrl;
    private ProxyConfig proxyConfig;
    private Module[] installedModules;
    private ArrayList<File> generatedFileList;
    private ModuleItem[] installedModuleItems;
    private ModuleItem[] updatableModuleItems;
    private ModuleItem[] availableModuleItems;

    public DefaultModuleManager() {
        this(RuntimeContext.getModuleContext());
    }

    public DefaultModuleManager(ModuleContext context) {
        this.context = context;
        this.proxyConfig = ProxyConfig.NULL;
        this.generatedFileList = new ArrayList(8);
    }

    @Override
    public URL getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(URL repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public Module[] getInstalledModules() {
        if (this.installedModules == null) {
            this.installedModules = this.context.getModules();
        }
        return this.installedModules;
    }

    @Override
    public Module[] getRepositoryModules(ProgressMonitor pm) throws CoreException {
        if (this.repositoryUrl == null) {
            throw new CoreException("Repository URL not set.");
        }
        this.context.getLogger().info("Connecting repository using " + this.repositoryUrl);
        RepositoryScanner repositoryScanner = new RepositoryScanner(this.context.getLogger(), this.repositoryUrl, this.proxyConfig);
        return repositoryScanner.scan(pm);
    }

    @Override
    public ModuleItem[] getInstalledModuleItems() {
        if (this.installedModuleItems == null) {
            this.installedModuleItems = DefaultModuleManager.toModuleItems(this.getInstalledModules());
        }
        return this.installedModuleItems;
    }

    @Override
    public ModuleItem[] getUpdatableModuleItems() {
        if (this.updatableModuleItems == null) {
            return new ModuleItem[0];
        }
        return this.updatableModuleItems;
    }

    @Override
    public ModuleItem[] getAvailableModuleItems() {
        if (this.availableModuleItems == null) {
            return new ModuleItem[0];
        }
        return this.availableModuleItems;
    }

    @Override
    public void synchronizeWithRepository(ProgressMonitor pm) throws CoreException {
        this.availableModuleItems = ModuleSyncRunner.sync(this.getInstalledModuleItems(), this.getRepositoryModules(pm));
        this.updatableModuleItems = DefaultModuleManager.extractUpdates(this.getInstalledModuleItems());
    }

    @Override
    public Module installModule(Module newModule, ProgressMonitor pm) throws CoreException {
        URL location = newModule.getLocation();
        Module installedModule = this.context.installModule(location, this.proxyConfig, pm);
        this.generatedFileList.add(new File(installedModule.getLocation().getPath()));
        return installedModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module updateModule(Module oldModule, Module newModule, ProgressMonitor pm) throws CoreException {
        pm.beginTask("Updating module", 100);
        try {
            Module installedModule = this.installModule(newModule, SubProgressMonitor.create((ProgressMonitor)pm, (int)50));
            this.uninstallModule(oldModule, SubProgressMonitor.create((ProgressMonitor)pm, (int)50));
            Module module = installedModule;
            return module;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void uninstallModule(Module oldModule, ProgressMonitor pm) throws CoreException {
        oldModule.uninstall(pm);
        File file = new File(oldModule.getLocation().getPath());
        this.generatedFileList.add(new File(file.getParent(), file.getName() + ".uninstall"));
    }

    @Override
    public void startTransaction() {
        this.generatedFileList.clear();
    }

    @Override
    public void endTransaction() {
        this.generatedFileList.clear();
    }

    @Override
    public void rollbackTransaction() {
        for (File file : this.generatedFileList) {
            try {
                this.context.getLogger().info(String.format("Module manager rollback: Deleting file [%s]", file));
                if (file.delete()) continue;
                file.deleteOnExit();
            }
            catch (Exception e) {
                this.context.getLogger().severe(String.format("Module manager rollback: %s", e.getMessage()));
            }
        }
    }

    private static ModuleItem[] toModuleItems(Module[] modules) {
        ModuleItem[] items = new ModuleItem[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            ModuleImpl module = (ModuleImpl)modules[i];
            items[i] = new ModuleItem(module);
        }
        return items;
    }

    private static ModuleItem[] extractUpdates(ModuleItem[] moduleItems) {
        ArrayList<ModuleItem> updates = new ArrayList<ModuleItem>(moduleItems.length);
        for (ModuleItem installedModuleItem : moduleItems) {
            if (installedModuleItem.getRepositoryModule() == null) continue;
            updates.add(installedModuleItem);
        }
        return updates.toArray(new ModuleItem[updates.size()]);
    }
}

