/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.collocation;

import com.bc.ceres.binding.Property;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.collocation.ResamplingType;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;

@OperatorMetadata(alias="Collocate", category="Geometric Operations", version="1.1", authors="Ralf Quast, Norman Fomferra", copyright="(c) 2007-2011 by Brockmann Consult", description="Collocates two products based on their geo-codings.")
public class CollocateOp
extends Operator {
    public static final String SOURCE_NAME_REFERENCE = "${ORIGINAL_NAME}";
    public static final String DEFAULT_MASTER_COMPONENT_PATTERN = "${ORIGINAL_NAME}_M";
    public static final String DEFAULT_SLAVE_COMPONENT_PATTERN = "${ORIGINAL_NAME}_S";
    private static final String NEAREST_NEIGHBOUR = "NEAREST_NEIGHBOUR";
    private static final String BILINEAR_INTERPOLATION = "BILINEAR_INTERPOLATION";
    private static final String CUBIC_CONVOLUTION = "CUBIC_CONVOLUTION";
    @SourceProduct(alias="master", description="The source product which serves as master.")
    private Product masterProduct;
    @SourceProduct(alias="slave", description="The source product which serves as slave.")
    private Product slaveProduct;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct;
    @Parameter(defaultValue="_collocated", description="The name of the target product")
    @Deprecated
    private String targetProductName;
    @Parameter(defaultValue="COLLOCATED", description="The product type string for the target product (informal)")
    private String targetProductType;
    @Parameter(defaultValue="true", description="Whether or nor components of the master product shall be renamed in the target product.")
    private boolean renameMasterComponents;
    @Parameter(defaultValue="true", description="Whether or nor components of the slave product shall be renamed in the target product.")
    private boolean renameSlaveComponents;
    @Parameter(defaultValue="${ORIGINAL_NAME}_M", description="The text pattern to be used when renaming master components.")
    private String masterComponentPattern;
    @Parameter(defaultValue="${ORIGINAL_NAME}_S", description="The text pattern to be used when renaming slave components.")
    private String slaveComponentPattern;
    @Parameter(defaultValue="NEAREST_NEIGHBOUR", description="The method to be used when resampling the slave grid onto the master grid.")
    private ResamplingType resamplingType;
    private transient Map<Band, RasterDataNode> sourceRasterMap;

    public Product getMasterProduct() {
        return this.masterProduct;
    }

    public void setMasterProduct(Product masterProduct) {
        this.masterProduct = masterProduct;
    }

    public Product getSlaveProduct() {
        return this.slaveProduct;
    }

    public void setSlaveProduct(Product slaveProduct) {
        this.slaveProduct = slaveProduct;
    }

    public String getTargetProductType() {
        return this.targetProductType;
    }

    public void setTargetProductType(String targetProductType) {
        this.targetProductType = targetProductType;
    }

    public boolean getRenameMasterComponents() {
        return this.renameMasterComponents;
    }

    public void setRenameMasterComponents(boolean renameMasterComponents) {
        this.renameMasterComponents = renameMasterComponents;
    }

    public boolean getRenameSlaveComponents() {
        return this.renameSlaveComponents;
    }

    public void setRenameSlaveComponents(boolean renameSlaveComponents) {
        this.renameSlaveComponents = renameSlaveComponents;
    }

    public String getMasterComponentPattern() {
        return this.masterComponentPattern;
    }

    public void setMasterComponentPattern(String masterComponentPattern) {
        this.masterComponentPattern = masterComponentPattern;
    }

    public String getSlaveComponentPattern() {
        return this.slaveComponentPattern;
    }

    public void setSlaveComponentPattern(String slaveComponentPattern) {
        this.slaveComponentPattern = slaveComponentPattern;
    }

    public ResamplingType getResamplingType() {
        return this.resamplingType;
    }

    public void setResamplingType(ResamplingType resamplingType) {
        this.resamplingType = resamplingType;
    }

    public void initialize() throws OperatorException {
        Band targetBand;
        String targetBandName;
        ProductData.UTC utc2;
        if (this.masterProduct.getGeoCoding() == null) {
            throw new OperatorException(MessageFormat.format("Product ''{0}'' has no geo-coding.", this.masterProduct.getName()));
        }
        if (this.slaveProduct.getGeoCoding() == null) {
            throw new OperatorException(MessageFormat.format("Product ''{0}'' has no geo-coding.", this.slaveProduct.getName()));
        }
        if (this.renameMasterComponents && StringUtils.isNullOrEmpty((String)this.masterComponentPattern)) {
            throw new OperatorException(MessageFormat.format("Parameter ''{0}'' must be set to a non-empty string pattern.", "masterComponentPattern"));
        }
        if (this.renameSlaveComponents && StringUtils.isNullOrEmpty((String)this.slaveComponentPattern)) {
            throw new OperatorException(MessageFormat.format("Parameter ''{0}'' must be set to a non-empty string pattern.", "slaveComponentPattern"));
        }
        this.sourceRasterMap = new HashMap<Band, RasterDataNode>(31);
        this.targetProduct = new Product(this.targetProductName != null ? this.targetProductName : this.masterProduct.getName() + "_" + this.slaveProduct.getName(), this.targetProductType != null ? this.targetProductType : this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        ProductData.UTC utc1 = this.masterProduct.getStartTime();
        if (utc1 != null) {
            this.targetProduct.setStartTime(new ProductData.UTC(utc1.getMJD()));
        }
        if ((utc2 = this.masterProduct.getEndTime()) != null) {
            this.targetProduct.setEndTime(new ProductData.UTC(utc2.getMJD()));
        }
        ProductUtils.copyMetadata((Product)this.masterProduct, (Product)this.targetProduct);
        ProductUtils.copyTiePointGrids((Product)this.masterProduct, (Product)this.targetProduct);
        for (Band band : this.masterProduct.getBands()) {
            Band targetBand2 = ProductUtils.copyBand((String)band.getName(), (Product)this.masterProduct, (Product)this.targetProduct, (boolean)true);
            CollocateOp.setFlagCoding(targetBand2, band.getFlagCoding(), this.renameMasterComponents, this.masterComponentPattern);
            this.sourceRasterMap.put(targetBand2, (RasterDataNode)band);
        }
        if (this.renameMasterComponents) {
            for (Band band : this.targetProduct.getBands()) {
                band.setName(this.masterComponentPattern.replace(SOURCE_NAME_REFERENCE, band.getName()));
            }
        }
        this.copyMasks(this.masterProduct, this.renameMasterComponents, this.masterComponentPattern);
        for (Band band : this.slaveProduct.getBands()) {
            targetBandName = band.getName();
            if (this.renameSlaveComponents) {
                targetBandName = this.slaveComponentPattern.replace(SOURCE_NAME_REFERENCE, targetBandName);
            }
            targetBand = this.targetProduct.addBand(targetBandName, band.getDataType());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetBand);
            CollocateOp.setFlagCoding(targetBand, band.getFlagCoding(), this.renameSlaveComponents, this.slaveComponentPattern);
            this.sourceRasterMap.put(targetBand, (RasterDataNode)band);
        }
        for (Band band : this.slaveProduct.getTiePointGrids()) {
            targetBandName = band.getName();
            if (this.renameSlaveComponents) {
                targetBandName = this.slaveComponentPattern.replace(SOURCE_NAME_REFERENCE, targetBandName);
            }
            targetBand = this.targetProduct.addBand(targetBandName, band.getDataType());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetBand);
            this.sourceRasterMap.put(targetBand, (RasterDataNode)band);
        }
        for (Band band : this.targetProduct.getBands()) {
            for (Band targetBandInner : this.targetProduct.getBands()) {
                RasterDataNode sourceRaster = this.sourceRasterMap.get(targetBandInner);
                if (sourceRaster == null || sourceRaster.getProduct() != this.slaveProduct) continue;
                band.updateExpression(BandArithmetic.createExternalName((String)sourceRaster.getName()), BandArithmetic.createExternalName((String)targetBandInner.getName()));
            }
        }
        ProductUtils.copyGeoCoding((Product)this.masterProduct, (Product)this.targetProduct);
        this.copyMasks(this.slaveProduct, this.renameSlaveComponents, this.slaveComponentPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        pm.beginTask("Collocating bands...", this.targetProduct.getNumBands() + 1);
        try {
            PixelPos[] sourcePixelPositions = ProductUtils.computeSourcePixelCoordinates((GeoCoding)this.slaveProduct.getGeoCoding(), (int)this.slaveProduct.getSceneRasterWidth(), (int)this.slaveProduct.getSceneRasterHeight(), (GeoCoding)this.masterProduct.getGeoCoding(), (Rectangle)targetRectangle);
            Rectangle sourceRectangle = CollocateOp.getBoundingBox(sourcePixelPositions, this.slaveProduct.getSceneRasterWidth(), this.slaveProduct.getSceneRasterHeight());
            pm.worked(1);
            for (Band targetBand : this.targetProduct.getBands()) {
                this.checkForCancellation();
                RasterDataNode sourceRaster = this.sourceRasterMap.get(targetBand);
                Tile targetTile = targetTileMap.get(targetBand);
                this.collocateSourceBand(sourceRaster, sourceRectangle, sourcePixelPositions, targetTile, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            }
        }
        finally {
            pm.done();
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        RasterDataNode sourceRaster = this.sourceRasterMap.get(targetBand);
        if (sourceRaster.getProduct() == this.slaveProduct) {
            PixelPos[] sourcePixelPositions = ProductUtils.computeSourcePixelCoordinates((GeoCoding)this.slaveProduct.getGeoCoding(), (int)this.slaveProduct.getSceneRasterWidth(), (int)this.slaveProduct.getSceneRasterHeight(), (GeoCoding)this.masterProduct.getGeoCoding(), (Rectangle)targetTile.getRectangle());
            Rectangle sourceRectangle = CollocateOp.getBoundingBox(sourcePixelPositions, this.slaveProduct.getSceneRasterWidth(), this.slaveProduct.getSceneRasterHeight());
            this.collocateSourceBand(sourceRaster, sourceRectangle, sourcePixelPositions, targetTile, pm);
        } else {
            targetTile.setRawSamples(this.getSourceTile(sourceRaster, targetTile.getRectangle()).getRawSamples());
        }
    }

    public void dispose() {
        this.sourceRasterMap = null;
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collocateSourceBand(RasterDataNode sourceBand, Rectangle sourceRectangle, PixelPos[] sourcePixelPositions, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block15: {
            pm.beginTask(MessageFormat.format("collocating band {0}", sourceBand.getName()), targetTile.getHeight());
            try {
                RasterDataNode targetBand = targetTile.getRasterDataNode();
                Rectangle targetRectangle = targetTile.getRectangle();
                int sourceRasterHeight = this.slaveProduct.getSceneRasterHeight();
                int sourceRasterWidth = this.slaveProduct.getSceneRasterWidth();
                Resampling resampling = CollocateOp.isFlagBand(sourceBand) || CollocateOp.isValidPixelExpressionUsed(sourceBand) ? ResamplingType.NEAREST_NEIGHBOUR.getResampling() : this.resamplingType.getResampling();
                Resampling.Index resamplingIndex = resampling.createIndex();
                double noDataValue = targetBand.getGeophysicalNoDataValue();
                if (sourceRectangle != null) {
                    Tile sourceTile = this.getSourceTile(sourceBand, sourceRectangle);
                    ResamplingRaster resamplingRaster = new ResamplingRaster(sourceTile);
                    int index = 0;
                    for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                        int x = targetRectangle.x;
                        while (x < targetRectangle.x + targetRectangle.width) {
                            PixelPos sourcePixelPos = sourcePixelPositions[index];
                            if (sourcePixelPos != null) {
                                double sample;
                                resampling.computeIndex((double)sourcePixelPos.x, (double)sourcePixelPos.y, sourceRasterWidth, sourceRasterHeight, resamplingIndex);
                                if (resampling == Resampling.NEAREST_NEIGHBOUR) {
                                    sample = sourceTile.getSampleDouble((int)resamplingIndex.i0, (int)resamplingIndex.j0);
                                } else {
                                    try {
                                        sample = resampling.resample((Resampling.Raster)resamplingRaster, resamplingIndex);
                                    }
                                    catch (Exception e) {
                                        throw new OperatorException(e.getMessage());
                                    }
                                }
                                if (Double.isNaN(sample)) {
                                    sample = noDataValue;
                                }
                                targetTile.setSample(x, y, sample);
                            } else {
                                targetTile.setSample(x, y, noDataValue);
                            }
                            ++x;
                            ++index;
                        }
                        this.checkForCancellation();
                        pm.worked(1);
                    }
                    break block15;
                }
                int index = 0;
                for (int y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                    int x = targetRectangle.x;
                    while (x < targetRectangle.x + targetRectangle.width) {
                        targetTile.setSample(x, y, noDataValue);
                        ++x;
                        ++index;
                    }
                    this.checkForCancellation();
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private void copyMasks(Product sourceProduct, boolean rename, String pattern) {
        Mask[] masks;
        ProductNodeGroup maskGroup = sourceProduct.getMaskGroup();
        for (Mask mask : masks = (Mask[])maskGroup.toArray((ProductNode[])new Mask[maskGroup.getNodeCount()])) {
            Mask.ImageType imageType = mask.getImageType();
            Mask newmask = new Mask(mask.getName(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight(), imageType);
            newmask.setDescription(mask.getDescription());
            for (Property property : mask.getImageConfig().getProperties()) {
                newmask.getImageConfig().setValue(property.getDescriptor().getName(), property.getValue());
            }
            if (rename) {
                newmask.setName(pattern.replace(SOURCE_NAME_REFERENCE, mask.getName()));
                for (Property property : this.targetProduct.getBands()) {
                    RasterDataNode srcRDN = this.sourceRasterMap.get(property);
                    if (srcRDN == null) continue;
                    newmask.updateExpression(BandArithmetic.createExternalName((String)srcRDN.getName()), BandArithmetic.createExternalName((String)property.getName()));
                }
            }
            this.targetProduct.getMaskGroup().add((ProductNode)newmask);
        }
    }

    private static void setFlagCoding(Band band, FlagCoding flagCoding, boolean rename, String pattern) {
        if (flagCoding != null) {
            Product product;
            String flagCodingName = flagCoding.getName();
            if (rename) {
                flagCodingName = pattern.replace(SOURCE_NAME_REFERENCE, flagCodingName);
            }
            if (!(product = band.getProduct()).getFlagCodingGroup().contains(flagCodingName)) {
                CollocateOp.addFlagCoding(product, flagCoding, flagCodingName);
            }
            band.setSampleCoding((SampleCoding)product.getFlagCodingGroup().get(flagCodingName));
        }
    }

    private static void addFlagCoding(Product product, FlagCoding flagCoding, String flagCodingName) {
        FlagCoding targetFlagCoding = new FlagCoding(flagCodingName);
        targetFlagCoding.setDescription(flagCoding.getDescription());
        ProductUtils.copyMetadata((MetadataElement)flagCoding, (MetadataElement)targetFlagCoding);
        product.getFlagCodingGroup().add((ProductNode)targetFlagCoding);
    }

    private static Rectangle getBoundingBox(PixelPos[] pixelPositions, int maxWidth, int maxHeight) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (PixelPos pixelsPos : pixelPositions) {
            if (pixelsPos == null) continue;
            int x = (int)Math.floor(pixelsPos.getX());
            int y = (int)Math.floor(pixelsPos.getY());
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (minX > maxX || minY > maxY) {
            return null;
        }
        minX = Math.max(minX - 2, 0);
        maxX = Math.min(maxX + 2, maxWidth - 1);
        minY = Math.max(minY - 2, 0);
        maxY = Math.min(maxY + 2, maxHeight - 1);
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    private static boolean isFlagBand(RasterDataNode sourceRaster) {
        return sourceRaster instanceof Band && ((Band)sourceRaster).isFlagBand();
    }

    private static boolean isValidPixelExpressionUsed(RasterDataNode sourceRaster) {
        String validPixelExpression = sourceRaster.getValidPixelExpression();
        return validPixelExpression != null && !validPixelExpression.trim().isEmpty();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CollocateOp.class);
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;

        public ResamplingRaster(Tile tile) {
            this.tile = tile;
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) {
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    samples[i][j] = this.tile.getSampleDouble(x[j], y[i]);
                    if (!this.isNoDataValue(samples[i][j])) continue;
                    allValid = false;
                }
            }
            return allValid;
        }

        private boolean isNoDataValue(double sample) {
            RasterDataNode rasterDataNode = this.tile.getRasterDataNode();
            if (rasterDataNode.isNoDataValueUsed()) {
                if (rasterDataNode.isScalingApplied()) {
                    return rasterDataNode.getGeophysicalNoDataValue() == sample;
                }
                return rasterDataNode.getNoDataValue() == sample;
            }
            return false;
        }
    }
}

