/*
 * Copyright (C) 2010 Brockmann Consult GmbH (info@brockmann-consult.de)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see http://www.gnu.org/licenses/
 */
package org.esa.beam.util.geotiff;

public class EPSGCodes extends IntMap {

    /* Generated from file epsg_vertcs.properties */
    public static final int VertCS_Airy_1830_ellipsoid = 5001;
    public static final int VertCS_Airy_Modified_1849_ellipsoid = 5002;
    public static final int VertCS_ANS_ellipsoid = 5003;
    public static final int VertCS_Bessel_1841_ellipsoid = 5004;
    public static final int VertCS_Bessel_Modified_ellipsoid = 5005;
    public static final int VertCS_Bessel_Namibia_ellipsoid = 5006;
    public static final int VertCS_Clarke_1858_ellipsoid = 5007;
    public static final int VertCS_Clarke_1866_ellipsoid = 5008;
    public static final int VertCS_Clarke_1880_Benoit_ellipsoid = 5010;
    public static final int VertCS_Clarke_1880_IGN_ellipsoid = 5011;
    public static final int VertCS_Clarke_1880_RGS_ellipsoid = 5012;
    public static final int VertCS_Clarke_1880_Arc_ellipsoid = 5013;
    public static final int VertCS_Clarke_1880_SGA_1922_ellipsoid = 5014;
    public static final int VertCS_Everest_1830_1937_Adjustment_ellipsoid = 5015;
    public static final int VertCS_Everest_1830_1967_Definition_ellipsoid = 5016;
    public static final int VertCS_Everest_1830_1975_Definition_ellipsoid = 5017;
    public static final int VertCS_Everest_1830_Modified_ellipsoid = 5018;
    public static final int VertCS_GRS_1980_ellipsoid = 5019;
    public static final int VertCS_Helmert_1906_ellipsoid = 5020;
    public static final int VertCS_INS_ellipsoid = 5021;
    public static final int VertCS_International_1924_ellipsoid = 5022;
    public static final int VertCS_International_1967_ellipsoid = 5023;
    public static final int VertCS_Krassowsky_1940_ellipsoid = 5024;
    public static final int VertCS_NWL_9D_ellipsoid = 5025;
    public static final int VertCS_NWL_10D_ellipsoid = 5026;
    public static final int VertCS_Plessis_1817_ellipsoid = 5027;
    public static final int VertCS_Struve_1860_ellipsoid = 5028;
    public static final int VertCS_War_Office_ellipsoid = 5029;
    public static final int VertCS_WGS_84_ellipsoid = 5030;
    public static final int VertCS_GEM_10C_ellipsoid = 5031;
    public static final int VertCS_OSU86F_ellipsoid = 5032;
    public static final int VertCS_OSU91A_ellipsoid = 5033;
    public static final int VertCS_Newlyn = 5101;
    public static final int VertCS_North_American_Vertical_Datum_1929 = 5102;
    public static final int VertCS_North_American_Vertical_Datum_1988 = 5103;
    public static final int VertCS_Yellow_Sea_1956 = 5104;
    public static final int VertCS_Baltic_Sea = 5105;
    public static final int VertCS_Caspian_Sea = 5106;
    /* Generated from file epsg_unit.properties */
    public static final int Linear_Meter = 9001;
    public static final int Linear_Foot = 9002;
    public static final int Linear_Foot_US_Survey = 9003;
    public static final int Linear_Foot_Modified_American = 9004;
    public static final int Linear_Foot_Clarke = 9005;
    public static final int Linear_Foot_Indian = 9006;
    public static final int Linear_Link = 9007;
    public static final int Linear_Link_Benoit = 9008;
    public static final int Linear_Link_Sears = 9009;
    public static final int Linear_Chain_Benoit = 9010;
    public static final int Linear_Chain_Sears = 9011;
    public static final int Linear_Yard_Sears = 9012;
    public static final int Linear_Yard_Indian = 9013;
    public static final int Linear_Fathom = 9014;
    public static final int Linear_Mile_International_Nautical = 9015;
    public static final int Angular_Radian = 9101;
    public static final int Angular_Degree = 9102;
    public static final int Angular_Arc_Minute = 9103;
    public static final int Angular_Arc_Second = 9104;
    public static final int Angular_Grad = 9105;
    public static final int Angular_Gon = 9106;
    public static final int Angular_DMS = 9107;
    public static final int Angular_DMS_Hemisphere = 9108;
    /* Generated from file epsg_proj.properties */
    public static final int Proj_Alabama_CS27_East = 10101;
    public static final int Proj_Alabama_CS27_West = 10102;
    public static final int Proj_Alabama_CS83_East = 10131;
    public static final int Proj_Alabama_CS83_West = 10132;
    public static final int Proj_Arizona_Coordinate_System_east = 10201;
    public static final int Proj_Arizona_Coordinate_System_Central = 10202;
    public static final int Proj_Arizona_Coordinate_System_west = 10203;
    public static final int Proj_Arizona_CS83_east = 10231;
    public static final int Proj_Arizona_CS83_Central = 10232;
    public static final int Proj_Arizona_CS83_west = 10233;
    public static final int Proj_Arkansas_CS27_North = 10301;
    public static final int Proj_Arkansas_CS27_South = 10302;
    public static final int Proj_Arkansas_CS83_North = 10331;
    public static final int Proj_Arkansas_CS83_South = 10332;
    public static final int Proj_California_CS27_I = 10401;
    public static final int Proj_California_CS27_II = 10402;
    public static final int Proj_California_CS27_III = 10403;
    public static final int Proj_California_CS27_IV = 10404;
    public static final int Proj_California_CS27_V = 10405;
    public static final int Proj_California_CS27_VI = 10406;
    public static final int Proj_California_CS27_VII = 10407;
    public static final int Proj_California_CS83_1 = 10431;
    public static final int Proj_California_CS83_2 = 10432;
    public static final int Proj_California_CS83_3 = 10433;
    public static final int Proj_California_CS83_4 = 10434;
    public static final int Proj_California_CS83_5 = 10435;
    public static final int Proj_California_CS83_6 = 10436;
    public static final int Proj_Colorado_CS27_North = 10501;
    public static final int Proj_Colorado_CS27_Central = 10502;
    public static final int Proj_Colorado_CS27_South = 10503;
    public static final int Proj_Colorado_CS83_North = 10531;
    public static final int Proj_Colorado_CS83_Central = 10532;
    public static final int Proj_Colorado_CS83_South = 10533;
    public static final int Proj_Connecticut_CS27 = 10600;
    public static final int Proj_Connecticut_CS83 = 10630;
    public static final int Proj_Delaware_CS27 = 10700;
    public static final int Proj_Delaware_CS83 = 10730;
    public static final int Proj_Florida_CS27_East = 10901;
    public static final int Proj_Florida_CS27_West = 10902;
    public static final int Proj_Florida_CS27_North = 10903;
    public static final int Proj_Florida_CS83_East = 10931;
    public static final int Proj_Florida_CS83_West = 10932;
    public static final int Proj_Florida_CS83_North = 10933;
    public static final int Proj_Georgia_CS27_East = 11001;
    public static final int Proj_Georgia_CS27_West = 11002;
    public static final int Proj_Georgia_CS83_East = 11031;
    public static final int Proj_Georgia_CS83_West = 11032;
    public static final int Proj_Idaho_CS27_East = 11101;
    public static final int Proj_Idaho_CS27_Central = 11102;
    public static final int Proj_Idaho_CS27_West = 11103;
    public static final int Proj_Idaho_CS83_East = 11131;
    public static final int Proj_Idaho_CS83_Central = 11132;
    public static final int Proj_Idaho_CS83_West = 11133;
    public static final int Proj_Illinois_CS27_East = 11201;
    public static final int Proj_Illinois_CS27_West = 11202;
    public static final int Proj_Illinois_CS83_East = 11231;
    public static final int Proj_Illinois_CS83_West = 11232;
    public static final int Proj_Indiana_CS27_East = 11301;
    public static final int Proj_Indiana_CS27_West = 11302;
    public static final int Proj_Indiana_CS83_East = 11331;
    public static final int Proj_Indiana_CS83_West = 11332;
    public static final int Proj_Iowa_CS27_North = 11401;
    public static final int Proj_Iowa_CS27_South = 11402;
    public static final int Proj_Iowa_CS83_North = 11431;
    public static final int Proj_Iowa_CS83_South = 11432;
    public static final int Proj_Kansas_CS27_North = 11501;
    public static final int Proj_Kansas_CS27_South = 11502;
    public static final int Proj_Kansas_CS83_North = 11531;
    public static final int Proj_Kansas_CS83_South = 11532;
    public static final int Proj_Kentucky_CS27_North = 11601;
    public static final int Proj_Kentucky_CS27_South = 11602;
    public static final int Proj_Kentucky_CS83_North = 11631;
    public static final int Proj_Kentucky_CS83_South = 11632;
    public static final int Proj_Louisiana_CS27_North = 11701;
    public static final int Proj_Louisiana_CS27_South = 11702;
    public static final int Proj_Louisiana_CS83_North = 11731;
    public static final int Proj_Louisiana_CS83_South = 11732;
    public static final int Proj_Maine_CS27_East = 11801;
    public static final int Proj_Maine_CS27_West = 11802;
    public static final int Proj_Maine_CS83_East = 11831;
    public static final int Proj_Maine_CS83_West = 11832;
    public static final int Proj_Maryland_CS27 = 11900;
    public static final int Proj_Maryland_CS83 = 11930;
    public static final int Proj_Massachusetts_CS27_Mainland = 12001;
    public static final int Proj_Massachusetts_CS27_Island = 12002;
    public static final int Proj_Massachusetts_CS83_Mainland = 12031;
    public static final int Proj_Massachusetts_CS83_Island = 12032;
    public static final int Proj_Michigan_State_Plane_East = 12101;
    public static final int Proj_Michigan_State_Plane_Old_Central = 12102;
    public static final int Proj_Michigan_State_Plane_West = 12103;
    public static final int Proj_Michigan_CS27_North = 12111;
    public static final int Proj_Michigan_CS27_Central = 12112;
    public static final int Proj_Michigan_CS27_South = 12113;
    public static final int Proj_Michigan_CS83_North = 12141;
    public static final int Proj_Michigan_CS83_Central = 12142;
    public static final int Proj_Michigan_CS83_South = 12143;
    public static final int Proj_Minnesota_CS27_North = 12201;
    public static final int Proj_Minnesota_CS27_Central = 12202;
    public static final int Proj_Minnesota_CS27_South = 12203;
    public static final int Proj_Minnesota_CS83_North = 12231;
    public static final int Proj_Minnesota_CS83_Central = 12232;
    public static final int Proj_Minnesota_CS83_South = 12233;
    public static final int Proj_Mississippi_CS27_East = 12301;
    public static final int Proj_Mississippi_CS27_West = 12302;
    public static final int Proj_Mississippi_CS83_East = 12331;
    public static final int Proj_Mississippi_CS83_West = 12332;
    public static final int Proj_Missouri_CS27_East = 12401;
    public static final int Proj_Missouri_CS27_Central = 12402;
    public static final int Proj_Missouri_CS27_West = 12403;
    public static final int Proj_Missouri_CS83_East = 12431;
    public static final int Proj_Missouri_CS83_Central = 12432;
    public static final int Proj_Missouri_CS83_West = 12433;
    public static final int Proj_Montana_CS27_North = 12501;
    public static final int Proj_Montana_CS27_Central = 12502;
    public static final int Proj_Montana_CS27_South = 12503;
    public static final int Proj_Montana_CS83 = 12530;
    public static final int Proj_Nebraska_CS27_North = 12601;
    public static final int Proj_Nebraska_CS27_South = 12602;
    public static final int Proj_Nebraska_CS83 = 12630;
    public static final int Proj_Nevada_CS27_East = 12701;
    public static final int Proj_Nevada_CS27_Central = 12702;
    public static final int Proj_Nevada_CS27_West = 12703;
    public static final int Proj_Nevada_CS83_East = 12731;
    public static final int Proj_Nevada_CS83_Central = 12732;
    public static final int Proj_Nevada_CS83_West = 12733;
    public static final int Proj_New_Hampshire_CS27 = 12800;
    public static final int Proj_New_Hampshire_CS83 = 12830;
    public static final int Proj_New_Jersey_CS27 = 12900;
    public static final int Proj_New_Jersey_CS83 = 12930;
    public static final int Proj_New_Mexico_CS27_East = 13001;
    public static final int Proj_New_Mexico_CS27_Central = 13002;
    public static final int Proj_New_Mexico_CS27_West = 13003;
    public static final int Proj_New_Mexico_CS83_East = 13031;
    public static final int Proj_New_Mexico_CS83_Central = 13032;
    public static final int Proj_New_Mexico_CS83_West = 13033;
    public static final int Proj_New_York_CS27_East = 13101;
    public static final int Proj_New_York_CS27_Central = 13102;
    public static final int Proj_New_York_CS27_West = 13103;
    public static final int Proj_New_York_CS27_Long_Island = 13104;
    public static final int Proj_New_York_CS83_East = 13131;
    public static final int Proj_New_York_CS83_Central = 13132;
    public static final int Proj_New_York_CS83_West = 13133;
    public static final int Proj_New_York_CS83_Long_Island = 13134;
    public static final int Proj_North_Carolina_CS27 = 13200;
    public static final int Proj_North_Carolina_CS83 = 13230;
    public static final int Proj_North_Dakota_CS27_North = 13301;
    public static final int Proj_North_Dakota_CS27_South = 13302;
    public static final int Proj_North_Dakota_CS83_North = 13331;
    public static final int Proj_North_Dakota_CS83_South = 13332;
    public static final int Proj_Ohio_CS27_North = 13401;
    public static final int Proj_Ohio_CS27_South = 13402;
    public static final int Proj_Ohio_CS83_North = 13431;
    public static final int Proj_Ohio_CS83_South = 13432;
    public static final int Proj_Oklahoma_CS27_North = 13501;
    public static final int Proj_Oklahoma_CS27_South = 13502;
    public static final int Proj_Oklahoma_CS83_North = 13531;
    public static final int Proj_Oklahoma_CS83_South = 13532;
    public static final int Proj_Oregon_CS27_North = 13601;
    public static final int Proj_Oregon_CS27_South = 13602;
    public static final int Proj_Oregon_CS83_North = 13631;
    public static final int Proj_Oregon_CS83_South = 13632;
    public static final int Proj_Pennsylvania_CS27_North = 13701;
    public static final int Proj_Pennsylvania_CS27_South = 13702;
    public static final int Proj_Pennsylvania_CS83_North = 13731;
    public static final int Proj_Pennsylvania_CS83_South = 13732;
    public static final int Proj_Rhode_Island_CS27 = 13800;
    public static final int Proj_Rhode_Island_CS83 = 13830;
    public static final int Proj_South_Carolina_CS27_North = 13901;
    public static final int Proj_South_Carolina_CS27_South = 13902;
    public static final int Proj_South_Carolina_CS83 = 13930;
    public static final int Proj_South_Dakota_CS27_North = 14001;
    public static final int Proj_South_Dakota_CS27_South = 14002;
    public static final int Proj_South_Dakota_CS83_North = 14031;
    public static final int Proj_South_Dakota_CS83_South = 14032;
    public static final int Proj_Tennessee_CS27 = 14100;
    public static final int Proj_Tennessee_CS83 = 14130;
    public static final int Proj_Texas_CS27_North = 14201;
    public static final int Proj_Texas_CS27_North_Central = 14202;
    public static final int Proj_Texas_CS27_Central = 14203;
    public static final int Proj_Texas_CS27_South_Central = 14204;
    public static final int Proj_Texas_CS27_South = 14205;
    public static final int Proj_Texas_CS83_North = 14231;
    public static final int Proj_Texas_CS83_North_Central = 14232;
    public static final int Proj_Texas_CS83_Central = 14233;
    public static final int Proj_Texas_CS83_South_Central = 14234;
    public static final int Proj_Texas_CS83_South = 14235;
    public static final int Proj_Utah_CS27_North = 14301;
    public static final int Proj_Utah_CS27_Central = 14302;
    public static final int Proj_Utah_CS27_South = 14303;
    public static final int Proj_Utah_CS83_North = 14331;
    public static final int Proj_Utah_CS83_Central = 14332;
    public static final int Proj_Utah_CS83_South = 14333;
    public static final int Proj_Vermont_CS27 = 14400;
    public static final int Proj_Vermont_CS83 = 14430;
    public static final int Proj_Virginia_CS27_North = 14501;
    public static final int Proj_Virginia_CS27_South = 14502;
    public static final int Proj_Virginia_CS83_North = 14531;
    public static final int Proj_Virginia_CS83_South = 14532;
    public static final int Proj_Washington_CS27_North = 14601;
    public static final int Proj_Washington_CS27_South = 14602;
    public static final int Proj_Washington_CS83_North = 14631;
    public static final int Proj_Washington_CS83_South = 14632;
    public static final int Proj_West_Virginia_CS27_North = 14701;
    public static final int Proj_West_Virginia_CS27_South = 14702;
    public static final int Proj_West_Virginia_CS83_North = 14731;
    public static final int Proj_West_Virginia_CS83_South = 14732;
    public static final int Proj_Wisconsin_CS27_North = 14801;
    public static final int Proj_Wisconsin_CS27_Central = 14802;
    public static final int Proj_Wisconsin_CS27_South = 14803;
    public static final int Proj_Wisconsin_CS83_North = 14831;
    public static final int Proj_Wisconsin_CS83_Central = 14832;
    public static final int Proj_Wisconsin_CS83_South = 14833;
    public static final int Proj_Wyoming_CS27_East = 14901;
    public static final int Proj_Wyoming_CS27_East_Central = 14902;
    public static final int Proj_Wyoming_CS27_West_Central = 14903;
    public static final int Proj_Wyoming_CS27_West = 14904;
    public static final int Proj_Wyoming_CS83_East = 14931;
    public static final int Proj_Wyoming_CS83_East_Central = 14932;
    public static final int Proj_Wyoming_CS83_West_Central = 14933;
    public static final int Proj_Wyoming_CS83_West = 14934;
    public static final int Proj_Alaska_CS27_1 = 15001;
    public static final int Proj_Alaska_CS27_2 = 15002;
    public static final int Proj_Alaska_CS27_3 = 15003;
    public static final int Proj_Alaska_CS27_4 = 15004;
    public static final int Proj_Alaska_CS27_5 = 15005;
    public static final int Proj_Alaska_CS27_6 = 15006;
    public static final int Proj_Alaska_CS27_7 = 15007;
    public static final int Proj_Alaska_CS27_8 = 15008;
    public static final int Proj_Alaska_CS27_9 = 15009;
    public static final int Proj_Alaska_CS27_10 = 15010;
    public static final int Proj_Alaska_CS83_1 = 15031;
    public static final int Proj_Alaska_CS83_2 = 15032;
    public static final int Proj_Alaska_CS83_3 = 15033;
    public static final int Proj_Alaska_CS83_4 = 15034;
    public static final int Proj_Alaska_CS83_5 = 15035;
    public static final int Proj_Alaska_CS83_6 = 15036;
    public static final int Proj_Alaska_CS83_7 = 15037;
    public static final int Proj_Alaska_CS83_8 = 15038;
    public static final int Proj_Alaska_CS83_9 = 15039;
    public static final int Proj_Alaska_CS83_10 = 15040;
    public static final int Proj_Hawaii_CS27_1 = 15101;
    public static final int Proj_Hawaii_CS27_2 = 15102;
    public static final int Proj_Hawaii_CS27_3 = 15103;
    public static final int Proj_Hawaii_CS27_4 = 15104;
    public static final int Proj_Hawaii_CS27_5 = 15105;
    public static final int Proj_Hawaii_CS83_1 = 15131;
    public static final int Proj_Hawaii_CS83_2 = 15132;
    public static final int Proj_Hawaii_CS83_3 = 15133;
    public static final int Proj_Hawaii_CS83_4 = 15134;
    public static final int Proj_Hawaii_CS83_5 = 15135;
    public static final int Proj_Puerto_Rico_CS27 = 15201;
    public static final int Proj_St_Croix = 15202;
    public static final int Proj_Puerto_Rico_Virgin_Is = 15230;
    public static final int Proj_BLM_14N_feet = 15914;
    public static final int Proj_BLM_15N_feet = 15915;
    public static final int Proj_BLM_16N_feet = 15916;
    public static final int Proj_BLM_17N_feet = 15917;
    public static final int Proj_Map_Grid_of_Australia_48 = 17348;
    public static final int Proj_Map_Grid_of_Australia_49 = 17349;
    public static final int Proj_Map_Grid_of_Australia_50 = 17350;
    public static final int Proj_Map_Grid_of_Australia_51 = 17351;
    public static final int Proj_Map_Grid_of_Australia_52 = 17352;
    public static final int Proj_Map_Grid_of_Australia_53 = 17353;
    public static final int Proj_Map_Grid_of_Australia_54 = 17354;
    public static final int Proj_Map_Grid_of_Australia_55 = 17355;
    public static final int Proj_Map_Grid_of_Australia_56 = 17356;
    public static final int Proj_Map_Grid_of_Australia_57 = 17357;
    public static final int Proj_Map_Grid_of_Australia_58 = 17358;
    public static final int Proj_Australian_Map_Grid_48 = 17448;
    public static final int Proj_Australian_Map_Grid_49 = 17449;
    public static final int Proj_Australian_Map_Grid_50 = 17450;
    public static final int Proj_Australian_Map_Grid_51 = 17451;
    public static final int Proj_Australian_Map_Grid_52 = 17452;
    public static final int Proj_Australian_Map_Grid_53 = 17453;
    public static final int Proj_Australian_Map_Grid_54 = 17454;
    public static final int Proj_Australian_Map_Grid_55 = 17455;
    public static final int Proj_Australian_Map_Grid_56 = 17456;
    public static final int Proj_Australian_Map_Grid_57 = 17457;
    public static final int Proj_Australian_Map_Grid_58 = 17458;
    public static final int Proj_Argentina_1 = 18031;
    public static final int Proj_Argentina_2 = 18032;
    public static final int Proj_Argentina_3 = 18033;
    public static final int Proj_Argentina_4 = 18034;
    public static final int Proj_Argentina_5 = 18035;
    public static final int Proj_Argentina_6 = 18036;
    public static final int Proj_Argentina_7 = 18037;
    public static final int Proj_Colombia_3W = 18051;
    public static final int Proj_Colombia_Bogota = 18052;
    public static final int Proj_Colombia_3E = 18053;
    public static final int Proj_Colombia_6E = 18054;
    public static final int Proj_Egypt_Red_Belt = 18072;
    public static final int Proj_Egypt_Purple_Belt = 18073;
    public static final int Proj_Extended_Purple_Belt = 18074;
    public static final int Proj_New_Zealand_North_Island_Nat_Grid = 18141;
    public static final int Proj_New_Zealand_South_Island_Nat_Grid = 18142;
    public static final int Proj_Bahrain_Grid = 19900;
    public static final int Proj_Netherlands_E_Indies_Equatorial = 19905;
    public static final int Proj_RSO_Borneo = 19912;
    /* Generated from file epsg_pm.properties */
    public static final int PM_Greenwich = 8901;
    public static final int PM_Lisbon = 8902;
    public static final int PM_Paris = 8903;
    public static final int PM_Bogota = 8904;
    public static final int PM_Madrid = 8905;
    public static final int PM_Rome = 8906;
    public static final int PM_Bern = 8907;
    public static final int PM_Jakarta = 8908;
    public static final int PM_Ferro = 8909;
    public static final int PM_Brussels = 8910;
    public static final int PM_Stockholm = 8911;
    /* Generated from file epsg_pcs.properties */
    public static final int PCS_Adindan_UTM_zone_37N = 20137;
    public static final int PCS_Adindan_UTM_zone_38N = 20138;
    public static final int PCS_AGD66_AMG_zone_48 = 20248;
    public static final int PCS_AGD66_AMG_zone_49 = 20249;
    public static final int PCS_AGD66_AMG_zone_50 = 20250;
    public static final int PCS_AGD66_AMG_zone_51 = 20251;
    public static final int PCS_AGD66_AMG_zone_52 = 20252;
    public static final int PCS_AGD66_AMG_zone_53 = 20253;
    public static final int PCS_AGD66_AMG_zone_54 = 20254;
    public static final int PCS_AGD66_AMG_zone_55 = 20255;
    public static final int PCS_AGD66_AMG_zone_56 = 20256;
    public static final int PCS_AGD66_AMG_zone_57 = 20257;
    public static final int PCS_AGD66_AMG_zone_58 = 20258;
    public static final int PCS_AGD84_AMG_zone_48 = 20348;
    public static final int PCS_AGD84_AMG_zone_49 = 20349;
    public static final int PCS_AGD84_AMG_zone_50 = 20350;
    public static final int PCS_AGD84_AMG_zone_51 = 20351;
    public static final int PCS_AGD84_AMG_zone_52 = 20352;
    public static final int PCS_AGD84_AMG_zone_53 = 20353;
    public static final int PCS_AGD84_AMG_zone_54 = 20354;
    public static final int PCS_AGD84_AMG_zone_55 = 20355;
    public static final int PCS_AGD84_AMG_zone_56 = 20356;
    public static final int PCS_AGD84_AMG_zone_57 = 20357;
    public static final int PCS_AGD84_AMG_zone_58 = 20358;
    public static final int PCS_Ain_el_Abd_UTM_zone_37N = 20437;
    public static final int PCS_Ain_el_Abd_UTM_zone_38N = 20438;
    public static final int PCS_Ain_el_Abd_UTM_zone_39N = 20439;
    public static final int PCS_Ain_el_Abd_Bahrain_Grid = 20499;
    public static final int PCS_Afgooye_UTM_zone_38N = 20538;
    public static final int PCS_Afgooye_UTM_zone_39N = 20539;
    public static final int PCS_Lisbon_Portugese_Grid = 20700;
    public static final int PCS_Aratu_UTM_zone_22S = 20822;
    public static final int PCS_Aratu_UTM_zone_23S = 20823;
    public static final int PCS_Aratu_UTM_zone_24S = 20824;
    public static final int PCS_Arc_1950_Lo13 = 20973;
    public static final int PCS_Arc_1950_Lo15 = 20975;
    public static final int PCS_Arc_1950_Lo17 = 20977;
    public static final int PCS_Arc_1950_Lo19 = 20979;
    public static final int PCS_Arc_1950_Lo21 = 20981;
    public static final int PCS_Arc_1950_Lo23 = 20983;
    public static final int PCS_Arc_1950_Lo25 = 20985;
    public static final int PCS_Arc_1950_Lo27 = 20987;
    public static final int PCS_Arc_1950_Lo29 = 20989;
    public static final int PCS_Arc_1950_Lo31 = 20991;
    public static final int PCS_Arc_1950_Lo33 = 20993;
    public static final int PCS_Arc_1950_Lo35 = 20995;
    public static final int PCS_Batavia_NEIEZ = 21100;
    public static final int PCS_Batavia_UTM_zone_48S = 21148;
    public static final int PCS_Batavia_UTM_zone_49S = 21149;
    public static final int PCS_Batavia_UTM_zone_50S = 21150;
    public static final int PCS_Beijing_Gauss_zone_13 = 21413;
    public static final int PCS_Beijing_Gauss_zone_14 = 21414;
    public static final int PCS_Beijing_Gauss_zone_15 = 21415;
    public static final int PCS_Beijing_Gauss_zone_16 = 21416;
    public static final int PCS_Beijing_Gauss_zone_17 = 21417;
    public static final int PCS_Beijing_Gauss_zone_18 = 21418;
    public static final int PCS_Beijing_Gauss_zone_19 = 21419;
    public static final int PCS_Beijing_Gauss_zone_20 = 21420;
    public static final int PCS_Beijing_Gauss_zone_21 = 21421;
    public static final int PCS_Beijing_Gauss_zone_22 = 21422;
    public static final int PCS_Beijing_Gauss_zone_23 = 21423;
    public static final int PCS_Beijing_Gauss_13N = 21473;
    public static final int PCS_Beijing_Gauss_14N = 21474;
    public static final int PCS_Beijing_Gauss_15N = 21475;
    public static final int PCS_Beijing_Gauss_16N = 21476;
    public static final int PCS_Beijing_Gauss_17N = 21477;
    public static final int PCS_Beijing_Gauss_18N = 21478;
    public static final int PCS_Beijing_Gauss_19N = 21479;
    public static final int PCS_Beijing_Gauss_20N = 21480;
    public static final int PCS_Beijing_Gauss_21N = 21481;
    public static final int PCS_Beijing_Gauss_22N = 21482;
    public static final int PCS_Beijing_Gauss_23N = 21483;
    public static final int PCS_Belge_Lambert_50 = 21500;
    public static final int PCS_Bern_1898_Swiss_Old = 21790;
    public static final int PCS_Bogota_UTM_zone_17N = 21817;
    public static final int PCS_Bogota_UTM_zone_18N = 21818;
    public static final int PCS_Bogota_Colombia_3W = 21891;
    public static final int PCS_Bogota_Colombia_Bogota = 21892;
    public static final int PCS_Bogota_Colombia_3E = 21893;
    public static final int PCS_Bogota_Colombia_6E = 21894;
    public static final int PCS_Camacupa_UTM_32S = 22032;
    public static final int PCS_Camacupa_UTM_33S = 22033;
    public static final int PCS_C_Inchauspe_Argentina_1 = 22191;
    public static final int PCS_C_Inchauspe_Argentina_2 = 22192;
    public static final int PCS_C_Inchauspe_Argentina_3 = 22193;
    public static final int PCS_C_Inchauspe_Argentina_4 = 22194;
    public static final int PCS_C_Inchauspe_Argentina_5 = 22195;
    public static final int PCS_C_Inchauspe_Argentina_6 = 22196;
    public static final int PCS_C_Inchauspe_Argentina_7 = 22197;
    public static final int PCS_Carthage_UTM_zone_32N = 22332;
    public static final int PCS_Carthage_Nord_Tunisie = 22391;
    public static final int PCS_Carthage_Sud_Tunisie = 22392;
    public static final int PCS_Corrego_Alegre_UTM_23S = 22523;
    public static final int PCS_Corrego_Alegre_UTM_24S = 22524;
    public static final int PCS_Douala_UTM_zone_32N = 22832;
    public static final int PCS_Egypt_1907_Red_Belt = 22992;
    public static final int PCS_Egypt_1907_Purple_Belt = 22993;
    public static final int PCS_Egypt_1907_Ext_Purple = 22994;
    public static final int PCS_ED50_UTM_zone_28N = 23028;
    public static final int PCS_ED50_UTM_zone_29N = 23029;
    public static final int PCS_ED50_UTM_zone_30N = 23030;
    public static final int PCS_ED50_UTM_zone_31N = 23031;
    public static final int PCS_ED50_UTM_zone_32N = 23032;
    public static final int PCS_ED50_UTM_zone_33N = 23033;
    public static final int PCS_ED50_UTM_zone_34N = 23034;
    public static final int PCS_ED50_UTM_zone_35N = 23035;
    public static final int PCS_ED50_UTM_zone_36N = 23036;
    public static final int PCS_ED50_UTM_zone_37N = 23037;
    public static final int PCS_ED50_UTM_zone_38N = 23038;
    public static final int PCS_Fahud_UTM_zone_39N = 23239;
    public static final int PCS_Fahud_UTM_zone_40N = 23240;
    public static final int PCS_Garoua_UTM_zone_33N = 23433;
    public static final int PCS_ID74_UTM_zone_46N = 23846;
    public static final int PCS_ID74_UTM_zone_47N = 23847;
    public static final int PCS_ID74_UTM_zone_48N = 23848;
    public static final int PCS_ID74_UTM_zone_49N = 23849;
    public static final int PCS_ID74_UTM_zone_50N = 23850;
    public static final int PCS_ID74_UTM_zone_51N = 23851;
    public static final int PCS_ID74_UTM_zone_52N = 23852;
    public static final int PCS_ID74_UTM_zone_53N = 23853;
    public static final int PCS_ID74_UTM_zone_46S = 23886;
    public static final int PCS_ID74_UTM_zone_47S = 23887;
    public static final int PCS_ID74_UTM_zone_48S = 23888;
    public static final int PCS_ID74_UTM_zone_49S = 23889;
    public static final int PCS_ID74_UTM_zone_50S = 23890;
    public static final int PCS_ID74_UTM_zone_51S = 23891;
    public static final int PCS_ID74_UTM_zone_52S = 23892;
    public static final int PCS_ID74_UTM_zone_53S = 23893;
    public static final int PCS_ID74_UTM_zone_54S = 23894;
    public static final int PCS_Indian_1954_UTM_47N = 23947;
    public static final int PCS_Indian_1954_UTM_48N = 23948;
    public static final int PCS_Indian_1975_UTM_47N = 24047;
    public static final int PCS_Indian_1975_UTM_48N = 24048;
    public static final int PCS_Jamaica_1875_Old_Grid = 24100;
    public static final int PCS_JAD69_Jamaica_Grid = 24200;
    public static final int PCS_Kalianpur_India_0 = 24370;
    public static final int PCS_Kalianpur_India_I = 24371;
    public static final int PCS_Kalianpur_India_IIa = 24372;
    public static final int PCS_Kalianpur_India_IIIa = 24373;
    public static final int PCS_Kalianpur_India_IVa = 24374;
    public static final int PCS_Kalianpur_India_IIb = 24382;
    public static final int PCS_Kalianpur_India_IIIb = 24383;
    public static final int PCS_Kalianpur_India_IVb = 24384;
    public static final int PCS_Kertau_Singapore_Grid = 24500;
    public static final int PCS_Kertau_UTM_zone_47N = 24547;
    public static final int PCS_Kertau_UTM_zone_48N = 24548;
    public static final int PCS_La_Canoa_UTM_zone_20N = 24720;
    public static final int PCS_La_Canoa_UTM_zone_21N = 24721;
    public static final int PCS_PSAD56_UTM_zone_18N = 24818;
    public static final int PCS_PSAD56_UTM_zone_19N = 24819;
    public static final int PCS_PSAD56_UTM_zone_20N = 24820;
    public static final int PCS_PSAD56_UTM_zone_21N = 24821;
    public static final int PCS_PSAD56_UTM_zone_17S = 24877;
    public static final int PCS_PSAD56_UTM_zone_18S = 24878;
    public static final int PCS_PSAD56_UTM_zone_19S = 24879;
    public static final int PCS_PSAD56_UTM_zone_20S = 24880;
    public static final int PCS_PSAD56_Peru_west_zone = 24891;
    public static final int PCS_PSAD56_Peru_central = 24892;
    public static final int PCS_PSAD56_Peru_east_zone = 24893;
    public static final int PCS_Leigon_Ghana_Grid = 25000;
    public static final int PCS_Lome_UTM_zone_31N = 25231;
    public static final int PCS_Luzon_Philippines_I = 25391;
    public static final int PCS_Luzon_Philippines_II = 25392;
    public static final int PCS_Luzon_Philippines_III = 25393;
    public static final int PCS_Luzon_Philippines_IV = 25394;
    public static final int PCS_Luzon_Philippines_V = 25395;
    public static final int PCS_Makassar_NEIEZ = 25700;
    public static final int PCS_Malongo_1987_UTM_32S = 25932;
    public static final int PCS_Merchich_Nord_Maroc = 26191;
    public static final int PCS_Merchich_Sud_Maroc = 26192;
    public static final int PCS_Merchich_Sahara = 26193;
    public static final int PCS_Massawa_UTM_zone_37N = 26237;
    public static final int PCS_Minna_UTM_zone_31N = 26331;
    public static final int PCS_Minna_UTM_zone_32N = 26332;
    public static final int PCS_Minna_Nigeria_West = 26391;
    public static final int PCS_Minna_Nigeria_Mid_Belt = 26392;
    public static final int PCS_Minna_Nigeria_East = 26393;
    public static final int PCS_Mhast_UTM_zone_32S = 26432;
    public static final int PCS_Monte_Mario_Italy_1 = 26591;
    public static final int PCS_Monte_Mario_Italy_2 = 26592;
    public static final int PCS_M_poraloko_UTM_32N = 26632;
    public static final int PCS_M_poraloko_UTM_32S = 26692;
    public static final int PCS_NAD27_UTM_zone_3N = 26703;
    public static final int PCS_NAD27_UTM_zone_4N = 26704;
    public static final int PCS_NAD27_UTM_zone_5N = 26705;
    public static final int PCS_NAD27_UTM_zone_6N = 26706;
    public static final int PCS_NAD27_UTM_zone_7N = 26707;
    public static final int PCS_NAD27_UTM_zone_8N = 26708;
    public static final int PCS_NAD27_UTM_zone_9N = 26709;
    public static final int PCS_NAD27_UTM_zone_10N = 26710;
    public static final int PCS_NAD27_UTM_zone_11N = 26711;
    public static final int PCS_NAD27_UTM_zone_12N = 26712;
    public static final int PCS_NAD27_UTM_zone_13N = 26713;
    public static final int PCS_NAD27_UTM_zone_14N = 26714;
    public static final int PCS_NAD27_UTM_zone_15N = 26715;
    public static final int PCS_NAD27_UTM_zone_16N = 26716;
    public static final int PCS_NAD27_UTM_zone_17N = 26717;
    public static final int PCS_NAD27_UTM_zone_18N = 26718;
    public static final int PCS_NAD27_UTM_zone_19N = 26719;
    public static final int PCS_NAD27_UTM_zone_20N = 26720;
    public static final int PCS_NAD27_UTM_zone_21N = 26721;
    public static final int PCS_NAD27_UTM_zone_22N = 26722;
    public static final int PCS_NAD27_Alabama_East = 26729;
    public static final int PCS_NAD27_Alabama_West = 26730;
    public static final int PCS_NAD27_Alaska_zone_1 = 26731;
    public static final int PCS_NAD27_Alaska_zone_2 = 26732;
    public static final int PCS_NAD27_Alaska_zone_3 = 26733;
    public static final int PCS_NAD27_Alaska_zone_4 = 26734;
    public static final int PCS_NAD27_Alaska_zone_5 = 26735;
    public static final int PCS_NAD27_Alaska_zone_6 = 26736;
    public static final int PCS_NAD27_Alaska_zone_7 = 26737;
    public static final int PCS_NAD27_Alaska_zone_8 = 26738;
    public static final int PCS_NAD27_Alaska_zone_9 = 26739;
    public static final int PCS_NAD27_Alaska_zone_10 = 26740;
    public static final int PCS_NAD27_California_I = 26741;
    public static final int PCS_NAD27_California_II = 26742;
    public static final int PCS_NAD27_California_III = 26743;
    public static final int PCS_NAD27_California_IV = 26744;
    public static final int PCS_NAD27_California_V = 26745;
    public static final int PCS_NAD27_California_VI = 26746;
    public static final int PCS_NAD27_California_VII = 26747;
    public static final int PCS_NAD27_Arizona_East = 26748;
    public static final int PCS_NAD27_Arizona_Central = 26749;
    public static final int PCS_NAD27_Arizona_West = 26750;
    public static final int PCS_NAD27_Arkansas_North = 26751;
    public static final int PCS_NAD27_Arkansas_South = 26752;
    public static final int PCS_NAD27_Colorado_North = 26753;
    public static final int PCS_NAD27_Colorado_Central = 26754;
    public static final int PCS_NAD27_Colorado_South = 26755;
    public static final int PCS_NAD27_Connecticut = 26756;
    public static final int PCS_NAD27_Delaware = 26757;
    public static final int PCS_NAD27_Florida_East = 26758;
    public static final int PCS_NAD27_Florida_West = 26759;
    public static final int PCS_NAD27_Florida_North = 26760;
    public static final int PCS_NAD27_Hawaii_zone_1 = 26761;
    public static final int PCS_NAD27_Hawaii_zone_2 = 26762;
    public static final int PCS_NAD27_Hawaii_zone_3 = 26763;
    public static final int PCS_NAD27_Hawaii_zone_4 = 26764;
    public static final int PCS_NAD27_Hawaii_zone_5 = 26765;
    public static final int PCS_NAD27_Georgia_East = 26766;
    public static final int PCS_NAD27_Georgia_West = 26767;
    public static final int PCS_NAD27_Idaho_East = 26768;
    public static final int PCS_NAD27_Idaho_Central = 26769;
    public static final int PCS_NAD27_Idaho_West = 26770;
    public static final int PCS_NAD27_Illinois_East = 26771;
    public static final int PCS_NAD27_Illinois_West = 26772;
    public static final int PCS_NAD27_Indiana_East = 26773;
    public static final int PCS_NAD27_BLM_14N_feet = 26774;
    public static final int PCS_NAD27_Indiana_West = 26774;
    public static final int PCS_NAD27_BLM_15N_feet = 26775;
    public static final int PCS_NAD27_Iowa_North = 26775;
    public static final int PCS_NAD27_BLM_16N_feet = 26776;
    public static final int PCS_NAD27_Iowa_South = 26776;
    public static final int PCS_NAD27_BLM_17N_feet = 26777;
    public static final int PCS_NAD27_Kansas_North = 26777;
    public static final int PCS_NAD27_Kansas_South = 26778;
    public static final int PCS_NAD27_Kentucky_North = 26779;
    public static final int PCS_NAD27_Kentucky_South = 26780;
    public static final int PCS_NAD27_Louisiana_North = 26781;
    public static final int PCS_NAD27_Louisiana_South = 26782;
    public static final int PCS_NAD27_Maine_East = 26783;
    public static final int PCS_NAD27_Maine_West = 26784;
    public static final int PCS_NAD27_Maryland = 26785;
    public static final int PCS_NAD27_Massachusetts = 26786;
    public static final int PCS_NAD27_Massachusetts_Is = 26787;
    public static final int PCS_NAD27_Michigan_North = 26788;
    public static final int PCS_NAD27_Michigan_Central = 26789;
    public static final int PCS_NAD27_Michigan_South = 26790;
    public static final int PCS_NAD27_Minnesota_North = 26791;
    public static final int PCS_NAD27_Minnesota_Cent = 26792;
    public static final int PCS_NAD27_Minnesota_South = 26793;
    public static final int PCS_NAD27_Mississippi_East = 26794;
    public static final int PCS_NAD27_Mississippi_West = 26795;
    public static final int PCS_NAD27_Missouri_East = 26796;
    public static final int PCS_NAD27_Missouri_Central = 26797;
    public static final int PCS_NAD27_Missouri_West = 26798;
    public static final int PCS_NAD_Michigan_Michigan_East = 26801;
    public static final int PCS_NAD_Michigan_Michigan_Old_Central = 26802;
    public static final int PCS_NAD_Michigan_Michigan_West = 26803;
    public static final int PCS_NAD83_UTM_zone_3N = 26903;
    public static final int PCS_NAD83_UTM_zone_4N = 26904;
    public static final int PCS_NAD83_UTM_zone_5N = 26905;
    public static final int PCS_NAD83_UTM_zone_6N = 26906;
    public static final int PCS_NAD83_UTM_zone_7N = 26907;
    public static final int PCS_NAD83_UTM_zone_8N = 26908;
    public static final int PCS_NAD83_UTM_zone_9N = 26909;
    public static final int PCS_NAD83_UTM_zone_10N = 26910;
    public static final int PCS_NAD83_UTM_zone_11N = 26911;
    public static final int PCS_NAD83_UTM_zone_12N = 26912;
    public static final int PCS_NAD83_UTM_zone_13N = 26913;
    public static final int PCS_NAD83_UTM_zone_14N = 26914;
    public static final int PCS_NAD83_UTM_zone_15N = 26915;
    public static final int PCS_NAD83_UTM_zone_16N = 26916;
    public static final int PCS_NAD83_UTM_zone_17N = 26917;
    public static final int PCS_NAD83_UTM_zone_18N = 26918;
    public static final int PCS_NAD83_UTM_zone_19N = 26919;
    public static final int PCS_NAD83_UTM_zone_20N = 26920;
    public static final int PCS_NAD83_UTM_zone_21N = 26921;
    public static final int PCS_NAD83_UTM_zone_22N = 26922;
    public static final int PCS_NAD83_UTM_zone_23N = 26923;
    public static final int PCS_NAD83_Alabama_East = 26929;
    public static final int PCS_NAD83_Alabama_West = 26930;
    public static final int PCS_NAD83_Alaska_zone_1 = 26931;
    public static final int PCS_NAD83_Alaska_zone_2 = 26932;
    public static final int PCS_NAD83_Alaska_zone_3 = 26933;
    public static final int PCS_NAD83_Alaska_zone_4 = 26934;
    public static final int PCS_NAD83_Alaska_zone_5 = 26935;
    public static final int PCS_NAD83_Alaska_zone_6 = 26936;
    public static final int PCS_NAD83_Alaska_zone_7 = 26937;
    public static final int PCS_NAD83_Alaska_zone_8 = 26938;
    public static final int PCS_NAD83_Alaska_zone_9 = 26939;
    public static final int PCS_NAD83_Alaska_zone_10 = 26940;
    public static final int PCS_NAD83_California_1 = 26941;
    public static final int PCS_NAD83_California_2 = 26942;
    public static final int PCS_NAD83_California_3 = 26943;
    public static final int PCS_NAD83_California_4 = 26944;
    public static final int PCS_NAD83_California_5 = 26945;
    public static final int PCS_NAD83_California_6 = 26946;
    public static final int PCS_NAD83_Arizona_East = 26948;
    public static final int PCS_NAD83_Arizona_Central = 26949;
    public static final int PCS_NAD83_Arizona_West = 26950;
    public static final int PCS_NAD83_Arkansas_North = 26951;
    public static final int PCS_NAD83_Arkansas_South = 26952;
    public static final int PCS_NAD83_Colorado_North = 26953;
    public static final int PCS_NAD83_Colorado_Central = 26954;
    public static final int PCS_NAD83_Colorado_South = 26955;
    public static final int PCS_NAD83_Connecticut = 26956;
    public static final int PCS_NAD83_Delaware = 26957;
    public static final int PCS_NAD83_Florida_East = 26958;
    public static final int PCS_NAD83_Florida_West = 26959;
    public static final int PCS_NAD83_Florida_North = 26960;
    public static final int PCS_NAD83_Hawaii_zone_1 = 26961;
    public static final int PCS_NAD83_Hawaii_zone_2 = 26962;
    public static final int PCS_NAD83_Hawaii_zone_3 = 26963;
    public static final int PCS_NAD83_Hawaii_zone_4 = 26964;
    public static final int PCS_NAD83_Hawaii_zone_5 = 26965;
    public static final int PCS_NAD83_Georgia_East = 26966;
    public static final int PCS_NAD83_Georgia_West = 26967;
    public static final int PCS_NAD83_Idaho_East = 26968;
    public static final int PCS_NAD83_Idaho_Central = 26969;
    public static final int PCS_NAD83_Idaho_West = 26970;
    public static final int PCS_NAD83_Illinois_East = 26971;
    public static final int PCS_NAD83_Illinois_West = 26972;
    public static final int PCS_NAD83_Indiana_East = 26973;
    public static final int PCS_NAD83_Indiana_West = 26974;
    public static final int PCS_NAD83_Iowa_North = 26975;
    public static final int PCS_NAD83_Iowa_South = 26976;
    public static final int PCS_NAD83_Kansas_North = 26977;
    public static final int PCS_NAD83_Kansas_South = 26978;
    public static final int PCS_NAD83_Kentucky_North = 26979;
    public static final int PCS_NAD83_Kentucky_South = 26980;
    public static final int PCS_NAD83_Louisiana_North = 26981;
    public static final int PCS_NAD83_Louisiana_South = 26982;
    public static final int PCS_NAD83_Maine_East = 26983;
    public static final int PCS_NAD83_Maine_West = 26984;
    public static final int PCS_NAD83_Maryland = 26985;
    public static final int PCS_NAD83_Massachusetts = 26986;
    public static final int PCS_NAD83_Massachusetts_Is = 26987;
    public static final int PCS_NAD83_Michigan_North = 26988;
    public static final int PCS_NAD83_Michigan_Central = 26989;
    public static final int PCS_NAD83_Michigan_South = 26990;
    public static final int PCS_NAD83_Minnesota_North = 26991;
    public static final int PCS_NAD83_Minnesota_Cent = 26992;
    public static final int PCS_NAD83_Minnesota_South = 26993;
    public static final int PCS_NAD83_Mississippi_East = 26994;
    public static final int PCS_NAD83_Mississippi_West = 26995;
    public static final int PCS_NAD83_Missouri_East = 26996;
    public static final int PCS_NAD83_Missouri_Central = 26997;
    public static final int PCS_NAD83_Missouri_West = 26998;
    public static final int PCS_Nahrwan_1967_UTM_38N = 27038;
    public static final int PCS_Nahrwan_1967_UTM_39N = 27039;
    public static final int PCS_Nahrwan_1967_UTM_40N = 27040;
    public static final int PCS_Naparima_UTM_20N = 27120;
    public static final int PCS_GD49_NZ_Map_Grid = 27200;
    public static final int PCS_GD49_North_Island_Grid = 27291;
    public static final int PCS_GD49_South_Island_Grid = 27292;
    public static final int PCS_Datum_73_UTM_zone_29N = 27429;
    public static final int PCS_ATF_Nord_de_Guerre = 27500;
    public static final int PCS_NTF_France_I = 27581;
    public static final int PCS_NTF_France_II = 27582;
    public static final int PCS_NTF_France_III = 27583;
    public static final int PCS_NTF_Nord_France = 27591;
    public static final int PCS_NTF_Centre_France = 27592;
    public static final int PCS_NTF_Sud_France = 27593;
    public static final int PCS_British_National_Grid = 27700;
    public static final int PCS_Point_Noire_UTM_32S = 28232;
    public static final int PCS_GDA94_MGA_zone_48 = 28348;
    public static final int PCS_GDA94_MGA_zone_49 = 28349;
    public static final int PCS_GDA94_MGA_zone_50 = 28350;
    public static final int PCS_GDA94_MGA_zone_51 = 28351;
    public static final int PCS_GDA94_MGA_zone_52 = 28352;
    public static final int PCS_GDA94_MGA_zone_53 = 28353;
    public static final int PCS_GDA94_MGA_zone_54 = 28354;
    public static final int PCS_GDA94_MGA_zone_55 = 28355;
    public static final int PCS_GDA94_MGA_zone_56 = 28356;
    public static final int PCS_GDA94_MGA_zone_57 = 28357;
    public static final int PCS_GDA94_MGA_zone_58 = 28358;
    public static final int PCS_Pulkovo_Gauss_zone_4 = 28404;
    public static final int PCS_Pulkovo_Gauss_zone_5 = 28405;
    public static final int PCS_Pulkovo_Gauss_zone_6 = 28406;
    public static final int PCS_Pulkovo_Gauss_zone_7 = 28407;
    public static final int PCS_Pulkovo_Gauss_zone_8 = 28408;
    public static final int PCS_Pulkovo_Gauss_zone_9 = 28409;
    public static final int PCS_Pulkovo_Gauss_zone_10 = 28410;
    public static final int PCS_Pulkovo_Gauss_zone_11 = 28411;
    public static final int PCS_Pulkovo_Gauss_zone_12 = 28412;
    public static final int PCS_Pulkovo_Gauss_zone_13 = 28413;
    public static final int PCS_Pulkovo_Gauss_zone_14 = 28414;
    public static final int PCS_Pulkovo_Gauss_zone_15 = 28415;
    public static final int PCS_Pulkovo_Gauss_zone_16 = 28416;
    public static final int PCS_Pulkovo_Gauss_zone_17 = 28417;
    public static final int PCS_Pulkovo_Gauss_zone_18 = 28418;
    public static final int PCS_Pulkovo_Gauss_zone_19 = 28419;
    public static final int PCS_Pulkovo_Gauss_zone_20 = 28420;
    public static final int PCS_Pulkovo_Gauss_zone_21 = 28421;
    public static final int PCS_Pulkovo_Gauss_zone_22 = 28422;
    public static final int PCS_Pulkovo_Gauss_zone_23 = 28423;
    public static final int PCS_Pulkovo_Gauss_zone_24 = 28424;
    public static final int PCS_Pulkovo_Gauss_zone_25 = 28425;
    public static final int PCS_Pulkovo_Gauss_zone_26 = 28426;
    public static final int PCS_Pulkovo_Gauss_zone_27 = 28427;
    public static final int PCS_Pulkovo_Gauss_zone_28 = 28428;
    public static final int PCS_Pulkovo_Gauss_zone_29 = 28429;
    public static final int PCS_Pulkovo_Gauss_zone_30 = 28430;
    public static final int PCS_Pulkovo_Gauss_zone_31 = 28431;
    public static final int PCS_Pulkovo_Gauss_zone_32 = 28432;
    public static final int PCS_Pulkovo_Gauss_4N = 28464;
    public static final int PCS_Pulkovo_Gauss_5N = 28465;
    public static final int PCS_Pulkovo_Gauss_6N = 28466;
    public static final int PCS_Pulkovo_Gauss_7N = 28467;
    public static final int PCS_Pulkovo_Gauss_8N = 28468;
    public static final int PCS_Pulkovo_Gauss_9N = 28469;
    public static final int PCS_Pulkovo_Gauss_10N = 28470;
    public static final int PCS_Pulkovo_Gauss_11N = 28471;
    public static final int PCS_Pulkovo_Gauss_12N = 28472;
    public static final int PCS_Pulkovo_Gauss_13N = 28473;
    public static final int PCS_Pulkovo_Gauss_14N = 28474;
    public static final int PCS_Pulkovo_Gauss_15N = 28475;
    public static final int PCS_Pulkovo_Gauss_16N = 28476;
    public static final int PCS_Pulkovo_Gauss_17N = 28477;
    public static final int PCS_Pulkovo_Gauss_18N = 28478;
    public static final int PCS_Pulkovo_Gauss_19N = 28479;
    public static final int PCS_Pulkovo_Gauss_20N = 28480;
    public static final int PCS_Pulkovo_Gauss_21N = 28481;
    public static final int PCS_Pulkovo_Gauss_22N = 28482;
    public static final int PCS_Pulkovo_Gauss_23N = 28483;
    public static final int PCS_Pulkovo_Gauss_24N = 28484;
    public static final int PCS_Pulkovo_Gauss_25N = 28485;
    public static final int PCS_Pulkovo_Gauss_26N = 28486;
    public static final int PCS_Pulkovo_Gauss_27N = 28487;
    public static final int PCS_Pulkovo_Gauss_28N = 28488;
    public static final int PCS_Pulkovo_Gauss_29N = 28489;
    public static final int PCS_Pulkovo_Gauss_30N = 28490;
    public static final int PCS_Pulkovo_Gauss_31N = 28491;
    public static final int PCS_Pulkovo_Gauss_32N = 28492;
    public static final int PCS_Qatar_National_Grid = 28600;
    public static final int PCS_RD_Netherlands_Old = 28991;
    public static final int PCS_RD_Netherlands_New = 28992;
    public static final int PCS_SAD69_UTM_zone_18N = 29118;
    public static final int PCS_SAD69_UTM_zone_19N = 29119;
    public static final int PCS_SAD69_UTM_zone_20N = 29120;
    public static final int PCS_SAD69_UTM_zone_21N = 29121;
    public static final int PCS_SAD69_UTM_zone_22N = 29122;
    public static final int PCS_SAD69_UTM_zone_17S = 29177;
    public static final int PCS_SAD69_UTM_zone_18S = 29178;
    public static final int PCS_SAD69_UTM_zone_19S = 29179;
    public static final int PCS_SAD69_UTM_zone_20S = 29180;
    public static final int PCS_SAD69_UTM_zone_21S = 29181;
    public static final int PCS_SAD69_UTM_zone_22S = 29182;
    public static final int PCS_SAD69_UTM_zone_23S = 29183;
    public static final int PCS_SAD69_UTM_zone_24S = 29184;
    public static final int PCS_SAD69_UTM_zone_25S = 29185;
    public static final int PCS_Sapper_Hill_UTM_20S = 29220;
    public static final int PCS_Sapper_Hill_UTM_21S = 29221;
    public static final int PCS_Schwarzeck_UTM_33S = 29333;
    public static final int PCS_Sudan_UTM_zone_35N = 29635;
    public static final int PCS_Sudan_UTM_zone_36N = 29636;
    public static final int PCS_Tananarive_Laborde = 29700;
    public static final int PCS_Tananarive_UTM_38S = 29738;
    public static final int PCS_Tananarive_UTM_39S = 29739;
    public static final int PCS_Timbalai_1948_Borneo = 29800;
    public static final int PCS_Timbalai_1948_UTM_49N = 29849;
    public static final int PCS_Timbalai_1948_UTM_50N = 29850;
    public static final int PCS_TM65_Irish_Nat_Grid = 29900;
    public static final int PCS_Trinidad_1903_Trinidad = 30200;
    public static final int PCS_TC_1948_UTM_zone_39N = 30339;
    public static final int PCS_TC_1948_UTM_zone_40N = 30340;
    public static final int PCS_Voirol_N_Algerie_ancien = 30491;
    public static final int PCS_Voirol_S_Algerie_ancien = 30492;
    public static final int PCS_Voirol_Unifie_N_Algerie = 30591;
    public static final int PCS_Voirol_Unifie_S_Algerie = 30592;
    public static final int PCS_Bern_1938_Swiss_New = 30600;
    public static final int PCS_Nord_Sahara_UTM_29N = 30729;
    public static final int PCS_Nord_Sahara_UTM_30N = 30730;
    public static final int PCS_Nord_Sahara_UTM_31N = 30731;
    public static final int PCS_Nord_Sahara_UTM_32N = 30732;
    public static final int PCS_Yoff_UTM_zone_28N = 31028;
    public static final int PCS_Zanderij_UTM_zone_21N = 31121;
    public static final int PCS_MGI_Austria_West = 31291;
    public static final int PCS_MGI_Austria_Central = 31292;
    public static final int PCS_MGI_Austria_East = 31293;
    public static final int PCS_Belge_Lambert_72 = 31300;
    public static final int PCS_DHDN_Germany_zone_1 = 31491;
    public static final int PCS_DHDN_Germany_zone_2 = 31492;
    public static final int PCS_DHDN_Germany_zone_3 = 31493;
    public static final int PCS_DHDN_Germany_zone_4 = 31494;
    public static final int PCS_DHDN_Germany_zone_5 = 31495;
    public static final int PCS_NAD27_Montana_North = 32001;
    public static final int PCS_NAD27_Montana_Central = 32002;
    public static final int PCS_NAD27_Montana_South = 32003;
    public static final int PCS_NAD27_Nebraska_North = 32005;
    public static final int PCS_NAD27_Nebraska_South = 32006;
    public static final int PCS_NAD27_Nevada_East = 32007;
    public static final int PCS_NAD27_Nevada_Central = 32008;
    public static final int PCS_NAD27_Nevada_West = 32009;
    public static final int PCS_NAD27_New_Hampshire = 32010;
    public static final int PCS_NAD27_New_Jersey = 32011;
    public static final int PCS_NAD27_New_Mexico_East = 32012;
    public static final int PCS_NAD27_New_Mexico_Cent = 32013;
    public static final int PCS_NAD27_New_Mexico_West = 32014;
    public static final int PCS_NAD27_New_York_East = 32015;
    public static final int PCS_NAD27_New_York_Central = 32016;
    public static final int PCS_NAD27_New_York_West = 32017;
    public static final int PCS_NAD27_New_York_Long_Is = 32018;
    public static final int PCS_NAD27_North_Carolina = 32019;
    public static final int PCS_NAD27_North_Dakota_N = 32020;
    public static final int PCS_NAD27_North_Dakota_S = 32021;
    public static final int PCS_NAD27_Ohio_North = 32022;
    public static final int PCS_NAD27_Ohio_South = 32023;
    public static final int PCS_NAD27_Oklahoma_North = 32024;
    public static final int PCS_NAD27_Oklahoma_South = 32025;
    public static final int PCS_NAD27_Oregon_North = 32026;
    public static final int PCS_NAD27_Oregon_South = 32027;
    public static final int PCS_NAD27_Pennsylvania_N = 32028;
    public static final int PCS_NAD27_Pennsylvania_S = 32029;
    public static final int PCS_NAD27_Rhode_Island = 32030;
    public static final int PCS_NAD27_South_Carolina_N = 32031;
    public static final int PCS_NAD27_South_Carolina_S = 32033;
    public static final int PCS_NAD27_South_Dakota_N = 32034;
    public static final int PCS_NAD27_South_Dakota_S = 32035;
    public static final int PCS_NAD27_Tennessee = 32036;
    public static final int PCS_NAD27_Texas_North = 32037;
    public static final int PCS_NAD27_Texas_North_Cen = 32038;
    public static final int PCS_NAD27_Texas_Central = 32039;
    public static final int PCS_NAD27_Texas_South_Cen = 32040;
    public static final int PCS_NAD27_Texas_South = 32041;
    public static final int PCS_NAD27_Utah_North = 32042;
    public static final int PCS_NAD27_Utah_Central = 32043;
    public static final int PCS_NAD27_Utah_South = 32044;
    public static final int PCS_NAD27_Vermont = 32045;
    public static final int PCS_NAD27_Virginia_North = 32046;
    public static final int PCS_NAD27_Virginia_South = 32047;
    public static final int PCS_NAD27_Washington_North = 32048;
    public static final int PCS_NAD27_Washington_South = 32049;
    public static final int PCS_NAD27_West_Virginia_N = 32050;
    public static final int PCS_NAD27_West_Virginia_S = 32051;
    public static final int PCS_NAD27_Wisconsin_North = 32052;
    public static final int PCS_NAD27_Wisconsin_Cen = 32053;
    public static final int PCS_NAD27_Wisconsin_South = 32054;
    public static final int PCS_NAD27_Wyoming_East = 32055;
    public static final int PCS_NAD27_Wyoming_E_Cen = 32056;
    public static final int PCS_NAD27_Wyoming_W_Cen = 32057;
    public static final int PCS_NAD27_Wyoming_West = 32058;
    public static final int PCS_NAD27_Puerto_Rico = 32059;
    public static final int PCS_NAD27_St_Croix = 32060;
    public static final int PCS_NAD83_Montana = 32100;
    public static final int PCS_NAD83_Nebraska = 32104;
    public static final int PCS_NAD83_Nevada_East = 32107;
    public static final int PCS_NAD83_Nevada_Central = 32108;
    public static final int PCS_NAD83_Nevada_West = 32109;
    public static final int PCS_NAD83_New_Hampshire = 32110;
    public static final int PCS_NAD83_New_Jersey = 32111;
    public static final int PCS_NAD83_New_Mexico_East = 32112;
    public static final int PCS_NAD83_New_Mexico_Cent = 32113;
    public static final int PCS_NAD83_New_Mexico_West = 32114;
    public static final int PCS_NAD83_New_York_East = 32115;
    public static final int PCS_NAD83_New_York_Central = 32116;
    public static final int PCS_NAD83_New_York_West = 32117;
    public static final int PCS_NAD83_New_York_Long_Is = 32118;
    public static final int PCS_NAD83_North_Carolina = 32119;
    public static final int PCS_NAD83_North_Dakota_N = 32120;
    public static final int PCS_NAD83_North_Dakota_S = 32121;
    public static final int PCS_NAD83_Ohio_North = 32122;
    public static final int PCS_NAD83_Ohio_South = 32123;
    public static final int PCS_NAD83_Oklahoma_North = 32124;
    public static final int PCS_NAD83_Oklahoma_South = 32125;
    public static final int PCS_NAD83_Oregon_North = 32126;
    public static final int PCS_NAD83_Oregon_South = 32127;
    public static final int PCS_NAD83_Pennsylvania_N = 32128;
    public static final int PCS_NAD83_Pennsylvania_S = 32129;
    public static final int PCS_NAD83_Rhode_Island = 32130;
    public static final int PCS_NAD83_South_Carolina = 32133;
    public static final int PCS_NAD83_South_Dakota_N = 32134;
    public static final int PCS_NAD83_South_Dakota_S = 32135;
    public static final int PCS_NAD83_Tennessee = 32136;
    public static final int PCS_NAD83_Texas_North = 32137;
    public static final int PCS_NAD83_Texas_North_Cen = 32138;
    public static final int PCS_NAD83_Texas_Central = 32139;
    public static final int PCS_NAD83_Texas_South_Cen = 32140;
    public static final int PCS_NAD83_Texas_South = 32141;
    public static final int PCS_NAD83_Utah_North = 32142;
    public static final int PCS_NAD83_Utah_Central = 32143;
    public static final int PCS_NAD83_Utah_South = 32144;
    public static final int PCS_NAD83_Vermont = 32145;
    public static final int PCS_NAD83_Virginia_North = 32146;
    public static final int PCS_NAD83_Virginia_South = 32147;
    public static final int PCS_NAD83_Washington_North = 32148;
    public static final int PCS_NAD83_Washington_South = 32149;
    public static final int PCS_NAD83_West_Virginia_N = 32150;
    public static final int PCS_NAD83_West_Virginia_S = 32151;
    public static final int PCS_NAD83_Wisconsin_North = 32152;
    public static final int PCS_NAD83_Wisconsin_Cen = 32153;
    public static final int PCS_NAD83_Wisconsin_South = 32154;
    public static final int PCS_NAD83_Wyoming_East = 32155;
    public static final int PCS_NAD83_Wyoming_E_Cen = 32156;
    public static final int PCS_NAD83_Wyoming_W_Cen = 32157;
    public static final int PCS_NAD83_Wyoming_West = 32158;
    public static final int PCS_NAD83_Puerto_Rico_Virgin_Is = 32161;
    public static final int PCS_WGS72_UTM_zone_1N = 32201;
    public static final int PCS_WGS72_UTM_zone_2N = 32202;
    public static final int PCS_WGS72_UTM_zone_3N = 32203;
    public static final int PCS_WGS72_UTM_zone_4N = 32204;
    public static final int PCS_WGS72_UTM_zone_5N = 32205;
    public static final int PCS_WGS72_UTM_zone_6N = 32206;
    public static final int PCS_WGS72_UTM_zone_7N = 32207;
    public static final int PCS_WGS72_UTM_zone_8N = 32208;
    public static final int PCS_WGS72_UTM_zone_9N = 32209;
    public static final int PCS_WGS72_UTM_zone_10N = 32210;
    public static final int PCS_WGS72_UTM_zone_11N = 32211;
    public static final int PCS_WGS72_UTM_zone_12N = 32212;
    public static final int PCS_WGS72_UTM_zone_13N = 32213;
    public static final int PCS_WGS72_UTM_zone_14N = 32214;
    public static final int PCS_WGS72_UTM_zone_15N = 32215;
    public static final int PCS_WGS72_UTM_zone_16N = 32216;
    public static final int PCS_WGS72_UTM_zone_17N = 32217;
    public static final int PCS_WGS72_UTM_zone_18N = 32218;
    public static final int PCS_WGS72_UTM_zone_19N = 32219;
    public static final int PCS_WGS72_UTM_zone_20N = 32220;
    public static final int PCS_WGS72_UTM_zone_21N = 32221;
    public static final int PCS_WGS72_UTM_zone_22N = 32222;
    public static final int PCS_WGS72_UTM_zone_23N = 32223;
    public static final int PCS_WGS72_UTM_zone_24N = 32224;
    public static final int PCS_WGS72_UTM_zone_25N = 32225;
    public static final int PCS_WGS72_UTM_zone_26N = 32226;
    public static final int PCS_WGS72_UTM_zone_27N = 32227;
    public static final int PCS_WGS72_UTM_zone_28N = 32228;
    public static final int PCS_WGS72_UTM_zone_29N = 32229;
    public static final int PCS_WGS72_UTM_zone_30N = 32230;
    public static final int PCS_WGS72_UTM_zone_31N = 32231;
    public static final int PCS_WGS72_UTM_zone_32N = 32232;
    public static final int PCS_WGS72_UTM_zone_33N = 32233;
    public static final int PCS_WGS72_UTM_zone_34N = 32234;
    public static final int PCS_WGS72_UTM_zone_35N = 32235;
    public static final int PCS_WGS72_UTM_zone_36N = 32236;
    public static final int PCS_WGS72_UTM_zone_37N = 32237;
    public static final int PCS_WGS72_UTM_zone_38N = 32238;
    public static final int PCS_WGS72_UTM_zone_39N = 32239;
    public static final int PCS_WGS72_UTM_zone_40N = 32240;
    public static final int PCS_WGS72_UTM_zone_41N = 32241;
    public static final int PCS_WGS72_UTM_zone_42N = 32242;
    public static final int PCS_WGS72_UTM_zone_43N = 32243;
    public static final int PCS_WGS72_UTM_zone_44N = 32244;
    public static final int PCS_WGS72_UTM_zone_45N = 32245;
    public static final int PCS_WGS72_UTM_zone_46N = 32246;
    public static final int PCS_WGS72_UTM_zone_47N = 32247;
    public static final int PCS_WGS72_UTM_zone_48N = 32248;
    public static final int PCS_WGS72_UTM_zone_49N = 32249;
    public static final int PCS_WGS72_UTM_zone_50N = 32250;
    public static final int PCS_WGS72_UTM_zone_51N = 32251;
    public static final int PCS_WGS72_UTM_zone_52N = 32252;
    public static final int PCS_WGS72_UTM_zone_53N = 32253;
    public static final int PCS_WGS72_UTM_zone_54N = 32254;
    public static final int PCS_WGS72_UTM_zone_55N = 32255;
    public static final int PCS_WGS72_UTM_zone_56N = 32256;
    public static final int PCS_WGS72_UTM_zone_57N = 32257;
    public static final int PCS_WGS72_UTM_zone_58N = 32258;
    public static final int PCS_WGS72_UTM_zone_59N = 32259;
    public static final int PCS_WGS72_UTM_zone_60N = 32260;
    public static final int PCS_WGS72_UTM_zone_1S = 32301;
    public static final int PCS_WGS72_UTM_zone_2S = 32302;
    public static final int PCS_WGS72_UTM_zone_3S = 32303;
    public static final int PCS_WGS72_UTM_zone_4S = 32304;
    public static final int PCS_WGS72_UTM_zone_5S = 32305;
    public static final int PCS_WGS72_UTM_zone_6S = 32306;
    public static final int PCS_WGS72_UTM_zone_7S = 32307;
    public static final int PCS_WGS72_UTM_zone_8S = 32308;
    public static final int PCS_WGS72_UTM_zone_9S = 32309;
    public static final int PCS_WGS72_UTM_zone_10S = 32310;
    public static final int PCS_WGS72_UTM_zone_11S = 32311;
    public static final int PCS_WGS72_UTM_zone_12S = 32312;
    public static final int PCS_WGS72_UTM_zone_13S = 32313;
    public static final int PCS_WGS72_UTM_zone_14S = 32314;
    public static final int PCS_WGS72_UTM_zone_15S = 32315;
    public static final int PCS_WGS72_UTM_zone_16S = 32316;
    public static final int PCS_WGS72_UTM_zone_17S = 32317;
    public static final int PCS_WGS72_UTM_zone_18S = 32318;
    public static final int PCS_WGS72_UTM_zone_19S = 32319;
    public static final int PCS_WGS72_UTM_zone_20S = 32320;
    public static final int PCS_WGS72_UTM_zone_21S = 32321;
    public static final int PCS_WGS72_UTM_zone_22S = 32322;
    public static final int PCS_WGS72_UTM_zone_23S = 32323;
    public static final int PCS_WGS72_UTM_zone_24S = 32324;
    public static final int PCS_WGS72_UTM_zone_25S = 32325;
    public static final int PCS_WGS72_UTM_zone_26S = 32326;
    public static final int PCS_WGS72_UTM_zone_27S = 32327;
    public static final int PCS_WGS72_UTM_zone_28S = 32328;
    public static final int PCS_WGS72_UTM_zone_29S = 32329;
    public static final int PCS_WGS72_UTM_zone_30S = 32330;
    public static final int PCS_WGS72_UTM_zone_31S = 32331;
    public static final int PCS_WGS72_UTM_zone_32S = 32332;
    public static final int PCS_WGS72_UTM_zone_33S = 32333;
    public static final int PCS_WGS72_UTM_zone_34S = 32334;
    public static final int PCS_WGS72_UTM_zone_35S = 32335;
    public static final int PCS_WGS72_UTM_zone_36S = 32336;
    public static final int PCS_WGS72_UTM_zone_37S = 32337;
    public static final int PCS_WGS72_UTM_zone_38S = 32338;
    public static final int PCS_WGS72_UTM_zone_39S = 32339;
    public static final int PCS_WGS72_UTM_zone_40S = 32340;
    public static final int PCS_WGS72_UTM_zone_41S = 32341;
    public static final int PCS_WGS72_UTM_zone_42S = 32342;
    public static final int PCS_WGS72_UTM_zone_43S = 32343;
    public static final int PCS_WGS72_UTM_zone_44S = 32344;
    public static final int PCS_WGS72_UTM_zone_45S = 32345;
    public static final int PCS_WGS72_UTM_zone_46S = 32346;
    public static final int PCS_WGS72_UTM_zone_47S = 32347;
    public static final int PCS_WGS72_UTM_zone_48S = 32348;
    public static final int PCS_WGS72_UTM_zone_49S = 32349;
    public static final int PCS_WGS72_UTM_zone_50S = 32350;
    public static final int PCS_WGS72_UTM_zone_51S = 32351;
    public static final int PCS_WGS72_UTM_zone_52S = 32352;
    public static final int PCS_WGS72_UTM_zone_53S = 32353;
    public static final int PCS_WGS72_UTM_zone_54S = 32354;
    public static final int PCS_WGS72_UTM_zone_55S = 32355;
    public static final int PCS_WGS72_UTM_zone_56S = 32356;
    public static final int PCS_WGS72_UTM_zone_57S = 32357;
    public static final int PCS_WGS72_UTM_zone_58S = 32358;
    public static final int PCS_WGS72_UTM_zone_59S = 32359;
    public static final int PCS_WGS72_UTM_zone_60S = 32360;
    public static final int PCS_WGS72BE_UTM_zone_1N = 32401;
    public static final int PCS_WGS72BE_UTM_zone_2N = 32402;
    public static final int PCS_WGS72BE_UTM_zone_3N = 32403;
    public static final int PCS_WGS72BE_UTM_zone_4N = 32404;
    public static final int PCS_WGS72BE_UTM_zone_5N = 32405;
    public static final int PCS_WGS72BE_UTM_zone_6N = 32406;
    public static final int PCS_WGS72BE_UTM_zone_7N = 32407;
    public static final int PCS_WGS72BE_UTM_zone_8N = 32408;
    public static final int PCS_WGS72BE_UTM_zone_9N = 32409;
    public static final int PCS_WGS72BE_UTM_zone_10N = 32410;
    public static final int PCS_WGS72BE_UTM_zone_11N = 32411;
    public static final int PCS_WGS72BE_UTM_zone_12N = 32412;
    public static final int PCS_WGS72BE_UTM_zone_13N = 32413;
    public static final int PCS_WGS72BE_UTM_zone_14N = 32414;
    public static final int PCS_WGS72BE_UTM_zone_15N = 32415;
    public static final int PCS_WGS72BE_UTM_zone_16N = 32416;
    public static final int PCS_WGS72BE_UTM_zone_17N = 32417;
    public static final int PCS_WGS72BE_UTM_zone_18N = 32418;
    public static final int PCS_WGS72BE_UTM_zone_19N = 32419;
    public static final int PCS_WGS72BE_UTM_zone_20N = 32420;
    public static final int PCS_WGS72BE_UTM_zone_21N = 32421;
    public static final int PCS_WGS72BE_UTM_zone_22N = 32422;
    public static final int PCS_WGS72BE_UTM_zone_23N = 32423;
    public static final int PCS_WGS72BE_UTM_zone_24N = 32424;
    public static final int PCS_WGS72BE_UTM_zone_25N = 32425;
    public static final int PCS_WGS72BE_UTM_zone_26N = 32426;
    public static final int PCS_WGS72BE_UTM_zone_27N = 32427;
    public static final int PCS_WGS72BE_UTM_zone_28N = 32428;
    public static final int PCS_WGS72BE_UTM_zone_29N = 32429;
    public static final int PCS_WGS72BE_UTM_zone_30N = 32430;
    public static final int PCS_WGS72BE_UTM_zone_31N = 32431;
    public static final int PCS_WGS72BE_UTM_zone_32N = 32432;
    public static final int PCS_WGS72BE_UTM_zone_33N = 32433;
    public static final int PCS_WGS72BE_UTM_zone_34N = 32434;
    public static final int PCS_WGS72BE_UTM_zone_35N = 32435;
    public static final int PCS_WGS72BE_UTM_zone_36N = 32436;
    public static final int PCS_WGS72BE_UTM_zone_37N = 32437;
    public static final int PCS_WGS72BE_UTM_zone_38N = 32438;
    public static final int PCS_WGS72BE_UTM_zone_39N = 32439;
    public static final int PCS_WGS72BE_UTM_zone_40N = 32440;
    public static final int PCS_WGS72BE_UTM_zone_41N = 32441;
    public static final int PCS_WGS72BE_UTM_zone_42N = 32442;
    public static final int PCS_WGS72BE_UTM_zone_43N = 32443;
    public static final int PCS_WGS72BE_UTM_zone_44N = 32444;
    public static final int PCS_WGS72BE_UTM_zone_45N = 32445;
    public static final int PCS_WGS72BE_UTM_zone_46N = 32446;
    public static final int PCS_WGS72BE_UTM_zone_47N = 32447;
    public static final int PCS_WGS72BE_UTM_zone_48N = 32448;
    public static final int PCS_WGS72BE_UTM_zone_49N = 32449;
    public static final int PCS_WGS72BE_UTM_zone_50N = 32450;
    public static final int PCS_WGS72BE_UTM_zone_51N = 32451;
    public static final int PCS_WGS72BE_UTM_zone_52N = 32452;
    public static final int PCS_WGS72BE_UTM_zone_53N = 32453;
    public static final int PCS_WGS72BE_UTM_zone_54N = 32454;
    public static final int PCS_WGS72BE_UTM_zone_55N = 32455;
    public static final int PCS_WGS72BE_UTM_zone_56N = 32456;
    public static final int PCS_WGS72BE_UTM_zone_57N = 32457;
    public static final int PCS_WGS72BE_UTM_zone_58N = 32458;
    public static final int PCS_WGS72BE_UTM_zone_59N = 32459;
    public static final int PCS_WGS72BE_UTM_zone_60N = 32460;
    public static final int PCS_WGS72BE_UTM_zone_1S = 32501;
    public static final int PCS_WGS72BE_UTM_zone_2S = 32502;
    public static final int PCS_WGS72BE_UTM_zone_3S = 32503;
    public static final int PCS_WGS72BE_UTM_zone_4S = 32504;
    public static final int PCS_WGS72BE_UTM_zone_5S = 32505;
    public static final int PCS_WGS72BE_UTM_zone_6S = 32506;
    public static final int PCS_WGS72BE_UTM_zone_7S = 32507;
    public static final int PCS_WGS72BE_UTM_zone_8S = 32508;
    public static final int PCS_WGS72BE_UTM_zone_9S = 32509;
    public static final int PCS_WGS72BE_UTM_zone_10S = 32510;
    public static final int PCS_WGS72BE_UTM_zone_11S = 32511;
    public static final int PCS_WGS72BE_UTM_zone_12S = 32512;
    public static final int PCS_WGS72BE_UTM_zone_13S = 32513;
    public static final int PCS_WGS72BE_UTM_zone_14S = 32514;
    public static final int PCS_WGS72BE_UTM_zone_15S = 32515;
    public static final int PCS_WGS72BE_UTM_zone_16S = 32516;
    public static final int PCS_WGS72BE_UTM_zone_17S = 32517;
    public static final int PCS_WGS72BE_UTM_zone_18S = 32518;
    public static final int PCS_WGS72BE_UTM_zone_19S = 32519;
    public static final int PCS_WGS72BE_UTM_zone_20S = 32520;
    public static final int PCS_WGS72BE_UTM_zone_21S = 32521;
    public static final int PCS_WGS72BE_UTM_zone_22S = 32522;
    public static final int PCS_WGS72BE_UTM_zone_23S = 32523;
    public static final int PCS_WGS72BE_UTM_zone_24S = 32524;
    public static final int PCS_WGS72BE_UTM_zone_25S = 32525;
    public static final int PCS_WGS72BE_UTM_zone_26S = 32526;
    public static final int PCS_WGS72BE_UTM_zone_27S = 32527;
    public static final int PCS_WGS72BE_UTM_zone_28S = 32528;
    public static final int PCS_WGS72BE_UTM_zone_29S = 32529;
    public static final int PCS_WGS72BE_UTM_zone_30S = 32530;
    public static final int PCS_WGS72BE_UTM_zone_31S = 32531;
    public static final int PCS_WGS72BE_UTM_zone_32S = 32532;
    public static final int PCS_WGS72BE_UTM_zone_33S = 32533;
    public static final int PCS_WGS72BE_UTM_zone_34S = 32534;
    public static final int PCS_WGS72BE_UTM_zone_35S = 32535;
    public static final int PCS_WGS72BE_UTM_zone_36S = 32536;
    public static final int PCS_WGS72BE_UTM_zone_37S = 32537;
    public static final int PCS_WGS72BE_UTM_zone_38S = 32538;
    public static final int PCS_WGS72BE_UTM_zone_39S = 32539;
    public static final int PCS_WGS72BE_UTM_zone_40S = 32540;
    public static final int PCS_WGS72BE_UTM_zone_41S = 32541;
    public static final int PCS_WGS72BE_UTM_zone_42S = 32542;
    public static final int PCS_WGS72BE_UTM_zone_43S = 32543;
    public static final int PCS_WGS72BE_UTM_zone_44S = 32544;
    public static final int PCS_WGS72BE_UTM_zone_45S = 32545;
    public static final int PCS_WGS72BE_UTM_zone_46S = 32546;
    public static final int PCS_WGS72BE_UTM_zone_47S = 32547;
    public static final int PCS_WGS72BE_UTM_zone_48S = 32548;
    public static final int PCS_WGS72BE_UTM_zone_49S = 32549;
    public static final int PCS_WGS72BE_UTM_zone_50S = 32550;
    public static final int PCS_WGS72BE_UTM_zone_51S = 32551;
    public static final int PCS_WGS72BE_UTM_zone_52S = 32552;
    public static final int PCS_WGS72BE_UTM_zone_53S = 32553;
    public static final int PCS_WGS72BE_UTM_zone_54S = 32554;
    public static final int PCS_WGS72BE_UTM_zone_55S = 32555;
    public static final int PCS_WGS72BE_UTM_zone_56S = 32556;
    public static final int PCS_WGS72BE_UTM_zone_57S = 32557;
    public static final int PCS_WGS72BE_UTM_zone_58S = 32558;
    public static final int PCS_WGS72BE_UTM_zone_59S = 32559;
    public static final int PCS_WGS72BE_UTM_zone_60S = 32560;
    public static final int PCS_WGS84_UTM_zone_1N = 32601;
    public static final int PCS_WGS84_UTM_zone_2N = 32602;
    public static final int PCS_WGS84_UTM_zone_3N = 32603;
    public static final int PCS_WGS84_UTM_zone_4N = 32604;
    public static final int PCS_WGS84_UTM_zone_5N = 32605;
    public static final int PCS_WGS84_UTM_zone_6N = 32606;
    public static final int PCS_WGS84_UTM_zone_7N = 32607;
    public static final int PCS_WGS84_UTM_zone_8N = 32608;
    public static final int PCS_WGS84_UTM_zone_9N = 32609;
    public static final int PCS_WGS84_UTM_zone_10N = 32610;
    public static final int PCS_WGS84_UTM_zone_11N = 32611;
    public static final int PCS_WGS84_UTM_zone_12N = 32612;
    public static final int PCS_WGS84_UTM_zone_13N = 32613;
    public static final int PCS_WGS84_UTM_zone_14N = 32614;
    public static final int PCS_WGS84_UTM_zone_15N = 32615;
    public static final int PCS_WGS84_UTM_zone_16N = 32616;
    public static final int PCS_WGS84_UTM_zone_17N = 32617;
    public static final int PCS_WGS84_UTM_zone_18N = 32618;
    public static final int PCS_WGS84_UTM_zone_19N = 32619;
    public static final int PCS_WGS84_UTM_zone_20N = 32620;
    public static final int PCS_WGS84_UTM_zone_21N = 32621;
    public static final int PCS_WGS84_UTM_zone_22N = 32622;
    public static final int PCS_WGS84_UTM_zone_23N = 32623;
    public static final int PCS_WGS84_UTM_zone_24N = 32624;
    public static final int PCS_WGS84_UTM_zone_25N = 32625;
    public static final int PCS_WGS84_UTM_zone_26N = 32626;
    public static final int PCS_WGS84_UTM_zone_27N = 32627;
    public static final int PCS_WGS84_UTM_zone_28N = 32628;
    public static final int PCS_WGS84_UTM_zone_29N = 32629;
    public static final int PCS_WGS84_UTM_zone_30N = 32630;
    public static final int PCS_WGS84_UTM_zone_31N = 32631;
    public static final int PCS_WGS84_UTM_zone_32N = 32632;
    public static final int PCS_WGS84_UTM_zone_33N = 32633;
    public static final int PCS_WGS84_UTM_zone_34N = 32634;
    public static final int PCS_WGS84_UTM_zone_35N = 32635;
    public static final int PCS_WGS84_UTM_zone_36N = 32636;
    public static final int PCS_WGS84_UTM_zone_37N = 32637;
    public static final int PCS_WGS84_UTM_zone_38N = 32638;
    public static final int PCS_WGS84_UTM_zone_39N = 32639;
    public static final int PCS_WGS84_UTM_zone_40N = 32640;
    public static final int PCS_WGS84_UTM_zone_41N = 32641;
    public static final int PCS_WGS84_UTM_zone_42N = 32642;
    public static final int PCS_WGS84_UTM_zone_43N = 32643;
    public static final int PCS_WGS84_UTM_zone_44N = 32644;
    public static final int PCS_WGS84_UTM_zone_45N = 32645;
    public static final int PCS_WGS84_UTM_zone_46N = 32646;
    public static final int PCS_WGS84_UTM_zone_47N = 32647;
    public static final int PCS_WGS84_UTM_zone_48N = 32648;
    public static final int PCS_WGS84_UTM_zone_49N = 32649;
    public static final int PCS_WGS84_UTM_zone_50N = 32650;
    public static final int PCS_WGS84_UTM_zone_51N = 32651;
    public static final int PCS_WGS84_UTM_zone_52N = 32652;
    public static final int PCS_WGS84_UTM_zone_53N = 32653;
    public static final int PCS_WGS84_UTM_zone_54N = 32654;
    public static final int PCS_WGS84_UTM_zone_55N = 32655;
    public static final int PCS_WGS84_UTM_zone_56N = 32656;
    public static final int PCS_WGS84_UTM_zone_57N = 32657;
    public static final int PCS_WGS84_UTM_zone_58N = 32658;
    public static final int PCS_WGS84_UTM_zone_59N = 32659;
    public static final int PCS_WGS84_UTM_zone_60N = 32660;
    public static final int PCS_WGS84_UTM_zone_1S = 32701;
    public static final int PCS_WGS84_UTM_zone_2S = 32702;
    public static final int PCS_WGS84_UTM_zone_3S = 32703;
    public static final int PCS_WGS84_UTM_zone_4S = 32704;
    public static final int PCS_WGS84_UTM_zone_5S = 32705;
    public static final int PCS_WGS84_UTM_zone_6S = 32706;
    public static final int PCS_WGS84_UTM_zone_7S = 32707;
    public static final int PCS_WGS84_UTM_zone_8S = 32708;
    public static final int PCS_WGS84_UTM_zone_9S = 32709;
    public static final int PCS_WGS84_UTM_zone_10S = 32710;
    public static final int PCS_WGS84_UTM_zone_11S = 32711;
    public static final int PCS_WGS84_UTM_zone_12S = 32712;
    public static final int PCS_WGS84_UTM_zone_13S = 32713;
    public static final int PCS_WGS84_UTM_zone_14S = 32714;
    public static final int PCS_WGS84_UTM_zone_15S = 32715;
    public static final int PCS_WGS84_UTM_zone_16S = 32716;
    public static final int PCS_WGS84_UTM_zone_17S = 32717;
    public static final int PCS_WGS84_UTM_zone_18S = 32718;
    public static final int PCS_WGS84_UTM_zone_19S = 32719;
    public static final int PCS_WGS84_UTM_zone_20S = 32720;
    public static final int PCS_WGS84_UTM_zone_21S = 32721;
    public static final int PCS_WGS84_UTM_zone_22S = 32722;
    public static final int PCS_WGS84_UTM_zone_23S = 32723;
    public static final int PCS_WGS84_UTM_zone_24S = 32724;
    public static final int PCS_WGS84_UTM_zone_25S = 32725;
    public static final int PCS_WGS84_UTM_zone_26S = 32726;
    public static final int PCS_WGS84_UTM_zone_27S = 32727;
    public static final int PCS_WGS84_UTM_zone_28S = 32728;
    public static final int PCS_WGS84_UTM_zone_29S = 32729;
    public static final int PCS_WGS84_UTM_zone_30S = 32730;
    public static final int PCS_WGS84_UTM_zone_31S = 32731;
    public static final int PCS_WGS84_UTM_zone_32S = 32732;
    public static final int PCS_WGS84_UTM_zone_33S = 32733;
    public static final int PCS_WGS84_UTM_zone_34S = 32734;
    public static final int PCS_WGS84_UTM_zone_35S = 32735;
    public static final int PCS_WGS84_UTM_zone_36S = 32736;
    public static final int PCS_WGS84_UTM_zone_37S = 32737;
    public static final int PCS_WGS84_UTM_zone_38S = 32738;
    public static final int PCS_WGS84_UTM_zone_39S = 32739;
    public static final int PCS_WGS84_UTM_zone_40S = 32740;
    public static final int PCS_WGS84_UTM_zone_41S = 32741;
    public static final int PCS_WGS84_UTM_zone_42S = 32742;
    public static final int PCS_WGS84_UTM_zone_43S = 32743;
    public static final int PCS_WGS84_UTM_zone_44S = 32744;
    public static final int PCS_WGS84_UTM_zone_45S = 32745;
    public static final int PCS_WGS84_UTM_zone_46S = 32746;
    public static final int PCS_WGS84_UTM_zone_47S = 32747;
    public static final int PCS_WGS84_UTM_zone_48S = 32748;
    public static final int PCS_WGS84_UTM_zone_49S = 32749;
    public static final int PCS_WGS84_UTM_zone_50S = 32750;
    public static final int PCS_WGS84_UTM_zone_51S = 32751;
    public static final int PCS_WGS84_UTM_zone_52S = 32752;
    public static final int PCS_WGS84_UTM_zone_53S = 32753;
    public static final int PCS_WGS84_UTM_zone_54S = 32754;
    public static final int PCS_WGS84_UTM_zone_55S = 32755;
    public static final int PCS_WGS84_UTM_zone_56S = 32756;
    public static final int PCS_WGS84_UTM_zone_57S = 32757;
    public static final int PCS_WGS84_UTM_zone_58S = 32758;
    public static final int PCS_WGS84_UTM_zone_59S = 32759;
    public static final int PCS_WGS84_UTM_zone_60S = 32760;
    /* Generated from file epsg_gcs.properties */
    public static final int GCSE_Airy1830 = 4001;
    public static final int GCSE_AiryModified1849 = 4002;
    public static final int GCSE_AustralianNationalSpheroid = 4003;
    public static final int GCSE_Bessel1841 = 4004;
    public static final int GCSE_BesselModified = 4005;
    public static final int GCSE_BesselNamibia = 4006;
    public static final int GCSE_Clarke1858 = 4007;
    public static final int GCSE_Clarke1866 = 4008;
    public static final int GCSE_Clarke1866Michigan = 4009;
    public static final int GCSE_Clarke1880_Benoit = 4010;
    public static final int GCSE_Clarke1880_IGN = 4011;
    public static final int GCSE_Clarke1880_RGS = 4012;
    public static final int GCSE_Clarke1880_Arc = 4013;
    public static final int GCSE_Clarke1880_SGA1922 = 4014;
    public static final int GCSE_Everest1830_1937Adjustment = 4015;
    public static final int GCSE_Everest1830_1967Definition = 4016;
    public static final int GCSE_Everest1830_1975Definition = 4017;
    public static final int GCSE_Everest1830Modified = 4018;
    public static final int GCSE_GRS1980 = 4019;
    public static final int GCSE_Helmert1906 = 4020;
    public static final int GCSE_IndonesianNationalSpheroid = 4021;
    public static final int GCSE_International1924 = 4022;
    public static final int GCSE_International1967 = 4023;
    public static final int GCSE_Krassowsky1940 = 4024;
    public static final int GCSE_NWL9D = 4025;
    public static final int GCSE_NWL10D = 4026;
    public static final int GCSE_Plessis1817 = 4027;
    public static final int GCSE_Struve1860 = 4028;
    public static final int GCSE_WarOffice = 4029;
    public static final int GCSE_WGS84 = 4030;
    public static final int GCSE_GEM10C = 4031;
    public static final int GCSE_OSU86F = 4032;
    public static final int GCSE_OSU91A = 4033;
    public static final int GCSE_Clarke1880 = 4034;
    public static final int GCSE_Sphere = 4035;
    public static final int GCS_Adindan = 4201;
    public static final int GCS_AGD66 = 4202;
    public static final int GCS_AGD84 = 4203;
    public static final int GCS_Ain_el_Abd = 4204;
    public static final int GCS_Afgooye = 4205;
    public static final int GCS_Agadez = 4206;
    public static final int GCS_Lisbon = 4207;
    public static final int GCS_Aratu = 4208;
    public static final int GCS_Arc_1950 = 4209;
    public static final int GCS_Arc_1960 = 4210;
    public static final int GCS_Batavia = 4211;
    public static final int GCS_Barbados = 4212;
    public static final int GCS_Beduaram = 4213;
    public static final int GCS_Beijing_1954 = 4214;
    public static final int GCS_Belge_1950 = 4215;
    public static final int GCS_Bermuda_1957 = 4216;
    public static final int GCS_Bern_1898 = 4217;
    public static final int GCS_Bogota = 4218;
    public static final int GCS_Bukit_Rimpah = 4219;
    public static final int GCS_Camacupa = 4220;
    public static final int GCS_Campo_Inchauspe = 4221;
    public static final int GCS_Cape = 4222;
    public static final int GCS_Carthage = 4223;
    public static final int GCS_Chua = 4224;
    public static final int GCS_Corrego_Alegre = 4225;
    public static final int GCS_Cote_d_Ivoire = 4226;
    public static final int GCS_Deir_ez_Zor = 4227;
    public static final int GCS_Douala = 4228;
    public static final int GCS_Egypt_1907 = 4229;
    public static final int GCS_ED50 = 4230;
    public static final int GCS_ED87 = 4231;
    public static final int GCS_Fahud = 4232;
    public static final int GCS_Gandajika_1970 = 4233;
    public static final int GCS_Garoua = 4234;
    public static final int GCS_Guyane_Francaise = 4235;
    public static final int GCS_Hu_Tzu_Shan = 4236;
    public static final int GCS_HD72 = 4237;
    public static final int GCS_ID74 = 4238;
    public static final int GCS_Indian_1954 = 4239;
    public static final int GCS_Indian_1975 = 4240;
    public static final int GCS_Jamaica_1875 = 4241;
    public static final int GCS_JAD69 = 4242;
    public static final int GCS_Kalianpur = 4243;
    public static final int GCS_Kandawala = 4244;
    public static final int GCS_Kertau = 4245;
    public static final int GCS_KOC = 4246;
    public static final int GCS_La_Canoa = 4247;
    public static final int GCS_PSAD56 = 4248;
    public static final int GCS_Lake = 4249;
    public static final int GCS_Leigon = 4250;
    public static final int GCS_Liberia_1964 = 4251;
    public static final int GCS_Lome = 4252;
    public static final int GCS_Luzon_1911 = 4253;
    public static final int GCS_Hito_XVIII_1963 = 4254;
    public static final int GCS_Herat_North = 4255;
    public static final int GCS_Mahe_1971 = 4256;
    public static final int GCS_Makassar = 4257;
    public static final int GCS_EUREF89 = 4258;
    public static final int GCS_Malongo_1987 = 4259;
    public static final int GCS_Manoca = 4260;
    public static final int GCS_Merchich = 4261;
    public static final int GCS_Massawa = 4262;
    public static final int GCS_Minna = 4263;
    public static final int GCS_Mhast = 4264;
    public static final int GCS_Monte_Mario = 4265;
    public static final int GCS_M_poraloko = 4266;
    public static final int GCS_NAD27 = 4267;
    public static final int GCS_NAD_Michigan = 4268;
    public static final int GCS_NAD83 = 4269;
    public static final int GCS_Nahrwan_1967 = 4270;
    public static final int GCS_Naparima_1972 = 4271;
    public static final int GCS_GD49 = 4272;
    public static final int GCS_NGO_1948 = 4273;
    public static final int GCS_Datum_73 = 4274;
    public static final int GCS_NTF = 4275;
    public static final int GCS_NSWC_9Z_2 = 4276;
    public static final int GCS_OSGB_1936 = 4277;
    public static final int GCS_OSGB70 = 4278;
    public static final int GCS_OS_SN80 = 4279;
    public static final int GCS_Padang = 4280;
    public static final int GCS_Palestine_1923 = 4281;
    public static final int GCS_Pointe_Noire = 4282;
    public static final int GCS_GDA94 = 4283;
    public static final int GCS_Pulkovo_1942 = 4284;
    public static final int GCS_Qatar = 4285;
    public static final int GCS_Qatar_1948 = 4286;
    public static final int GCS_Qornoq = 4287;
    public static final int GCS_Loma_Quintana = 4288;
    public static final int GCS_Amersfoort = 4289;
    public static final int GCS_RT38 = 4290;
    public static final int GCS_SAD69 = 4291;
    public static final int GCS_Sapper_Hill_1943 = 4292;
    public static final int GCS_Schwarzeck = 4293;
    public static final int GCS_Segora = 4294;
    public static final int GCS_Serindung = 4295;
    public static final int GCS_Sudan = 4296;
    public static final int GCS_Tananarive = 4297;
    public static final int GCS_Timbalai_1948 = 4298;
    public static final int GCS_TM65 = 4299;
    public static final int GCS_TM75 = 4300;
    public static final int GCS_Tokyo = 4301;
    public static final int GCS_Trinidad_1903 = 4302;
    public static final int GCS_TC_1948 = 4303;
    public static final int GCS_Voirol_1875 = 4304;
    public static final int GCS_Voirol_Unifie = 4305;
    public static final int GCS_Bern_1938 = 4306;
    public static final int GCS_Nord_Sahara_1959 = 4307;
    public static final int GCS_Stockholm_1938 = 4308;
    public static final int GCS_Yacare = 4309;
    public static final int GCS_Yoff = 4310;
    public static final int GCS_Zanderij = 4311;
    public static final int GCS_MGI = 4312;
    public static final int GCS_Belge_1972 = 4313;
    public static final int GCS_DHDN = 4314;
    public static final int GCS_Conakry_1905 = 4315;
    public static final int GCS_WGS_72 = 4322;
    public static final int GCS_WGS_72BE = 4324;
    public static final int GCS_WGS_84 = 4326;
    public static final int GCS_Bern_1898_Bern = 4801;
    public static final int GCS_Bogota_Bogota = 4802;
    public static final int GCS_Lisbon_Lisbon = 4803;
    public static final int GCS_Makassar_Jakarta = 4804;
    public static final int GCS_MGI_Ferro = 4805;
    public static final int GCS_Monte_Mario_Rome = 4806;
    public static final int GCS_NTF_Paris = 4807;
    public static final int GCS_Padang_Jakarta = 4808;
    public static final int GCS_Belge_1950_Brussels = 4809;
    public static final int GCS_Tananarive_Paris = 4810;
    public static final int GCS_Voirol_1875_Paris = 4811;
    public static final int GCS_Voirol_Unifie_Paris = 4812;
    public static final int GCS_Batavia_Jakarta = 4813;
    public static final int GCS_ATF_Paris = 4901;
    public static final int GCS_NDG_Paris = 4902;
    /* Generated from file epsg_ellipse.properties */
    public static final int Ellipse_Airy_1830 = 7001;
    public static final int Ellipse_Airy_Modified_1849 = 7002;
    public static final int Ellipse_Australian_National_Spheroid = 7003;
    public static final int Ellipse_Bessel_1841 = 7004;
    public static final int Ellipse_Bessel_Modified = 7005;
    public static final int Ellipse_Bessel_Namibia = 7006;
    public static final int Ellipse_Clarke_1858 = 7007;
    public static final int Ellipse_Clarke_1866 = 7008;
    public static final int Ellipse_Clarke_1866_Michigan = 7009;
    public static final int Ellipse_Clarke_1880_Benoit = 7010;
    public static final int Ellipse_Clarke_1880_IGN = 7011;
    public static final int Ellipse_Clarke_1880_RGS = 7012;
    public static final int Ellipse_Clarke_1880_Arc = 7013;
    public static final int Ellipse_Clarke_1880_SGA_1922 = 7014;
    public static final int Ellipse_Everest_1830_1937_Adjustment = 7015;
    public static final int Ellipse_Everest_1830_1967_Definition = 7016;
    public static final int Ellipse_Everest_1830_1975_Definition = 7017;
    public static final int Ellipse_Everest_1830_Modified = 7018;
    public static final int Ellipse_GRS_1980 = 7019;
    public static final int Ellipse_Helmert_1906 = 7020;
    public static final int Ellipse_Indonesian_National_Spheroid = 7021;
    public static final int Ellipse_International_1924 = 7022;
    public static final int Ellipse_International_1967 = 7023;
    public static final int Ellipse_Krassowsky_1940 = 7024;
    public static final int Ellipse_NWL_9D = 7025;
    public static final int Ellipse_NWL_10D = 7026;
    public static final int Ellipse_Plessis_1817 = 7027;
    public static final int Ellipse_Struve_1860 = 7028;
    public static final int Ellipse_War_Office = 7029;
    public static final int Ellipse_WGS_84 = 7030;
    public static final int Ellipse_GEM_10C = 7031;
    public static final int Ellipse_OSU86F = 7032;
    public static final int Ellipse_OSU91A = 7033;
    public static final int Ellipse_Clarke_1880 = 7034;
    public static final int Ellipse_Sphere = 7035;
    /* Generated from file epsg_datum.properties */
    public static final int DatumE_Airy1830 = 6001;
    public static final int DatumE_AiryModified1849 = 6002;
    public static final int DatumE_AustralianNationalSpheroid = 6003;
    public static final int DatumE_Bessel1841 = 6004;
    public static final int DatumE_BesselModified = 6005;
    public static final int DatumE_BesselNamibia = 6006;
    public static final int DatumE_Clarke1858 = 6007;
    public static final int DatumE_Clarke1866 = 6008;
    public static final int DatumE_Clarke1866Michigan = 6009;
    public static final int DatumE_Clarke1880_Benoit = 6010;
    public static final int DatumE_Clarke1880_IGN = 6011;
    public static final int DatumE_Clarke1880_RGS = 6012;
    public static final int DatumE_Clarke1880_Arc = 6013;
    public static final int DatumE_Clarke1880_SGA1922 = 6014;
    public static final int DatumE_Everest1830_1937Adjustment = 6015;
    public static final int DatumE_Everest1830_1967Definition = 6016;
    public static final int DatumE_Everest1830_1975Definition = 6017;
    public static final int DatumE_Everest1830Modified = 6018;
    public static final int DatumE_GRS1980 = 6019;
    public static final int DatumE_Helmert1906 = 6020;
    public static final int DatumE_IndonesianNationalSpheroid = 6021;
    public static final int DatumE_International1924 = 6022;
    public static final int DatumE_International1967 = 6023;
    public static final int DatumE_Krassowsky1960 = 6024;
    public static final int DatumE_NWL9D = 6025;
    public static final int DatumE_NWL10D = 6026;
    public static final int DatumE_Plessis1817 = 6027;
    public static final int DatumE_Struve1860 = 6028;
    public static final int DatumE_WarOffice = 6029;
    public static final int DatumE_WGS84 = 6030;
    public static final int DatumE_GEM10C = 6031;
    public static final int DatumE_OSU86F = 6032;
    public static final int DatumE_OSU91A = 6033;
    public static final int DatumE_Clarke1880 = 6034;
    public static final int DatumE_Sphere = 6035;
    public static final int Datum_Adindan = 6201;
    public static final int Datum_Australian_Geodetic_Datum_1966 = 6202;
    public static final int Datum_Australian_Geodetic_Datum_1984 = 6203;
    public static final int Datum_Ain_el_Abd_1970 = 6204;
    public static final int Datum_Afgooye = 6205;
    public static final int Datum_Agadez = 6206;
    public static final int Datum_Lisbon = 6207;
    public static final int Datum_Aratu = 6208;
    public static final int Datum_Arc_1950 = 6209;
    public static final int Datum_Arc_1960 = 6210;
    public static final int Datum_Batavia = 6211;
    public static final int Datum_Barbados = 6212;
    public static final int Datum_Beduaram = 6213;
    public static final int Datum_Beijing_1954 = 6214;
    public static final int Datum_Reseau_National_Belge_1950 = 6215;
    public static final int Datum_Bermuda_1957 = 6216;
    public static final int Datum_Bern_1898 = 6217;
    public static final int Datum_Bogota = 6218;
    public static final int Datum_Bukit_Rimpah = 6219;
    public static final int Datum_Camacupa = 6220;
    public static final int Datum_Campo_Inchauspe = 6221;
    public static final int Datum_Cape = 6222;
    public static final int Datum_Carthage = 6223;
    public static final int Datum_Chua = 6224;
    public static final int Datum_Corrego_Alegre = 6225;
    public static final int Datum_Cote_d_Ivoire = 6226;
    public static final int Datum_Deir_ez_Zor = 6227;
    public static final int Datum_Douala = 6228;
    public static final int Datum_Egypt_1907 = 6229;
    public static final int Datum_European_Datum_1950 = 6230;
    public static final int Datum_European_Datum_1987 = 6231;
    public static final int Datum_Fahud = 6232;
    public static final int Datum_Gandajika_1970 = 6233;
    public static final int Datum_Garoua = 6234;
    public static final int Datum_Guyane_Francaise = 6235;
    public static final int Datum_Hu_Tzu_Shan = 6236;
    public static final int Datum_Hungarian_Datum_1972 = 6237;
    public static final int Datum_Indonesian_Datum_1974 = 6238;
    public static final int Datum_Indian_1954 = 6239;
    public static final int Datum_Indian_1975 = 6240;
    public static final int Datum_Jamaica_1875 = 6241;
    public static final int Datum_Jamaica_1969 = 6242;
    public static final int Datum_Kalianpur = 6243;
    public static final int Datum_Kandawala = 6244;
    public static final int Datum_Kertau = 6245;
    public static final int Datum_Kuwait_Oil_Company = 6246;
    public static final int Datum_La_Canoa = 6247;
    public static final int Datum_Provisional_S_American_Datum_1956 = 6248;
    public static final int Datum_Lake = 6249;
    public static final int Datum_Leigon = 6250;
    public static final int Datum_Liberia_1964 = 6251;
    public static final int Datum_Lome = 6252;
    public static final int Datum_Luzon_1911 = 6253;
    public static final int Datum_Hito_XVIII_1963 = 6254;
    public static final int Datum_Herat_North = 6255;
    public static final int Datum_Mahe_1971 = 6256;
    public static final int Datum_Makassar = 6257;
    public static final int Datum_European_Reference_System_1989 = 6258;
    public static final int Datum_Malongo_1987 = 6259;
    public static final int Datum_Manoca = 6260;
    public static final int Datum_Merchich = 6261;
    public static final int Datum_Massawa = 6262;
    public static final int Datum_Minna = 6263;
    public static final int Datum_Mhast = 6264;
    public static final int Datum_Monte_Mario = 6265;
    public static final int Datum_M_poraloko = 6266;
    public static final int Datum_North_American_Datum_1927 = 6267;
    public static final int Datum_NAD_Michigan = 6268;
    public static final int Datum_North_American_Datum_1983 = 6269;
    public static final int Datum_Nahrwan_1967 = 6270;
    public static final int Datum_Naparima_1972 = 6271;
    public static final int Datum_New_Zealand_Geodetic_Datum_1949 = 6272;
    public static final int Datum_NGO_1948 = 6273;
    public static final int Datum_Datum_73 = 6274;
    public static final int Datum_Nouvelle_Triangulation_Francaise = 6275;
    public static final int Datum_NSWC_9Z_2 = 6276;
    public static final int Datum_OSGB_1936 = 6277;
    public static final int Datum_OSGB_1970_SN = 6278;
    public static final int Datum_OS_SN_1980 = 6279;
    public static final int Datum_Padang_1884 = 6280;
    public static final int Datum_Palestine_1923 = 6281;
    public static final int Datum_Pointe_Noire = 6282;
    public static final int Datum_Geocentric_Datum_of_Australia_1994 = 6283;
    public static final int Datum_Pulkovo_1942 = 6284;
    public static final int Datum_Qatar = 6285;
    public static final int Datum_Qatar_1948 = 6286;
    public static final int Datum_Qornoq = 6287;
    public static final int Datum_Loma_Quintana = 6288;
    public static final int Datum_Amersfoort = 6289;
    public static final int Datum_RT38 = 6290;
    public static final int Datum_South_American_Datum_1969 = 6291;
    public static final int Datum_Sapper_Hill_1943 = 6292;
    public static final int Datum_Schwarzeck = 6293;
    public static final int Datum_Segora = 6294;
    public static final int Datum_Serindung = 6295;
    public static final int Datum_Sudan = 6296;
    public static final int Datum_Tananarive_1925 = 6297;
    public static final int Datum_Timbalai_1948 = 6298;
    public static final int Datum_TM65 = 6299;
    public static final int Datum_TM75 = 6300;
    public static final int Datum_Tokyo = 6301;
    public static final int Datum_Trinidad_1903 = 6302;
    public static final int Datum_Trucial_Coast_1948 = 6303;
    public static final int Datum_Voirol_1875 = 6304;
    public static final int Datum_Voirol_Unifie_1960 = 6305;
    public static final int Datum_Bern_1938 = 6306;
    public static final int Datum_Nord_Sahara_1959 = 6307;
    public static final int Datum_Stockholm_1938 = 6308;
    public static final int Datum_Yacare = 6309;
    public static final int Datum_Yoff = 6310;
    public static final int Datum_Zanderij = 6311;
    public static final int Datum_Militar_Geographische_Institut = 6312;
    public static final int Datum_Reseau_National_Belge_1972 = 6313;
    public static final int Datum_Deutsche_Hauptdreiecksnetz = 6314;
    public static final int Datum_Conakry_1905 = 6315;
    public static final int Datum_WGS72 = 6322;
    public static final int Datum_WGS72_Transit_Broadcast_Ephemeris = 6324;
    public static final int Datum_WGS84 = 6326;
    public static final int Datum_Ancienne_Triangulation_Francaise = 6901;
    public static final int Datum_Nord_de_Guerre = 6902;
    
    public static EPSGCodes getInstance() {
        return Holder.instance;
    }

    private EPSGCodes() {
        init(EPSGCodes.class.getFields());
    }
    
    // Initialization on demand holder idiom
    private static class Holder {
        private static final EPSGCodes instance = new EPSGCodes();
    }
}
