/*
 * Decompiled with CFR 0.152.
 */
package com.bc.io;

import com.bc.io.IOUtils;
import com.bc.io.ObservableInputStream;
import com.bc.io.ProgressMonitorInputStreamObserver;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitor;

public class FileDownloader {
    public static File downloadFile(URL fileUrl, File targetDir, Component parentComponent) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(targetDir, new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        String message = "Downloading data from " + fileUrl + " to " + outputFile;
        ProgressMonitor progressMonitor = new ProgressMonitor(parentComponent, message, "", 0, 100);
        BufferedInputStream is = new BufferedInputStream(new ObservableInputStream(urlConnection.getInputStream(), contentLength, new ProgressMonitorInputStreamObserver(progressMonitor)));
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            IOUtils.copyBytesAndClose(is, os);
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            progressMonitor.close();
        }
        return outputFile;
    }
}

