/*
 * Decompiled with CFR 0.152.
 */
package com.bc.io;

import java.io.File;
import java.io.FileFilter;

public class FileScanner {
    public static void scanDirectory(String dirPath, FileFilter fileFilter, Handler fileHandler) {
        FileScanner.scanDirectory(new File(dirPath), fileFilter, fileHandler);
    }

    public static void scanDirectories(String[] dirPaths, FileFilter fileFilter, Handler fileHandler) {
        for (int i = 0; i < dirPaths.length; ++i) {
            FileScanner.scanDirectory(dirPaths[i], fileFilter, fileHandler);
        }
    }

    public static void scanDirectory(File dir, FileFilter fileFilter, Handler fileHandler) {
        FileScanner.scanDirectories(new File[]{dir}, fileFilter, fileHandler);
    }

    public static void scanDirectories(File[] dirs, FileFilter fileFilter, Handler fileHandler) {
        for (int i = 0; i < dirs.length; ++i) {
            FileScanner.scanDirectoryImpl(dirs[i], fileFilter, fileHandler);
        }
    }

    private static void scanDirectoryImpl(File dir, FileFilter fileFilter, Handler fileHandler) {
        File[] files = dir.listFiles();
        if (files == null) {
            fileHandler.onDirectoryScanRejected(dir);
            return;
        }
        fileHandler.onDirectoryScanStarted(dir);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileScanner.scanDirectoryImpl(file, fileFilter, fileHandler);
                continue;
            }
            if (!fileFilter.accept(file)) continue;
            fileHandler.onFileAccepted(file);
        }
        fileHandler.onDirectoryScanEnded(dir);
    }

    public static class HandlerAdapter
    implements Handler {
        @Override
        public void onDirectoryScanEnded(File dir) {
        }

        @Override
        public void onDirectoryScanStarted(File dir) {
        }

        @Override
        public void onDirectoryScanRejected(File dir) {
        }

        @Override
        public void onFileAccepted(File file) {
        }
    }

    public static interface Handler {
        public void onDirectoryScanStarted(File var1);

        public void onDirectoryScanEnded(File var1);

        public void onDirectoryScanRejected(File var1);

        public void onFileAccepted(File var1);
    }
}

