/*
 * Decompiled with CFR 0.152.
 */
package com.bc.io;

import com.bc.io.IOUtils;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ProgressMonitor;

public class FileUnpacker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackZip(File archiveFile, File targetDir, Component parentComponent) throws IOException {
        ZipFile zipFile = new ZipFile(archiveFile);
        List entryList = FileUnpacker.extractZipEntries(zipFile);
        ArrayList createdFileList = new ArrayList(entryList.size());
        ArrayList createdDirList = new ArrayList(entryList.size());
        String message = "Unpacking data from " + archiveFile;
        ProgressMonitor progressMonitor = new ProgressMonitor(parentComponent, message, "", 0, entryList.size() - 1);
        try {
            FileUnpacker.extractZipEntries(zipFile, targetDir, progressMonitor, entryList, createdFileList, createdDirList);
        }
        catch (IOException e) {
            FileUnpacker.deleteFilesInList(createdFileList);
            FileUnpacker.deleteFilesInList(createdDirList);
        }
        finally {
            progressMonitor.close();
            zipFile.close();
        }
    }

    private static List extractZipEntries(ZipFile zipFile) {
        ArrayList<ZipEntry> entryList = new ArrayList<ZipEntry>(100);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            entryList.add(enumeration.nextElement());
        }
        return entryList;
    }

    private static void extractZipEntries(ZipFile zipFile, File targetDir, ProgressMonitor progressMonitor, List entryList, List createdFileList, List createdDirList) throws IOException {
        progressMonitor.setProgress(0);
        for (int i = 0; i < entryList.size(); ++i) {
            ZipEntry zipEntry = (ZipEntry)entryList.get(i);
            if (progressMonitor.isCanceled()) {
                throw new InterruptedIOException();
            }
            String zipName = zipEntry.getName().replace('/', File.separatorChar);
            File outputFile = new File(targetDir, zipName);
            if (zipEntry.isDirectory()) {
                FileUnpacker.ensureExistingDir(outputFile, createdDirList);
            } else {
                String note = "Writing file " + outputFile;
                progressMonitor.setNote(note);
                File parentDir = outputFile.getParentFile();
                if (parentDir != null) {
                    FileUnpacker.ensureExistingDir(parentDir, createdDirList);
                }
                FileUnpacker.writeOutputFile(zipFile, zipEntry, outputFile, createdFileList);
            }
            progressMonitor.setProgress(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputFile(ZipFile zipFile, ZipEntry zipEntry, File outputFile, List createdFileList) throws IOException {
        BufferedOutputStream os;
        boolean outputFileExists = outputFile.exists();
        BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            IOUtils.copyBytesAndClose(is, os);
        }
        finally {
            if (!outputFileExists) {
                createdFileList.add(outputFile);
            }
        }
    }

    private static void ensureExistingDir(File outputDir, List createdDirList) throws IOException {
        boolean created = IOUtils.createDir(outputDir);
        if (created) {
            createdDirList.add(outputDir);
        }
    }

    private static void deleteFilesInList(List createdFileList) {
        for (int i = createdFileList.size() - 1; i >= 0; --i) {
            File outputFile = (File)createdFileList.get(i);
            outputFile.delete();
        }
    }
}

