/*
 * Decompiled with CFR 0.152.
 */
package com.bc.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static void copyBytes(InputStream is, OutputStream os) throws IOException {
        int b;
        while ((b = is.read()) != -1) {
            os.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytesAndClose(InputStream is, OutputStream os) throws IOException {
        try {
            IOUtils.copyBytes(is, os);
        }
        finally {
            try {
                os.close();
            }
            finally {
                is.close();
            }
        }
    }

    public static boolean createDir(File dir) throws IOException {
        boolean created = dir.mkdirs();
        if (!dir.exists()) {
            throw new IOException("failed to create output directory " + dir);
        }
        return created;
    }
}

