/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Function;
import com.bc.jexp.Symbol;
import com.bc.jexp.Variable;
import java.util.List;

public abstract class Term {
    public static final int TYPE_B = 1;
    public static final int TYPE_I = 2;
    public static final int TYPE_D = 3;
    public static final int TYPE_S = 4;
    private static final Term[] _EMPTY_TERM_ARRAY = new Term[0];

    public abstract int getRetType();

    public abstract boolean evalB(EvalEnv var1);

    public abstract int evalI(EvalEnv var1);

    public abstract double evalD(EvalEnv var1);

    public String evalS(EvalEnv env) {
        return this.toString();
    }

    public Term[] getChildren() {
        return _EMPTY_TERM_ARRAY;
    }

    public abstract String toString();

    public final boolean isB() {
        return this.getRetType() == 1;
    }

    public final boolean isI() {
        return this.getRetType() == 2;
    }

    public final boolean isD() {
        return this.getRetType() == 3;
    }

    public final boolean isN() {
        return this.isI() || this.isD();
    }

    public static boolean toB(int value) {
        return value != 0;
    }

    public static boolean toB(double value) {
        return value != 0.0;
    }

    public static int toI(boolean value) {
        return value ? 1 : 0;
    }

    public static int toI(double value) {
        return (int)value;
    }

    public static double toD(boolean value) {
        return value ? 1.0 : 0.0;
    }

    public static String toS(boolean value) {
        return Boolean.toString(value);
    }

    public static String toS(int value) {
        return Integer.toString(value);
    }

    public static String toS(double value) {
        return Double.toString(value);
    }

    private static String getParamString(String name, Term[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public static final class GeD
    extends BinaryB {
        public GeD(Term arg1, Term arg2) {
            super("GeD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) >= this.arg2.evalD(env);
        }
    }

    public static final class GeI
    extends BinaryB {
        public GeI(Term arg1, Term arg2) {
            super("GeI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) >= this.arg2.evalI(env);
        }
    }

    public static final class GtD
    extends BinaryB {
        public GtD(Term arg1, Term arg2) {
            super("GtD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) > this.arg2.evalD(env);
        }
    }

    public static final class GtI
    extends BinaryB {
        public GtI(Term arg1, Term arg2) {
            super("GtI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) > this.arg2.evalI(env);
        }
    }

    public static final class LeD
    extends BinaryB {
        public LeD(Term arg1, Term arg2) {
            super("LeD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) <= this.arg2.evalD(env);
        }
    }

    public static final class LeI
    extends BinaryB {
        public LeI(Term arg1, Term arg2) {
            super("LeI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) <= this.arg2.evalI(env);
        }
    }

    public static final class LtD
    extends BinaryB {
        public LtD(Term arg1, Term arg2) {
            super("LtD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) < this.arg2.evalD(env);
        }
    }

    public static final class LtI
    extends BinaryB {
        public LtI(Term arg1, Term arg2) {
            super("LtI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) < this.arg2.evalI(env);
        }
    }

    public static final class NEqD
    extends BinaryB {
        public NEqD(Term arg1, Term arg2) {
            super("NEqD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) != this.arg2.evalD(env);
        }
    }

    public static final class NEqI
    extends BinaryB {
        public NEqI(Term arg1, Term arg2) {
            super("NEqI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) != this.arg2.evalI(env);
        }
    }

    public static final class NEqB
    extends BinaryB {
        public NEqB(Term arg1, Term arg2) {
            super("NEqB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) != this.arg2.evalB(env);
        }
    }

    public static final class EqD
    extends BinaryB {
        public EqD(Term arg1, Term arg2) {
            super("EqD", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalD(env) == this.arg2.evalD(env);
        }
    }

    public static final class EqI
    extends BinaryB {
        public EqI(Term arg1, Term arg2) {
            super("EqI", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalI(env) == this.arg2.evalI(env);
        }
    }

    public static final class EqB
    extends BinaryB {
        public EqB(Term arg1, Term arg2) {
            super("EqB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) == this.arg2.evalB(env);
        }
    }

    public static final class Mod
    extends BinaryN {
        public Mod(int type, Term arg1, Term arg2) {
            super("Mod", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) % this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) % this.arg2.evalD(env);
        }
    }

    public static final class Div
    extends BinaryN {
        public Div(int type, Term arg1, Term arg2) {
            super("Div", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) / this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) / this.arg2.evalD(env);
        }
    }

    public static final class Mul
    extends BinaryN {
        public Mul(int type, Term arg1, Term arg2) {
            super("Mul", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) * this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) * this.arg2.evalD(env);
        }
    }

    public static final class Sub
    extends BinaryN {
        public Sub(int type, Term arg1, Term arg2) {
            super("Sub", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) - this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) - this.arg2.evalD(env);
        }
    }

    public static final class Add
    extends BinaryN {
        public Add(int type, Term arg1, Term arg2) {
            super("Add", type, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) + this.arg2.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalD(env) + this.arg2.evalD(env);
        }
    }

    public static final class Neg
    extends UnaryN {
        public Neg(int type, Term arg) {
            super("Neg", type, arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return -this.arg.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return -this.arg.evalD(env);
        }
    }

    public static final class OrI
    extends BinaryI {
        public OrI(Term arg1, Term arg2) {
            super("OrI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) | this.arg2.evalI(env);
        }
    }

    public static final class AndI
    extends BinaryI {
        public AndI(Term arg1, Term arg2) {
            super("AndI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) & this.arg2.evalI(env);
        }
    }

    public static final class XOrI
    extends BinaryI {
        public XOrI(Term arg1, Term arg2) {
            super("XOrI", arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalI(env) ^ this.arg2.evalI(env);
        }
    }

    public static final class NotI
    extends UnaryI {
        public NotI(Term arg) {
            super("NotI", arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return ~this.arg.evalI(env);
        }
    }

    public static final class OrB
    extends BinaryB {
        public OrB(Term arg1, Term arg2) {
            super("OrB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) || this.arg2.evalB(env);
        }
    }

    public static final class AndB
    extends BinaryB {
        public AndB(Term arg1, Term arg2) {
            super("AndB", arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) && this.arg2.evalB(env);
        }
    }

    public static final class NotB
    extends UnaryB {
        public NotB(Term arg) {
            super("NotB", arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return !this.arg.evalB(env);
        }
    }

    public static final class Assign
    extends Binary {
        public Assign(Term arg1, Term arg2) {
            super("Assign", arg1.getRetType(), arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv context) {
            throw new EvalException("not implemented");
        }

        @Override
        public int evalI(EvalEnv env) {
            throw new EvalException("not implemented");
        }

        @Override
        public double evalD(EvalEnv env) {
            throw new EvalException("not implemented");
        }
    }

    public static final class Cond
    extends Op {
        protected final Term arg1;
        protected final Term arg2;
        protected final Term arg3;

        public Cond(int type, Term arg1, Term arg2, Term arg3) {
            super("Cond", type, new Term[]{arg1, arg2, arg3});
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.arg3 = arg3;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalB(env) : this.arg3.evalB(env);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalI(env) : this.arg3.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.arg1.evalB(env) ? this.arg2.evalD(env) : this.arg3.evalD(env);
        }
    }

    public static abstract class BinaryN
    extends Binary {
        protected BinaryN(String name, int type, Term arg1, Term arg2) {
            super(name, type, arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.type == 2 ? BinaryN.toB(this.evalI(env)) : BinaryN.toB(this.evalD(env));
        }
    }

    public static abstract class BinaryI
    extends Binary {
        protected BinaryI(String name, Term arg1, Term arg2) {
            super(name, 2, arg1, arg2);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return BinaryI.toB(this.evalI(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalI(env);
        }
    }

    public static abstract class BinaryB
    extends Binary {
        protected BinaryB(String name, Term arg1, Term arg2) {
            super(name, 1, arg1, arg2);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.evalB(env) ? 1 : 0;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalB(env) ? 1.0 : 0.0;
        }
    }

    public static abstract class Binary
    extends Op {
        protected final Term arg1;
        protected final Term arg2;

        protected Binary(String name, int type, Term arg1, Term arg2) {
            super(name, type, new Term[]{arg1, arg2});
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
    }

    public static abstract class UnaryN
    extends Unary {
        protected UnaryN(String name, int type, Term arg) {
            super(name, type, arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return UnaryN.toB(this.evalD(env));
        }
    }

    public static abstract class UnaryI
    extends Unary {
        protected UnaryI(String name, Term arg) {
            super(name, 2, arg);
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return UnaryI.toB(this.evalI(env));
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalI(env);
        }
    }

    public static abstract class UnaryB
    extends Unary {
        protected UnaryB(String name, Term arg) {
            super(name, 1, arg);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.evalB(env) ? 1 : 0;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.evalB(env) ? 1.0 : 0.0;
        }
    }

    public static abstract class Unary
    extends Op {
        protected final Term arg;

        protected Unary(String name, int type, Term arg) {
            super(name, type, new Term[]{arg});
            this.arg = arg;
        }
    }

    public static abstract class Op
    extends Term {
        protected final String name;
        protected final int type;
        protected final Term[] args;

        protected Op(String name, int type, Term[] args) {
            this.name = name.intern();
            this.type = type;
            this.args = args;
        }

        @Override
        public int getRetType() {
            return this.type;
        }

        public Term[] getArgs() {
            return this.args;
        }

        @Override
        public Term[] getChildren() {
            return this.getArgs();
        }

        @Override
        public String toString() {
            return Term.getParamString(this.name, this.args);
        }
    }

    public static final class Call
    extends Term {
        protected final Function function;
        protected final Term[] args;

        public Call(Function function, List<Term> args) {
            this(function, args.toArray(new Term[args.size()]));
        }

        public Call(Function function, Term[] args) {
            this.function = function;
            this.args = args;
        }

        @Override
        public int getRetType() {
            return this.function.getRetType();
        }

        public Function getFunction() {
            return this.function;
        }

        public Term[] getArgs() {
            return this.args;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.function.evalB(env, this.args);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.function.evalI(env, this.args);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.function.evalD(env, this.args);
        }

        @Override
        public Term[] getChildren() {
            return this.getArgs();
        }

        @Override
        public String toString() {
            return Term.getParamString(this.function.getName(), this.args);
        }
    }

    public static final class Ref
    extends Term {
        protected final Symbol symbol;

        public Ref(Symbol symbol) {
            this.symbol = symbol;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Variable getVariable() {
            return this.symbol instanceof Variable ? (Variable)this.symbol : null;
        }

        @Override
        public int getRetType() {
            return this.symbol.getRetType();
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.symbol.evalB(env);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.symbol.evalI(env);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.symbol.evalD(env);
        }

        @Override
        public String evalS(EvalEnv env) {
            return this.symbol.evalS(env);
        }

        @Override
        public String toString() {
            return this.symbol.getName();
        }
    }

    public static class ConstS
    extends Term {
        private final String value;

        public ConstS(String value) {
            this.value = value;
        }

        @Override
        public int getRetType() {
            return 4;
        }

        @Override
        public boolean evalB(EvalEnv context) {
            if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false")) {
                return Boolean.valueOf(this.value);
            }
            throw new EvalException("Not a boolean.");
        }

        @Override
        public int evalI(EvalEnv env) {
            try {
                return Integer.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new EvalException("Not an integer.", e);
            }
        }

        @Override
        public double evalD(EvalEnv env) {
            try {
                return Double.valueOf(this.value);
            }
            catch (NumberFormatException e) {
                throw new EvalException("Not a double.", e);
            }
        }

        @Override
        public String evalS(EvalEnv env) {
            return this.value;
        }

        @Override
        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    public static final class ConstD
    extends Term {
        private final double value;

        public ConstD(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 3;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return ConstD.toB(this.value);
        }

        @Override
        public int evalI(EvalEnv env) {
            return ConstD.toI(this.value);
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class ConstI
    extends Term {
        private final int value;

        public ConstI(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 2;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return ConstI.toB(this.value);
        }

        @Override
        public int evalI(EvalEnv env) {
            return this.value;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this.value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class ConstB
    extends Term {
        private final boolean value;

        public ConstB(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public int getRetType() {
            return 1;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this.value;
        }

        @Override
        public int evalI(EvalEnv env) {
            return ConstB.toI(this.value);
        }

        @Override
        public double evalD(EvalEnv env) {
            return ConstB.toD(this.value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

