/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Function;
import com.bc.jexp.Term;

public abstract class AbstractFunction
implements Function {
    private final String name;
    private final int retType;
    private final int numArgs;
    private final int[] argTypes;

    protected AbstractFunction(String name, int retType, int numArgs) {
        this(name, retType, numArgs, numArgs > 0 ? new int[numArgs] : null);
        if (this.argTypes != null) {
            for (int i = 0; i < this.argTypes.length; ++i) {
                this.argTypes[i] = retType;
            }
        }
    }

    protected AbstractFunction(String name, int retType, int numArgs, int[] argTypes) {
        this.name = name.intern();
        this.retType = retType;
        this.numArgs = numArgs;
        this.argTypes = argTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRetType() {
        return this.retType;
    }

    @Override
    public int getNumArgs() {
        return this.numArgs;
    }

    @Override
    public int getArgType(int argIndex) {
        return this.argTypes != null ? this.argTypes[argIndex] : this.retType;
    }

    public static abstract class D
    extends AbstractFunction {
        public D(String name, int numArgs) {
            super(name, 3, numArgs);
        }

        public D(String name, int numArgs, int[] argTypes) {
            super(name, 3, numArgs, argTypes);
        }

        @Override
        public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
            return Term.toB(this.evalD(env, args));
        }

        @Override
        public int evalI(EvalEnv env, Term[] args) throws EvalException {
            return Term.toI(this.evalD(env, args));
        }
    }

    public static abstract class I
    extends AbstractFunction {
        public I(String name, int numArgs) {
            super(name, 2, numArgs);
        }

        public I(String name, int numArgs, int[] argTypes) {
            super(name, 2, numArgs, argTypes);
        }

        @Override
        public boolean evalB(EvalEnv env, Term[] args) throws EvalException {
            return Term.toB(this.evalI(env, args));
        }

        @Override
        public double evalD(EvalEnv env, Term[] args) throws EvalException {
            return this.evalI(env, args);
        }
    }

    public static abstract class B
    extends AbstractFunction {
        public B(String name, int numArgs) {
            super(name, 1, numArgs);
        }

        public B(String name, int numArgs, int[] argTypes) {
            super(name, 1, numArgs, argTypes);
        }

        @Override
        public int evalI(EvalEnv env, Term[] args) throws EvalException {
            return Term.toI(this.evalB(env, args));
        }

        @Override
        public double evalD(EvalEnv env, Term[] args) throws EvalException {
            return Term.toD(this.evalB(env, args));
        }
    }
}

