/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.Variable;
import com.bc.jexp.impl.AbstractSymbol;

public final class SymbolFactory {
    private SymbolFactory() {
    }

    public static Symbol createConstant(String name, boolean value) {
        return new VariableB(name, value);
    }

    public static Symbol createConstant(String name, int value) {
        return new VariableI(name, value);
    }

    public static Symbol createConstant(String name, double value) {
        return new VariableD(name, value);
    }

    public static Variable createVariable(String name, boolean value) {
        return new VariableB(name, value);
    }

    public static Variable createVariable(String name, int value) {
        return new VariableI(name, value);
    }

    public static Variable createVariable(String name, double value) {
        return new VariableD(name, value);
    }

    private static final class VariableD
    extends AbstractSymbol.D
    implements Variable {
        private double _value;

        private VariableD(String name, double value) {
            super(name);
            this._value = value;
        }

        @Override
        public double evalD(EvalEnv env) {
            return this._value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this._value = Term.toD(v);
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this._value = v;
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this._value = v;
        }
    }

    private static final class VariableI
    extends AbstractSymbol.I
    implements Variable {
        private int _value;

        private VariableI(String name, int value) {
            super(name);
            this._value = value;
        }

        @Override
        public int evalI(EvalEnv env) {
            return this._value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this._value = Term.toI(v);
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this._value = v;
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this._value = Term.toI(v);
        }
    }

    private static final class VariableB
    extends AbstractSymbol.B
    implements Variable {
        private boolean _value;

        private VariableB(String name, boolean value) {
            super(name);
            this._value = value;
        }

        @Override
        public boolean evalB(EvalEnv env) {
            return this._value;
        }

        @Override
        public void assignB(EvalEnv env, boolean v) {
            this._value = v;
        }

        @Override
        public void assignI(EvalEnv env, int v) {
            this._value = Term.toB(v);
        }

        @Override
        public void assignD(EvalEnv env, double v) {
            this._value = Term.toB(v);
        }
    }
}

