/*
 * Decompiled with CFR 0.152.
 */
package com.bc.jexp.impl;

public final class Tokenizer {
    public static final int TT_EOS = -1;
    public static final int TT_UNKNOWN = -2;
    public static final int TT_INT = -11;
    public static final int TT_HEX_INT = -12;
    public static final int TT_OCT_INT = -13;
    public static final int TT_DOUBLE = -14;
    public static final int TT_STRING = -21;
    public static final int TT_NAME = -31;
    public static final int TT_KEYWORD = -32;
    public static final int TT_ESCAPED_NAME = -33;
    public static final int TT_SPECIAL = -41;
    private static final String[] keywords = new String[]{"and", "or", "not", "true", "false", "if", "then", "else"};
    private static final String[] specialTokens = new String[]{"==", "<=", ">=", "!=", "&&", "||", "<<", ">>"};
    private static final char[] ordinaryChars = new char[]{'(', ')', '{', '}', '[', ']', ',', ':', '<', '>', '=', '!', '?', '\"', '|', '&', '%', '$', '+', '-', '*', '/', '^', '~'};
    private final char[] source;
    private final StringBuilder token;
    private boolean pushedBack;
    private int type;
    private int pos;
    private int line;
    private int column;
    private boolean caseSensitive;

    public Tokenizer(String source, boolean caseSensitive) {
        this.source = source.toCharArray();
        this.line = 1;
        this.column = 0;
        this.pos = 0;
        this.type = -2;
        this.pushedBack = false;
        this.token = new StringBuilder();
        this.caseSensitive = caseSensitive;
    }

    public Tokenizer(String source) {
        this(source, false);
    }

    public int getType() {
        return this.type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getToken() {
        return this.token.toString();
    }

    public void pushBack() {
        this.pushedBack = true;
    }

    public int next() {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.type;
        }
        this.type = -2;
        this.token.setLength(0);
        this.eatWhite();
        if (this.isEos()) {
            this.type = -1;
        } else if (this.isNameStart()) {
            this.eatName();
        } else if (this.isEscapedNameStart()) {
            this.eatEscapedName();
        } else if (this.isStringStart()) {
            this.eatString();
        } else if (this.isHexNumberStart()) {
            this.eatHexNumber();
        } else if (this.isNumberStart()) {
            this.eatNumber();
        } else {
            for (String specialToken : specialTokens) {
                int i;
                int n = specialToken.length();
                for (i = this.pos; i < this.pos + n && !this.isEos(i) && specialToken.charAt(i - this.pos) == this.peek(i); ++i) {
                }
                if (i != this.pos + n) continue;
                this.type = -41;
                this.eat(n);
                break;
            }
            if (this.type != -41) {
                for (char ordinaryChar : ordinaryChars) {
                    if (ordinaryChar != this.peek()) continue;
                    this.type = this.peek();
                    this.eat();
                    break;
                }
            }
        }
        return this.type;
    }

    public static boolean isExternalName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (String keyword : keywords) {
            if (!keyword.equalsIgnoreCase(name)) continue;
            return false;
        }
        return name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'' || name.matches("[a-z_$A-Z][a-z_$A-Z0-9\\.]*");
    }

    public static String createExternalName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name to be externalized must at least contain one character");
        }
        if (Tokenizer.isExternalName(name)) {
            return name;
        }
        return "'" + name.replaceAll("[\\']", "\\'\\'") + "'";
    }

    private void eatWhite() {
        while (this.isWhite()) {
            if (this.peek() == '\n') {
                ++this.line;
                this.column = 0;
            }
            this.incPos();
        }
    }

    private void eatName() {
        this.type = -31;
        do {
            this.eat();
        } while (this.isNamePart());
        String name = this.token.toString();
        for (String keyword : keywords) {
            boolean isEqual = this.caseSensitive ? name.equals(keyword) : name.equalsIgnoreCase(keyword);
            if (!isEqual) continue;
            this.type = -32;
            break;
        }
    }

    private void eatString() {
        this.type = -21;
        this.incPos();
        while (!this.isStringEnd()) {
            this.eat();
        }
        if (!this.isEos()) {
            this.incPos();
        }
    }

    private void eatEscapedName() {
        this.type = -33;
        this.incPos();
        while (!this.isEscapedNameEnd()) {
            if (this.isEscapedEscape()) {
                this.incPos();
            }
            this.eat();
        }
        if (!this.isEos()) {
            this.incPos();
        }
    }

    private void eatNumber() {
        while (this.isDigit()) {
            this.eat();
        }
        if (this.isDot()) {
            this.type = -14;
            this.eat();
            while (this.isDigit()) {
                this.eat();
            }
        }
        if (this.isExpPartStart()) {
            this.type = -14;
            this.eat();
            this.eat();
            while (this.isDigit()) {
                this.eat();
            }
        }
        if (this.type != -14) {
            this.type = -11;
            if (this.token.charAt(0) == '0' && this.token.length() > 1) {
                this.type = -13;
                for (int i = 0; i < this.token.length(); ++i) {
                    if (!Tokenizer.isOctDigit(this.token.charAt(i))) continue;
                    this.type = -11;
                    break;
                }
            }
        }
    }

    private void eatHexNumber() {
        this.type = -12;
        this.eat();
        this.eat();
        while (this.isHexDigit()) {
            this.eat();
        }
    }

    private boolean isWhite() {
        return this.isWhite(this.pos);
    }

    private boolean isWhite(int i) {
        return !this.isEos(i) && Character.isWhitespace(this.peek(i));
    }

    private boolean isEscapedNameStart() {
        return this.isChar('\'');
    }

    private boolean isEscapedNameEnd() {
        return this.isEos() || this.isChar('\'') && !this.isChar(this.pos + 1, '\'');
    }

    private boolean isEscapedEscape() {
        return this.isChar('\'') && this.isChar(this.pos + 1, '\'');
    }

    private boolean isStringStart() {
        return this.isChar('\"');
    }

    private boolean isStringEnd() {
        return this.isEos() || this.isChar('\"');
    }

    private boolean isNumberStart() {
        return this.isDigit() || this.isDotAndDigit();
    }

    private boolean isHexNumberStart() {
        return this.isHexNumberStart(this.pos);
    }

    private boolean isHexNumberStart(int i) {
        return this.isChar(i, '0') && (this.isChar(i + 1, 'x') || this.isChar(i + 1, 'X') || this.isChar(i + 1, 'm'));
    }

    private boolean isDotAndDigit() {
        return this.isDotAndDigit(this.pos);
    }

    private boolean isDotAndDigit(int i) {
        return this.isDot(i) && this.isDigit(i + 1);
    }

    private boolean isSignAndDigit(int i) {
        return this.isSign(i) && this.isDigit(i + 1);
    }

    private boolean isExpPartStart() {
        return !(!this.isChar('e') && !this.isChar('E') || !this.isDigit(this.pos + 1) && !this.isSignAndDigit(this.pos + 1));
    }

    private boolean isDot() {
        return this.isDot(this.pos);
    }

    private boolean isDot(int i) {
        return this.isChar(i, '.');
    }

    private boolean isSign(int i) {
        return this.isMinus(i) || this.isPlus(i);
    }

    private boolean isPlus(int i) {
        return this.isChar(i, '+');
    }

    private boolean isMinus(int i) {
        return this.isChar(i, '-');
    }

    private boolean isChar(char ch) {
        return this.peek() == ch;
    }

    private boolean isChar(int i, char ch) {
        return this.peek(i) == ch;
    }

    private boolean isEos() {
        return this.isEos(this.pos);
    }

    private boolean isEos(int i) {
        return i >= this.source.length;
    }

    private boolean isDigit() {
        return this.isDigit(this.pos);
    }

    private boolean isDigit(int i) {
        return !this.isEos(i) && Character.isDigit(this.peek(i));
    }

    private boolean isHexDigit() {
        return this.isHexDigit(this.pos);
    }

    private boolean isHexDigit(int i) {
        return !this.isEos(i) && (Character.isDigit(this.peek(i)) || this.peek(i) >= 'a' && this.peek(i) <= 'f' || this.peek(i) >= 'A' && this.peek(i) <= 'F');
    }

    private static boolean isOctDigit(char ch) {
        return ch >= '0' && ch <= '8';
    }

    private boolean isNameStart() {
        return this.isNameStart(this.pos);
    }

    private boolean isNameStart(int i) {
        return !this.isEos(i) && (Character.isLetter(this.source[i]) || this.source[i] == '_' || this.source[i] == '$');
    }

    private boolean isNamePart() {
        return this.isNamePart(this.pos);
    }

    private boolean isNamePart(int i) {
        return this.isNameStart(i) || this.isDigit(i) || this.isDot(i);
    }

    private char peek() {
        return this.peek(this.pos);
    }

    private char peek(int i) {
        return this.isEos(i) ? (char)'\u0000' : this.source[i];
    }

    private void eat() {
        this.token.append(this.peek());
        this.incPos();
    }

    private void eat(int n) {
        this.token.append(this.source, this.pos, n);
        this.incPos(n);
    }

    private void incPos() {
        ++this.pos;
        ++this.column;
    }

    private void incPos(int n) {
        this.pos += n;
        this.column += n;
    }
}

