/*
 * Decompiled with CFR 0.152.
 */
package com.bc.util;

import com.bc.util.ObjectArray;

public class CachingObjectArray {
    private ObjectFactory objectFactory;
    private ObjectArray objectArray;
    private int minIndex;
    private int maxIndex;

    public CachingObjectArray(ObjectFactory objectFactory) {
        if (objectFactory == null) {
            throw new IllegalArgumentException("objectFactory == null");
        }
        this.objectFactory = objectFactory;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setCachedRange(int indexMin, int indexMax) {
        if (indexMax < indexMin) {
            throw new IllegalArgumentException("indexMin < indexMax");
        }
        ObjectArray objectArray = new ObjectArray(indexMin, indexMax);
        ObjectArray objectArrayOld = this.objectArray;
        if (objectArrayOld != null) {
            objectArray.set(objectArrayOld);
            objectArrayOld.clear();
        }
        this.objectArray = objectArray;
        this.minIndex = this.objectArray.getMinIndex();
        this.maxIndex = this.objectArray.getMaxIndex();
    }

    public final Object getObject(int index) throws Exception {
        if (index < this.minIndex || index > this.maxIndex) {
            return this.objectFactory.createObject(index);
        }
        Object object = this.objectArray.getObject(index);
        if (object == null) {
            object = this.objectFactory.createObject(index);
            this.objectArray.setObject(index, object);
        }
        return object;
    }

    public final void setObject(int index, Object o) {
        Object object = this.objectArray.getObject(index);
        if (object == null) {
            this.objectArray.setObject(index, o);
        }
    }

    public void clear() {
        if (this.objectArray != null) {
            this.objectArray.clear();
        }
    }

    public static interface ObjectFactory {
        public Object createObject(int var1) throws Exception;
    }
}

