/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ModuleState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.datamodel.RGBImageProfileManager;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.GeoTools;
import org.geotools.referencing.operation.MathTransformProvider;

public class BeamCoreActivator
implements Activator {
    private static ModuleContext moduleContext;
    private FactoryIteratorProvider geotoolsFactoryIteratorProvider;

    public static boolean isStarted() {
        return moduleContext != null;
    }

    public static <T> void loadServices(ServiceRegistry<T> registry) {
        Iterable iterable = SystemUtils.loadServices(registry.getServiceType());
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            try {
                registry.addService(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                Logger logger = moduleContext != null ? moduleContext.getLogger() : BeamLogManager.getSystemLogger();
                logger.log(Level.WARNING, e.getMessage(), e.getCause());
            }
        }
    }

    public void start(ModuleContext moduleContext) throws CoreException {
        BeamCoreActivator.moduleContext = moduleContext;
        SystemUtils.init3rdPartyLibs(moduleContext.getModule().getClassLoader());
        BeamCoreActivator.registerRGBProfiles(moduleContext);
        this.registerGeotoolsServices();
    }

    public void stop(ModuleContext moduleContext) throws CoreException {
        BeamCoreActivator.moduleContext = null;
        this.deregisterGeotoolsServices();
    }

    private void registerGeotoolsServices() {
        ServiceRegistry serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(MathTransformProvider.class);
        BeamCoreActivator.loadServices(serviceRegistry);
        this.geotoolsFactoryIteratorProvider = new GeotoolsFactoryIteratorProvider(serviceRegistry);
        GeoTools.addFactoryIteratorProvider((FactoryIteratorProvider)this.geotoolsFactoryIteratorProvider);
    }

    private void deregisterGeotoolsServices() {
        if (this.geotoolsFactoryIteratorProvider != null) {
            GeoTools.removeFactoryIteratorProvider((FactoryIteratorProvider)this.geotoolsFactoryIteratorProvider);
        }
    }

    private static void registerRGBProfiles(ModuleContext moduleContext) throws CoreException {
        ExtensionPoint rgbExtensionPoint = moduleContext.getModule().getExtensionPoint("rgbProfiles");
        Extension[] rgbExtensions = rgbExtensionPoint.getExtensions();
        RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
        for (Extension extension : rgbExtensions) {
            ConfigurationElement[] rgbElements;
            ConfigurationElement confElem = extension.getConfigurationElement();
            for (ConfigurationElement rgbElement : rgbElements = (ConfigurationElement[])confElem.getChildren("rgbProfile")) {
                RGBImageProfile rgbImageProfile = new RGBImageProfile();
                rgbImageProfile.configure(rgbElement);
                profileManager.addProfile(rgbImageProfile);
            }
        }
    }

    public static <T> List<T> loadExecutableExtensions(ModuleContext moduleContext, String extensionPointId, String elementName, Class<T> extensionType) {
        Module module = moduleContext.getModule();
        ExtensionPoint extensionPoint = module.getExtensionPoint(extensionPointId);
        ConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        ArrayList<Object> executableExtensions = new ArrayList<Object>(32);
        for (ConfigurationElement configurationElement : configurationElements) {
            ConfigurationElement[] children;
            for (ConfigurationElement child : children = (ConfigurationElement[])configurationElement.getChildren(elementName)) {
                try {
                    ModuleState moduleState = child.getDeclaringExtension().getDeclaringModule().getState();
                    if (!moduleState.isOneOf(ModuleState.STARTING, new ModuleState[]{ModuleState.RESOLVED})) continue;
                    Object executableExtension = child.createExecutableExtension(extensionType);
                    executableExtensions.add(executableExtension);
                }
                catch (CoreException e) {
                    moduleContext.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return executableExtensions;
    }

    private static final class GeotoolsFactoryIteratorProvider
    implements FactoryIteratorProvider {
        private final ServiceRegistry<MathTransformProvider> serviceRegistry;

        private GeotoolsFactoryIteratorProvider(ServiceRegistry<MathTransformProvider> serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        public <T> Iterator<T> iterator(Class<T> category) {
            if (category.equals(this.serviceRegistry.getServiceType())) {
                return this.serviceRegistry.getServices().iterator();
            }
            return null;
        }
    }
}

