/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.beam.util.SystemUtils;

public class GlobalTestConfig {
    public static final String BEAM_TEST_DATA_INPUT_DIR_PROPERTY_NAME = "org.esa.beam.testdata.in";
    public static final String BEAM_TEST_DATA_OUTPUT_DIR_PROPERTY_NAME = "org.esa.beam.testdata.out";
    public static final String BEAM_TEST_DATA_INPUT_DIR_DEFAULT_PATH = "testdata" + File.separatorChar + "in";
    public static final String BEAM_TEST_DATA_OUTPUT_DIR_DEFAULT_PATH = "testdata" + File.separatorChar + "out";

    public static File getBeamTestDataInputDirectory() {
        return GlobalTestConfig.getDirectory(BEAM_TEST_DATA_INPUT_DIR_PROPERTY_NAME, BEAM_TEST_DATA_INPUT_DIR_DEFAULT_PATH);
    }

    public static File getBeamTestDataInputFile(String relPath) {
        return new File(GlobalTestConfig.getBeamTestDataInputDirectory(), SystemUtils.convertToLocalPath(relPath));
    }

    public static File getBeamTestDataOutputDirectory() {
        return GlobalTestConfig.getDirectory(BEAM_TEST_DATA_OUTPUT_DIR_PROPERTY_NAME, BEAM_TEST_DATA_OUTPUT_DIR_DEFAULT_PATH);
    }

    public static File getBeamTestDataOutputFile(String relPath) {
        return new File(GlobalTestConfig.getBeamTestDataOutputDirectory(), SystemUtils.convertToLocalPath(relPath));
    }

    public static Test createTest(Class testClass, File inputFile) {
        if (!inputFile.exists()) {
            return GlobalTestConfig.createEmptyTest(testClass, inputFile);
        }
        return new TestSuite(testClass);
    }

    private static Test createEmptyTest(final Class testClass, final File inputFile) {
        return new TestCase(testClass.getName()){

            public void runTest() {
                System.out.println();
                System.out.println(testClass.getName() + ": warning: test will not be performed: testdata not found: ");
                System.out.println(inputFile.getPath());
            }
        };
    }

    private static File getDirectory(String propertyName, String beamRelDefaultPath) {
        String filePath = System.getProperty(propertyName);
        if (filePath != null) {
            return new File(filePath);
        }
        return new File(SystemUtils.getBeamHomeDir(), SystemUtils.convertToLocalPath(beamRelDefaultPath));
    }
}

