/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.GlobalTestConfig;
import org.esa.beam.util.io.FileUtils;

public class GlobalTestTools {
    public static void deleteTestDataOutputDirectory() {
        FileUtils.deleteTree(GlobalTestConfig.getBeamTestDataOutputDirectory());
    }

    public static void deleteTestDataInputDirectory() {
        FileUtils.deleteTree(GlobalTestConfig.getBeamTestDataInputDirectory());
    }

    public static void deleteTestDirectory() {
        GlobalTestTools.deleteTestDataInputDirectory();
        GlobalTestTools.deleteTestDataOutputDirectory();
    }

    public static String equal(int[] exp, int[] act) {
        if (exp == null) {
            if (act != null) {
                return "Expected was '" + exp + "' but was '" + act + "'";
            }
            return "";
        }
        String s = "An int[] with the size " + exp.length + " was expected but the given array ";
        if (act == null) {
            return s + "is " + act;
        }
        if (exp.length != act.length) {
            return s + "length is " + act.length;
        }
        for (int i = 0; i < exp.length; ++i) {
            if (exp[i] == act[i]) continue;
            return "Fail at index " + i + ": Expected <" + exp[i] + "> but was <" + act[i] + ">";
        }
        return "";
    }

    public static String createPlatformIndependentFilePath(String path) {
        if (path.indexOf(47) > 0) {
            path = path.replace('/', File.separatorChar);
        } else if (path.indexOf(92) > 0) {
            path = path.replace('\\', File.separatorChar);
        }
        return path;
    }

    public static byte[] createBytes(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(i % 256);
        }
        return bytes;
    }

    public static void writeBlanks(ImageOutputStream ios, int numBlanks) throws IOException {
        char[] chars = new char[numBlanks];
        Arrays.fill(chars, ' ');
        ios.writeBytes(new String(chars));
    }
}

