/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.dataio.dimap.DimapProductReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class DimapProductReaderPlugIn
implements ProductReaderPlugIn {
    private final BeamFileFilter dimapFileFilter = (BeamFileFilter)DimapProductHelpers.createDimapFileFilter();
    private ArrayList<DimapProductReader.ReaderExtender> readerExtenders;

    @Override
    public String[] getFormatNames() {
        return new String[]{"BEAM-DIMAP"};
    }

    @Override
    public String[] getDefaultFileExtensions() {
        return new String[]{".dim"};
    }

    @Override
    public String getDescription(Locale name) {
        return "DIMAP (BEAM profile) product reader";
    }

    @Override
    public DecodeQualification getDecodeQualification(Object object) {
        File file = null;
        if (object instanceof String) {
            file = new File((String)object);
        } else if (object instanceof File) {
            file = (File)object;
        }
        if (file != null && file.getPath().toLowerCase().endsWith(".dim") && file.exists() && file.isFile()) {
            FileReader fr = null;
            try {
                fr = new FileReader(file);
                char[] cbuf = new char[80];
                if (fr.read(cbuf) != -1) {
                    String s = new String(cbuf);
                    fr.close();
                    if (s.contains("<Dimap_Document")) {
                        return DecodeQualification.INTENDED;
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public ProductReader createReaderInstance() {
        DimapProductReader dimapProductReader = new DimapProductReader(this);
        if (this.readerExtenders != null) {
            for (DimapProductReader.ReaderExtender readerExtender : this.readerExtenders) {
                dimapProductReader.addExtender(readerExtender);
            }
        }
        return dimapProductReader;
    }

    @Override
    public BeamFileFilter getProductFileFilter() {
        return this.dimapFileFilter;
    }

    public void addReaderExtender(DimapProductReader.ReaderExtender extender) {
        if (extender == null) {
            return;
        }
        if (this.readerExtenders == null) {
            this.readerExtenders = new ArrayList();
        }
        this.readerExtenders.add(extender);
    }

    public void removeReaderExtender(DimapProductReader.ReaderExtender extender) {
        if (extender == null || this.readerExtenders == null) {
            return;
        }
        this.readerExtenders.remove(extender);
    }
}

