/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap.spi;

import java.util.Iterator;
import org.esa.beam.dataio.dimap.spi.DimapPersistable;
import org.esa.beam.dataio.dimap.spi.DimapPersistableSpi;
import org.esa.beam.dataio.dimap.spi.DimapPersistableSpiRegistry;
import org.jdom.Element;

public class DimapPersistence {
    public static DimapPersistable getPersistable(Element element) {
        return DimapPersistence.getDimapPersistable(element);
    }

    public static DimapPersistable getPersistable(Object object) {
        return DimapPersistence.getDimapPersistable(object);
    }

    private static DimapPersistable getDimapPersistable(Object object) {
        Iterator<DimapPersistableSpi> serviceProviders = DimapPersistableSpiRegistry.getInstance().getPersistableSpis();
        while (serviceProviders.hasNext()) {
            DimapPersistableSpi persistableSpi = serviceProviders.next();
            if (!DimapPersistence.checkUsability(persistableSpi, object)) continue;
            return persistableSpi.createPersistable();
        }
        return null;
    }

    private static boolean checkUsability(DimapPersistableSpi persistableSpi, Object object) {
        if (object instanceof Element) {
            return persistableSpi.canDecode((Element)object);
        }
        return persistableSpi.canPersist(object);
    }
}

