/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap.spi;

import com.bc.ceres.binding.PropertyContainer;
import java.awt.Color;
import org.esa.beam.dataio.dimap.spi.DimapPersistable;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.jdom.Content;
import org.jdom.Element;

public abstract class MaskPersistable
implements DimapPersistable {
    @Override
    public final Mask createObjectFromXml(Element element, Product product) {
        String name = MaskPersistable.getChildAttributeValue(element, "NAME", "value");
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        Mask mask = new Mask(name, width, height, this.createImageType());
        mask.setDescription(MaskPersistable.getChildAttributeValue(element, "DESCRIPTION", "value"));
        mask.setImageTransparency(Double.parseDouble(MaskPersistable.getChildAttributeValue(element, "TRANSPARENCY", "value")));
        int r = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "red"));
        int g = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "green"));
        int b = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "blue"));
        int a = Integer.parseInt(MaskPersistable.getChildAttributeValue(element, "COLOR", "alpha"));
        mask.setImageColor(new Color(r, g, b, a));
        this.configureMask(mask, element);
        return mask;
    }

    @Override
    public final Element createXmlFromObject(Object object) {
        Mask mask = (Mask)object;
        Element root = new Element("Mask");
        root.setAttribute("type", mask.getImageType().getName());
        PropertyContainer config = mask.getImageConfig();
        root.addContent((Content)MaskPersistable.createElement("NAME", mask.getName()));
        root.addContent((Content)MaskPersistable.createElement("DESCRIPTION", mask.getDescription()));
        Element colorElement = new Element("COLOR");
        Color color = (Color)config.getValue("color");
        colorElement.setAttribute("red", String.valueOf(color.getRed()));
        colorElement.setAttribute("green", String.valueOf(color.getGreen()));
        colorElement.setAttribute("blue", String.valueOf(color.getBlue()));
        colorElement.setAttribute("alpha", String.valueOf(color.getAlpha()));
        root.addContent((Content)colorElement);
        Object transparencyValue = config.getValue("transparency");
        String transparency = String.valueOf(transparencyValue);
        root.addContent((Content)MaskPersistable.createElement("TRANSPARENCY", transparency));
        this.configureElement(root, mask);
        return root;
    }

    protected abstract Mask.ImageType createImageType();

    protected abstract void configureMask(Mask var1, Element var2);

    protected abstract void configureElement(Element var1, Mask var2);

    protected static Element createElement(String elementName, String value) {
        Element elem = new Element(elementName);
        if (value != null) {
            elem.setAttribute("value", value);
        } else {
            elem.setAttribute("value", "");
        }
        return elem;
    }

    protected static String getChildAttributeValue(Element element, String childName, String attributeName) {
        return element.getChild(childName).getAttribute(attributeName).getValue();
    }
}

