/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap.spi;

import com.bc.ceres.binding.PropertyContainer;
import org.esa.beam.dataio.dimap.spi.MaskPersistable;
import org.esa.beam.framework.datamodel.Mask;
import org.jdom.Content;
import org.jdom.Element;

public class RangeTypeMaskPersistable
extends MaskPersistable {
    @Override
    protected Mask.ImageType createImageType() {
        return Mask.RangeType.INSTANCE;
    }

    @Override
    protected void configureMask(Mask mask, Element element) {
        PropertyContainer imageConfig = mask.getImageConfig();
        String minimum = RangeTypeMaskPersistable.getChildAttributeValue(element, "MINIMUM", "value");
        String maximum = RangeTypeMaskPersistable.getChildAttributeValue(element, "MAXIMUM", "value");
        String raster = RangeTypeMaskPersistable.getChildAttributeValue(element, "RASTER", "value");
        imageConfig.setValue("minimum", (Object)Double.parseDouble(minimum));
        imageConfig.setValue("maximum", (Object)Double.parseDouble(maximum));
        imageConfig.setValue("rasterName", (Object)raster);
    }

    @Override
    protected void configureElement(Element root, Mask mask) {
        PropertyContainer config = mask.getImageConfig();
        Object minValue = config.getValue("minimum");
        Object maxValue = config.getValue("maximum");
        Object rasterValue = config.getValue("rasterName");
        root.addContent((Content)RangeTypeMaskPersistable.createElement("MINIMUM", String.valueOf(minValue)));
        root.addContent((Content)RangeTypeMaskPersistable.createElement("MAXIMUM", String.valueOf(maxValue)));
        root.addContent((Content)RangeTypeMaskPersistable.createElement("RASTER", String.valueOf(rasterValue)));
    }
}

