/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.bc.ceres.binding.ConversionException;
import java.io.IOException;
import org.esa.beam.dataio.geometry.AbstractInterpretationStrategy;
import org.esa.beam.util.FeatureUtils;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GeometryNoFeatureTypeStrategy
extends AbstractInterpretationStrategy {
    private static int idCount = 0;
    private String geometryName;

    public GeometryNoFeatureTypeStrategy(String geometryName) {
        this.geometryName = geometryName;
    }

    @Override
    public void setDefaultGeometry(String defaultGeometry, CoordinateReferenceSystem featureCrs, SimpleFeatureTypeBuilder builder) {
        if (defaultGeometry != null) {
            builder.setDefaultGeometry(defaultGeometry);
        }
        builder.setDefaultGeometry(this.geometryName);
    }

    @Override
    public void setName(SimpleFeatureTypeBuilder builder) {
        builder.setName(FeatureUtils.createFeatureTypeName(builder.getDefaultGeometry()));
    }

    @Override
    public int getExpectedTokenCount(int attributeCount) {
        return attributeCount;
    }

    @Override
    public String getFeatureId(String[] tokens) {
        return FeatureUtils.createFeatureId(idCount++);
    }

    @Override
    public SimpleFeature interpretLine(String[] tokens, SimpleFeatureBuilder builder, SimpleFeatureType simpleFeatureType) throws IOException, ConversionException {
        for (int attributeIndex = 0; attributeIndex < tokens.length; ++attributeIndex) {
            String token = tokens[attributeIndex];
            this.setAttributeValue(builder, simpleFeatureType, attributeIndex, token);
        }
        String featureId = this.getFeatureId(tokens);
        return builder.buildFeature(featureId);
    }

    @Override
    public int getStartColumn() {
        return 0;
    }
}

