/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.bc.ceres.binding.ConversionException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import org.esa.beam.dataio.geometry.AbstractInterpretationStrategy;
import org.esa.beam.util.FeatureUtils;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class LatLonNoFeatureTypeStrategy
extends AbstractInterpretationStrategy {
    private static int count = 0;
    private double lat;
    private double lon;
    private int latIndex;
    private int lonIndex;

    LatLonNoFeatureTypeStrategy(int latIndex, int lonIndex) {
        this.latIndex = latIndex;
        this.lonIndex = lonIndex;
    }

    @Override
    public void setDefaultGeometry(String defaultGeometry, CoordinateReferenceSystem featureCrs, SimpleFeatureTypeBuilder builder) throws IOException {
        builder.add("geometry", Point.class, featureCrs);
        builder.setDefaultGeometry("geometry");
    }

    @Override
    public void setName(SimpleFeatureTypeBuilder builder) {
        builder.setName(FeatureUtils.createFeatureTypeName(builder.getDefaultGeometry()));
    }

    @Override
    public int getExpectedTokenCount(int attributeCount) {
        return attributeCount - 1;
    }

    @Override
    public SimpleFeature interpretLine(String[] tokens, SimpleFeatureBuilder builder, SimpleFeatureType simpleFeatureType) throws IOException, ConversionException, TransformException {
        int attributeIndex = 0;
        for (int columnIndex = 0; columnIndex < tokens.length; ++columnIndex) {
            String token = tokens[columnIndex];
            if (columnIndex == this.latIndex) {
                this.lat = Double.parseDouble(token);
            } else if (columnIndex == this.lonIndex) {
                this.lon = Double.parseDouble(token);
            }
            this.setAttributeValue(builder, simpleFeatureType, attributeIndex, token);
            ++attributeIndex;
        }
        builder.set("geometry", (Object)new GeometryFactory().createPoint(new Coordinate(this.lon, this.lat)));
        String featureId = this.getFeatureId(tokens);
        return builder.buildFeature(featureId);
    }

    @Override
    public String getFeatureId(String[] tokens) {
        return FeatureUtils.createFeatureId(count++);
    }

    @Override
    public int getStartColumn() {
        return 0;
    }
}

