/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.placemark;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.XmlWriter;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.logging.BeamLogManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class PlacemarkIO {
    public static final String FILE_EXTENSION_FLAT_OLD = ".pnf";
    public static final String FILE_EXTENSION_XML_OLD = ".pnx";
    public static final String FILE_EXTENSION_FLAT_TEXT = ".txt";
    public static final String FILE_EXTENSION_PLACEMARK = ".placemark";
    private static final int INDEX_FOR_NAME = 0;
    private static final int INDEX_FOR_LON = 1;
    private static final int INDEX_FOR_LAT = 2;
    private static final int INDEX_FOR_DESC = 3;
    private static final int INDEX_FOR_LABEL = 4;
    private static final int INDEX_FOR_DATETIME = 5;
    private static final String LABEL_COL_NAME = "Label";
    private static final String[] LON_COL_NAMES = new String[]{"Lon", "long", "longitude", "lon_IS"};
    private static final String[] LAT_COL_NAMES = new String[]{"Lat", "latitude", "lat_IS"};
    private static final String NAME_COL_NAME = "Name";
    private static final String[] DESC_COL_NAMES = new String[]{"Desc", "Description"};
    private static final String DATETIME_COL_NAME = "DateTime";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private PlacemarkIO() {
    }

    public static List<Placemark> readPlacemarks(Reader reader, GeoCoding geoCoding, PlacemarkDescriptor placemarkDescriptor) throws IOException {
        char[] magicBytes = new char[5];
        try (PushbackReader inputReader = new PushbackReader(reader, magicBytes.length);){
            inputReader.read(magicBytes);
            inputReader.unread(magicBytes);
            if ("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".startsWith(new String(magicBytes))) {
                List<Placemark> list = PlacemarkIO.readPlacemarksFromXMLFile(inputReader, geoCoding, placemarkDescriptor);
                return list;
            }
            List<Placemark> list = PlacemarkIO.readPlacemarksFromFlatFile(inputReader, geoCoding, placemarkDescriptor);
            return list;
        }
    }

    private static List<Placemark> readPlacemarksFromFlatFile(Reader reader, GeoCoding geoCoding, PlacemarkDescriptor placemarkDescriptor) throws IOException {
        ArrayList<Placemark> placemarks;
        block26: {
            placemarks = new ArrayList<Placemark>();
            try (BufferedReader lineReader = new BufferedReader(reader);){
                int row = 0;
                ArrayList<Integer> stdColIndexes = null;
                int biggestIndex = 0;
                while (true) {
                    Integer dateTimeIndex;
                    float lat;
                    float lon;
                    String line;
                    if ((line = lineReader.readLine()) == null) {
                        break block26;
                    }
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    String[] strings = StringUtils.toStringArray(line, "\t");
                    if (stdColIndexes == null) {
                        int nameIndex = PlacemarkIO.findColumnIndex(strings, NAME_COL_NAME);
                        int lonIndex = PlacemarkIO.findColumnIndex(strings, LON_COL_NAMES);
                        int latIndex = PlacemarkIO.findColumnIndex(strings, LAT_COL_NAMES);
                        int descIndex = PlacemarkIO.findColumnIndex(strings, DESC_COL_NAMES);
                        int labelIndex = PlacemarkIO.findColumnIndex(strings, LABEL_COL_NAME);
                        int dateTimeIndex2 = PlacemarkIO.findColumnIndex(strings, DATETIME_COL_NAME);
                        if (nameIndex == -1 || lonIndex == -1 || latIndex == -1) {
                            throw new IOException("Invalid placemark file format:\nat least the columns 'Name', 'Lon' and 'Lat' must be given.");
                        }
                        biggestIndex = biggestIndex > nameIndex ? biggestIndex : nameIndex;
                        biggestIndex = biggestIndex > lonIndex ? biggestIndex : lonIndex;
                        biggestIndex = biggestIndex > latIndex ? biggestIndex : latIndex;
                        stdColIndexes = new ArrayList<Integer>(6);
                        stdColIndexes.add(0, nameIndex);
                        stdColIndexes.add(1, lonIndex);
                        stdColIndexes.add(2, latIndex);
                        stdColIndexes.add(3, descIndex);
                        stdColIndexes.add(4, labelIndex);
                        stdColIndexes.add(5, dateTimeIndex2);
                        continue;
                    }
                    ++row;
                    if (strings.length <= biggestIndex) break;
                    String name = strings[(Integer)stdColIndexes.get(0)];
                    try {
                        lon = Float.parseFloat(strings[(Integer)stdColIndexes.get(1)]);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IOException("Invalid placemark file format:\ndata row " + row + ": value for 'Lon' is invalid");
                    }
                    try {
                        lat = Float.parseFloat(strings[(Integer)stdColIndexes.get(2)]);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IOException("Invalid placemark file format:\ndata row " + row + ": value for 'Lat' is invalid");
                    }
                    String label = name;
                    Integer labelIndex = (Integer)stdColIndexes.get(4);
                    if (labelIndex >= 0 && strings.length > labelIndex) {
                        label = strings[labelIndex];
                    }
                    Placemark placemark = Placemark.createPointPlacemark(placemarkDescriptor, name, label, "", null, new GeoPos(lat, lon), geoCoding);
                    String desc = null;
                    Integer descIndex = (Integer)stdColIndexes.get(3);
                    if (descIndex >= 0 && strings.length > descIndex) {
                        desc = strings[descIndex];
                    }
                    if (desc != null) {
                        placemark.setDescription(desc);
                    }
                    if ((dateTimeIndex = (Integer)stdColIndexes.get(5)) >= 0 && strings.length > dateTimeIndex) {
                        try {
                            Date date = dateFormat.parse(strings[dateTimeIndex]);
                            placemark.getFeature().setAttribute("dateTime", (Object)date);
                        }
                        catch (ParseException ignored) {
                            // empty catch block
                        }
                    }
                    placemarks.add(placemark);
                }
                throw new IOException("Invalid placemark file format:\ndata row " + row + ": values for 'Name', 'Lon' and 'Lat' must be given.");
            }
        }
        return placemarks;
    }

    static int findColumnIndex(String[] strings, String ... colNames) {
        String colName;
        int index = -1;
        String[] stringArray = colNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (index = StringUtils.indexOfIgnoreCase(strings, colName = stringArray[i])) == -1; ++i) {
        }
        return index;
    }

    private static List<Placemark> readPlacemarksFromXMLFile(Reader reader, GeoCoding geoCoding, PlacemarkDescriptor placemarkDescriptor) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document w3cDocument = builder.parse(new InputSource(reader));
            Document document = new DOMBuilder().build(w3cDocument);
            Element rootElement = document.getRootElement();
            List children = rootElement.getChildren("Placemark");
            if (children.isEmpty()) {
                children = rootElement.getChildren("Pin");
            }
            ArrayList<Placemark> placemarks = new ArrayList<Placemark>(children.size());
            for (Object child : children) {
                Element element = (Element)child;
                try {
                    Placemark placemark = PlacemarkIO.createPlacemark(element, placemarkDescriptor, geoCoding);
                    placemarks.add(placemark);
                }
                catch (IllegalArgumentException ignored) {}
            }
            return placemarks;
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException | SAXException e) {
            throw new IOException(e.toString(), e);
        }
    }

    public static void writePlacemarksWithAdditionalData(Writer writer, String roleLabel, String productName, List<Placemark> placemarkList, List<Object[]> valueList, String[] standardColumnNames, String[] additionalColumnNames) {
        int columnCountMin = standardColumnNames.length;
        int columnCount = columnCountMin + additionalColumnNames.length;
        try (PrintWriter pw = new PrintWriter(writer);){
            pw.println("# SNAP " + roleLabel + " export table");
            pw.println("#");
            pw.println("# Product:\t" + productName);
            pw.println("# Created on:\t" + new Date());
            pw.println();
            Product product = null;
            if (!placemarkList.isEmpty()) {
                Placemark placemark = placemarkList.get(0);
                product = placemark.getProduct();
            }
            if (product != null && additionalColumnNames.length != 0) {
                pw.println(PlacemarkIO.getWavelengthLine(product, standardColumnNames, additionalColumnNames));
            }
            pw.println(PlacemarkIO.getHeaderLine(standardColumnNames, additionalColumnNames));
            for (int i = 0; i < placemarkList.size(); ++i) {
                Placemark placemark = placemarkList.get(i);
                Object[] values = valueList.get(i);
                pw.println(PlacemarkIO.getDataLine(placemark, values, columnCountMin, columnCount));
            }
        }
    }

    private static String getDataLine(Placemark placemark, Object[] values, int columnCountMin, int columnCount) {
        int col;
        StringBuilder sb = new StringBuilder();
        sb.append(placemark.getName());
        for (col = 0; col < columnCountMin; ++col) {
            PlacemarkIO.formatValue(values[col], sb);
        }
        sb.append("\t");
        sb.append(placemark.getDescription());
        for (col = columnCountMin; col < columnCount; ++col) {
            PlacemarkIO.formatValue(values[col], sb);
        }
        return sb.toString();
    }

    private static void formatValue(Object value, StringBuilder sb) {
        String stringValue = value instanceof Date ? dateFormat.format(value) : value.toString();
        sb.append("\t");
        sb.append(stringValue);
    }

    private static String getHeaderLine(String[] standardColumnNames, String[] additionalColumnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME_COL_NAME);
        for (String name : standardColumnNames) {
            sb.append("\t");
            sb.append(name);
        }
        sb.append("\t");
        sb.append(DESC_COL_NAMES[0]);
        for (String additionalColumnName : additionalColumnNames) {
            sb.append("\t");
            sb.append(additionalColumnName);
        }
        return sb.toString();
    }

    private static String getWavelengthLine(Product product, String[] standardColumnNames, String[] additionalColumnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Wavelength:");
        for (String ignored : standardColumnNames) {
            sb.append("\t");
        }
        sb.append("\t");
        for (String additionalColumnName : additionalColumnNames) {
            Band band = product.getBand(additionalColumnName);
            float spectralWavelength = 0.0f;
            if (band != null) {
                spectralWavelength = band.getSpectralWavelength();
            }
            sb.append("\t");
            sb.append(spectralWavelength);
        }
        return sb.toString();
    }

    public static void writePlacemarksFile(Writer writer, List<Placemark> placemarks) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, true);
        String[] tags = XmlWriter.createTags(0, "Placemarks");
        xmlWriter.println(tags[0]);
        for (Placemark placemark : placemarks) {
            if (placemark == null) continue;
            PlacemarkIO.writeXML(placemark, xmlWriter, 1);
        }
        xmlWriter.println(tags[1]);
        xmlWriter.close();
    }

    public static BeamFileFilter createTextFileFilter() {
        return new BeamFileFilter("PLACEMARK_TEXT_FILE", new String[]{FILE_EXTENSION_FLAT_TEXT, FILE_EXTENSION_FLAT_OLD}, "Placemark files - flat text format");
    }

    public static BeamFileFilter createPlacemarkFileFilter() {
        return new BeamFileFilter("PLACEMARK_XML_FILE", new String[]{FILE_EXTENSION_PLACEMARK, FILE_EXTENSION_XML_OLD}, "Placemark files - XML format");
    }

    public static Placemark createPlacemark(Element element, PlacemarkDescriptor descriptor, GeoCoding geoCoding) {
        if (!"Placemark".equals(element.getName()) && !"Pin".equals(element.getName())) {
            throw new IllegalArgumentException(MessageFormat.format("Element ''{0}'' or ''{1}'' expected.", "Placemark", "Pin"));
        }
        String name1 = element.getAttributeValue("name");
        if (name1 == null) {
            throw new IllegalArgumentException(MessageFormat.format("Missing attribute ''{0}''.", "name"));
        }
        if (!ProductNode.isValidNodeName(name1)) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid placemark name ''{0}''.", name1));
        }
        String label = element.getChildTextTrim("LABEL");
        if (label == null) {
            label = name1;
        }
        String description1 = element.getChildTextTrim("DESCRIPTION");
        String latText = element.getChildTextTrim("LATITUDE");
        String lonText = element.getChildTextTrim("LONGITUDE");
        String posXText = element.getChildTextTrim("PIXEL_X");
        String posYText = element.getChildTextTrim("PIXEL_Y");
        GeoPos geoPos = null;
        if (latText != null && lonText != null) {
            try {
                float lat = Float.parseFloat(latText);
                float lon = Float.parseFloat(lonText);
                geoPos = new GeoPos(lat, lon);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid geo-position.", e);
            }
        }
        PixelPos pixelPos = null;
        if (posXText != null && posYText != null) {
            try {
                float pixelX = Float.parseFloat(posXText);
                float pixelY = Float.parseFloat(posYText);
                pixelPos = new PixelPos(pixelX, pixelY);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid pixel-position.", e);
            }
        }
        if (geoPos == null && pixelPos == null) {
            throw new IllegalArgumentException("Neither geo-position nor pixel-position given.");
        }
        Placemark placemark = Placemark.createPointPlacemark(descriptor, name1, label, description1, pixelPos, geoPos, geoCoding);
        String styleCss = element.getChildTextTrim("STYLE_CSS");
        if (styleCss == null) {
            String placemarkStyleCss = placemark.getStyleCss();
            styleCss = StringUtils.isNullOrEmpty(placemarkStyleCss) ? PlacemarkIO.getStyleCssFromOldFormat(element) : placemarkStyleCss + ";" + PlacemarkIO.getStyleCssFromOldFormat(element);
        }
        placemark.setStyleCss(styleCss);
        return placemark;
    }

    private static String getStyleCssFromOldFormat(Element element) {
        StringBuilder styleCss = new StringBuilder();
        PlacemarkIO.buildStyleCss(PlacemarkIO.getColorProperty(element, "FillColor", "fill"), styleCss);
        PlacemarkIO.buildStyleCss(PlacemarkIO.getColorProperty(element, "OutlineColor", "stroke"), styleCss);
        return styleCss.toString();
    }

    private static void buildStyleCss(Property strokeProperty, StringBuilder styleCss) {
        if (strokeProperty.getValue() != null) {
            if (styleCss.length() > 0) {
                styleCss.append(";");
            }
            styleCss.append(strokeProperty.getName()).append(":").append(strokeProperty.getValueAsText());
        }
    }

    private static Property getColorProperty(Element element, String elementName, String propertyName) {
        Property fillProperty = Property.create((String)propertyName, Color.class);
        Color fillColor = PlacemarkIO.createColor(element.getChild(elementName));
        if (fillColor != null) {
            try {
                fillProperty.setValue((Object)fillColor);
            }
            catch (ValidationException e) {
                BeamLogManager.getSystemLogger().warning(e.getMessage());
            }
        }
        return fillProperty;
    }

    private static Color createColor(Element elem) {
        Element colorElem;
        if (elem != null && (colorElem = elem.getChild("COLOR")) != null) {
            try {
                return DimapProductHelpers.createColor(colorElem);
            }
            catch (IllegalArgumentException e) {
                Debug.trace(e);
            }
        }
        return null;
    }

    public static void writeXML(Placemark placemark, XmlWriter writer, int indent) {
        String styleCss;
        PixelPos pixelPos;
        Guardian.assertNotNull("writer", writer);
        Guardian.assertGreaterThan("indent", indent, -1L);
        String[][] attributes = new String[][]{{"name", placemark.getName()}};
        String[] pinTags = XmlWriter.createTags(indent, "Placemark", attributes);
        writer.println(pinTags[0]);
        writer.printLine(++indent, "LABEL", placemark.getLabel());
        writer.printLine(indent, "DESCRIPTION", placemark.getDescription());
        GeoPos geoPos = placemark.getGeoPos();
        if (geoPos != null) {
            writer.printLine(indent, "LATITUDE", geoPos.lat);
            writer.printLine(indent, "LONGITUDE", geoPos.lon);
        }
        if ((pixelPos = placemark.getPixelPos()) != null && pixelPos.isValid()) {
            writer.printLine(indent, "PIXEL_X", pixelPos.x);
            writer.printLine(indent, "PIXEL_Y", pixelPos.y);
        }
        if ((styleCss = placemark.getStyleCss()) != null && !styleCss.isEmpty()) {
            writer.printLine(indent, "STYLE_CSS", styleCss);
        }
        writer.println(pinTags[1]);
    }

    public static void writeColor(String tagName, int indent, Color color, XmlWriter writer) {
        String[] colorTags = XmlWriter.createTags(indent, tagName);
        writer.println(colorTags[0]);
        DimapProductHelpers.printColorTag(indent + 1, color, writer);
        writer.println(colorTags[1]);
    }
}

