/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.codesnippets.framework.datamodel;

import com.bc.ceres.core.PrintWriterProgressMonitor;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.ParseException;
import com.bc.jexp.Term;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;

public class ProductExamples {
    public static Product createInMemoryProduct() {
        int width = 200;
        int height = 200;
        float[] bandData = new float[width * height];
        Product product = new Product("productName", "productType", width, height);
        Band aBand = new Band("bandName", 30, width, height);
        aBand.setData(ProductData.createInstance(bandData));
        product.addBand(aBand);
        product.setModified(false);
        return product;
    }

    public Product addTiePointGeoCoding(Product product) {
        float[] latitudes = new float[]{64.50828f, 64.67363f, 64.83669f, 64.22428f, 64.38799f, 64.54942f, 63.939045f, 64.101135f, 64.26096f};
        float[] longitudes = new float[]{39.62003f, 39.041527f, 38.455982f, 39.18259f, 38.607548f, 38.025665f, 38.753914f, 38.182358f, 37.604156f};
        TiePointGrid latGrid = new TiePointGrid("latitude", 3, 3, 0.0f, 0.0f, 2.0f, 2.0f, latitudes);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 3, 3, 0.0f, 0.0f, 2.0f, 2.0f, longitudes);
        product.addTiePointGrid(latGrid);
        product.addTiePointGrid(lonGrid);
        TiePointGeoCoding coding = new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84);
        product.setGeoCoding(coding);
        return product;
    }

    public static class WriteInMemoryProductToDisk {
        public static void main(String[] args) {
            Product aProduct = ProductExamples.createInMemoryProduct();
            File aFile = new File("C:/data/test_product.dim");
            try {
                ProductIO.writeProduct(aProduct, aFile, "BEAM-DIMAP", true, (ProgressMonitor)new PrintWriterProgressMonitor((OutputStream)System.out));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ReadBitmaskLinewise {
        public static void main(String[] args) {
            try {
                Product product = ProductIO.readProduct("C:/Projects/BEAM/data/MER_RR__1P_A.N1");
                int width = product.getSceneRasterWidth();
                int height = product.getSceneRasterHeight();
                Term term = product.parseExpression("not l2_flags.INVALID and not l1_flags.BRIGHT");
                boolean[] maskLine = new boolean[width];
                for (int y = 0; y < height; ++y) {
                    product.readBitmask(0, 0, width, 1, term, maskLine, (ProgressMonitor)new PrintWriterProgressMonitor((OutputStream)System.out));
                }
                product.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

