/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageOutputStream;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;

public class BandWriterMain {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("parameter usage: <input-file> <output-file> <band-name>");
            return;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String bandName = args[2];
        try {
            BandWriterMain.run(inputPath, outputPath, bandName);
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    private static void run(String inputPath, String outputPath, String bandName) throws IOException {
        Product product = ProductIO.readProduct(inputPath);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        Band band = product.getBand(bandName);
        if (band == null) {
            throw new IOException("band not found: " + bandName);
        }
        System.out.println("writing band raw image file " + outputPath + " containing " + w + " x " + h + " pixels of type " + ProductData.getTypeString(band.getDataType()) + "...");
        FileImageOutputStream outputStream = new FileImageOutputStream(new File(outputPath));
        ProductData bandScanLine = band.createCompatibleRasterData(w, 1);
        for (int y = 0; y < h; ++y) {
            band.readRasterData(0, y, w, 1, bandScanLine, ProgressMonitor.NULL);
            bandScanLine.writeTo(outputStream);
        }
        outputStream.close();
        System.out.println("OK");
    }
}

