/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.ParseException;
import com.bc.jexp.Term;
import java.io.FileOutputStream;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;

public class BitmaskWriterMain {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("parameter usage: <input-file> <output-file> <bit-mask-expr>");
            return;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String bitmaskExpr = args[2];
        try {
            BitmaskWriterMain.run(inputPath, outputPath, bitmaskExpr);
        }
        catch (IOException e) {
            System.out.println("I/O error: " + e.getMessage());
        }
        catch (ParseException e) {
            System.out.println("bit-mask syntax error: " + e.getMessage());
        }
    }

    private static void run(String inputPath, String outputPath, String bitmaskExpr) throws IOException, ParseException {
        Product product = ProductIO.readProduct(inputPath);
        Term bitmaskTerm = product.parseExpression(bitmaskExpr);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        System.out.println("writing bit-mask image file " + outputPath + " containing " + w + " x " + h + " pixels of type byte...");
        FileOutputStream outputStream = new FileOutputStream(outputPath);
        byte[] bitmaskScanLine = new byte[w];
        for (int y = 0; y < h; ++y) {
            product.readBitmask(0, y, w, 1, bitmaskTerm, bitmaskScanLine, (byte)-1, (byte)0, ProgressMonitor.NULL);
            outputStream.write(bitmaskScanLine);
        }
        outputStream.close();
        System.out.println("OK");
    }
}

