/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import java.io.FileWriter;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;

public class GcpExportMain {
    private static final String _GCP_LINE_SEPARATOR = System.getProperty("line.separator");

    public static void main(String[] args) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(args[0]);
            Product product = ProductIO.readProduct(args[1]);
            GeoCoding geoCoding = product.getGeoCoding();
            int width = product.getSceneRasterWidth();
            int height = product.getSceneRasterHeight();
            int resolution = Integer.parseInt(args[2]);
            int gcpWidth = Math.max(width / resolution + 1, 2);
            int gcpHeight = Math.max(height / resolution + 1, 2);
            float xMultiplier = 1.0f * (float)(width - 1) / (float)(gcpWidth - 1);
            float yMultiplier = 1.0f * (float)(height - 1) / (float)(gcpHeight - 1);
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos = new GeoPos();
            writer.write(GcpExportMain.createLineString("; ENVI Registration GCP File"));
            for (int y = 0; y < gcpHeight; ++y) {
                for (int x = 0; x < gcpWidth; ++x) {
                    float imageX = xMultiplier * (float)x;
                    float imageY = yMultiplier * (float)y;
                    pixelPos.x = imageX + 0.5f;
                    pixelPos.y = imageY + 0.5f;
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    float mapX = geoPos.lon;
                    float mapY = geoPos.lat;
                    writer.write(GcpExportMain.createLineString(mapX, mapY, pixelPos.x + 1.0f, pixelPos.y + 1.0f));
                }
            }
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String createLineString(String str) {
        return str.concat(_GCP_LINE_SEPARATOR);
    }

    private static String createLineString(float mapX, float mapY, float imageX, float imageY) {
        return "" + mapX + "\t" + mapY + "\t" + imageX + "\t" + imageY + _GCP_LINE_SEPARATOR;
    }
}

