/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;

public class GeoCodingEx {
    public static void main(String[] args) {
        try {
            Product product = ProductIO.readProduct("C:/Projects/BEAM/data/MER_RR__1P_A.N1");
            GeoCoding geoCoding = product.getGeoCoding();
            int width = product.getSceneRasterWidth();
            int height = product.getSceneRasterHeight();
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos = new GeoPos();
            System.out.println();
            System.out.println("# pixel coordinates --> geo coordinates");
            System.out.println("Pixel-X Pixel-Y Longitude Latitude");
            for (float y = 0.5f; y < (float)height; y += 128.0f) {
                for (float x = 0.5f; x < (float)width; x += 128.0f) {
                    pixelPos.x = x;
                    pixelPos.y = y;
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    System.out.println(pixelPos.x + "  " + pixelPos.y + "  " + geoPos.lon + "  " + geoPos.lat);
                }
            }
            System.out.println();
            System.out.println("# geo coordinates --> pixel coordinates");
            System.out.println("Pixel-X Pixel-Y Longitude Latitude");
            float lon0 = -4.0f;
            float lon1 = 14.0f;
            float lat0 = 55.0f;
            int n = 10;
            for (int i = 0; i < n; ++i) {
                geoPos.lon = lon0 + (float)i * (lon1 - lon0) / ((float)n - 1.0f);
                geoPos.lat = lat0;
                geoCoding.getPixelPos(geoPos, pixelPos);
                System.out.println(pixelPos.x + "  " + pixelPos.y + "  " + geoPos.lon + "  " + geoPos.lat);
            }
            product.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

