/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;

public class SolarFluxEx {
    public static void main(String[] args) {
        try {
            Product product = ProductIO.readProduct("C:/Projects/BEAM/data/MER_RR__1P_A.N1");
            float[] solarFlux = SolarFluxEx.getSolarFlux(product);
            for (int i = 0; i < solarFlux.length; ++i) {
                System.out.println("solarFlux[" + i + "] = " + solarFlux[i]);
            }
            product.closeIO();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static float[] getSolarFlux(Product product) {
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement gadsElem = metadataRoot.getElement("Scaling_Factor_GADS");
        MetadataAttribute solarFluxAtt = gadsElem.getAttribute("sun_spec_flux");
        return (float[])solarFluxAtt.getDataElems();
    }
}

