/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.data_export;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageOutputStream;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;

public class TiePointGridWriterMain {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("parameter usage: <input-file> <output-file> <grid-name>");
            return;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        String gridName = args[2];
        try {
            TiePointGridWriterMain.run(inputPath, outputPath, gridName);
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    private static void run(String inputPath, String outputPath, String gridName) throws IOException {
        Product product = ProductIO.readProduct(inputPath);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        TiePointGrid grid = product.getTiePointGrid(gridName);
        if (grid == null) {
            throw new IOException("tie-point grid not found: " + gridName);
        }
        System.out.println("writing tie-point grid raw image file " + outputPath + " containing " + w + " x " + h + " interpolated pixels of type " + ProductData.getTypeString(grid.getDataType()) + "...");
        FileImageOutputStream outputStream = new FileImageOutputStream(new File(outputPath));
        float[] gridScanLine = new float[w];
        for (int y = 0; y < h; ++y) {
            grid.readPixels(0, y, w, 1, gridScanLine, ProgressMonitor.NULL);
            outputStream.writeFloats(gridScanLine, 0, w);
        }
        outputStream.close();
        System.out.println("OK");
    }
}

