/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.examples.ndvi_simple;

import com.bc.ceres.core.PrintWriterProgressMonitor;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.FileImageOutputStream;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;

public class NdviSimpleMain {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("parameter usage: <input-file> <output-file>");
            return;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        try {
            NdviSimpleMain.run(inputPath, outputPath);
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    private static void run(String inputPath, String outputPath) throws IOException {
        Product product = ProductIO.readProduct(inputPath);
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        Band lowBand = product.getBand("radiance_6");
        if (lowBand == null) {
            throw new IOException("low-band 'radiance_6' not found");
        }
        Band hiBand = product.getBand("radiance_10");
        if (hiBand == null) {
            throw new IOException("hi-band 'radiance_10' not found");
        }
        System.out.println("writing NDVI raw image file " + outputPath + " containing " + w + " x " + h + " pixels of type byte (value range 0-255)...");
        FileImageOutputStream outputStream = new FileImageOutputStream(new File(outputPath));
        float[] lowBandPixels = new float[w];
        float[] hiBandPixels = new float[w];
        for (int y = 0; y < h; ++y) {
            lowBand.readPixels(0, y, w, 1, lowBandPixels, (ProgressMonitor)new PrintWriterProgressMonitor((OutputStream)System.out));
            hiBand.readPixels(0, y, w, 1, hiBandPixels, (ProgressMonitor)new PrintWriterProgressMonitor((OutputStream)System.out));
            for (int x = 0; x < w; ++x) {
                float dif = lowBandPixels[x] - hiBandPixels[x];
                float sum = lowBandPixels[x] + hiBandPixels[x];
                float ndvi = sum != 0.0f ? dif / sum : 0.0f;
                if (ndvi < 0.0f) {
                    ndvi = 0.0f;
                } else if (ndvi > 1.0f) {
                    ndvi = 1.0f;
                }
                int ndviByte = (int)(255.0f * ndvi);
                outputStream.writeByte(ndviByte);
            }
        }
        outputStream.close();
        System.out.println("OK");
    }
}

