/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Product;

public final class ProductCache {
    private static final int cacheSize = 200;
    private final Map<File, Product> productMap = new HashMap<File, Product>(200);
    private final Map<File, Long> timeStampMap = new HashMap<File, Long>(200);
    private final ArrayList<File> fileList = new ArrayList(200);
    private static final ProductCache theInstance = new ProductCache();

    private ProductCache() {
    }

    public static ProductCache instance() {
        return theInstance;
    }

    public synchronized void addProduct(File file, Product p) {
        this.productMap.put(file, p);
        this.timeStampMap.put(file, file.lastModified());
        this.fileList.remove(file);
        this.fileList.add(0, file);
        if (this.fileList.size() > 200) {
            int index = this.fileList.size() - 1;
            File lastFile = this.fileList.get(index);
            this.productMap.remove(lastFile);
            this.fileList.remove(index);
        }
    }

    public Product getProduct(File file) {
        Product prod = this.productMap.get(file);
        if (prod != null && prod.getFileLocation() != null && file.lastModified() == this.timeStampMap.get(file).longValue()) {
            return prod;
        }
        return null;
    }

    public synchronized void removeProduct(File file) {
        if (file == null) {
            return;
        }
        this.productMap.remove(file);
        this.fileList.remove(file);
        this.timeStampMap.remove(file);
    }

    public synchronized void clearCache() {
        ArrayList toDelete = (ArrayList)this.fileList.clone();
        for (File f : toDelete) {
            Product prod = this.productMap.get(f);
            if (prod == null) continue;
            prod.dispose();
        }
        toDelete.clear();
        this.productMap.clear();
        this.fileList.clear();
        this.timeStampMap.clear();
    }
}

