/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductCache;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.logging.BeamLogManager;

public class ProductIO {
    public static final String DEFAULT_FORMAT_NAME = "BEAM-DIMAP";

    public static ProductReader getProductReader(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
        if (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            return plugIn.createReaderInstance();
        }
        return null;
    }

    public static String[] getProductWriterExtensions(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.getDefaultFileExtensions();
        }
        return null;
    }

    public static ProductWriter getProductWriter(String formatName) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductWriterPlugIn> it = registry.getWriterPlugIns(formatName);
        if (it.hasNext()) {
            ProductWriterPlugIn plugIn = it.next();
            return plugIn.createWriterInstance();
        }
        return null;
    }

    public static Product readProduct(File file, String ... formatNames) throws IOException {
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        for (String formatName : formatNames) {
            ProductReader productReader;
            Iterator<ProductReaderPlugIn> it = registry.getReaderPlugIns(formatName);
            ProductReaderPlugIn selectedPlugIn = null;
            while (it.hasNext()) {
                ProductReaderPlugIn plugIn = it.next();
                DecodeQualification decodeQualification = plugIn.getDecodeQualification(file);
                if (decodeQualification == DecodeQualification.INTENDED) {
                    selectedPlugIn = plugIn;
                    break;
                }
                if (decodeQualification != DecodeQualification.SUITABLE) continue;
                selectedPlugIn = plugIn;
            }
            if (selectedPlugIn == null || (productReader = selectedPlugIn.createReaderInstance()) == null) continue;
            return productReader.readProductNodes(file, null);
        }
        return ProductIO.readProductImpl(file, null);
    }

    public static Product readProduct(String filePath) throws IOException {
        return ProductIO.readProductImpl(new File(filePath), null);
    }

    public static Product readProduct(File file) throws IOException {
        return ProductIO.readProductImpl(file, null);
    }

    private static Product readProductImpl(File file, ProductSubsetDef subsetDef) throws IOException {
        return ProductIO.readandCacheProduct(file, subsetDef);
    }

    private static synchronized Product readandCacheProduct(File file, ProductSubsetDef subsetDef) throws IOException {
        ProductReader productReader;
        Product cachedProduct = ProductCache.instance().getProduct(file);
        if (cachedProduct != null) {
            ProductCache.instance().addProduct(file, cachedProduct);
            return cachedProduct;
        }
        Guardian.assertNotNull("file", file);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        Product product = ProductIO.readCommonProductReader(file);
        if (product == null && (productReader = ProductIO.getProductReaderForInput(file)) != null) {
            product = productReader.readProductNodes(file, subsetDef);
        }
        if (product != null) {
            ProductCache.instance().addProduct(file, product);
        }
        return product;
    }

    public static Product readCommonProductReader(File file) throws IOException {
        String filename = file.getName().toLowerCase();
        if (filename.endsWith("dim")) {
            return ProductIO.readProduct(file, DEFAULT_FORMAT_NAME);
        }
        if (filename.endsWith("n1") || filename.endsWith("e1") || filename.endsWith("e2")) {
            return ProductIO.readProduct(file, "ENVISAT");
        }
        if ((filename.startsWith("TSX") || filename.startsWith("TDX")) && filename.endsWith("xml")) {
            return ProductIO.readProduct(file, "TerraSarX");
        }
        if (filename.equals("product.xml")) {
            return ProductIO.readProduct(file, "RADARSAT-2");
        }
        if (filename.endsWith("tif")) {
            return ProductIO.readProduct(file, "GeoTIFF");
        }
        if (filename.endsWith("dbl")) {
            return ProductIO.readProduct(file, "SMOS-DBL");
        }
        return null;
    }

    public static ProductReader findCommonProductReader(File file) {
        String filename = file.getName().toLowerCase();
        if (filename.endsWith("n1") || filename.endsWith("e1") || filename.endsWith("e2")) {
            return ProductIO.getProductReader("ENVISAT");
        }
        if (filename.endsWith("dim")) {
            return ProductIO.getProductReader(DEFAULT_FORMAT_NAME);
        }
        if ((filename.startsWith("TSX") || filename.startsWith("TDX")) && filename.endsWith("xml")) {
            return ProductIO.getProductReader("TerraSarX");
        }
        if (filename.endsWith("tif")) {
            return ProductIO.getProductReader("GeoTIFF");
        }
        if (filename.endsWith("dbl")) {
            return ProductIO.getProductReader("SMOS-DBL");
        }
        return null;
    }

    @Deprecated
    public static ProductReader getProductReaderForFile(File file) {
        return ProductIO.getProductReaderForInput(file);
    }

    public static ProductReader getProductReaderForInput(Object input) {
        ProductReader reader;
        Logger logger = BeamLogManager.getSystemLogger();
        logger.fine("Searching reader plugin for '" + input + "'");
        if (input instanceof File && (reader = ProductIO.findCommonProductReader((File)input)) != null) {
            return reader;
        }
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator<ProductReaderPlugIn> it = registry.getAllReaderPlugIns();
        Object selectedPlugIn = null;
        while (it.hasNext()) {
            ProductReaderPlugIn plugIn = it.next();
            long startTime = System.currentTimeMillis();
            DecodeQualification decodeQualification = plugIn.getDecodeQualification(input);
            long endTime = System.currentTimeMillis();
            logger.fine(String.format("Checking reader plugin %s (took %d ms)", plugIn.getClass().getName(), endTime - startTime));
            if (decodeQualification == DecodeQualification.INTENDED) {
                selectedPlugIn = plugIn;
                break;
            }
            if (decodeQualification != DecodeQualification.SUITABLE) continue;
            selectedPlugIn = plugIn;
        }
        if (selectedPlugIn != null) {
            logger.fine("Selected " + selectedPlugIn.getClass().getName());
            return selectedPlugIn.createReaderInstance();
        }
        logger.fine("No suitable reader plugin found");
        return null;
    }

    public static void writeProduct(Product product, String filePath, String formatName) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, ProgressMonitor.NULL);
    }

    public static void writeProduct(Product product, String filePath, String formatName, ProgressMonitor pm) throws IOException {
        ProductIO.writeProduct(product, new File(filePath), formatName, false, pm);
    }

    public static void writeProduct(Product product, File file, String formatName, boolean incremental) throws IOException {
        ProductIO.writeProduct(product, file, formatName, incremental, ProgressMonitor.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter;
        Guardian.assertNotNull("product", (Object)product);
        Guardian.assertNotNull("file", file);
        if (formatName == null) {
            formatName = DEFAULT_FORMAT_NAME;
        }
        if ((productWriter = ProductIO.getProductWriter(formatName)) == null) {
            throw new ProductIOException("no product writer for the '" + formatName + "' format available");
        }
        productWriter.setIncrementalMode(incremental);
        productWriter.setFormatName(formatName);
        ProductWriter productWriterOld = product.getProductWriter();
        product.setProductWriter(productWriter);
        IOException ioException = null;
        try {
            productWriter.writeProductNodes(product, file);
            ProductIO.writeAllBands(product, pm);
        }
        catch (IOException e) {
            ioException = e;
        }
        finally {
            block15: {
                try {
                    product.closeProductWriter();
                }
                catch (IOException e) {
                    if (ioException != null) break block15;
                    ioException = e;
                }
            }
            product.setProductWriter(productWriterOld);
            product.setFileLocation(file);
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAllBands(Product product, ProgressMonitor pm) throws IOException {
        ProductWriter productWriter = product.getProductWriter();
        ArrayList<Band> bandsToWrite = new ArrayList<Band>();
        for (int i = 0; i < product.getNumBands(); ++i) {
            Band band = product.getBandAt(i);
            if (!productWriter.shouldWrite(band)) continue;
            bandsToWrite.add(band);
        }
        if (!bandsToWrite.isEmpty()) {
            pm.beginTask("Writing bands of product '" + product.getName() + "'...", bandsToWrite.size());
            try {
                for (Band band : bandsToWrite) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    band.writeRasterDataFully(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private ProductIO() {
    }
}

