/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.esa.beam.BeamCoreActivator;
import org.esa.beam.framework.dataio.ProductIOPlugIn;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public class ProductIOPlugInManager {
    private final ServiceRegistry<ProductReaderPlugIn> readerPlugIns;
    private final ServiceRegistry<ProductWriterPlugIn> writerPlugIns;

    public static ProductIOPlugInManager getInstance() {
        return Holder.instance;
    }

    public Iterator<ProductReaderPlugIn> getAllReaderPlugIns() {
        return this.readerPlugIns.getServices().iterator();
    }

    public Iterator<ProductReaderPlugIn> getReaderPlugIns(String formatName) {
        Guardian.assertNotNull("formatName", formatName);
        return ProductIOPlugInManager.getProductIOPlugIns(this.readerPlugIns.getServices(), formatName);
    }

    public void addReaderPlugIn(ProductReaderPlugIn readerPlugIn) {
        this.readerPlugIns.addService((Object)readerPlugIn);
    }

    public ProductReaderPlugIn getReaderPlugIn(String className) {
        return (ProductReaderPlugIn)this.readerPlugIns.getService(className);
    }

    public boolean removeReaderPlugIn(ProductReaderPlugIn readerPlugIn) {
        return this.readerPlugIns.removeService((Object)readerPlugIn);
    }

    public Iterator<ProductWriterPlugIn> getAllWriterPlugIns() {
        return this.writerPlugIns.getServices().iterator();
    }

    public Iterator<ProductWriterPlugIn> getWriterPlugIns(String formatName) {
        Guardian.assertNotNull("formatName", formatName);
        return ProductIOPlugInManager.getProductIOPlugIns(this.writerPlugIns.getServices(), formatName);
    }

    public void addWriterPlugIn(ProductWriterPlugIn writerPlugIn) {
        this.writerPlugIns.addService((Object)writerPlugIn);
    }

    public boolean removeWriterPlugIn(ProductWriterPlugIn writerPlugIn) {
        return this.writerPlugIns.removeService((Object)writerPlugIn);
    }

    public String[] getAllProductWriterFormatStrings() {
        Iterator<ProductWriterPlugIn> iterator = this.getAllWriterPlugIns();
        ArrayList<String> formats = new ArrayList<String>();
        while (iterator.hasNext()) {
            String[] formatNames;
            ProductIOPlugIn writer = iterator.next();
            for (String formatName : formatNames = writer.getFormatNames()) {
                if (formats.contains(formatName)) continue;
                formats.add(formatName);
            }
        }
        return formats.toArray(new String[formats.size()]);
    }

    private static <T extends ProductIOPlugIn> Iterator<T> getProductIOPlugIns(Set<T> ioPlugIns, String formatName) {
        Debug.assertNotNull(ioPlugIns);
        Debug.assertNotNull(formatName);
        ArrayList<ProductIOPlugIn> validPlugins = new ArrayList<ProductIOPlugIn>();
        for (ProductIOPlugIn plugIn : ioPlugIns) {
            String[] formatNames;
            for (String otherFormatName : formatNames = plugIn.getFormatNames()) {
                if (!otherFormatName.equalsIgnoreCase(formatName)) continue;
                validPlugins.add(plugIn);
            }
        }
        return validPlugins.iterator();
    }

    protected ProductIOPlugInManager() {
        ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
        this.readerPlugIns = serviceRegistryManager.getServiceRegistry(ProductReaderPlugIn.class);
        this.writerPlugIns = serviceRegistryManager.getServiceRegistry(ProductWriterPlugIn.class);
        if (!BeamCoreActivator.isStarted()) {
            BeamCoreActivator.loadServices(this.readerPlugIns);
            BeamCoreActivator.loadServices(this.writerPlugIns);
        }
    }

    private static class Holder {
        private static final ProductIOPlugInManager instance = new ProductIOPlugInManager();

        private Holder() {
        }
    }
}

