/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.Histogram;
import org.esa.beam.framework.dataio.AbstractProductBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ProductUtils;

public class ProductSubsetBuilder
extends AbstractProductBuilder {
    public ProductSubsetBuilder() {
        this(false);
    }

    public ProductSubsetBuilder(boolean sourceProductOwner) {
        super(sourceProductOwner);
    }

    public static Product createProductSubset(Product sourceProduct, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        return ProductSubsetBuilder.createProductSubset(sourceProduct, false, subsetDef, name, desc);
    }

    public static Product createProductSubset(Product sourceProduct, boolean sourceProductOwner, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        ProductSubsetBuilder productSubsetBuilder = new ProductSubsetBuilder(sourceProductOwner);
        return productSubsetBuilder.readProductNodes(sourceProduct, subsetDef, name, desc);
    }

    private static void updateMetadata(Product sourceProduct, Product targetProduct, ProductSubsetDef subsetDef) throws IOException {
        try {
            TiePointGrid srTPG;
            MetadataAttribute slantRange;
            MetadataAttribute offsetY;
            MetadataAttribute offsetX;
            MetadataAttribute width;
            MetadataAttribute totalSize;
            ProductData.UTC endTime;
            MetadataAttribute lastLineTime;
            ProductData.UTC startTime;
            MetadataElement root = targetProduct.getMetadataRoot();
            if (root == null) {
                return;
            }
            MetadataElement absRoot = root.getElement("Abstracted_Metadata");
            if (absRoot == null) {
                return;
            }
            boolean nearRangeOnLeft = ProductSubsetBuilder.isNearRangeOnLeft(targetProduct);
            MetadataAttribute firstLineTime = absRoot.getAttribute("first_line_time");
            if (firstLineTime != null && (startTime = targetProduct.getStartTime()) != null) {
                firstLineTime.getData().setElems(startTime.getArray());
            }
            if ((lastLineTime = absRoot.getAttribute("last_line_time")) != null && (endTime = targetProduct.getEndTime()) != null) {
                lastLineTime.getData().setElems(endTime.getArray());
            }
            if ((totalSize = absRoot.getAttribute("total_size")) != null) {
                totalSize.getData().setElemUInt(targetProduct.getRawStorageSize());
            }
            if (nearRangeOnLeft) {
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "first_near_lat", "first_near_long", 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "first_far_lat", "first_far_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "last_near_lat", "last_near_long", 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "last_far_lat", "last_far_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
            } else {
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "first_near_lat", "first_near_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "first_far_lat", "first_far_long", 0.5f, 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "last_near_lat", "last_near_long", (float)(targetProduct.getSceneRasterWidth() - 1) + 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
                ProductSubsetBuilder.setLatLongMetadata(targetProduct, absRoot, "last_far_lat", "last_far_long", 0.5f, (float)(targetProduct.getSceneRasterHeight() - 1) + 0.5f);
            }
            MetadataAttribute height = absRoot.getAttribute("num_output_lines");
            if (height != null) {
                height.getData().setElemUInt(targetProduct.getSceneRasterHeight());
            }
            if ((width = absRoot.getAttribute("num_samples_per_line")) != null) {
                width.getData().setElemUInt(targetProduct.getSceneRasterWidth());
            }
            if ((offsetX = absRoot.getAttribute("subset_offset_x")) != null && subsetDef.getRegion() != null) {
                offsetX.getData().setElemUInt(subsetDef.getRegion().x);
            }
            if ((offsetY = absRoot.getAttribute("subset_offset_y")) != null && subsetDef.getRegion() != null) {
                offsetY.getData().setElemUInt(subsetDef.getRegion().y);
            }
            if ((slantRange = absRoot.getAttribute("slant_range_to_first_pixel")) != null && (srTPG = targetProduct.getTiePointGrid("slant_range_time")) != null) {
                double slantRangeTime = nearRangeOnLeft ? srTPG.getPixelDouble(0, 0) / 1.0E9 : srTPG.getPixelDouble(targetProduct.getSceneRasterWidth() - 1, 0) / 1.0E9;
                double halfLightSpeed = 1.49896229E8;
                double slantRangeDist = slantRangeTime * 1.49896229E8;
                slantRange.getData().setElemDouble(slantRangeDist);
            }
            ProductSubsetBuilder.setSubsetSRGRCoefficients(sourceProduct, targetProduct, subsetDef, absRoot, nearRangeOnLeft);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static boolean isNearRangeOnLeft(Product product) {
        TiePointGrid incidenceAngle = product.getTiePointGrid("incident_angle");
        if (incidenceAngle != null) {
            double incidenceAngleToLastPixel;
            double incidenceAngleToFirstPixel = incidenceAngle.getPixelDouble(0, 0);
            return incidenceAngleToFirstPixel < (incidenceAngleToLastPixel = incidenceAngle.getPixelDouble(product.getSceneRasterWidth() - 1, 0));
        }
        return true;
    }

    private static void setSubsetSRGRCoefficients(Product sourceProduct, Product targetProduct, ProductSubsetDef subsetDef, MetadataElement absRoot, boolean nearRangeOnLeft) {
        MetadataElement SRGRCoefficientsElem = absRoot.getElement("SRGR_Coefficients");
        if (SRGRCoefficientsElem != null) {
            double rangeSpacing = absRoot.getAttributeDouble("RANGE_SPACING", 0.0);
            double colIndex = subsetDef.getRegion() == null ? 0.0 : subsetDef.getRegion().getX();
            for (MetadataElement srgrList : SRGRCoefficientsElem.getElements()) {
                double ground_range_origin_subset;
                double grO = srgrList.getAttributeDouble("ground_range_origin", 0.0);
                if (nearRangeOnLeft) {
                    ground_range_origin_subset = grO + colIndex * rangeSpacing;
                } else {
                    double colIndexFromRight = (double)sourceProduct.getSceneRasterWidth() - colIndex - (double)targetProduct.getSceneRasterWidth();
                    ground_range_origin_subset = grO + colIndexFromRight * rangeSpacing;
                }
                srgrList.setAttributeDouble("ground_range_origin", ground_range_origin_subset);
            }
        }
    }

    private static void setLatLongMetadata(Product product, MetadataElement absRoot, String tagLat, String tagLon, float x, float y) {
        MetadataAttribute lon;
        PixelPos pixelPos = new PixelPos(x, y);
        GeoPos geoPos = new GeoPos();
        if (product.getGeoCoding() == null) {
            return;
        }
        product.getGeoCoding().getGeoPos(pixelPos, geoPos);
        MetadataAttribute lat = absRoot.getAttribute(tagLat);
        if (lat != null) {
            lat.getData().setElemDouble(geoPos.getLat());
        }
        if ((lon = absRoot.getAttribute(tagLon)) != null) {
            lon.getData().setElemDouble(geoPos.getLon());
        }
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        if (!(this.getInput() instanceof Product)) {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        this.sourceProduct = (Product)((Object)this.getInput());
        Debug.assertNotNull((Object)this.sourceProduct);
        this.sceneRasterWidth = this.sourceProduct.getSceneRasterWidth();
        this.sceneRasterHeight = this.sourceProduct.getSceneRasterHeight();
        if (this.getSubsetDef() != null) {
            Dimension s = this.getSubsetDef().getSceneRasterSize(this.sceneRasterWidth, this.sceneRasterHeight);
            this.sceneRasterWidth = s.width;
            this.sceneRasterHeight = s.height;
        }
        Product targetProduct = this.createProduct();
        ProductSubsetBuilder.updateMetadata(this.sourceProduct, targetProduct, this.getSubsetDef());
        return targetProduct;
    }

    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Band sourceBand = (Band)this.bandMap.get(destBand);
        if (sourceBand.getRasterData() != null) {
            if (sourceBand.getSceneRasterWidth() == destWidth && sourceBand.getSceneRasterHeight() == destHeight) {
                this.copyBandRasterDataFully(sourceBand, destBuffer, destWidth, destHeight);
            } else {
                this.copyBandRasterDataSubSampling(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destWidth);
            }
        } else if (sourceWidth == destWidth && sourceHeight == destHeight) {
            this.readBandRasterDataRegion(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
        } else {
            this.readBandRasterDataSubSampling(sourceBand, sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, destWidth, pm);
        }
    }

    private void copyBandRasterDataFully(Band sourceBand, ProductData destBuffer, int destWidth, int destHeight) {
        ProductSubsetBuilder.copyData(sourceBand.getRasterData(), 0, destBuffer, 0, destWidth * destHeight);
    }

    private void readBandRasterDataRegion(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        sourceBand.readRasterData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, destBuffer, pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBandRasterDataSubSampling(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, int destWidth, ProgressMonitor pm) throws IOException {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        ProductData lineBuffer = ProductData.createInstance(destBuffer.getType(), sourceWidth);
        int destPos = 0;
        try {
            pm.beginTask("Reading sub sampled raster data...", 2 * (sourceMaxY - sourceMinY));
            for (int sourceY = sourceMinY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                sourceBand.readRasterData(sourceOffsetX, sourceY, sourceWidth, 1, lineBuffer, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                if (sourceStepX == 1) {
                    ProductSubsetBuilder.copyData(lineBuffer, 0, destBuffer, destPos, destWidth);
                } else {
                    ProductSubsetBuilder.copyLine(lineBuffer, 0, sourceWidth, sourceStepX, destBuffer, destPos);
                }
                pm.worked(1);
                destPos += destWidth;
            }
        }
        finally {
            pm.done();
        }
    }

    private void copyBandRasterDataSubSampling(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, int destWidth) {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        int destPos = 0;
        for (int sourceY = sourceMinY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
            if (sourceStepX == 1) {
                ProductSubsetBuilder.copyData(sourceBand.getRasterData(), sourceY * sourceBand.getSceneRasterWidth() + sourceOffsetX, destBuffer, destPos, destWidth);
            } else {
                ProductSubsetBuilder.copyLine(sourceBand.getRasterData(), sourceY * sourceBand.getSceneRasterWidth() + sourceOffsetX, sourceWidth, sourceStepX, destBuffer, destPos);
            }
            destPos += destWidth;
        }
    }

    private static void copyData(ProductData sourceBuffer, int sourcePos, ProductData destBuffer, int destPos, int destLength) {
        System.arraycopy(sourceBuffer.getElems(), sourcePos, destBuffer.getElems(), destPos, destLength);
    }

    private static void copyLine(ProductData sourceBuffer, int sourceOffsetPos, int sourceWidth, int sourceStepX, ProductData destBuffer, int destOffsetPos) {
        int sourceMinX = sourceOffsetPos;
        int sourceMaxX = sourceOffsetPos + sourceWidth - 1;
        if (destBuffer.getElems() instanceof byte[]) {
            byte[] destArray = (byte[])destBuffer.getElems();
            byte[] sourceArray = (byte[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof short[]) {
            short[] destArray = (short[])destBuffer.getElems();
            short[] sourceArray = (short[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof int[]) {
            int[] destArray = (int[])destBuffer.getElems();
            int[] sourceArray = (int[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof float[]) {
            float[] destArray = (float[])destBuffer.getElems();
            float[] sourceArray = (float[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else if (destBuffer.getElems() instanceof double[]) {
            double[] destArray = (double[])destBuffer.getElems();
            double[] sourceArray = (double[])sourceBuffer.getElems();
            for (int sourceX = sourceMinX; sourceX <= sourceMaxX; sourceX += sourceStepX) {
                destArray[destOffsetPos] = sourceArray[sourceX];
                ++destOffsetPos;
            }
        } else {
            Debug.assertTrue(false, "illegal product data type");
            throw new IllegalStateException("illegal product data type");
        }
    }

    private Product createProduct() {
        Product sourceProduct = this.getSourceProduct();
        Debug.assertNotNull((Object)sourceProduct);
        Debug.assertTrue(this.getSceneRasterWidth() > 0);
        Debug.assertTrue(this.getSceneRasterHeight() > 0);
        String newProductName = this.newProductName == null || this.newProductName.length() == 0 ? sourceProduct.getName() : this.newProductName;
        Product product = new Product(newProductName, sourceProduct.getProductType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), this);
        product.setPointingFactory(sourceProduct.getPointingFactory());
        if (this.newProductDesc == null || this.newProductDesc.length() == 0) {
            product.setDescription(sourceProduct.getDescription());
        } else {
            product.setDescription(this.newProductDesc);
        }
        if (!this.isMetadataIgnored()) {
            ProductUtils.copyMetadata(sourceProduct, product);
        }
        this.addTiePointGridsToProduct(product);
        this.addBandsToProduct(product);
        ProductUtils.copyMasks(sourceProduct, product);
        this.addFlagCodingsToProduct(product);
        this.addGeoCodingToProduct(product);
        this.addIndexCodingsToProduct(product);
        ProductUtils.copyVectorData(sourceProduct, product);
        ProductUtils.copyOverlayMasks(sourceProduct, product);
        ProductUtils.copyPreferredTileSize(sourceProduct, product);
        this.setSceneRasterStartAndStopTime(product);
        this.addSubsetInfoMetadata(product);
        return product;
    }

    private void setSceneRasterStartAndStopTime(Product product) {
        Product sourceProduct = this.getSourceProduct();
        ProductData.UTC startTime = sourceProduct.getStartTime();
        ProductData.UTC stopTime = sourceProduct.getEndTime();
        ProductSubsetDef subsetDef = this.getSubsetDef();
        if (startTime != null && stopTime != null && subsetDef != null && subsetDef.getRegion() != null) {
            double height = sourceProduct.getSceneRasterHeight();
            Rectangle region = subsetDef.getRegion();
            double regionY = region.getY();
            double regionHeight = region.getHeight();
            double dStart = startTime.getMJD();
            double dStop = stopTime.getMJD();
            double vPerLine = (dStop - dStart) / (height - 1.0);
            double newStart = vPerLine * regionY + dStart;
            double newStop = vPerLine * (regionHeight - 1.0) + newStart;
            product.setStartTime(new ProductData.UTC(newStart));
            product.setEndTime(new ProductData.UTC(newStop));
        } else {
            product.setStartTime(startTime);
            product.setEndTime(stopTime);
        }
    }

    private void addSubsetInfoMetadata(Product product) {
        if (this.getSubsetDef() != null) {
            String[] nodeNames;
            ProductSubsetDef subsetDef = this.getSubsetDef();
            Product sourceProduct = this.getSourceProduct();
            String nameSubsetinfo = "SubsetInfo";
            MetadataElement subsetElem = new MetadataElement(nameSubsetinfo);
            ProductSubsetBuilder.addAttribString("SourceProduct.name", sourceProduct.getName(), subsetElem);
            subsetElem.setAttributeInt("SubSampling.x", subsetDef.getSubSamplingX());
            subsetElem.setAttributeInt("SubSampling.y", subsetDef.getSubSamplingY());
            if (subsetDef.getRegion() != null) {
                Rectangle region = subsetDef.getRegion();
                subsetElem.setAttributeInt("SubRegion.x", region.x);
                subsetElem.setAttributeInt("SubRegion.y", region.y);
                subsetElem.setAttributeInt("SubRegion.width", region.width);
                subsetElem.setAttributeInt("SubRegion.height", region.height);
            }
            if ((nodeNames = subsetDef.getNodeNames()) != null) {
                for (int i = 0; i < nodeNames.length; ++i) {
                    ProductSubsetBuilder.addAttribString("ProductNodeName." + (i + 1), nodeNames[i], subsetElem);
                }
            }
            ProductUtils.addElementToHistory(product, subsetElem);
        }
    }

    protected void addBandsToProduct(Product product) {
        Debug.assertNotNull((Object)this.getSourceProduct());
        Debug.assertNotNull((Object)product);
        for (int i = 0; i < this.getSourceProduct().getNumBands(); ++i) {
            Band destBand;
            Band sourceBand = this.getSourceProduct().getBandAt(i);
            String bandName = sourceBand.getName();
            if (!this.isNodeAccepted(bandName)) continue;
            boolean treatVirtualBandsAsRealBands = false;
            if (this.getSubsetDef() != null && this.getSubsetDef().getTreatVirtualBandsAsRealBands()) {
                treatVirtualBandsAsRealBands = true;
            }
            if (!treatVirtualBandsAsRealBands && sourceBand instanceof VirtualBand) {
                VirtualBand virtualSource = (VirtualBand)sourceBand;
                destBand = new VirtualBand(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight(), virtualSource.getExpression());
            } else {
                destBand = new Band(bandName, sourceBand.getDataType(), this.getSceneRasterWidth(), this.getSceneRasterHeight());
            }
            if (sourceBand.getUnit() != null) {
                destBand.setUnit(sourceBand.getUnit());
            }
            if (sourceBand.getDescription() != null) {
                destBand.setDescription(sourceBand.getDescription());
            }
            destBand.setScalingFactor(sourceBand.getScalingFactor());
            destBand.setScalingOffset(sourceBand.getScalingOffset());
            destBand.setLog10Scaled(sourceBand.isLog10Scaled());
            destBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
            destBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
            destBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
            destBand.setSolarFlux(sourceBand.getSolarFlux());
            if (sourceBand.isNoDataValueSet()) {
                destBand.setNoDataValue(sourceBand.getNoDataValue());
            }
            destBand.setNoDataValueUsed(sourceBand.isNoDataValueUsed());
            destBand.setValidPixelExpression(sourceBand.getValidPixelExpression());
            FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
            IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
            if (sourceFlagCoding != null) {
                String flagCodingName = sourceFlagCoding.getName();
                FlagCoding destFlagCoding = product.getFlagCodingGroup().get(flagCodingName);
                if (destFlagCoding == null) {
                    destFlagCoding = ProductUtils.copyFlagCoding(sourceFlagCoding, product);
                }
                destBand.setSampleCoding(destFlagCoding);
            } else if (sourceIndexCoding != null) {
                String indexCodingName = sourceIndexCoding.getName();
                IndexCoding destIndexCoding = product.getIndexCodingGroup().get(indexCodingName);
                if (destIndexCoding == null) {
                    destIndexCoding = ProductUtils.copyIndexCoding(sourceIndexCoding, product);
                }
                destBand.setSampleCoding(destIndexCoding);
            } else {
                destBand.setSampleCoding(null);
            }
            if (this.isFullScene(this.getSubsetDef()) && sourceBand.isStxSet()) {
                this.copyStx(sourceBand, destBand);
            }
            product.addBand(destBand);
            this.bandMap.put(destBand, sourceBand);
        }
        for (Map.Entry entry : this.bandMap.entrySet()) {
            this.copyImageInfo((RasterDataNode)entry.getValue(), (RasterDataNode)entry.getKey());
        }
    }

    protected void addTiePointGridsToProduct(Product product) {
        String lonGridName;
        String latGridName;
        GeoCoding geoCoding = this.getSourceProduct().getGeoCoding();
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding tiePointGeoCoding = (TiePointGeoCoding)geoCoding;
            TiePointGrid latGrid = tiePointGeoCoding.getLatGrid();
            TiePointGrid lonGrid = tiePointGeoCoding.getLonGrid();
            latGridName = latGrid.getName();
            lonGridName = lonGrid.getName();
        } else {
            latGridName = null;
            lonGridName = null;
        }
        for (int i = 0; i < this.getSourceProduct().getNumTiePointGrids(); ++i) {
            TiePointGrid sourceTiePointGrid = this.getSourceProduct().getTiePointGridAt(i);
            String gridName = sourceTiePointGrid.getName();
            if (!this.isNodeAccepted(gridName) && !gridName.equals(latGridName) && !gridName.equals(lonGridName)) continue;
            TiePointGrid tiePointGrid = TiePointGrid.createSubset(sourceTiePointGrid, this.getSubsetDef());
            if (this.isFullScene(this.getSubsetDef()) && sourceTiePointGrid.isStxSet()) {
                this.copyStx(sourceTiePointGrid, tiePointGrid);
            }
            product.addTiePointGrid(tiePointGrid);
            this.copyImageInfo(sourceTiePointGrid, tiePointGrid);
        }
    }

    private void copyStx(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        Stx sourceStx = sourceRaster.getStx();
        Histogram sourceHistogram = sourceStx.getHistogram();
        Histogram targetHistogram = new Histogram(sourceStx.getHistogramBinCount(), sourceHistogram.getLowValue(0), sourceHistogram.getHighValue(0), 1);
        System.arraycopy(sourceHistogram.getBins(0), 0, targetHistogram.getBins(0), 0, sourceStx.getHistogramBinCount());
        Stx targetStx = new Stx(sourceStx.getMinimum(), sourceStx.getMaximum(), sourceStx.getMean(), sourceStx.getStandardDeviation(), sourceStx.getCoefficientOfVariation(), sourceStx.getEquivalentNumberOfLooks(), sourceStx.isLogHistogram(), sourceStx.isIntHistogram(), targetHistogram, sourceStx.getResolutionLevel());
        targetRaster.setStx(targetStx);
    }

    private void copyImageInfo(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        if (sourceRaster.getImageInfo() != null) {
            ImageInfo imageInfo = sourceRaster.getImageInfo().createDeepCopy();
            targetRaster.setImageInfo(imageInfo);
        }
    }

    private boolean isFullScene(ProductSubsetDef subsetDef) {
        if (subsetDef == null) {
            return true;
        }
        Rectangle sourceRegion = new Rectangle(0, 0, this.sourceProduct.getSceneRasterWidth(), this.getSceneRasterHeight());
        return subsetDef.getRegion() == null || subsetDef.getRegion().equals(sourceRegion) && subsetDef.getSubSamplingX() == 1 && subsetDef.getSubSamplingY() == 1;
    }

    protected void addGeoCodingToProduct(Product product) {
        if (!this.getSourceProduct().transferGeoCodingTo(product, this.getSubsetDef())) {
            Debug.trace("GeoCoding could not be transferred.");
        }
    }
}

