/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.jexp.ParseException;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public abstract class AbstractBand
extends RasterDataNode {
    public static final String VIEW_MODE_ORTHO = "ORTHO";
    public static final String VIEW_MODE_FORWARD = "FORWARD";
    public static final String VIEW_MODE_NADIR = "NADIR";

    public AbstractBand(String name, int dataType, int width, int height) {
        super(name, dataType, width, height);
    }

    @Override
    public void writePixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("pixels", pixels);
        ProductData subRasterData = this.createCompatibleRasterData(w, h);
        int n = w * h;
        if (!this.isScalingApplied() && subRasterData.getElems() instanceof int[]) {
            System.arraycopy(pixels, 0, subRasterData.getElems(), 0, n);
        } else if (this.isScalingApplied()) {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemDoubleAt(i, this.scaleInverse(pixels[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemIntAt(i, pixels[i]);
            }
        }
        this.writeRasterData(x, y, w, h, subRasterData, pm);
    }

    @Override
    public synchronized void writePixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("pixels", pixels);
        ProductData subRasterData = this.createCompatibleRasterData(w, h);
        int n = w * h;
        if (!this.isScalingApplied() && subRasterData.getElems() instanceof float[]) {
            System.arraycopy(pixels, 0, subRasterData.getElems(), 0, n);
        } else if (this.isScalingApplied()) {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemDoubleAt(i, this.scaleInverse(pixels[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemFloatAt(i, pixels[i]);
            }
        }
        this.writeRasterData(x, y, w, h, subRasterData, pm);
    }

    @Override
    public void writePixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("pixels", pixels);
        ProductData subRasterData = this.createCompatibleRasterData(w, h);
        int n = w * h;
        if (!this.isScalingApplied() && subRasterData.getElems() instanceof double[]) {
            System.arraycopy(pixels, 0, subRasterData.getElems(), 0, n);
        } else if (this.isScalingApplied()) {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemDoubleAt(i, this.scaleInverse(pixels[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                subRasterData.setElemDoubleAt(i, pixels[i]);
            }
        }
        this.writeRasterData(x, y, w, h, subRasterData, pm);
    }

    @Override
    public abstract long getRawStorageSize(ProductSubsetDef var1);

    private ProductData readSubRegionRasterData(int x, int y, int w, int h, ProgressMonitor pm) throws IOException {
        ProductData subRasterData = this.createCompatibleRasterData(w, h);
        this.readRasterData(x, y, w, h, subRasterData, pm);
        return subRasterData;
    }

    private ProductData getRasterDataSafe() {
        if (!this.hasRasterData()) {
            throw new IllegalStateException("raster data not loaded");
        }
        return this.getRasterData();
    }

    public String getViewModeId(String bandName) {
        String nameLC = this.getName().toLowerCase();
        String viewModeId = VIEW_MODE_NADIR;
        if (nameLC.indexOf("forward") >= 0 || nameLC.indexOf("fward") >= 0) {
            viewModeId = VIEW_MODE_FORWARD;
        }
        return viewModeId;
    }

    protected static int[] ensureMinLengthArray(int[] array, int length) {
        if (array == null) {
            return new int[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static float[] ensureMinLengthArray(float[] array, int length) {
        if (array == null) {
            return new float[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    protected static double[] ensureMinLengthArray(double[] array, int length) {
        if (array == null) {
            return new double[length];
        }
        if (array.length < length) {
            throw new IllegalArgumentException("The length of the given array is less than " + length);
        }
        return array;
    }

    @Deprecated
    public int computeBand(String expression, String validMaskExpression, Product[] sourceProducts, int defaultProductIndex, boolean checkInvalids, boolean useInvalidValue, double noDataValue, ProgressMonitor pm) throws IOException, ParseException {
        ProductData targetRasterData = this.getRasterData();
        if (targetRasterData == null) {
            targetRasterData = this.createCompatibleRasterData();
        }
        int numInvalids = BandArithmetic.computeBand(expression, validMaskExpression, sourceProducts, defaultProductIndex, checkInvalids, useInvalidValue, noDataValue, 0, 0, this.getRasterWidth(), this.getRasterHeight(), targetRasterData, this, pm);
        this.setRasterData(targetRasterData);
        this.fireProductNodeDataChanged();
        return numInvalids;
    }

    @Override
    public ProductData getSceneRasterData() {
        return this.getRasterData();
    }

    @Override
    public int getPixelInt(int x, int y) {
        if (this.isScalingApplied()) {
            return (int)Math.round(this.scale(this.getRasterData().getElemDoubleAt(this.getRasterWidth() * y + x)));
        }
        return this.getRasterData().getElemIntAt(this.getRasterWidth() * y + x);
    }

    @Override
    public float getPixelFloat(int x, int y) {
        if (this.isScalingApplied()) {
            return (float)this.scale(this.getRasterData().getElemDoubleAt(this.getRasterWidth() * y + x));
        }
        return this.getRasterData().getElemFloatAt(this.getRasterWidth() * y + x);
    }

    @Override
    public double getPixelDouble(int x, int y) {
        if (this.isScalingApplied()) {
            return this.scale(this.getRasterData().getElemDoubleAt(this.getRasterWidth() * y + x));
        }
        return this.getRasterData().getElemDoubleAt(this.getRasterWidth() * y + x);
    }

    @Override
    public void setPixelInt(int x, int y, int pixelValue) {
        if (this.isScalingApplied()) {
            this.getRasterData().setElemDoubleAt(this.getRasterWidth() * y + x, this.scaleInverse(pixelValue));
        } else {
            this.getRasterData().setElemIntAt(this.getRasterWidth() * y + x, pixelValue);
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public void setPixelFloat(int x, int y, float pixelValue) {
        if (this.isScalingApplied()) {
            this.getRasterData().setElemDoubleAt(this.getRasterWidth() * y + x, this.scaleInverse(pixelValue));
        } else {
            this.getRasterData().setElemFloatAt(this.getRasterWidth() * y + x, pixelValue);
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public void setPixelDouble(int x, int y, double pixelValue) {
        if (this.isScalingApplied()) {
            this.getRasterData().setElemDoubleAt(this.getRasterWidth() * y + x, this.scaleInverse(pixelValue));
        } else {
            this.getRasterData().setElemDoubleAt(this.getRasterWidth() * y + x, pixelValue);
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public int[] readPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        if (this.hasRasterData()) {
            pixels = this.getPixels(x, y, w, h, pixels, pm);
        } else {
            ProductData rawData = this.readSubRegionRasterData(x, y, w, h, pm);
            int n = w * h;
            pixels = AbstractBand.ensureMinLengthArray(pixels, n);
            if (!this.isScalingApplied() && rawData.getElems() instanceof int[]) {
                System.arraycopy(rawData.getElems(), 0, pixels, 0, n);
            } else if (this.isScalingApplied()) {
                for (int i = 0; i < n; ++i) {
                    pixels[i] = (int)Math.round(this.scale(rawData.getElemDoubleAt(i)));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    pixels[i] = rawData.getElemIntAt(i);
                }
            }
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] readPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        block10: {
            try {
                if (this.hasRasterData()) {
                    pm.beginTask("Reading pixels...", 1);
                    pixels = this.getPixels(x, y, w, h, pixels, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                    break block10;
                }
                pm.beginTask("Reading pixels...", 2);
                ProductData rawData = this.readSubRegionRasterData(x, y, w, h, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                int n = w * h;
                pixels = AbstractBand.ensureMinLengthArray(pixels, n);
                if (!this.isScalingApplied() && rawData.getElems() instanceof float[]) {
                    System.arraycopy(rawData.getElems(), 0, pixels, 0, n);
                } else if (this.isScalingApplied()) {
                    for (int i = 0; i < n; ++i) {
                        pixels[i] = (float)this.scale(rawData.getElemFloatAt(i));
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        pixels[i] = rawData.getElemFloatAt(i);
                    }
                }
                pm.worked(1);
            }
            finally {
                pm.done();
            }
        }
        return pixels;
    }

    @Override
    public double[] readPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        if (this.hasRasterData()) {
            pixels = this.getPixels(x, y, w, h, pixels, pm);
        } else {
            ProductData rawData = this.readSubRegionRasterData(x, y, w, h, pm);
            int n = w * h;
            pixels = AbstractBand.ensureMinLengthArray(pixels, n);
            if (!this.isScalingApplied() && rawData.getElems() instanceof double[]) {
                System.arraycopy(rawData.getElems(), 0, pixels, 0, n);
            } else if (this.isScalingApplied()) {
                for (int i = 0; i < n; ++i) {
                    pixels[i] = this.scale(rawData.getElemDoubleAt(i));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    pixels[i] = rawData.getElemDoubleAt(i);
                }
            }
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) {
        pixels = AbstractBand.ensureMinLengthArray(pixels, w * h);
        ProductData rasterData = this.getRasterDataSafe();
        int x1 = x;
        int y1 = y;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        int pos = 0;
        pm.beginTask("Retrieving pixels...", y2 - y1);
        try {
            if (this.isScalingApplied()) {
                for (y = y1; y <= y2; ++y) {
                    int xOffs = y * this.getRasterWidth();
                    for (x = x1; x <= x2; ++x) {
                        pixels[pos++] = (int)Math.round(this.scale(rasterData.getElemDoubleAt(xOffs + x)));
                    }
                    pm.worked(1);
                }
            } else {
                for (y = y1; y <= y2; ++y) {
                    int xOffs = y * this.getRasterWidth();
                    for (x = x1; x <= x2; ++x) {
                        pixels[pos++] = rasterData.getElemIntAt(xOffs + x);
                    }
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getPixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) {
        pixels = AbstractBand.ensureMinLengthArray(pixels, w * h);
        ProductData rasterData = this.getRasterDataSafe();
        int x1 = x;
        int y1 = y;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        int pos = 0;
        pm.beginTask("Retrieving pixels...", y2 - y1);
        try {
            if (this.isScalingApplied()) {
                for (y = y1; y <= y2; ++y) {
                    int xOffs = y * this.getRasterWidth();
                    for (x = x1; x <= x2; ++x) {
                        pixels[pos++] = (float)this.scale(rasterData.getElemFloatAt(xOffs + x));
                    }
                    pm.worked(1);
                }
            } else {
                for (y = y1; y <= y2; ++y) {
                    int xOffs = y * this.getRasterWidth();
                    for (x = x1; x <= x2; ++x) {
                        pixels[pos++] = rasterData.getElemFloatAt(xOffs + x);
                    }
                    pm.worked(1);
                }
            }
        }
        finally {
            pm.done();
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getPixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) {
        block10: {
            pixels = AbstractBand.ensureMinLengthArray(pixels, w * h);
            ProductData rasterData = this.getRasterDataSafe();
            int x1 = x;
            int y1 = y;
            int x2 = x1 + w - 1;
            int y2 = y1 + h - 1;
            int pos = 0;
            pm.beginTask("Retrieving pixels...", y2 - y1);
            try {
                if (this.isScalingApplied()) {
                    for (y = y1; y <= y2; ++y) {
                        if (pm.isCanceled()) {
                            break block10;
                        }
                        int xOffs = y * this.getRasterWidth();
                        for (x = x1; x <= x2; ++x) {
                            pixels[pos++] = this.scale(rasterData.getElemDoubleAt(xOffs + x));
                        }
                        pm.worked(1);
                    }
                    break block10;
                }
                for (y = y1; y <= y2; ++y) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    int xOffs = y * this.getRasterWidth();
                    for (x = x1; x <= x2; ++x) {
                        pixels[pos++] = rasterData.getElemDoubleAt(xOffs + x);
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }
        return pixels;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] pixels) {
        Guardian.assertNotNull("pixels", pixels);
        ProductData rasterData = this.getRasterData();
        int x1 = x;
        int y1 = y;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        int pos = 0;
        if (this.isScalingApplied()) {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemDoubleAt(xOffs + x, this.scaleInverse(pixels[pos++]));
                }
            }
        } else {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemIntAt(xOffs + x, pixels[pos++]);
                }
            }
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, float[] pixels) {
        Guardian.assertNotNull("pixels", pixels);
        ProductData rasterData = this.getRasterData();
        int x1 = x;
        int y1 = y;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        int pos = 0;
        if (this.isScalingApplied()) {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemDoubleAt(xOffs + x, this.scaleInverse(pixels[pos++]));
                }
            }
        } else {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemFloatAt(xOffs + x, pixels[pos++]);
                }
            }
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, double[] pixels) {
        Guardian.assertNotNull("pixels", pixels);
        ProductData rasterData = this.getRasterData();
        int x1 = x;
        int y1 = y;
        int x2 = x1 + w - 1;
        int y2 = y1 + h - 1;
        int pos = 0;
        if (this.isScalingApplied()) {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemDoubleAt(xOffs + x, this.scaleInverse(pixels[pos++]));
                }
            }
        } else {
            for (y = y1; y <= y2; ++y) {
                int xOffs = y * this.getRasterWidth();
                for (x = x1; x <= x2; ++x) {
                    rasterData.setElemDoubleAt(xOffs + x, pixels[pos++]);
                }
            }
        }
        this.fireProductNodeDataChanged();
        this.setModified(true);
    }

    public void ensureRasterData() {
        if (!this.hasRasterData()) {
            this.setRasterData(this.createCompatibleRasterData());
        }
        Debug.assertNotNull(this.getRasterData());
    }

    @Override
    @Deprecated
    public void loadRasterData(ProgressMonitor pm) throws IOException {
        if (!this.hasRasterData()) {
            this.readRasterDataFully(pm);
        }
    }

    @Override
    @Deprecated
    public void unloadRasterData() {
        if (this.hasRasterData()) {
            this.setRasterData(null);
        }
    }
}

