/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Random;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.AbstractBand;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.StxFactory;
import org.esa.beam.jai.BandOpImage;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ImageUtils;

public class Band
extends AbstractBand {
    public static final String PROPERTY_NAME_SAMPLE_CODING = "sampleCoding";
    public static final String PROPERTY_NAME_SOLAR_FLUX = "solarFlux";
    public static final String PROPERTY_NAME_SPECTRAL_BAND_INDEX = "spectralBandIndex";
    public static final String PROPERTY_NAME_SPECTRAL_BANDWIDTH = "spectralBandwidth";
    public static final String PROPERTY_NAME_SPECTRAL_WAVELENGTH = "spectralWavelength";
    private SampleCoding sampleCoding;
    private int spectralBandIndex;
    private float spectralWavelength;
    private float spectralBandwidth;
    private float solarFlux;

    public Band(String name, int dataType, int width, int height) {
        super(name, dataType, width, height);
        this.setSpectralBandIndex(-1);
        this.setModified(false);
    }

    public FlagCoding getFlagCoding() {
        return this.getSampleCoding() instanceof FlagCoding ? (FlagCoding)this.getSampleCoding() : null;
    }

    public boolean isFlagBand() {
        return this.getFlagCoding() != null;
    }

    public IndexCoding getIndexCoding() {
        return this.getSampleCoding() instanceof IndexCoding ? (IndexCoding)this.getSampleCoding() : null;
    }

    public boolean isIndexBand() {
        return this.getIndexCoding() != null;
    }

    public SampleCoding getSampleCoding() {
        return this.sampleCoding;
    }

    public void setSampleCoding(SampleCoding sampleCoding) {
        if (sampleCoding != null && !this.hasIntPixels()) {
            throw new IllegalArgumentException("band does not contain integer pixels");
        }
        if (this.sampleCoding != sampleCoding) {
            this.sampleCoding = sampleCoding;
            this.fireProductNodeChanged(PROPERTY_NAME_SAMPLE_CODING);
            this.setModified(true);
        }
    }

    public int getSpectralBandIndex() {
        return this.spectralBandIndex;
    }

    public void setSpectralBandIndex(int spectralBandIndex) {
        if (this.spectralBandIndex != spectralBandIndex) {
            this.spectralBandIndex = spectralBandIndex;
            this.fireProductNodeChanged(PROPERTY_NAME_SPECTRAL_BAND_INDEX);
            this.setModified(true);
        }
    }

    public float getSpectralWavelength() {
        return this.spectralWavelength;
    }

    public void setSpectralWavelength(float spectralWavelength) {
        if (this.spectralWavelength != spectralWavelength) {
            this.spectralWavelength = spectralWavelength;
            this.fireProductNodeChanged(PROPERTY_NAME_SPECTRAL_WAVELENGTH);
            this.setModified(true);
        }
    }

    public float getSpectralBandwidth() {
        return this.spectralBandwidth;
    }

    public void setSpectralBandwidth(float spectralBandwidth) {
        if (this.spectralBandwidth != spectralBandwidth) {
            this.spectralBandwidth = spectralBandwidth;
            this.fireProductNodeChanged(PROPERTY_NAME_SPECTRAL_BANDWIDTH);
            this.setModified(true);
        }
    }

    public float getSolarFlux() {
        return this.solarFlux;
    }

    public void setSolarFlux(float solarFlux) {
        if (this.solarFlux != solarFlux) {
            this.solarFlux = solarFlux;
            this.fireProductNodeChanged(PROPERTY_NAME_SOLAR_FLUX);
            this.setModified(true);
        }
    }

    @Override
    protected RenderedImage createSourceImage() {
        MultiLevelModel model = ImageManager.getMultiLevelModel(this);
        if (this.hasRasterData()) {
            RenderedImage image = ImageUtils.createRenderedImage(this.getRasterWidth(), this.getRasterHeight(), this.getRasterData());
            return new DefaultMultiLevelImage((MultiLevelSource)new DefaultMultiLevelSource(image, model));
        }
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(model){

            public RenderedImage createImage(int level) {
                return new BandOpImage(Band.this, ResolutionLevel.create(this.getModel(), level));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("rasterData", rasterData);
        if (this.isProductReaderDirectlyUsable()) {
            this.getProductReader().readBandRasterData(this, offsetX, offsetY, width, height, rasterData, pm);
        } else {
            try {
                pm.beginTask("Reading raster data...", 100);
                MultiLevelImage sourceImage = this.getSourceImage();
                int x = sourceImage.getMinX() + offsetX;
                int y = sourceImage.getMinY() + offsetY;
                Raster data = sourceImage.getData(new Rectangle(x, y, width, height));
                pm.worked(90);
                data.getDataElements(x, y, width, height, rasterData.getElems());
                pm.worked(10);
            }
            finally {
                pm.done();
            }
        }
    }

    private boolean isProductReaderDirectlyUsable() {
        BandOpImage bandOpImage;
        ProductReader productReader = this.getProductReader();
        return productReader != null && this.isSourceImageSet() && this.getSourceImage().getImage(0) instanceof BandOpImage && (bandOpImage = (BandOpImage)((Object)this.getSourceImage().getImage(0))).getBand().getProductReader() == productReader;
    }

    @Override
    public void readRasterDataFully(ProgressMonitor pm) throws IOException {
        ProductData rasterData = this.hasRasterData() ? this.getRasterData() : this.createCompatibleRasterData(this.getRasterWidth(), this.getRasterHeight());
        this.readRasterData(0, 0, this.getSceneRasterWidth(), this.getSceneRasterHeight(), rasterData, pm);
        this.setRasterData(rasterData);
    }

    @Override
    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("rasterData", rasterData);
        Product product = this.getProductSafe();
        ProductWriter writer = product.getProductWriterSafe();
        writer.writeBandRasterData(this, offsetX, offsetY, width, height, rasterData, pm);
        this.removeCachedImageData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRasterDataFully(ProgressMonitor pm) throws IOException {
        if (this.hasRasterData()) {
            this.writeRasterData(0, 0, this.getRasterWidth(), this.getRasterHeight(), this.getRasterData(), pm);
        } else {
            MultiLevelImage sourceImage = this.getSourceImage();
            try {
                Point[] tileIndices = sourceImage.getTileIndices(new Rectangle(0, 0, sourceImage.getWidth(), sourceImage.getHeight()));
                pm.beginTask("Writing raster data...", tileIndices.length);
                for (Point tileIndex : tileIndices) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    Rectangle rect = sourceImage.getTileRect(tileIndex.x, tileIndex.y);
                    if (!rect.isEmpty()) {
                        Raster data = sourceImage.getData(rect);
                        ProductData rasterData = this.createCompatibleRasterData(rect.width, rect.height);
                        data.getDataElements(rect.x, rect.y, rect.width, rect.height, rasterData.getElems());
                        this.writeRasterData(rect.x, rect.y, rect.width, rect.height, rasterData, ProgressMonitor.NULL);
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        long size = 0L;
        if (this.isPartOfSubset(subsetDef)) {
            size += 256L;
            long numDataElems = this.getNumDataElems();
            if (subsetDef != null) {
                long width = this.getSceneRasterWidth();
                long height = this.getSceneRasterHeight();
                Rectangle region = subsetDef.getRegion();
                if (region != null) {
                    width = region.width;
                    height = region.height;
                }
                numDataElems = (width /= (long)(1 + subsetDef.getSubSamplingX())) * (height /= (long)(1 + subsetDef.getSubSamplingY()));
            }
            size += (long)ProductData.getElemSize(this.getDataType()) * numDataElems;
        }
        return size;
    }

    private void removeCachedImageData() {
        if (this.isSourceImageSet()) {
            this.getSourceImage().reset();
        }
        if (this.isGeophysicalImageSet()) {
            this.getGeophysicalImage().reset();
        }
        if (this.isValidMaskImageSet()) {
            this.getValidMaskImage().reset();
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "," + ProductData.getTypeString(this.getDataType()) + "," + this.getRasterWidth() + "," + this.getRasterHeight() + "," + this.getSpectralBandIndex() + "," + this.getSpectralWavelength() + "," + this.getSpectralBandwidth() + "," + this.getSolarFlux() + "]";
    }

    @Override
    public void removeFromFile(ProductWriter productWriter) {
        productWriter.removeBand(this);
    }

    @Override
    public ImageInfo createDefaultImageInfo(double[] histoSkipAreas, ProgressMonitor pm) {
        IndexCoding indexCoding = this.getIndexCoding();
        if (indexCoding == null) {
            return super.createDefaultImageInfo(histoSkipAreas, pm);
        }
        int sampleCount = indexCoding.getSampleCount();
        Random random = new Random(-889275714L);
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            String name = indexCoding.getSampleName(i);
            int value = indexCoding.getSampleValue(i);
            Color color = i == 0 ? new Color(0, 0, 0) : Color.getHSBColor((float)(i - 1) / (float)sampleCount, 0.85f, 1.0f);
            points[i] = new ColorPaletteDef.Point(value, color, name);
        }
        return new ImageInfo(new ColorPaletteDef(points, points.length));
    }

    @Override
    protected Stx computeStxImpl(int level, ProgressMonitor pm) {
        IndexCoding indexCoding = this.getIndexCoding();
        if (indexCoding == null) {
            return super.computeStxImpl(level, pm);
        }
        int sampleCount = indexCoding.getSampleCount();
        int minSample = Integer.MAX_VALUE;
        int maxSample = Integer.MIN_VALUE;
        for (int i = 0; i < sampleCount; ++i) {
            int sample = indexCoding.getSampleValue(i);
            minSample = Math.min(minSample, sample);
            maxSample = Math.max(maxSample, sample);
        }
        int binCount = maxSample - minSample + 1;
        double min = minSample;
        double max = maxSample;
        return new StxFactory().withResolutionLevel(level).withHistogramBinCount(binCount).withMinimum(min).withMaximum(max).create(this, pm);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.sampleCoding = null;
    }
}

