/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.FXYGeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.Guardian;

public class CombinedFXYGeoCoding
extends AbstractGeoCoding {
    private CodingWrapper[] _codingWrappers;
    private final Datum _datum;
    private int _lastIndex;

    public CombinedFXYGeoCoding(CodingWrapper[] codingWrappers) {
        Guardian.assertNotNull("codingWrappers", codingWrappers);
        ArrayList<CodingWrapper> wrappers = new ArrayList<CodingWrapper>();
        for (int i = 0; i < codingWrappers.length; ++i) {
            CodingWrapper codingWrapper = codingWrappers[i];
            if (codingWrapper == null) continue;
            wrappers.add(codingWrapper);
        }
        Guardian.assertGreaterThan("number of coding wrappers", wrappers.size(), 0L);
        this._codingWrappers = wrappers.toArray(new CodingWrapper[wrappers.size()]);
        this._datum = this._codingWrappers[0].getGeoGoding().getDatum();
        this._lastIndex = 0;
    }

    public CodingWrapper[] getCodingWrappers() {
        return this._codingWrappers;
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        CodingWrapper[] wrappers = new CodingWrapper[this._codingWrappers.length];
        int ccdCarryover = 0;
        for (int i = 0; i < this._codingWrappers.length; ++i) {
            CodingWrapper wrapper = this._codingWrappers[i];
            Point location = wrapper.getLocation();
            Dimension dimension = wrapper.getDimension();
            FXYGeoCoding sourceGC = wrapper.getGeoGoding();
            float gcPixelOffsetX = sourceGC.getPixelOffsetX();
            float gcPixelOffsetY = sourceGC.getPixelOffsetY();
            float gcPixelSizeX = sourceGC.getPixelSizeX();
            float gcPixelSizeY = sourceGC.getPixelSizeY();
            int gcwPosX = location.x;
            int gcwPosXSrc = 0;
            int gcwPosY = location.y;
            int gcwWidth = dimension.width;
            int gcwWidthSrc = 0;
            int gcwHeight = dimension.height;
            if (subsetDef != null) {
                Rectangle subsetRegion = subsetDef.getRegion() != null ? subsetDef.getRegion() : new Rectangle(0, 0, srcScene.getRasterWidth(), srcScene.getRasterHeight());
                if (!wrapper.intersects(subsetRegion)) {
                    wrappers[i] = null;
                    continue;
                }
                if (gcwPosX < subsetRegion.x) {
                    gcPixelOffsetX += (float)(subsetRegion.x - gcwPosX) * gcPixelSizeX;
                }
                gcPixelOffsetX += (float)ccdCarryover * gcPixelSizeX;
                if (gcwPosY < subsetRegion.y) {
                    gcPixelOffsetY += (float)(subsetRegion.y - gcwPosY) * gcPixelSizeY;
                }
                Rectangle intersection = wrapper.intersection(subsetRegion);
                intersection.x += ccdCarryover;
                intersection.width -= ccdCarryover;
                gcwPosXSrc = intersection.x - subsetRegion.x;
                gcwPosY = intersection.y - subsetRegion.y;
                gcwWidthSrc = intersection.width;
                gcwHeight = intersection.height;
                int subSamplingX = subsetDef.getSubSamplingX();
                int subSamplingY = subsetDef.getSubSamplingY();
                if (subSamplingX != 1) {
                    ccdCarryover = subSamplingX - gcwWidthSrc % subSamplingX;
                }
                gcPixelSizeX *= (float)subSamplingX;
                gcPixelSizeY *= (float)subSamplingY;
                gcwPosX = gcwPosXSrc / subSamplingX;
                gcwPosY /= subSamplingY;
                gcwWidth = (gcwWidthSrc - 1) / subSamplingX + 1;
                gcwHeight = (gcwHeight - 1) / subSamplingY + 1;
            }
            FXYGeoCoding gc = sourceGC.createCloneWithNewOffsetAndSize(gcPixelOffsetX, gcPixelOffsetY, gcPixelSizeX, gcPixelSizeY);
            wrappers[i] = new CodingWrapper(gc, gcwPosX, gcwPosY, gcwWidth, gcwHeight);
        }
        destScene.setGeoCoding(new CombinedFXYGeoCoding(wrappers));
        return true;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        for (int i = 0; i < this._codingWrappers.length; ++i) {
            CodingWrapper codingWrapper = this._codingWrappers[i];
            if (!codingWrapper.getGeoGoding().isCrossingMeridianAt180()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canGetPixelPos() {
        return true;
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        CombinedFXYGeoCoding combinedFXYGeoCoding = this;
        synchronized (combinedFXYGeoCoding) {
            int index = this._lastIndex;
            do {
                CodingWrapper wrapper;
                if ((wrapper = this._codingWrappers[index]).contains(pixelPos = wrapper.getPixelPos(geoPos, pixelPos))) {
                    this._lastIndex = index;
                    break;
                }
                if (++index != this._codingWrappers.length) continue;
                index = 0;
            } while (index != this._lastIndex);
            return pixelPos;
        }
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        for (int i = 0; i < this._codingWrappers.length; ++i) {
            CodingWrapper codingWrapper = this._codingWrappers[i];
            if (!codingWrapper.contains(pixelPos)) continue;
            return codingWrapper.getGeoPos(pixelPos, geoPos);
        }
        if (geoPos == null) {
            geoPos = new GeoPos(0.0f, 0.0f);
        }
        return geoPos;
    }

    @Override
    public Datum getDatum() {
        return this._datum;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this._codingWrappers.length; ++i) {
            this._codingWrappers[i].dispose();
            this._codingWrappers[i] = null;
        }
        this._codingWrappers = null;
    }

    public static class CodingWrapper {
        private FXYGeoCoding _geoGoding;
        private Rectangle _region;
        private Point _location;
        private Dimension _dimension;

        public CodingWrapper(FXYGeoCoding geoCoding, int x, int y, int width, int height) {
            this._geoGoding = geoCoding;
            this._location = new Point(x, y);
            this._dimension = new Dimension(width, height);
            this._region = new Rectangle(this._location, this._dimension);
        }

        public FXYGeoCoding getGeoGoding() {
            return this._geoGoding;
        }

        private Point getLocation() {
            return this._location;
        }

        private Dimension getDimension() {
            return this._dimension;
        }

        public Rectangle getRegion() {
            return this._region;
        }

        private boolean contains(PixelPos pixelPos) {
            return this._region.contains(pixelPos);
        }

        private void dispose() {
            this._geoGoding.dispose();
            this._geoGoding = null;
            this._region = null;
            this._dimension = null;
            this._location = null;
        }

        private PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
            PixelPos pos = this._geoGoding.getPixelPos(geoPos, pixelPos);
            pos.x += (float)this._location.x;
            pos.y += (float)this._location.y;
            return pos;
        }

        private GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
            PixelPos localPixelPos = new PixelPos();
            localPixelPos.setLocation(pixelPos.getX() - (double)this._location.x, pixelPos.getY() - (double)this._location.y);
            return this._geoGoding.getGeoPos(localPixelPos, geoPos);
        }

        public boolean intersects(Rectangle rectangle) {
            return this._region.intersects(rectangle);
        }

        public Rectangle intersection(Rectangle rectangle) {
            return this._region.intersection(rectangle);
        }
    }
}

