/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.GeoApproximation;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.util.math.SinusoidalDistance;

class DefaultPixelFinder {
    private static final int MAX_SEARCH_CYCLE_COUNT = 30;
    private final PlanarImage lonImage;
    private final PlanarImage latImage;
    private final PlanarImage maskImage;
    private final double pixelDiagonalSquared;
    private final int imageW;
    private final int imageH;

    DefaultPixelFinder(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double pixelDiagonalSquared) {
        this.lonImage = lonImage;
        this.latImage = latImage;
        this.maskImage = maskImage;
        this.pixelDiagonalSquared = pixelDiagonalSquared;
        this.imageW = lonImage.getWidth();
        this.imageH = lonImage.getHeight();
    }

    void findPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        int searchRadius = 60;
        int x0 = (int)Math.floor(pixelPos.x);
        int y0 = (int)Math.floor(pixelPos.y);
        if (x0 + 60 >= 0 && x0 - 60 < this.imageW && y0 + 60 >= 0 && y0 - 60 < this.imageH) {
            double minDistance;
            if (x0 < 0) {
                x0 = 0;
            } else if (x0 >= this.imageW) {
                x0 = this.imageW - 1;
            }
            if (y0 < 0) {
                y0 = 0;
            } else if (y0 >= this.imageH) {
                y0 = this.imageH - 1;
            }
            int x1 = Math.max(x0 - 60, 0);
            int y1 = Math.max(y0 - 60, 0);
            int x2 = Math.min(x0 + 60, this.imageW - 1);
            int y2 = Math.min(y0 + 60, this.imageH - 1);
            int rasterMinX = x1;
            int rasterMinY = y1;
            int rasterMaxX = x2;
            int rasterMaxY = y2;
            double lon0 = GeoApproximation.normalizeLon(geoPos.lon);
            double lat0 = geoPos.lat;
            SinusoidalDistance dc = new SinusoidalDistance(lon0, lat0);
            if (this.maskImage == null || DefaultPixelFinder.getSample(x0, y0, this.maskImage) != 0) {
                double lon = GeoApproximation.normalizeLon(DefaultPixelFinder.getSampleDouble(x0, y0, this.lonImage));
                double lat = DefaultPixelFinder.getSampleDouble(x0, y0, this.latImage);
                minDistance = dc.distance(lon, lat);
            } else {
                minDistance = Double.POSITIVE_INFINITY;
            }
            for (int i = 0; i < 30; ++i) {
                x1 = x0;
                y1 = y0;
                int minX = Math.max(x1 - 2, rasterMinX);
                int minY = Math.max(y1 - 2, rasterMinY);
                int maxX = Math.min(x1 + 2, rasterMaxX);
                int maxY = Math.min(y1 + 2, rasterMaxY);
                if (this.maskImage != null) {
                    while (minX > rasterMinX && DefaultPixelFinder.getSample(minX, y1, this.maskImage) == 0) {
                        if (minX <= rasterMinX) continue;
                        --minX;
                    }
                    while (maxX < rasterMaxX && DefaultPixelFinder.getSample(maxX, y1, this.maskImage) == 0) {
                        if (maxX >= rasterMaxX) continue;
                        ++maxX;
                    }
                }
                for (int y = minY; y <= maxY; ++y) {
                    for (int x = minX; x <= maxX; ++x) {
                        double lat;
                        double lon;
                        double d;
                        if (y == y0 && x == x0 || this.maskImage != null && DefaultPixelFinder.getSample(x, y, this.maskImage) == 0 || !((d = dc.distance(lon = GeoApproximation.normalizeLon(DefaultPixelFinder.getSampleDouble(x, y, this.lonImage)), lat = DefaultPixelFinder.getSampleDouble(x, y, this.latImage))) < minDistance)) continue;
                        x1 = x;
                        y1 = y;
                        minDistance = d;
                    }
                }
                if (x1 == x0 && y1 == y0) break;
                x0 = x1;
                y0 = y1;
            }
            if (minDistance < this.pixelDiagonalSquared) {
                pixelPos.setLocation((float)x0 + 0.5f, (float)y0 + 0.5f);
            } else {
                pixelPos.setInvalid();
            }
        } else {
            pixelPos.setInvalid();
        }
    }

    private static double getSampleDouble(int pixelX, int pixelY, PlanarImage image) {
        int x = image.getMinX() + pixelX;
        int y = image.getMinY() + pixelY;
        int tileX = image.XToTileX(x);
        int tileY = image.YToTileY(y);
        Raster data = image.getTile(tileX, tileY);
        return data.getSampleDouble(x, y, 0);
    }

    private static int getSample(int pixelX, int pixelY, PlanarImage image) {
        int x = image.getMinX() + pixelX;
        int y = image.getMinY() + pixelY;
        int tileX = image.XToTileX(x);
        int tileY = image.YToTileY(y);
        Raster data = image.getTile(tileX, tileY);
        return data.getSample(x, y, 0);
    }
}

