/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Rectangle;
import org.esa.beam.framework.datamodel.Stepping;
import org.esa.beam.framework.datamodel.SteppingFactory;

class DefaultSteppingFactory
implements SteppingFactory {
    DefaultSteppingFactory() {
    }

    @Override
    public Stepping createStepping(Rectangle rectangle, int maxPointCount) {
        int sw = rectangle.width;
        int sh = rectangle.height;
        int minX = rectangle.x;
        int minY = rectangle.y;
        int maxX = minX + sw - 1;
        int maxY = minY + sh - 1;
        int pointCountX = sw;
        int pointCountY = sh;
        int stepX = 1;
        int stepY = 1;
        boolean adjustStepX = true;
        while (pointCountX * pointCountY > maxPointCount) {
            if (adjustStepX) {
                pointCountX = sw / ++stepX + 1;
            } else {
                pointCountY = sh / ++stepY + 1;
            }
            adjustStepX = !adjustStepX;
        }
        pointCountX = Math.max(1, pointCountX);
        pointCountY = Math.max(1, pointCountY);
        if (sw % stepX != 0) {
            ++pointCountX;
        }
        if (sh % stepY != 0) {
            ++pointCountY;
        }
        return new Stepping(minX, minY, maxX, maxY, pointCountX, pointCountY, stepX, stepY);
    }
}

