/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.concurrent.CancellationException;
import javax.media.jai.PixelAccessor;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.operator.MinDescriptor;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.math.MathUtils;

public class DensityPlot {
    public static void accumulate(RasterDataNode raster1, double sampleMin1, double sampleMax1, RasterDataNode raster2, double sampleMin2, double sampleMax2, Mask roiMask, int width, int height, byte[] pixelValues, ProgressMonitor pm) {
        Assert.notNull((Object)raster1, (String)"raster1");
        Assert.notNull((Object)raster2, (String)"raster2");
        Assert.notNull((Object)pm, (String)"pm");
        DensityPlotOp densityPlotOp = new DensityPlotOp(sampleMin1, sampleMax1, sampleMin2, sampleMax2, width, height);
        Shape maskShape = null;
        MultiLevelImage maskImage = null;
        if (roiMask != null) {
            maskShape = roiMask.getValidShape();
            maskImage = roiMask.getSourceImage();
        }
        densityPlotOp.accumulate(raster1, raster2, (RenderedImage)maskImage, maskShape, pixelValues, pm);
    }

    private static class DensityPlotOp {
        private final double sampleMin1;
        private final double sampleMax1;
        private final double sampleMin2;
        private final double sampleMax2;
        private final int width;
        private final int height;
        private final double xScale;
        private final double yScale;

        public DensityPlotOp(double sampleMin1, double sampleMax1, double sampleMin2, double sampleMax2, int width, int height) {
            this.sampleMin1 = sampleMin1;
            this.sampleMax1 = sampleMax1;
            this.sampleMin2 = sampleMin2;
            this.sampleMax2 = sampleMax2;
            this.width = width;
            this.height = height;
            this.xScale = (double)width / (sampleMax1 - sampleMin1);
            this.yScale = (double)height / (sampleMax2 - sampleMin2);
        }

        private static void checkSampleModelForOneBand(SampleModel sampleModel) {
            if (sampleModel.getNumBands() != 1) {
                throw new IllegalStateException("sampleModel.numBands != 1");
            }
        }

        private static void checkSampleModelForTypeByte(SampleModel sampleModel) {
            if (sampleModel.getDataType() != 0) {
                throw new IllegalStateException("sampleModel.dataType != TYPE_BYTE");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accumulate(RasterDataNode raster1, RasterDataNode raster2, RenderedImage roiImage, Shape roiShape, byte[] pixelValues, ProgressMonitor pm) {
            PixelAccessor maskAccessor;
            Area area;
            MultiLevelImage dataImage = raster1.getGeophysicalImage();
            Object dataImage1 = raster1.getGeophysicalImage();
            Object dataImage2 = raster2.getGeophysicalImage();
            SampleModel dataSampleModel1 = dataImage1.getSampleModel();
            DensityPlotOp.checkSampleModelForOneBand(dataSampleModel1);
            SampleModel dataSampleModel2 = dataImage2.getSampleModel();
            DensityPlotOp.checkSampleModelForOneBand(dataSampleModel2);
            int dataType1 = dataSampleModel1.getDataType();
            int dataType2 = dataSampleModel2.getDataType();
            int maxDataType = Math.max(dataType1, dataType2);
            if (dataType1 != maxDataType) {
                dataImage1 = ImageManager.createFormatOp((RenderedImage)dataImage1, maxDataType);
            }
            if (dataType2 != maxDataType) {
                dataImage2 = ImageManager.createFormatOp((RenderedImage)dataImage2, maxDataType);
            }
            PixelAccessor dataAccessor1 = new PixelAccessor(dataImage1.getSampleModel(), null);
            PixelAccessor dataAccessor2 = new PixelAccessor(dataImage2.getSampleModel(), null);
            Object maskImage = raster1.getValidMaskImage();
            MultiLevelImage maskImage2 = raster2.getValidMaskImage();
            if (maskImage != null) {
                if (maskImage2 != null && maskImage != maskImage2) {
                    maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)maskImage2, null);
                }
                if (roiImage != null) {
                    maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)roiImage, null);
                }
            } else {
                if (maskImage2 != null) {
                    maskImage = maskImage2;
                }
                if (maskImage != null) {
                    if (roiImage != null) {
                        maskImage = MinDescriptor.create((RenderedImage)maskImage, (RenderedImage)roiImage, null);
                    }
                } else if (roiImage != null) {
                    maskImage = roiImage;
                }
            }
            Shape validShape1 = raster1.getValidShape();
            Shape validShape2 = raster2.getValidShape();
            Shape effectiveShape = validShape1;
            if (validShape1 != null && validShape2 != null) {
                area = new Area(validShape1);
                area.intersect(new Area(validShape2));
                effectiveShape = area;
            } else if (validShape2 != null) {
                effectiveShape = validShape2;
            }
            if (effectiveShape != null && roiShape != null) {
                area = new Area(effectiveShape);
                area.intersect(new Area(roiShape));
                effectiveShape = area;
            } else if (roiShape != null) {
                effectiveShape = roiShape;
            }
            if (maskImage != null) {
                SampleModel maskSampleModel = maskImage.getSampleModel();
                DensityPlotOp.checkSampleModelForOneBand(maskSampleModel);
                DensityPlotOp.checkSampleModelForTypeByte(maskSampleModel);
                maskAccessor = new PixelAccessor(maskSampleModel, null);
            } else {
                maskAccessor = null;
            }
            int numXTiles = dataImage1.getNumXTiles();
            int numYTiles = dataImage1.getNumYTiles();
            int tileX1 = dataImage1.getTileGridXOffset();
            int tileY1 = dataImage1.getTileGridYOffset();
            int tileX2 = tileX1 + numXTiles - 1;
            int tileY2 = tileY1 + numYTiles - 1;
            Rectangle imageRect = new Rectangle(dataImage1.getMinX(), dataImage1.getMinY(), dataImage1.getWidth(), dataImage1.getHeight());
            try {
                pm.beginTask("Computing densityplot", numXTiles * numYTiles);
                for (int tileY = tileY1; tileY <= tileY2; ++tileY) {
                    for (int tileX = tileX1; tileX <= tileX2; ++tileX) {
                        Rectangle dataRect;
                        if (pm.isCanceled()) {
                            throw new CancellationException("Process terminated by user.");
                        }
                        boolean tileContainsData = true;
                        if (effectiveShape != null && !effectiveShape.intersects(dataRect = dataImage.getTileRect(tileX, tileY))) {
                            tileContainsData = false;
                        }
                        if (!tileContainsData) continue;
                        Raster dataTile1 = dataImage1.getTile(tileX, tileY);
                        Raster dataTile2 = dataImage2.getTile(tileX, tileY);
                        Raster maskTile = maskImage != null ? maskImage.getTile(tileX, tileY) : null;
                        Rectangle r = imageRect.intersection(dataTile1.getBounds());
                        switch (dataAccessor1.sampleType) {
                            case -1: 
                            case 0: {
                                this.accumulateDataUByte(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                                break;
                            }
                            case 1: {
                                this.accumulateDataUShort(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                                break;
                            }
                            case 2: {
                                this.accumulateDataShort(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                                break;
                            }
                            case 3: {
                                this.accumulateDataInt(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                                break;
                            }
                            case 4: {
                                this.accumulateDataFloat(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                                break;
                            }
                            case 5: {
                                this.accumulateDataDouble(dataTile1, dataAccessor1, dataTile2, dataAccessor2, maskTile, maskAccessor, r, pixelValues);
                            }
                        }
                        pm.worked(1);
                    }
                }
            }
            finally {
                pm.done();
            }
        }

        private void accumulateDataUByte(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 0, false);
            byte[] data1 = duid1.getByteData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 0, false);
            byte[] data2 = duid2.getByteData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset1 = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset1] != 0) && (sample1 = (double)(data1[dataPixelOffset1] & 0xFF)) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = (double)(data2[dataPixelOffset2] & 0xFF)) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset1 += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }

        private void accumulateDataUShort(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 1, false);
            short[] data1 = duid1.getShortData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 1, false);
            short[] data2 = duid2.getShortData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset] != 0) && (sample1 = (double)(data1[dataPixelOffset1] & 0xFFFF)) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = (double)(data2[dataPixelOffset2] & 0xFFFF)) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }

        private void accumulateDataShort(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 2, false);
            short[] data1 = duid1.getShortData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 2, false);
            short[] data2 = duid2.getShortData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset] != 0) && (sample1 = (double)data1[dataPixelOffset1]) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = (double)data2[dataPixelOffset2]) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }

        private void accumulateDataInt(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 3, false);
            int[] data1 = duid1.getIntData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 3, false);
            int[] data2 = duid2.getIntData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset] != 0) && (sample1 = (double)data1[dataPixelOffset1]) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = (double)data2[dataPixelOffset2]) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }

        private void accumulateDataFloat(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 4, false);
            float[] data1 = duid1.getFloatData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 4, false);
            float[] data2 = duid2.getFloatData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset] != 0) && (sample1 = (double)data1[dataPixelOffset1]) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = (double)data2[dataPixelOffset2]) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }

        private void accumulateDataDouble(Raster dataTile1, PixelAccessor dataAccessor1, Raster dataTile2, PixelAccessor dataAccessor2, Raster maskTile, PixelAccessor maskAccessor, Rectangle r, byte[] pixelValues) {
            UnpackedImageData duid1 = dataAccessor1.getPixels(dataTile1, r, 5, false);
            double[] data1 = duid1.getDoubleData(0);
            int dataPixelStride1 = duid1.pixelStride;
            int dataLineStride1 = duid1.lineStride;
            int dataBandOffset1 = duid1.bandOffsets[0];
            UnpackedImageData duid2 = dataAccessor2.getPixels(dataTile2, r, 5, false);
            double[] data2 = duid2.getDoubleData(0);
            int dataPixelStride2 = duid2.pixelStride;
            int dataLineStride2 = duid2.lineStride;
            int dataBandOffset2 = duid2.bandOffsets[0];
            byte[] mask = null;
            int maskPixelStride = 0;
            int maskLineStride = 0;
            int maskBandOffset = 0;
            if (maskTile != null) {
                UnpackedImageData muid = maskAccessor.getPixels(maskTile, r, 0, false);
                mask = muid.getByteData(0);
                maskPixelStride = muid.pixelStride;
                maskLineStride = muid.lineStride;
                maskBandOffset = muid.bandOffsets[0];
            }
            int dataLineOffset1 = dataBandOffset1;
            int dataLineOffset2 = dataBandOffset2;
            int maskLineOffset = maskBandOffset;
            for (int y = 0; y < r.height; ++y) {
                int dataPixelOffset1 = dataLineOffset1;
                int dataPixelOffset2 = dataLineOffset2;
                int maskPixelOffset = maskLineOffset;
                for (int x = 0; x < r.width; ++x) {
                    double sample2;
                    double sample1;
                    if ((mask == null || mask[maskPixelOffset] != 0) && (sample1 = data1[dataPixelOffset1]) >= this.sampleMin1 && sample1 <= this.sampleMax1 && (sample2 = data2[dataPixelOffset2]) >= this.sampleMin2 && sample2 <= this.sampleMax2) {
                        int pixelX = MathUtils.floorInt(this.xScale * (sample1 - this.sampleMin1));
                        int pixelY = this.height - 1 - MathUtils.floorInt(this.yScale * (sample2 - this.sampleMin2));
                        if (pixelX >= 0 && pixelX < this.width && pixelY >= 0 && pixelY < this.height) {
                            int pixelIndex = pixelX + pixelY * this.width;
                            int pixelValue = pixelValues[pixelIndex] & 0xFF;
                            if (++pixelValue > 255) {
                                pixelValue = 255;
                            }
                            pixelValues[pixelIndex] = (byte)pixelValue;
                        }
                    }
                    dataPixelOffset1 += dataPixelStride1;
                    dataPixelOffset2 += dataPixelStride2;
                    maskPixelOffset += maskPixelStride;
                }
                dataLineOffset1 += dataLineStride1;
                dataLineOffset2 += dataLineStride2;
                maskLineOffset += maskLineStride;
            }
        }
    }
}

