/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public class FlagCoding
extends SampleCoding {
    public FlagCoding(String name) {
        super(name);
    }

    public MetadataAttribute getFlag(String name) {
        return this.getAttribute(name);
    }

    public String[] getFlagNames() {
        return this.getAttributeNames();
    }

    public MetadataAttribute addFlag(String name, int flagMask, String description) {
        return this.addSamples(name, new int[]{flagMask}, description);
    }

    public MetadataAttribute addFlag(String name, int flagMask, int flagValue, String description) {
        return this.addSamples(name, new int[]{flagMask, flagValue}, description);
    }

    public int getFlagMask(String name) {
        Guardian.assertNotNull("name", name);
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException("flag '" + name + "' not found");
        }
        Debug.assertTrue(attribute.getData().isInt());
        Debug.assertTrue(attribute.getData().getNumElems() == 1 || attribute.getData().getNumElems() == 2);
        return attribute.getData().getElemInt();
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }
}

