/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.jexp.ParseException;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BasicPixelGeoCoding;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.PixelGeoCoding;
import org.esa.beam.framework.datamodel.PixelGeoCoding2;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.util.ProductUtils;

public class GeoCodingFactory {
    public static final String USE_ALTERNATE_PIXEL_GEO_CODING_PROPERTY = "snap.useAlternatePixelGeoCoding";

    public static BasicPixelGeoCoding createPixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius) {
        if ("true".equals(System.getProperty(USE_ALTERNATE_PIXEL_GEO_CODING_PROPERTY))) {
            return new PixelGeoCoding(latBand, lonBand, validMask, searchRadius);
        }
        return new PixelGeoCoding2(latBand, lonBand, validMask);
    }

    public static BasicPixelGeoCoding createPixelGeoCoding(Band latBand, Band lonBand, String validMask, int searchRadius, ProgressMonitor pm) throws IOException {
        if ("true".equals(System.getProperty(USE_ALTERNATE_PIXEL_GEO_CODING_PROPERTY))) {
            return new PixelGeoCoding(latBand, lonBand, validMask, searchRadius, pm);
        }
        return new PixelGeoCoding2(latBand, lonBand, validMask);
    }

    static void copyReferencedRasters(String validMaskExpression, Scene sourceScene, Scene targetScene, ProductSubsetDef subsetDef) throws ParseException {
        RasterDataNode[] nodes;
        Product targetProduct = targetScene.getProduct();
        for (RasterDataNode node : nodes = BandArithmetic.getRefRasters(validMaskExpression, sourceScene.getProduct())) {
            if (targetProduct.containsRasterDataNode(node.getName())) continue;
            if (node instanceof TiePointGrid) {
                TiePointGrid tpg = TiePointGrid.createSubset((TiePointGrid)node, subsetDef);
                targetProduct.addTiePointGrid(tpg);
            }
            if (!(node instanceof Band)) continue;
            Band sourceBand = (Band)node;
            Band band = GeoCodingFactory.createSubset(sourceBand, targetScene, subsetDef);
            targetProduct.addBand(band);
            GeoCodingFactory.setFlagCoding(band, sourceBand.getFlagCoding());
        }
    }

    static Band createSubset(Band sourceBand, Scene targetScene, ProductSubsetDef subsetDef) {
        Band targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), targetScene.getRasterWidth(), targetScene.getRasterHeight());
        ProductUtils.copyRasterDataNodeProperties(sourceBand, targetBand);
        targetBand.setSourceImage(GeoCodingFactory.getSourceImage(subsetDef, sourceBand));
        return targetBand;
    }

    static Mask createSubset(Mask sourceMask, Scene targetScene, ProductSubsetDef subsetDef) {
        Mask targetMask = Mask.BandMathsType.create(sourceMask.getName(), sourceMask.getDescription(), targetScene.getRasterWidth(), targetScene.getRasterHeight(), Mask.BandMathsType.getExpression(sourceMask), sourceMask.getImageColor(), sourceMask.getImageTransparency());
        targetMask.setSourceImage(GeoCodingFactory.getSourceImage(subsetDef, sourceMask));
        return targetMask;
    }

    private static void setFlagCoding(Band band, FlagCoding flagCoding) {
        if (flagCoding != null) {
            String flagCodingName = flagCoding.getName();
            Product product = band.getProduct();
            if (!product.getFlagCodingGroup().contains(flagCodingName)) {
                GeoCodingFactory.addFlagCoding(product, flagCoding);
            }
            band.setSampleCoding(product.getFlagCodingGroup().get(flagCodingName));
        }
    }

    private static void addFlagCoding(Product product, FlagCoding flagCoding) {
        FlagCoding targetFlagCoding = new FlagCoding(flagCoding.getName());
        targetFlagCoding.setDescription(flagCoding.getDescription());
        ProductUtils.copyMetadata(flagCoding, targetFlagCoding);
        product.getFlagCodingGroup().add(targetFlagCoding);
    }

    private static RenderedImage getSourceImage(ProductSubsetDef subsetDef, Band band) {
        MultiLevelImage sourceImage = band.getSourceImage();
        if (subsetDef != null) {
            int subSamplingY;
            int subSamplingX;
            Rectangle region = subsetDef.getRegion();
            if (region != null) {
                float x = region.x;
                float y = region.y;
                float width = region.width;
                float height = region.height;
                sourceImage = CropDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(x), (Float)Float.valueOf(y), (Float)Float.valueOf(width), (Float)Float.valueOf(height), null);
            }
            if (GeoCodingFactory.mustSubSample(subSamplingX = subsetDef.getSubSamplingX(), subSamplingY = subsetDef.getSubSamplingY()) || GeoCodingFactory.mustTranslate(region)) {
                float scaleX = 1.0f / (float)subSamplingX;
                float scaleY = 1.0f / (float)subSamplingY;
                float transX = region != null ? (float)(-region.x) : 0.0f;
                float transY = region != null ? (float)(-region.y) : 0.0f;
                Interpolation interpolation = Interpolation.getInstance((int)0);
                sourceImage = ScaleDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(scaleX), (Float)Float.valueOf(scaleY), (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), (Interpolation)interpolation, null);
            }
        }
        return sourceImage;
    }

    private static boolean mustTranslate(Rectangle region) {
        return region != null && (region.x != 0 || region.y != 0);
    }

    private static boolean mustSubSample(int subSamplingX, int subSamplingY) {
        return subSamplingX != 1 || subSamplingY != 1;
    }
}

