/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import org.esa.beam.util.math.MathUtils;

public class GeoPos {
    private static final float _MIN_PER_DEG = 60.0f;
    private static final float _SEC_PER_DEG = 3600.0f;
    public float lat;
    public float lon;

    public GeoPos() {
    }

    public GeoPos(GeoPos geoPos) {
        this(geoPos.lat, geoPos.lon);
    }

    public GeoPos(float lat, float lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public void setLocation(float lat, float lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public final boolean isValid() {
        return GeoPos.isLatValid(this.lat) && GeoPos.isLonValid(this.lon);
    }

    public static boolean areValid(GeoPos[] gepPositions) {
        for (GeoPos geoPos : gepPositions) {
            if (geoPos.isValid()) continue;
            return false;
        }
        return true;
    }

    public final void setInvalid() {
        this.lat = Float.NaN;
        this.lon = Float.NaN;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof GeoPos)) {
            return false;
        }
        GeoPos other = (GeoPos)obj;
        return other.lat == this.lat && other.lon == this.lon;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.lat) + Float.floatToIntBits(this.lon);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getLatString() + "," + this.getLonString() + "]";
    }

    public void normalize() {
        this.lon = GeoPos.normalizeLon(this.lon);
    }

    public static float normalizeLon(float lon) {
        if (lon < -360.0f || lon > 360.0f) {
            lon %= 360.0f;
        }
        if (lon < -180.0f) {
            lon += 360.0f;
        } else if (lon > 180.0f) {
            lon -= 360.0f;
        }
        return lon;
    }

    public String getLatString() {
        return GeoPos.getLatString(this.lat);
    }

    public String getLonString() {
        return GeoPos.getLonString(this.lon);
    }

    public static String getLatString(float lat) {
        if (GeoPos.isLatValid(lat)) {
            return GeoPos.getDegreeString(lat, false);
        }
        return "Inv N";
    }

    public static String getLonString(float lon) {
        if (GeoPos.isLonValid(lon)) {
            return GeoPos.getDegreeString(lon, true);
        }
        return "Inv E";
    }

    private static String getDegreeString(float value, boolean longitudial) {
        int sign = value == 0.0f ? 0 : (value < 0.0f ? -1 : 1);
        float rest = Math.abs(value);
        int degree = MathUtils.floorInt(rest);
        int minutes = MathUtils.floorInt(60.0f * (rest -= (float)degree));
        int seconds = Math.round(3600.0f * (rest -= (float)minutes / 60.0f));
        rest -= (float)seconds / 3600.0f;
        if (seconds == 60) {
            seconds = 0;
            if (++minutes == 60) {
                minutes = 0;
                ++degree;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(degree);
        sb.append("\u00b0");
        if (minutes != 0 || seconds != 0) {
            if (minutes < 10) {
                sb.append('0');
            }
            sb.append(minutes);
            sb.append('\'');
            if (seconds != 0) {
                if (seconds < 10) {
                    sb.append('0');
                }
                sb.append(seconds);
                sb.append('\"');
            }
        }
        if (sign == -1) {
            sb.append(' ');
            if (longitudial) {
                sb.append('W');
            } else {
                sb.append('S');
            }
        } else if (sign == 1) {
            sb.append(' ');
            if (longitudial) {
                sb.append('E');
            } else {
                sb.append('N');
            }
        }
        return sb.toString();
    }

    private static boolean isLatValid(float lat) {
        return lat >= -90.0f && lat <= 90.0f;
    }

    private static boolean isLonValid(float lon) {
        return !Float.isNaN(lon) && !Float.isInfinite(lon);
    }
}

