/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.jexp.ParseException;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.AbstractGeoCoding;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BasicPixelGeoCoding;
import org.esa.beam.framework.datamodel.DefaultPixelFinder;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoCodingFactory;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.PixelPosEstimator;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.SimplePixelDimensionEstimator;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.math.MathUtils;

class PixelGeoCoding2
extends AbstractGeoCoding
implements BasicPixelGeoCoding {
    private static final String SYSPROP_PIXEL_GEO_CODING_FRACTION_ACCURACY = "snap.pixelGeoCoding.fractionAccuracy";
    private static final String SYSPROP_PIXEL_GEO_CODING_USE_TILING = "snap.pixelGeoCoding.useTiling";
    private final Band latBand;
    private final Band lonBand;
    private final String maskExpression;
    private final int rasterW;
    private final int rasterH;
    private final boolean fractionAccuracy = Boolean.getBoolean("snap.pixelGeoCoding.fractionAccuracy");
    private final DataProvider dataProvider;
    private final GeoCoding formerGeocoding;
    private transient PixelPosEstimator pixelPosEstimator;
    private transient DefaultPixelFinder pixelFinder;

    public PixelGeoCoding2(Band latBand, Band lonBand, String maskExpression) {
        MultiLevelImage latImage;
        MultiLevelImage lonImage;
        Guardian.assertNotNull("latBand", latBand);
        Guardian.assertNotNull("lonBand", lonBand);
        Product product = latBand.getProduct();
        if (product == null) {
            throw new IllegalArgumentException("latBand.getProduct() == null");
        }
        if (lonBand.getProduct() == null) {
            throw new IllegalArgumentException("lonBand.getProduct() == null");
        }
        if (product != lonBand.getProduct()) {
            throw new IllegalArgumentException("latBand.getProduct() != lonBand.getProduct()");
        }
        if (product.getSceneRasterWidth() < 2 || product.getSceneRasterHeight() < 2) {
            throw new IllegalArgumentException("latBand.getProduct().getSceneRasterWidth() < 2 || latBand.getProduct().getSceneRasterHeight() < 2");
        }
        this.latBand = latBand;
        this.lonBand = lonBand;
        this.formerGeocoding = product.getGeoCoding();
        this.rasterW = latBand.getSceneRasterWidth();
        this.rasterH = latBand.getSceneRasterHeight();
        try {
            lonImage = (PlanarImage)lonBand.getGeophysicalImage().getImage(0);
        }
        catch (ClassCastException e) {
            lonImage = lonBand.getGeophysicalImage();
        }
        try {
            latImage = (PlanarImage)latBand.getGeophysicalImage().getImage(0);
        }
        catch (ClassCastException e) {
            latImage = latBand.getGeophysicalImage();
        }
        PlanarImage maskImage = null;
        if (maskExpression != null) {
            if ((maskExpression = maskExpression.trim()).length() > 0) {
                ProductNodeGroup<Mask> maskGroup = product.getMaskGroup();
                for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
                    Mask mask = maskGroup.get(i);
                    if (mask.getImageType() != Mask.BandMathsType.INSTANCE || !maskExpression.equals(Mask.BandMathsType.getExpression(mask))) continue;
                    maskImage = mask.getSourceImage();
                    break;
                }
                if (maskImage == null) {
                    maskImage = (PlanarImage)ImageManager.getInstance().getMaskImage(maskExpression, lonBand.getProduct()).getImage(0);
                }
            } else {
                maskExpression = null;
                maskImage = null;
            }
        } else {
            maskExpression = null;
            maskImage = null;
        }
        this.maskExpression = maskExpression;
        SimplePixelDimensionEstimator pixelDimensionEstimator = new SimplePixelDimensionEstimator();
        Dimension2D pixelDimension = pixelDimensionEstimator.getPixelDimension((PlanarImage)lonImage, (PlanarImage)latImage, maskImage);
        double pixelSizeX = pixelDimension.getWidth();
        double pixelSizeY = pixelDimension.getHeight();
        double pixelDiagonalSquared = pixelSizeX * pixelSizeX + pixelSizeY * pixelSizeY;
        this.pixelPosEstimator = new PixelPosEstimator((PlanarImage)lonImage, (PlanarImage)latImage, maskImage, 0.5);
        this.pixelFinder = new DefaultPixelFinder((PlanarImage)lonImage, (PlanarImage)latImage, maskImage, pixelDiagonalSquared);
        boolean disableTiling = "false".equalsIgnoreCase(System.getProperty(SYSPROP_PIXEL_GEO_CODING_USE_TILING));
        this.dataProvider = disableTiling ? new ArrayDataProvider(lonBand, latBand, maskImage) : new ImageDataProvider((RenderedImage)lonImage, (RenderedImage)maskImage, (RenderedImage)latImage, (RenderedImage)maskImage);
    }

    @Override
    public Band getLatBand() {
        return this.latBand;
    }

    @Override
    public Band getLonBand() {
        return this.lonBand;
    }

    @Override
    public String getValidMask() {
        return this.maskExpression;
    }

    @Override
    public GeoCoding getPixelPosEstimator() {
        return this.formerGeocoding;
    }

    @Override
    public int getSearchRadius() {
        return 0;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return false;
    }

    @Override
    public boolean canGetPixelPos() {
        return this.pixelPosEstimator.canGetPixelPos();
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        if (geoPos.isValid()) {
            this.pixelPosEstimator.getPixelPos(geoPos, pixelPos);
            if (pixelPos.isValid()) {
                this.pixelFinder.findPixelPos(geoPos, pixelPos);
            }
        } else {
            pixelPos.setInvalid();
        }
        return pixelPos;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        if (pixelPos.isValid() && this.pixelPosIsInsideRasterWH(pixelPos)) {
            int x0 = (int)Math.floor(pixelPos.getX());
            int y0 = (int)Math.floor(pixelPos.getY());
            if (this.fractionAccuracy) {
                if (x0 > 0 && pixelPos.x - (float)x0 < 0.5f || x0 == this.rasterW - 1) {
                    --x0;
                }
                if (y0 > 0 && pixelPos.y - (float)y0 < 0.5f || y0 == this.rasterH - 1) {
                    --y0;
                }
                float wx = pixelPos.x - ((float)x0 + 0.5f);
                float wy = pixelPos.y - ((float)y0 + 0.5f);
                this.dataProvider.getGeoPosFloat(x0, y0, wx, wy, geoPos);
            } else {
                this.dataProvider.getGeoPosInteger(x0, y0, geoPos);
            }
            if (!geoPos.isValid()) {
                if (this.formerGeocoding != null && this.formerGeocoding.canGetGeoPos()) {
                    this.formerGeocoding.getGeoPos(pixelPos, geoPos);
                } else {
                    this.pixelPosEstimator.getGeoPos(pixelPos, geoPos);
                }
            }
        }
        return geoPos;
    }

    private boolean pixelPosIsInsideRasterWH(PixelPos pixelPos) {
        float x = pixelPos.x;
        float y = pixelPos.y;
        return x >= 0.0f && x < (float)this.rasterW && y >= 0.0f && y < (float)this.rasterH;
    }

    public int getRasterWidth() {
        return this.rasterW;
    }

    public int getRasterHeight() {
        return this.rasterH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PixelGeoCoding2 that = (PixelGeoCoding2)o;
        if (!this.latBand.equals(that.latBand)) {
            return false;
        }
        if (!this.lonBand.equals(that.lonBand)) {
            return false;
        }
        return !(this.maskExpression != null ? !this.maskExpression.equals(that.maskExpression) : that.maskExpression != null);
    }

    public int hashCode() {
        int result = this.latBand.hashCode();
        result = 31 * result + this.lonBand.hashCode();
        if (this.maskExpression != null) {
            result = 31 * result + this.maskExpression.hashCode();
        }
        return result;
    }

    @Override
    public synchronized void dispose() {
        this.pixelPosEstimator = null;
        this.pixelFinder = null;
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        Band srcLonBand;
        Band lonBand;
        Band srcLatBand = this.getLatBand();
        Product destProduct = destScene.getProduct();
        Band latBand = destProduct.getBand(srcLatBand.getName());
        if (latBand == null) {
            latBand = GeoCodingFactory.createSubset(srcLatBand, destScene, subsetDef);
            destProduct.addBand(latBand);
        }
        if ((lonBand = destProduct.getBand((srcLonBand = this.getLonBand()).getName())) == null) {
            lonBand = GeoCodingFactory.createSubset(srcLonBand, destScene, subsetDef);
            destProduct.addBand(lonBand);
        }
        String validMaskExpression = this.getValidMask();
        try {
            if (validMaskExpression != null) {
                GeoCodingFactory.copyReferencedRasters(validMaskExpression, srcScene, destScene, subsetDef);
            }
        }
        catch (ParseException ignored) {
            validMaskExpression = null;
        }
        destScene.setGeoCoding(new PixelGeoCoding2(latBand, lonBand, validMaskExpression));
        return true;
    }

    @Override
    public Datum getDatum() {
        return Datum.WGS_84;
    }

    private static class PixelPosEstimatorFactory {
        private final PlanarImage lonImage;
        private final PlanarImage latImage;
        private final PlanarImage maskImage;
        private final double accuracy;

        private PixelPosEstimatorFactory(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double accuracy) {
            this.lonImage = lonImage;
            this.latImage = latImage;
            this.maskImage = maskImage;
            this.accuracy = accuracy;
        }

        private PixelPosEstimator create() {
            return new PixelPosEstimator(this.lonImage, this.latImage, this.maskImage, this.accuracy);
        }
    }

    private static class ArrayDataProvider
    implements DataProvider {
        private final float[] lonData;
        private final float[] latData;
        private final int width;

        ArrayDataProvider(RasterDataNode lonBand, RasterDataNode latBand, PlanarImage maskImage) {
            this.width = lonBand.getSceneRasterWidth();
            int height = lonBand.getSceneRasterHeight();
            MultiLevelImage lonImage = ImageManager.createMaskedGeophysicalImage(lonBand, Float.valueOf(Float.NaN));
            this.lonData = lonImage.getData().getSamples(0, 0, this.width, height, 0, (float[])null);
            MultiLevelImage latImage = ImageManager.createMaskedGeophysicalImage(latBand, Float.valueOf(Float.NaN));
            this.latData = latImage.getData().getSamples(0, 0, this.width, height, 0, (float[])null);
            if (maskImage != null) {
                int[] maskValues = maskImage.getData().getSamples(0, 0, this.width, height, 0, (int[])null);
                for (int i = 0; i < maskValues.length; ++i) {
                    if (maskValues[i] != 0) continue;
                    this.lonData[i] = Float.NaN;
                    this.latData[i] = Float.NaN;
                }
            }
        }

        @Override
        public void getGeoPosInteger(int x0, int y0, GeoPos geoPos) {
            int i = this.width * y0 + x0;
            float lon0 = this.lonData[i];
            float lat0 = this.latData[i];
            if (lat0 >= -90.0f && lat0 <= 90.0f && lon0 >= -180.0f && lon0 <= 180.0f) {
                geoPos.setLocation(lat0, lon0);
            }
        }

        @Override
        public void getGeoPosFloat(int x0, int y0, float wx, float wy, GeoPos geoPos) {
            geoPos.lon = this.interpolate(x0, y0, wx, wy, this.lonData, -180.0f, 180.0f);
            geoPos.lat = this.interpolate(x0, y0, wx, wy, this.latData, -90.0f, 90.0f);
        }

        private float interpolate(int x0, int y0, float wx, float wy, float[] data, float min, float max) {
            float d11;
            float d01;
            float d10;
            int x1 = x0 + 1;
            int y1 = y0 + 1;
            float d00 = data[this.width * y0 + x0];
            if (d00 >= min && d00 <= max && (d10 = data[this.width * y0 + x1]) >= min && d10 <= max && (d01 = data[this.width * y1 + x0]) >= min && d01 <= max && (d11 = data[this.width * y1 + x1]) >= min && d11 <= max) {
                return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
            }
            return d00;
        }
    }

    private static class ImageDataProvider
    implements DataProvider {
        private final RenderedImage lonImage;
        private final RenderedImage lonMaskImage;
        private final RenderedImage latImage;
        private final RenderedImage latMaskImage;

        ImageDataProvider(RenderedImage lonImage, RenderedImage lonMaskImage, RenderedImage latImage, RenderedImage latMaskImage) {
            this.lonImage = lonImage;
            this.lonMaskImage = lonMaskImage;
            this.latImage = latImage;
            this.latMaskImage = latMaskImage;
        }

        @Override
        public void getGeoPosInteger(int x0, int y0, GeoPos geoPos) {
            float lon0 = this.getSampleFloat(x0, y0, this.lonImage, this.lonMaskImage);
            float lat0 = this.getSampleFloat(x0, y0, this.latImage, this.latMaskImage);
            if (lat0 >= -90.0f && lat0 <= 90.0f && lon0 >= -180.0f && lon0 <= 180.0f) {
                geoPos.setLocation(lat0, lon0);
            }
        }

        @Override
        public void getGeoPosFloat(int x0, int y0, float wx, float wy, GeoPos geoPos) {
            Rectangle region = new Rectangle(x0, y0, 2, 2);
            if (this.lonMaskImage == null || this.allValid(this.lonMaskImage.getData(region))) {
                Raster lonData = this.lonImage.getData(region);
                geoPos.lon = this.interpolate(wx, wy, lonData, -180.0f, 180.0f);
            } else {
                geoPos.lon = this.getSampleFloat(x0, y0, this.lonImage, this.lonMaskImage);
            }
            if (this.latMaskImage == null || this.allValid(this.latMaskImage.getData(region))) {
                Raster latData = this.latImage.getData(region);
                geoPos.lat = this.interpolate(wx, wy, latData, -90.0f, 90.0f);
            } else {
                geoPos.lat = this.getSampleFloat(x0, y0, this.latImage, this.latMaskImage);
            }
        }

        private boolean allValid(Raster raster) {
            int x0 = raster.getMinX() - raster.getSampleModelTranslateX();
            int x1 = x0 + 1;
            int y0 = raster.getMinY() - raster.getSampleModelTranslateY();
            int y1 = y0 + 1;
            DataBuffer dataBuffer = raster.getDataBuffer();
            SampleModel sampleModel = raster.getSampleModel();
            if (sampleModel.getSample(x0, y0, 0, dataBuffer) == 0) {
                return false;
            }
            if (sampleModel.getSample(x1, y0, 0, dataBuffer) == 0) {
                return false;
            }
            if (sampleModel.getSample(x0, y1, 0, dataBuffer) == 0) {
                return false;
            }
            return sampleModel.getSample(x1, y1, 0, dataBuffer) != 0;
        }

        private float interpolate(float wx, float wy, Raster raster, float min, float max) {
            float d11;
            float d01;
            float d10;
            int x0 = raster.getMinX() - raster.getSampleModelTranslateX();
            int x1 = x0 + 1;
            int y0 = raster.getMinY() - raster.getSampleModelTranslateY();
            int y1 = y0 + 1;
            DataBuffer dataBuffer = raster.getDataBuffer();
            SampleModel sampleModel = raster.getSampleModel();
            float d00 = sampleModel.getSampleFloat(x0, y0, 0, dataBuffer);
            if (d00 >= min && d00 <= max && (d10 = sampleModel.getSampleFloat(x1, y0, 0, dataBuffer)) >= min && d10 <= max && (d01 = sampleModel.getSampleFloat(x0, y1, 0, dataBuffer)) >= min && d01 <= max && (d11 = sampleModel.getSampleFloat(x1, y1, 0, dataBuffer)) >= min && d11 <= max) {
                return MathUtils.interpolate2D(wx, wy, d00, d10, d01, d11);
            }
            return d00;
        }

        private float getSampleFloat(int pixelX, int pixelY, RenderedImage dataImage, RenderedImage maskImage) {
            int y;
            int x;
            if (maskImage != null) {
                int maskTileY;
                x = maskImage.getMinX() + pixelX;
                y = maskImage.getMinY() + pixelY;
                int maskTileX = PlanarImage.XToTileX((int)x, (int)maskImage.getTileGridXOffset(), (int)maskImage.getTileWidth());
                int maskValue = maskImage.getTile(maskTileX, maskTileY = PlanarImage.YToTileY((int)y, (int)maskImage.getTileGridYOffset(), (int)maskImage.getTileHeight())).getSample(x, y, 0);
                if (maskValue == 0) {
                    return Float.NaN;
                }
            }
            x = dataImage.getMinX() + pixelX;
            y = dataImage.getMinY() + pixelY;
            int tileX = PlanarImage.XToTileX((int)x, (int)dataImage.getTileGridXOffset(), (int)dataImage.getTileWidth());
            int tileY = PlanarImage.YToTileY((int)y, (int)dataImage.getTileGridYOffset(), (int)dataImage.getTileHeight());
            Raster data = dataImage.getTile(tileX, tileY);
            return data.getSampleFloat(x, y, 0);
        }
    }

    private static interface DataProvider {
        public void getGeoPosInteger(int var1, int var2, GeoPos var3);

        public void getGeoPosFloat(int var1, int var2, float var3, float var4, GeoPos var5);
    }
}

