/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.DefaultSteppingFactory;
import org.esa.beam.framework.datamodel.GeoApproximation;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.SampleSource;
import org.esa.beam.framework.datamodel.SteppingFactory;

public class PixelPosEstimator {
    private static final boolean EXTRAPOLATE = true;
    private final GeoApproximation[] approximations;
    private final Rectangle bounds;

    public PixelPosEstimator(GeoApproximation[] approximations, Rectangle bounds) {
        this.approximations = approximations;
        this.bounds = bounds;
    }

    PixelPosEstimator(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double accuracy) {
        this(lonImage, latImage, maskImage, accuracy, new DefaultSteppingFactory());
    }

    private PixelPosEstimator(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double accuracy, SteppingFactory steppingFactory) {
        this.approximations = PixelPosEstimator.createApproximations(lonImage, latImage, maskImage, accuracy, steppingFactory);
        this.bounds = lonImage.getBounds();
    }

    public final boolean canGetPixelPos() {
        return this.approximations != null;
    }

    public GeoApproximation getPixelPos(GeoPos g, PixelPos p) {
        GeoApproximation approximation = null;
        if (this.approximations != null) {
            if (g.isValid()) {
                double lon;
                double lat = g.getLat();
                approximation = GeoApproximation.findMostSuitable(this.approximations, lat, lon = (double)g.getLon());
                if (approximation != null) {
                    p.setLocation(lon, lat);
                    approximation.g2p(p);
                    double x = p.getX();
                    double y = p.getY();
                } else {
                    p.setInvalid();
                }
            } else {
                p.setInvalid();
            }
        }
        return approximation;
    }

    GeoApproximation getGeoPos(PixelPos p, GeoPos g) {
        GeoApproximation approximation = null;
        if (this.approximations != null) {
            if (g == null) {
                g = new GeoPos();
            }
            if (p.isValid()) {
                approximation = GeoApproximation.findSuitable(this.approximations, p);
                if (approximation != null) {
                    double x = p.getX();
                    double y = p.getY();
                    Point2D.Double q = new Point2D.Double(x, y);
                    approximation.p2g(q);
                    double lon = ((Point2D)q).getX();
                    double lat = ((Point2D)q).getY();
                    if (lon >= -180.0 && lon <= 180.0 && lat >= -90.0 && lat <= 90.0) {
                        g.setLocation((float)lat, (float)lon);
                    } else {
                        g.setInvalid();
                    }
                } else {
                    g.setInvalid();
                }
            } else {
                g.setInvalid();
            }
        }
        return approximation;
    }

    private static GeoApproximation[] createApproximations(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage, double accuracy, SteppingFactory steppingFactory) {
        PlanarImageSampleSource lonSamples = new PlanarImageSampleSource(lonImage);
        PlanarImageSampleSource latSamples = new PlanarImageSampleSource(latImage);
        SampleSource maskSamples = maskImage != null ? new PlanarImageSampleSource(maskImage) : new SampleSource(){

            @Override
            public int getSample(int x, int y) {
                return 1;
            }

            @Override
            public double getSampleDouble(int x, int y) {
                return 1.0;
            }
        };
        Raster[] tiles = lonImage.getTiles();
        Rectangle[] rectangles = new Rectangle[tiles.length];
        for (int i = 0; i < rectangles.length; ++i) {
            rectangles[i] = tiles[i].getBounds();
        }
        return GeoApproximation.createApproximations(lonSamples, latSamples, maskSamples, accuracy, rectangles, steppingFactory);
    }

    static class PlanarImageSampleSource
    implements SampleSource {
        private final PlanarImage image;

        public PlanarImageSampleSource(PlanarImage image) {
            this.image = image;
        }

        @Override
        public int getSample(int x, int y) {
            return PlanarImageSampleSource.getSample(x, y, this.image);
        }

        @Override
        public double getSampleDouble(int x, int y) {
            return PlanarImageSampleSource.getSampleDouble(x, y, this.image);
        }

        private static int getSample(int pixelX, int pixelY, PlanarImage image) {
            int x = image.getMinX() + pixelX;
            int y = image.getMinY() + pixelY;
            int tileX = image.XToTileX(x);
            int tileY = image.YToTileY(y);
            Raster data = image.getTile(tileX, tileY);
            return data.getSample(x, y, 0);
        }

        private static double getSampleDouble(int pixelX, int pixelY, PlanarImage image) {
            int x = image.getMinX() + pixelX;
            int y = image.getMinY() + pixelY;
            int tileX = image.XToTileX(x);
            int tileY = image.YToTileY(y);
            Raster data = image.getTile(tileX, tileY);
            return data.getSampleDouble(x, y, 0);
        }
    }
}

