/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;

public class PlacemarkGroup
extends ProductNodeGroup<Placemark> {
    private final VectorDataNode vectorDataNode;
    private final Map<SimpleFeature, Placemark> placemarkMap;
    private final ProductNodeListener listener;

    PlacemarkGroup(Product product, String name, VectorDataNode vectorDataNode) {
        super(product, name, true);
        this.vectorDataNode = vectorDataNode;
        this.placemarkMap = Collections.synchronizedMap(new HashMap());
        this.listener = new VectorDataNodeListener();
        this.getProduct().addProductNodeListener(this.listener);
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorDataNode;
    }

    public final synchronized Placemark getPlacemark(SimpleFeature feature) {
        return this.placemarkMap.get(feature);
    }

    @Override
    public synchronized boolean add(Placemark placemark) {
        boolean added = this._add(placemark);
        if (added) {
            this.addToVectorData(placemark);
        }
        return added;
    }

    @Override
    public synchronized void add(int index, Placemark placemark) {
        this._add(index, placemark);
        this.addToVectorData(placemark);
    }

    @Override
    public synchronized boolean remove(Placemark placemark) {
        boolean removed = this._remove(placemark);
        if (removed) {
            this.removeFromVectorData(placemark);
        }
        return removed;
    }

    @Override
    public synchronized void dispose() {
        if (this.getProduct() != null) {
            this.getProduct().removeProductNodeListener(this.listener);
        }
        this.placemarkMap.clear();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _add(Placemark placemark) {
        Map<SimpleFeature, Placemark> map = this.placemarkMap;
        synchronized (map) {
            boolean added = super.add(placemark);
            if (added) {
                this.placemarkMap.put(placemark.getFeature(), placemark);
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _add(int index, Placemark placemark) {
        Map<SimpleFeature, Placemark> map = this.placemarkMap;
        synchronized (map) {
            super.add(index, placemark);
            this.placemarkMap.put(placemark.getFeature(), placemark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _remove(Placemark placemark) {
        Map<SimpleFeature, Placemark> map = this.placemarkMap;
        synchronized (map) {
            boolean removed = super.remove(placemark);
            if (removed) {
                this.placemarkMap.remove(placemark.getFeature());
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToVectorData(Placemark placemark) {
        VectorDataNode vectorDataNode = this.vectorDataNode;
        synchronized (vectorDataNode) {
            if (!this.vectorDataNode.getFeatureCollection().contains((Object)placemark.getFeature())) {
                this.vectorDataNode.getFeatureCollection().add((Feature)placemark.getFeature());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromVectorData(Placemark placemark) {
        VectorDataNode vectorDataNode = this.vectorDataNode;
        synchronized (vectorDataNode) {
            this.vectorDataNode.getFeatureCollection().remove((Object)placemark.getFeature());
        }
    }

    private class VectorDataNodeListener
    extends ProductNodeListenerAdapter {
        private VectorDataNodeListener() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            block7: {
                if (event.getSource() != PlacemarkGroup.this.vectorDataNode || !event.getPropertyName().equals("featureCollection")) break block7;
                SimpleFeature[] oldFeatures = (SimpleFeature[])event.getOldValue();
                SimpleFeature[] newFeatures = (SimpleFeature[])event.getNewValue();
                if (oldFeatures == null) {
                    for (SimpleFeature feature : newFeatures) {
                        Placemark placemark = (Placemark)((Object)PlacemarkGroup.this.placemarkMap.get(feature));
                        if (placemark != null) continue;
                        PlacemarkGroup.this._add(PlacemarkGroup.this.vectorDataNode.getPlacemarkDescriptor().createPlacemark(feature));
                    }
                } else if (newFeatures == null) {
                    for (SimpleFeature feature : oldFeatures) {
                        Placemark placemark = (Placemark)((Object)PlacemarkGroup.this.placemarkMap.get(feature));
                        if (placemark == null) continue;
                        PlacemarkGroup.this._remove(placemark);
                    }
                } else {
                    for (SimpleFeature feature : newFeatures) {
                        Placemark placemark = (Placemark)((Object)PlacemarkGroup.this.placemarkMap.get(feature));
                        if (placemark == null) continue;
                        placemark.updatePositions();
                    }
                }
            }
        }
    }
}

