/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.Set;
import org.esa.beam.BeamCoreActivator;
import org.esa.beam.framework.datamodel.PointingFactory;
import org.esa.beam.util.Guardian;

public class PointingFactoryRegistry {
    private static ServiceRegistry<PointingFactory> typeToFactoryMap;

    private PointingFactoryRegistry() {
        ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
        typeToFactoryMap = serviceRegistryManager.getServiceRegistry(PointingFactory.class);
        if (!BeamCoreActivator.isStarted()) {
            BeamCoreActivator.loadServices(typeToFactoryMap);
        }
    }

    public static PointingFactoryRegistry getInstance() {
        return Holder.instance;
    }

    public PointingFactory getPointingFactory(String productType) {
        Guardian.assertNotNullOrEmpty("productType", productType);
        Set services = typeToFactoryMap.getServices();
        for (PointingFactory descriptor : services) {
            String[] supportedProductTypes;
            for (String supportedType : supportedProductTypes = descriptor.getSupportedProductTypes()) {
                if (!productType.equalsIgnoreCase(supportedType)) continue;
                return descriptor;
            }
        }
        return null;
    }

    public void addFactory(PointingFactory pointingFactory) {
        typeToFactoryMap.addService((Object)pointingFactory);
    }

    private static class Holder {
        private static final PointingFactoryRegistry instance = new PointingFactoryRegistry();

        private Holder() {
        }
    }
}

