/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.ParseException;
import com.bc.jexp.Parser;
import com.bc.jexp.Term;
import com.bc.jexp.WritableNamespace;
import com.bc.jexp.impl.ParserImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.beam.framework.dataio.ProductCache;
import org.esa.beam.framework.dataio.ProductFlipper;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BitmaskDef;
import org.esa.beam.framework.datamodel.DataNode;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.PointingFactory;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.ProductVisitorAdapter;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.SceneFactory;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataLoop;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.framework.dataop.barithm.SingleFlagSymbol;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.BitRaster;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.StopWatch;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.io.WildcardMatcher;
import org.esa.beam.util.math.MathUtils;

public class Product
extends ProductNode {
    public static final String METADATA_ROOT_NAME = "metadata";
    public static final String HISTORY_ROOT_NAME = "history";
    @Deprecated
    public static final String PIN_MASK_NAME = "pins";
    @Deprecated
    public static final String GCP_MASK_NAME = "ground_control_points";
    private static final String PIN_GROUP_NAME = "pins";
    private static final String GCP_GROUP_NAME = "ground_control_points";
    public static final String PROPERTY_NAME_GEOCODING = "geoCoding";
    public static final String PROPERTY_NAME_PRODUCT_TYPE = "productType";
    public static final String GEOMETRY_FEATURE_TYPE_NAME = "org.esa.beam.Geometry";
    private File fileLocation;
    private ProductReader reader;
    private ProductWriter writer;
    private GeoCoding geoCoding;
    private List<ProductNodeListener> listeners;
    private String productType;
    private final int sceneRasterWidth;
    private final int sceneRasterHeight;
    private ProductData.UTC startTime;
    private ProductData.UTC endTime;
    private final MetadataElement metadataRoot;
    private final ProductNodeGroup<Band> bandGroup;
    private final ProductNodeGroup<TiePointGrid> tiePointGridGroup;
    private final ProductNodeGroup<VectorDataNode> vectorDataGroup;
    private final ProductNodeGroup<FlagCoding> flagCodingGroup;
    private final ProductNodeGroup<IndexCoding> indexCodingGroup;
    private final ProductNodeGroup<Mask> maskGroup;
    private int refNo;
    private String refStr;
    private ProductManager productManager;
    private PointingFactory pointingFactory;
    private String quicklookBandName;
    private Dimension preferredTileSize;
    private AutoGrouping autoGrouping;
    private final PlacemarkGroup pinGroup;
    private final PlacemarkGroup gcpGroup;
    private final ProductNodeGroup<ProductNodeGroup> groups;
    private int numResolutionsMax;
    @Deprecated
    private final ProductNodeGroup<BitmaskDef> bitmaskDefGroup;
    @Deprecated
    private Map<String, BitRaster> validMasks;

    public Product(String name, String type, int sceneRasterWidth, int sceneRasterHeight) {
        this(name, type, sceneRasterWidth, sceneRasterHeight, null);
    }

    public Product(String name, String type, int sceneRasterWidth, int sceneRasterHeight, ProductReader reader) {
        this(null, name, type, sceneRasterWidth, sceneRasterHeight, reader);
    }

    private Product(File fileLocation, String name, String type, int sceneRasterWidth, int sceneRasterHeight, ProductReader reader) {
        super(name);
        Guardian.assertNotNullOrEmpty("type", type);
        this.fileLocation = fileLocation;
        this.productType = type;
        this.reader = reader;
        this.sceneRasterWidth = sceneRasterWidth;
        this.sceneRasterHeight = sceneRasterHeight;
        this.metadataRoot = new MetadataElement(METADATA_ROOT_NAME);
        this.metadataRoot.setOwner(this);
        this.bandGroup = new ProductNodeGroup(this, "bands", true);
        this.tiePointGridGroup = new ProductNodeGroup(this, "tie_point_grids", true);
        this.bitmaskDefGroup = new ProductNodeGroup(this, "bitmask_defs", true);
        this.vectorDataGroup = new VectorDataNodeProductNodeGroup();
        this.indexCodingGroup = new ProductNodeGroup(this, "index_codings", true);
        this.flagCodingGroup = new ProductNodeGroup(this, "flag_codings", true);
        this.maskGroup = new ProductNodeGroup(this, "masks", true);
        this.pinGroup = this.createPinGroup();
        this.gcpGroup = this.createGcpGroup();
        this.groups = new ProductNodeGroup(this, "groups", false);
        this.groups.add(this.bandGroup);
        this.groups.add(this.tiePointGridGroup);
        this.groups.add(this.vectorDataGroup);
        this.groups.add(this.indexCodingGroup);
        this.groups.add(this.flagCodingGroup);
        this.groups.add(this.maskGroup);
        this.groups.add(this.pinGroup);
        this.groups.add(this.gcpGroup);
        this.setModified(false);
        this.addProductNodeListener(new ProductNodeListenerAdapter(){

            @Override
            public void nodeAdded(ProductNodeEvent event) {
                if (event.getGroup() == Product.this.vectorDataGroup) {
                    Product.this.handleVectorDataNodeAdded(event);
                } else if (event.getGroup() == Product.this.maskGroup) {
                    Product.this.handleMaskAdded(event);
                }
            }

            @Override
            public void nodeRemoved(ProductNodeEvent event) {
                if (event.getGroup() == Product.this.vectorDataGroup) {
                    Product.this.handleVectorDataNodeRemoved(event);
                } else if (event.getGroup() == Product.this.maskGroup) {
                    Product.this.handleMaskRemoved(event);
                }
            }

            @Override
            public void nodeChanged(ProductNodeEvent event) {
                if ("name".equals(event.getPropertyName())) {
                    Product.this.handleNameChange(event);
                } else if (Product.PROPERTY_NAME_GEOCODING.equals(event.getPropertyName())) {
                    Product.this.handleGeoCodingChange();
                } else if ("featureCollection".equals(event.getPropertyName())) {
                    Product.this.handleFeatureCollectionChange(event);
                }
            }
        });
    }

    private void handleMaskAdded(ProductNodeEvent event) {
        Mask mask = (Mask)event.getSourceNode();
        if (StringUtils.isNullOrEmpty(mask.getDescription()) && mask.getImageType() == Mask.BandMathsType.INSTANCE) {
            String expression = Mask.BandMathsType.getExpression(mask);
            mask.setDescription(this.getSuitableBitmaskDefDescription(expression));
        }
    }

    private void handleVectorDataNodeAdded(ProductNodeEvent event) {
        Mask mask;
        VectorDataNode sourceNode = (VectorDataNode)event.getSourceNode();
        if (sourceNode.getFeatureCollection().size() > 0 && (mask = this.getMask(sourceNode)) == null) {
            this.addMask(sourceNode);
        }
    }

    private void handleVectorDataNodeRemoved(ProductNodeEvent event) {
        Mask mask = this.getMask((VectorDataNode)event.getSourceNode());
        if (mask != null) {
            this.getMaskGroup().remove(mask);
        }
    }

    private void handleMaskRemoved(ProductNodeEvent event) {
        TiePointGrid[] tiePointGrids;
        Band[] bands;
        Mask mask = (Mask)event.getSourceNode();
        for (Band band : bands = this.getBands()) {
            band.getOverlayMaskGroup().remove(mask);
        }
        for (TiePointGrid tiePointGrid : tiePointGrids = this.getTiePointGrids()) {
            tiePointGrid.getOverlayMaskGroup().remove(mask);
        }
    }

    private void addMask(VectorDataNode node) {
        this.addMask(node.getName(), node, "Mask derived from geometries in '" + node.getName() + "'", Color.RED, 0.5);
    }

    private void handleFeatureCollectionChange(ProductNodeEvent event) {
        VectorDataNode sourceNode = (VectorDataNode)event.getSourceNode();
        Mask mask = this.getMask(sourceNode);
        if (sourceNode.getFeatureCollection().size() > 0) {
            if (mask == null) {
                this.addMask(sourceNode);
            }
        } else if (mask != null) {
            this.getMaskGroup().remove(mask);
        }
    }

    private Mask getMask(VectorDataNode sourceNode) {
        Mask[] masks;
        for (Mask mask : masks = (Mask[])this.maskGroup.toArray(new Mask[this.maskGroup.getNodeCount()])) {
            if (mask.getImageType() != Mask.VectorDataType.INSTANCE || Mask.VectorDataType.getVectorData(mask) != sourceNode) continue;
            return mask;
        }
        return null;
    }

    private void handleGeoCodingChange() {
        for (int i = 0; i < this.pinGroup.getNodeCount(); ++i) {
            Placemark pin = (Placemark)((Object)this.pinGroup.get(i));
            PlacemarkDescriptor pinDescriptor = pin.getDescriptor();
            PixelPos pixelPos = pin.getPixelPos();
            GeoPos geoPos = pin.getGeoPos();
            if (pixelPos != null) {
                geoPos = pinDescriptor.updateGeoPos(this.getGeoCoding(), pixelPos, geoPos);
            }
            pin.setGeoPos(geoPos);
        }
    }

    private void handleNameChange(final ProductNodeEvent event) {
        String oldName = (String)event.getOldValue();
        String newName = event.getSourceNode().getName();
        final String oldExternName = BandArithmetic.createExternalName(oldName);
        final String newExternName = BandArithmetic.createExternalName(newName);
        ProductVisitorAdapter productVisitorAdapter = new ProductVisitorAdapter(){

            @Override
            public void visit(Product product) {
                if (product == event.getSourceNode()) {
                    product.setFileLocation(null);
                }
            }

            @Override
            public void visit(TiePointGrid grid) {
                grid.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(Band band) {
                band.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(Mask mask) {
                mask.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(VirtualBand virtualBand) {
                virtualBand.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(BitmaskDef bitmaskDef) {
                bitmaskDef.updateExpression(oldExternName, newExternName);
            }

            @Override
            public void visit(ProductNodeGroup group) {
                group.updateExpression(oldExternName, newExternName);
            }
        };
        this.acceptVisitor(productVisitorAdapter);
    }

    public File getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(File fileLocation) {
        this.fileLocation = fileLocation;
    }

    @Override
    public void setOwner(ProductNode owner) {
        throw new IllegalStateException("a product can not have an owner");
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        Guardian.assertNotNullOrEmpty(PROPERTY_NAME_PRODUCT_TYPE, productType);
        if (!ObjectUtils.equalObjects(this.productType, productType)) {
            String oldType = this.productType;
            this.productType = productType;
            this.fireProductNodeChanged(PROPERTY_NAME_PRODUCT_TYPE, oldType, productType);
            this.setModified(true);
        }
    }

    public void setProductReader(ProductReader reader) {
        Guardian.assertNotNull("ProductReader", reader);
        this.reader = reader;
    }

    @Override
    public ProductReader getProductReader() {
        return this.reader;
    }

    public void setProductWriter(ProductWriter writer) {
        this.writer = writer;
    }

    @Override
    public ProductWriter getProductWriter() {
        return this.writer;
    }

    public void writeHeader(Object output) throws IOException {
        Guardian.assertNotNull("output", output);
        Guardian.assertNotNull("writer", this.writer);
        this.writer.writeProductNodes(this, output);
    }

    public void closeProductReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public void closeProductWriter() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void closeIO() throws IOException {
        IOException eI = null;
        try {
            this.closeProductReader();
        }
        catch (IOException e) {
            eI = e;
        }
        IOException eO = null;
        try {
            this.closeProductWriter();
        }
        catch (IOException e) {
            eO = e;
        }
        if (eI != null) {
            throw eI;
        }
        if (eO != null) {
            throw eO;
        }
    }

    @Override
    public void dispose() {
        try {
            this.closeIO();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ProductCache.instance().removeProduct(this.getFileLocation());
        this.reader = null;
        this.writer = null;
        this.metadataRoot.dispose();
        this.bandGroup.dispose();
        this.tiePointGridGroup.dispose();
        this.bitmaskDefGroup.dispose();
        this.flagCodingGroup.dispose();
        this.indexCodingGroup.dispose();
        this.maskGroup.dispose();
        this.vectorDataGroup.dispose();
        this.pointingFactory = null;
        this.productManager = null;
        if (this.geoCoding != null) {
            this.geoCoding.dispose();
            this.geoCoding = null;
        }
        if (this.validMasks != null) {
            this.validMasks.clear();
            this.validMasks = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        this.fileLocation = null;
        ImageManager.getInstance().clearMaskImageCache(this);
    }

    public PointingFactory getPointingFactory() {
        return this.pointingFactory;
    }

    public void setPointingFactory(PointingFactory pointingFactory) {
        this.pointingFactory = pointingFactory;
    }

    public void setGeoCoding(GeoCoding geoCoding) {
        this.checkGeoCoding(geoCoding);
        if (!ObjectUtils.equalObjects(this.geoCoding, geoCoding)) {
            this.geoCoding = geoCoding;
            this.fireProductNodeChanged(PROPERTY_NAME_GEOCODING);
            this.setModified(true);
        }
    }

    public GeoCoding getGeoCoding() {
        return this.geoCoding;
    }

    public boolean isUsingSingleGeoCoding() {
        int i;
        GeoCoding geoCoding = this.getGeoCoding();
        if (geoCoding == null) {
            return false;
        }
        for (i = 0; i < this.getNumBands(); ++i) {
            if (geoCoding.equals(this.getBandAt(i).getGeoCoding())) continue;
            return false;
        }
        for (i = 0; i < this.getNumTiePointGrids(); ++i) {
            if (geoCoding.equals(this.getTiePointGridAt(i).getGeoCoding())) continue;
            return false;
        }
        return true;
    }

    public boolean transferGeoCodingTo(Product destProduct, ProductSubsetDef subsetDef) {
        Scene srcScene = SceneFactory.createScene(this);
        if (srcScene == null) {
            return false;
        }
        Scene destScene = SceneFactory.createScene(destProduct);
        return destScene != null && srcScene.transferGeoCodingTo(destScene, subsetDef);
    }

    public int getSceneRasterWidth() {
        return this.sceneRasterWidth;
    }

    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    public ProductData.UTC getStartTime() {
        return this.startTime;
    }

    public void setStartTime(ProductData.UTC startTime) {
        ProductData.UTC old = this.startTime;
        if (!ObjectUtils.equalObjects(old, startTime)) {
            this.startTime = startTime;
            this.setModified(true);
            this.fireProductNodeChanged("startTime", old, this.startTime);
        }
    }

    public ProductData.UTC getEndTime() {
        return this.endTime;
    }

    public void setEndTime(ProductData.UTC endTime) {
        ProductData.UTC old = this.endTime;
        if (!ObjectUtils.equalObjects(old, endTime)) {
            this.endTime = endTime;
            this.setModified(true);
            this.fireProductNodeChanged("endTime", old, this.endTime);
        }
    }

    public MetadataElement getMetadataRoot() {
        return this.metadataRoot;
    }

    public ProductNodeGroup<ProductNodeGroup> getGroups() {
        return this.groups;
    }

    public ProductNodeGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public ProductNodeGroup<TiePointGrid> getTiePointGridGroup() {
        return this.tiePointGridGroup;
    }

    public void addTiePointGrid(TiePointGrid tiePointGrid) {
        if (this.containsRasterDataNode(tiePointGrid.getName())) {
            throw new IllegalArgumentException("The Product '" + this.getName() + "' already contains " + "a tie-point grid with the name '" + tiePointGrid.getName() + "'.");
        }
        this.tiePointGridGroup.add(tiePointGrid);
    }

    public boolean removeTiePointGrid(TiePointGrid tiePointGrid) {
        return this.tiePointGridGroup.remove(tiePointGrid);
    }

    public int getNumTiePointGrids() {
        return this.tiePointGridGroup.getNodeCount();
    }

    public TiePointGrid getTiePointGridAt(int index) {
        return this.tiePointGridGroup.get(index);
    }

    public String[] getTiePointGridNames() {
        return this.tiePointGridGroup.getNodeNames();
    }

    public TiePointGrid[] getTiePointGrids() {
        TiePointGrid[] tiePointGrids = new TiePointGrid[this.getNumTiePointGrids()];
        for (int i = 0; i < tiePointGrids.length; ++i) {
            tiePointGrids[i] = this.getTiePointGridAt(i);
        }
        return tiePointGrids;
    }

    public TiePointGrid getTiePointGrid(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.tiePointGridGroup.get(name);
    }

    public boolean containsTiePointGrid(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.tiePointGridGroup.contains(name);
    }

    public ProductNodeGroup<Band> getBandGroup() {
        return this.bandGroup;
    }

    public void addBand(Band band) {
        Guardian.assertNotNull("band", band);
        if (this.containsRasterDataNode(band.getName())) {
            String name = band.getName();
            int i = name.lastIndexOf("__");
            int cnt = 2;
            if (i > 0) {
                String numStr = name.substring(i + 2, name.length());
                cnt = Integer.parseInt(numStr);
                ++cnt;
                name = name.substring(0, i);
            }
            name = name + "__" + cnt;
            band.setName(name);
            this.addBand(band);
            return;
        }
        this.bandGroup.add(band);
    }

    public Band addBand(String bandName, int dataType) {
        Band band = new Band(bandName, dataType, this.getSceneRasterWidth(), this.getSceneRasterHeight());
        this.addBand(band);
        return band;
    }

    public Band addBand(String bandName, String expression) {
        return this.addBand(bandName, expression, 30);
    }

    public Band addBand(String bandName, String expression, int dataType) {
        VirtualBand band = new VirtualBand(bandName, dataType, this.getSceneRasterWidth(), this.getSceneRasterHeight(), expression);
        this.addBand(band);
        return band;
    }

    public boolean removeBand(Band band) {
        return this.bandGroup.remove(band);
    }

    public int getNumBands() {
        return this.bandGroup.getNodeCount();
    }

    public Band getBandAt(int index) {
        return this.bandGroup.get(index);
    }

    public String[] getBandNames() {
        return this.bandGroup.getNodeNames();
    }

    public Band[] getBands() {
        return (Band[])this.bandGroup.toArray(new Band[this.getNumBands()]);
    }

    public Band getBand(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.get(name);
    }

    public int getBandIndex(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.indexOf(name);
    }

    public boolean containsBand(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bandGroup.contains(name);
    }

    public boolean containsRasterDataNode(String name) {
        return this.containsBand(name) || this.containsTiePointGrid(name) || this.getMaskGroup().contains(name);
    }

    public RasterDataNode getRasterDataNode(String name) {
        RasterDataNode rasterDataNode = this.getBand(name);
        if (rasterDataNode != null) {
            return rasterDataNode;
        }
        rasterDataNode = this.getTiePointGrid(name);
        if (rasterDataNode != null) {
            return rasterDataNode;
        }
        return this.getMaskGroup().get(name);
    }

    public ProductNodeGroup<Mask> getMaskGroup() {
        return this.maskGroup;
    }

    public ProductNodeGroup<VectorDataNode> getVectorDataGroup() {
        return this.vectorDataGroup;
    }

    public ProductNodeGroup<FlagCoding> getFlagCodingGroup() {
        return this.flagCodingGroup;
    }

    public ProductNodeGroup<IndexCoding> getIndexCodingGroup() {
        return this.indexCodingGroup;
    }

    public boolean containsPixel(float x, float y) {
        return x >= 0.0f && x <= (float)this.getSceneRasterWidth() && y >= 0.0f && y <= (float)this.getSceneRasterHeight();
    }

    public boolean containsPixel(PixelPos pixelPos) {
        return this.containsPixel(pixelPos.x, pixelPos.y);
    }

    private synchronized PlacemarkGroup createGcpGroup() {
        VectorDataNode vectorDataNode = new VectorDataNode("ground_control_points", Placemark.createGcpFeatureType());
        vectorDataNode.setDefaultStyleCss("symbol:plus; stroke:#ff8800; stroke-opacity:0.8; stroke-width:1.0");
        vectorDataNode.setPermanent(true);
        this.vectorDataGroup.add(vectorDataNode);
        return vectorDataNode.getPlacemarkGroup();
    }

    public PlacemarkGroup getGcpGroup() {
        return this.gcpGroup;
    }

    private synchronized PlacemarkGroup createPinGroup() {
        VectorDataNode vectorDataNode = new VectorDataNode("pins", Placemark.createPinFeatureType());
        vectorDataNode.setDefaultStyleCss("symbol:pin; fill:#0000ff; fill-opacity:0.7; stroke:#ffffff; stroke-opacity:1.0; stroke-width:0.5");
        vectorDataNode.setPermanent(true);
        this.vectorDataGroup.add(vectorDataNode);
        return vectorDataNode.getPlacemarkGroup();
    }

    public synchronized PlacemarkGroup getPinGroup() {
        return this.pinGroup;
    }

    public int getNumResolutionsMax() {
        return this.numResolutionsMax;
    }

    public void setNumResolutionsMax(int numResolutionsMax) {
        this.numResolutionsMax = numResolutionsMax;
    }

    public boolean isCompatibleProduct(Product product, float eps) {
        Guardian.assertNotNull("product", (Object)product);
        if (this == product) {
            return true;
        }
        if (this.getGeoCoding() == null && product.getGeoCoding() != null) {
            return false;
        }
        if (this.getGeoCoding() != null) {
            if (product.getGeoCoding() == null) {
                return false;
            }
            PixelPos pixelPos = new PixelPos();
            GeoPos geoPos1 = new GeoPos();
            GeoPos geoPos2 = new GeoPos();
            pixelPos.x = 0.5f;
            pixelPos.y = 0.5f;
            this.getGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                return false;
            }
            pixelPos.x = (float)(this.getSceneRasterWidth() - 1) + 0.5f;
            pixelPos.y = 0.5f;
            this.getGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                return false;
            }
            pixelPos.x = 0.5f;
            pixelPos.y = (float)(this.getSceneRasterHeight() - 1) + 0.5f;
            this.getGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                return false;
            }
            pixelPos.x = (float)(this.getSceneRasterWidth() - 1) + 0.5f;
            pixelPos.y = (float)(this.getSceneRasterHeight() - 1) + 0.5f;
            this.getGeoCoding().getGeoPos(pixelPos, geoPos1);
            product.getGeoCoding().getGeoPos(pixelPos, geoPos2);
            if (!Product.equalsLatLon(geoPos1, geoPos2, eps)) {
                return false;
            }
        }
        return true;
    }

    private static boolean equalsLatLon(GeoPos pos1, GeoPos pos2, float eps) {
        return MathUtils.equalValues(pos1.lat, pos2.lat, eps) && MathUtils.equalValues(pos1.lon, pos2.lon, eps);
    }

    public Term parseExpression(String expression) throws ParseException {
        Parser parser = this.createBandArithmeticParser();
        return parser.parse(expression);
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        this.bandGroup.acceptVisitor(visitor);
        this.tiePointGridGroup.acceptVisitor(visitor);
        this.flagCodingGroup.acceptVisitor(visitor);
        this.indexCodingGroup.acceptVisitor(visitor);
        this.vectorDataGroup.acceptVisitor(visitor);
        this.bitmaskDefGroup.acceptVisitor(visitor);
        this.maskGroup.acceptVisitor(visitor);
        this.metadataRoot.acceptVisitor(visitor);
        visitor.visit(this);
    }

    public boolean addProductNodeListener(ProductNodeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ProductNodeListener>();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                return true;
            }
        }
        return false;
    }

    public void removeProductNodeListener(ProductNodeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public ProductNodeListener[] getProductNodeListeners() {
        if (this.listeners == null) {
            return new ProductNodeListener[0];
        }
        return this.listeners.toArray(new ProductNodeListener[this.listeners.size()]);
    }

    protected boolean hasProductNodeListeners() {
        return this.listeners != null && this.listeners.size() > 0;
    }

    protected void fireNodeChanged(ProductNode sourceNode, String propertyName, Object oldValue, Object newValue) {
        this.fireEvent(sourceNode, propertyName, oldValue, newValue);
    }

    protected void fireNodeDataChanged(DataNode sourceNode) {
        this.fireEvent(sourceNode, 3, null);
    }

    protected void fireNodeAdded(ProductNode childNode, ProductNodeGroup nodeGroup) {
        this.fireEvent(childNode, 1, nodeGroup);
    }

    protected void fireNodeRemoved(ProductNode childNode, ProductNodeGroup nodeGroup) {
        this.fireEvent(childNode, 2, nodeGroup);
    }

    private void fireEvent(ProductNode sourceNode, int eventType, ProductNodeGroup nodeGroup) {
        if (this.hasProductNodeListeners()) {
            ProductNodeEvent event = new ProductNodeEvent(sourceNode, eventType, nodeGroup);
            this.fireEvent(event);
        }
    }

    private void fireEvent(ProductNode sourceNode, String propertyName, Object oldValue, Object newValue) {
        if (this.hasProductNodeListeners()) {
            ProductNodeEvent event = new ProductNodeEvent(sourceNode, propertyName, oldValue, newValue);
            this.fireEvent(event);
        }
    }

    private void fireEvent(ProductNodeEvent event) {
        Product.fireEvent(event, this.listeners.toArray(new ProductNodeListener[this.listeners.size()]));
    }

    static void fireEvent(ProductNodeEvent event, ProductNodeListener[] productNodeListeners) {
        for (ProductNodeListener listener : productNodeListeners) {
            Product.fireEvent(event, listener);
        }
    }

    static void fireEvent(ProductNodeEvent event, ProductNodeListener listener) {
        switch (event.getType()) {
            case 0: {
                listener.nodeChanged(event);
                break;
            }
            case 3: {
                listener.nodeDataChanged(event);
                break;
            }
            case 1: {
                listener.nodeAdded(event);
                break;
            }
            case 2: {
                listener.nodeRemoved(event);
            }
        }
    }

    public int getRefNo() {
        return this.refNo;
    }

    public void setRefNo(int refNo) {
        Guardian.assertWithinRange("refNo", refNo, 1L, Integer.MAX_VALUE);
        if (this.refNo != 0 && this.refNo != refNo) {
            throw new IllegalStateException("this.refNo != 0 && this.refNo != refNo");
        }
        this.refNo = refNo;
        this.refStr = "[" + this.refNo + "]";
    }

    public void resetRefNo() {
        this.refNo = 0;
        this.refStr = null;
    }

    String getRefStr() {
        return this.refStr;
    }

    public ProductManager getProductManager() {
        return this.productManager;
    }

    void setProductManager(ProductManager productManager) {
        this.productManager = productManager;
    }

    public boolean isCompatibleBandArithmeticExpression(String expression) {
        return this.isCompatibleBandArithmeticExpression(expression, null);
    }

    public boolean isCompatibleBandArithmeticExpression(String expression, Parser parser) {
        RasterDataSymbol[] termSymbols;
        Term term;
        Guardian.assertNotNull("expression", expression);
        if (parser == null) {
            parser = this.createBandArithmeticParser();
        }
        try {
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            return false;
        }
        if (term == null) {
            return false;
        }
        for (RasterDataSymbol termSymbol : termSymbols = BandArithmetic.getRefRasterDataSymbols(term)) {
            String symbolName;
            String flagName;
            String[] flagNames;
            RasterDataNode refRaster = termSymbol.getRaster();
            if (refRaster.getProduct() != this) {
                return false;
            }
            if (!(termSymbol instanceof SingleFlagSymbol) || StringUtils.containsIgnoreCase(flagNames = ((Band)refRaster).getFlagCoding().getFlagNames(), flagName = (symbolName = termSymbol.getName()).substring(symbolName.indexOf(46) + 1))) continue;
            return false;
        }
        return true;
    }

    public Parser createBandArithmeticParser() {
        WritableNamespace namespace = this.createBandArithmeticDefaultNamespace();
        return new ParserImpl(namespace, false);
    }

    public WritableNamespace createBandArithmeticDefaultNamespace() {
        return BandArithmetic.createDefaultNamespace(new Product[]{this}, 0);
    }

    public Product createSubset(ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        return ProductSubsetBuilder.createProductSubset(this, subsetDef, name, desc);
    }

    public Product createFlippedProduct(int flipType, String name, String desc) throws IOException {
        return ProductFlipper.createFlippedProduct(this, flipType, name, desc);
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            super.setModified(modified);
            if (!modified) {
                this.bandGroup.setModified(false);
                this.tiePointGridGroup.setModified(false);
                this.bitmaskDefGroup.setModified(false);
                this.maskGroup.setModified(false);
                this.vectorDataGroup.setModified(false);
                this.flagCodingGroup.setModified(false);
                this.indexCodingGroup.setModified(false);
                this.getMetadataRoot().setModified(false);
            }
        }
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        int i;
        long size = 0L;
        for (i = 0; i < this.getNumBands(); ++i) {
            size += this.getBandAt(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getNumTiePointGrids(); ++i) {
            size += this.getTiePointGridAt(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getFlagCodingGroup().getNodeCount(); ++i) {
            size += this.getFlagCodingGroup().get(i).getRawStorageSize(subsetDef);
        }
        for (i = 0; i < this.getMaskGroup().getNodeCount(); ++i) {
            size += this.getMaskGroup().get(i).getRawStorageSize(subsetDef);
        }
        return size += this.getMetadataRoot().getRawStorageSize(subsetDef);
    }

    public String getQuicklookBandName() {
        return this.quicklookBandName;
    }

    public void setQuicklookBandName(String quicklookBandName) {
        this.quicklookBandName = quicklookBandName;
    }

    public String createPixelInfoString(int pixelX, int pixelY) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Product:\t");
        sb.append(this.getName()).append("\n\n");
        sb.append("Image-X:\t");
        sb.append(pixelX);
        sb.append("\tpixel\n");
        sb.append("Image-Y:\t");
        sb.append(pixelY);
        sb.append("\tpixel\n");
        if (this.getGeoCoding() != null) {
            PixelPos pt = new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f);
            Band[] geoPos = this.getGeoCoding().getGeoPos(pt, null);
            sb.append("Longitude:\t");
            sb.append(geoPos.getLonString());
            sb.append("\tdegree\n");
            sb.append("Latitude:\t");
            sb.append(geoPos.getLatString());
            sb.append("\tdegree\n");
            if (this.getGeoCoding() instanceof MapGeoCoding) {
                MapGeoCoding mapGeoCoding = (MapGeoCoding)this.getGeoCoding();
                MapProjection mapProjection = mapGeoCoding.getMapInfo().getMapProjection();
                MapTransform mapTransform = mapProjection.getMapTransform();
                Point2D mapPoint = mapTransform.forward((GeoPos)geoPos, null);
                String mapUnit = mapProjection.getMapUnit();
                sb.append("Map-X:\t");
                sb.append(mapPoint.getX());
                sb.append("\t").append(mapUnit).append("\n");
                sb.append("Map-Y:\t");
                sb.append(mapPoint.getY());
                sb.append("\t").append(mapUnit).append("\n");
            }
        }
        if (pixelX >= 0 && pixelX < this.getSceneRasterWidth() && pixelY >= 0 && pixelY < this.getSceneRasterHeight()) {
            int i;
            sb.append("\n");
            boolean haveSpectralBand = false;
            for (Band band : this.getBands()) {
                if (!((double)band.getSpectralWavelength() > 0.0)) continue;
                haveSpectralBand = true;
                break;
            }
            if (haveSpectralBand) {
                sb.append("BandName\tWavelength\tUnit\tBandwidth\tUnit\tValue\tUnit\tSolar Flux\tUnit\n");
            } else {
                sb.append("BandName\tValue\tUnit\n");
            }
            for (Band band : this.getBands()) {
                sb.append(band.getName());
                sb.append(":\t");
                if ((double)band.getSpectralWavelength() > 0.0) {
                    sb.append(band.getSpectralWavelength());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                    sb.append(band.getSpectralBandwidth());
                    sb.append("\t");
                    sb.append("nm");
                    sb.append("\t");
                } else if (haveSpectralBand) {
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                    sb.append("\t");
                }
                sb.append(band.getPixelString(pixelX, pixelY));
                sb.append("\t");
                if (band.getUnit() != null) {
                    sb.append(band.getUnit());
                }
                sb.append("\t");
                float solarFlux = band.getSolarFlux();
                if ((double)solarFlux > 0.0) {
                    sb.append(solarFlux);
                    sb.append("\t");
                    sb.append("mW/(m^2*nm)");
                    sb.append("\t");
                }
                sb.append("\n");
            }
            sb.append("\n");
            for (i = 0; i < this.getNumTiePointGrids(); ++i) {
                TiePointGrid grid = this.getTiePointGridAt(i);
                if (!grid.hasRasterData()) continue;
                sb.append(grid.getName());
                sb.append(":\t");
                sb.append(grid.getPixelString(pixelX, pixelY));
                if (grid.getUnit() != null) {
                    sb.append("\t");
                    sb.append(grid.getUnit());
                }
                sb.append("\n");
            }
            for (i = 0; i < this.getNumBands(); ++i) {
                Band band = this.getBandAt(i);
                FlagCoding flagCoding = band.getFlagCoding();
                if (flagCoding == null) continue;
                boolean ioException = false;
                int[] flags = new int[1];
                if (band.hasRasterData()) {
                    flags[0] = band.getPixelInt(pixelX, pixelY);
                } else {
                    try {
                        band.readPixels(pixelX, pixelY, 1, 1, flags, ProgressMonitor.NULL);
                    }
                    catch (IOException e) {
                        ioException = true;
                    }
                }
                sb.append("\n");
                if (ioException) {
                    sb.append("I/O error");
                    continue;
                }
                for (int j = 0; j < flagCoding.getNumAttributes(); ++j) {
                    MetadataAttribute flagAttr = flagCoding.getAttributeAt(j);
                    int mask = flagAttr.getData().getElemInt();
                    boolean flagSet = (flags[0] & mask) == mask;
                    sb.append(band.getName());
                    sb.append(".");
                    sb.append(flagAttr.getName());
                    sb.append(":\t");
                    sb.append(flagSet ? "true" : "false");
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    public ProductNode[] getRemovedChildNodes() {
        ArrayList<ProductNode> removedNodes = new ArrayList<ProductNode>();
        removedNodes.addAll(this.bandGroup.getRemovedNodes());
        removedNodes.addAll(this.bitmaskDefGroup.getRemovedNodes());
        removedNodes.addAll(this.flagCodingGroup.getRemovedNodes());
        removedNodes.addAll(this.indexCodingGroup.getRemovedNodes());
        removedNodes.addAll(this.tiePointGridGroup.getRemovedNodes());
        removedNodes.addAll(this.maskGroup.getRemovedNodes());
        removedNodes.addAll(this.vectorDataGroup.getRemovedNodes());
        return removedNodes.toArray(new ProductNode[removedNodes.size()]);
    }

    private void checkGeoCoding(GeoCoding geoCoding) {
        if (geoCoding instanceof TiePointGeoCoding) {
            TiePointGeoCoding gc = (TiePointGeoCoding)geoCoding;
            Guardian.assertSame("gc.getLatGrid()", gc.getLatGrid(), this.getTiePointGrid(gc.getLatGrid().getName()));
            Guardian.assertSame("gc.getLonGrid()", gc.getLonGrid(), this.getTiePointGrid(gc.getLonGrid().getName()));
        } else if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding gc = (MapGeoCoding)geoCoding;
            MapInfo mapInfo = gc.getMapInfo();
            Guardian.assertNotNull("mapInfo", mapInfo);
            Guardian.assertEquals("mapInfo.getSceneWidth()", mapInfo.getSceneWidth(), this.getSceneRasterWidth());
            Guardian.assertEquals("mapInfo.getSceneHeight()", mapInfo.getSceneHeight(), this.getSceneRasterHeight());
        }
    }

    public boolean canBeOrthorectified() {
        for (int i = 0; i < this.getNumBands(); ++i) {
            if (this.getBandAt(i).canBeOrthorectified()) continue;
            return false;
        }
        return true;
    }

    private String getSuitableBitmaskDefDescription(String expr) {
        String description;
        Term.NotB notTerm;
        Term arg;
        Term term;
        if (StringUtils.isNullOrEmpty(expr)) {
            return null;
        }
        try {
            term = this.createBandArithmeticParser().parse(expr);
        }
        catch (ParseException e) {
            return null;
        }
        if (term instanceof Term.Ref) {
            return this.getSuitableBitmaskDefDescription((Term.Ref)term);
        }
        if (term instanceof Term.NotB && (arg = (notTerm = (Term.NotB)term).getArgs()[0]) instanceof Term.Ref && (description = this.getSuitableBitmaskDefDescription((Term.Ref)arg)) != null) {
            return "Not " + description;
        }
        return null;
    }

    private String getSuitableBitmaskDefDescription(Term.Ref ref) {
        String description = null;
        String symbolName = ref.getSymbol().getName();
        if (Product.isFlagSymbol(symbolName)) {
            MetadataAttribute attribute;
            FlagCoding flagCoding;
            String[] strings = StringUtils.split(symbolName, new char[]{'.'}, true);
            String nodeName = strings[0];
            String flagName = strings[1];
            RasterDataNode rasterDataNode = this.getRasterDataNode(nodeName);
            if (rasterDataNode instanceof Band && (flagCoding = ((Band)rasterDataNode).getFlagCoding()) != null && (attribute = flagCoding.getAttribute(flagName)) != null) {
                description = attribute.getDescription();
            }
        } else {
            RasterDataNode rasterDataNode = this.getRasterDataNode(symbolName);
            if (rasterDataNode != null) {
                description = rasterDataNode.getDescription();
            }
        }
        return description;
    }

    private static boolean isFlagSymbol(String symbolName) {
        return symbolName.indexOf(46) != -1;
    }

    public Dimension getPreferredTileSize() {
        return this.preferredTileSize;
    }

    public void setPreferredTileSize(int tileWidth, int tileHeight) {
        this.setPreferredTileSize(new Dimension(tileWidth, tileHeight));
    }

    public void setPreferredTileSize(Dimension preferredTileSize) {
        this.preferredTileSize = preferredTileSize;
    }

    public String[] getAllFlagNames() {
        ArrayList<String> l = new ArrayList<String>(32);
        for (int i = 0; i < this.getNumBands(); ++i) {
            Band band = this.getBandAt(i);
            if (band.getFlagCoding() == null) continue;
            for (int j = 0; j < band.getFlagCoding().getNumAttributes(); ++j) {
                MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                l.add(band.getName() + "." + attribute.getName());
            }
        }
        String[] flagNames = new String[l.size()];
        for (int i = 0; i < flagNames.length; ++i) {
            flagNames[i] = (String)l.get(i);
        }
        l.clear();
        return flagNames;
    }

    public AutoGrouping getAutoGrouping() {
        return this.autoGrouping;
    }

    public void setAutoGrouping(AutoGrouping autoGrouping) {
        AutoGrouping old = this.autoGrouping;
        if (!ObjectUtils.equalObjects(old, autoGrouping)) {
            this.autoGrouping = autoGrouping;
            this.fireProductNodeChanged("autoGrouping", old, this.autoGrouping);
        }
    }

    public void setAutoGrouping(String pattern) {
        Assert.notNull((Object)pattern, (String)"text");
        this.setAutoGrouping(AutoGroupingImpl.parse(pattern));
    }

    public Mask addMask(String maskName, Mask.ImageType imageType) {
        Mask mask = new Mask(maskName, this.sceneRasterWidth, this.sceneRasterHeight, imageType);
        this.getMaskGroup().add(mask);
        return mask;
    }

    public Mask addMask(String maskName, String expression, String description, Color color, double transparency) {
        Mask mask = Mask.BandMathsType.create(maskName, description, this.sceneRasterWidth, this.sceneRasterHeight, expression, color, transparency);
        this.getMaskGroup().add(mask);
        return mask;
    }

    public Mask addMask(String maskName, VectorDataNode vectorDataNode, String description, Color color, double transparency) {
        Mask mask = new Mask(maskName, this.getSceneRasterWidth(), this.getSceneRasterHeight(), Mask.VectorDataType.INSTANCE);
        Mask.VectorDataType.setVectorData(mask, vectorDataNode);
        mask.setDescription(description);
        mask.setImageColor(color);
        mask.setImageTransparency(transparency);
        this.getMaskGroup().add(mask);
        return mask;
    }

    @Deprecated
    public void addBitmaskDef(BitmaskDef bitmaskDef) {
        if (StringUtils.isNullOrEmpty(bitmaskDef.getDescription())) {
            String defaultDescription = this.getSuitableBitmaskDefDescription(bitmaskDef.getExpr());
            bitmaskDef.setDescription(defaultDescription);
        }
        this.bitmaskDefGroup.add(bitmaskDef);
        this.maskGroup.add(bitmaskDef.createMask(this.sceneRasterWidth, this.sceneRasterHeight));
    }

    @Deprecated
    public String[] getBitmaskDefNames() {
        return this.bitmaskDefGroup.getNodeNames();
    }

    @Deprecated
    public BitmaskDef getBitmaskDef(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.bitmaskDefGroup.get(name);
    }

    @Deprecated
    public BitRaster getValidMask(String id) {
        if (this.validMasks != null) {
            return this.validMasks.get(id);
        }
        return null;
    }

    @Deprecated
    public void setValidMask(String id, BitRaster validMask) {
        if (validMask != null) {
            Guardian.assertEquals("validMask", validMask.getWidth(), this.getSceneRasterWidth());
            Guardian.assertEquals("validMask", validMask.getHeight(), this.getSceneRasterHeight());
            if (this.validMasks == null) {
                this.validMasks = new HashMap<String, BitRaster>();
            }
            this.validMasks.put(id, validMask);
        } else if (this.validMasks != null) {
            this.validMasks.remove(id);
        }
    }

    @Deprecated
    public BitRaster createValidMask(String expression, ProgressMonitor pm) throws IOException {
        try {
            Term term = this.getProduct().parseExpression(expression);
            return this.createValidMask(term, pm);
        }
        catch (ParseException e) {
            IOException ioException = new IOException("Unable to load the valid pixel mask, parse error: " + e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Deprecated
    public BitRaster createValidMask(final Term term, ProgressMonitor pm) throws IOException {
        String id = term.toString();
        BitRaster cachedValidMask = this.getValidMask(id);
        if (cachedValidMask != null) {
            return cachedValidMask;
        }
        Debug.trace("createValidMask: " + id);
        int productWidth = this.getSceneRasterWidth();
        int productHeight = this.getSceneRasterHeight();
        final BitRaster validMask = new BitRaster(productWidth, productHeight);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        RasterDataLoop loop = new RasterDataLoop(0, 0, productWidth, productHeight, new Term[]{term}, pm);
        loop.forEachPixel(new RasterDataLoop.Body(){

            @Override
            public void eval(RasterDataEvalEnv env, int pixelIndex) {
                if (term.evalB(env)) {
                    validMask.set(pixelIndex);
                }
            }
        }, "Computing valid-mask...");
        this.setValidMask(id, validMask);
        stopWatch.stopAndTrace("createValidMask");
        return validMask;
    }

    @Deprecated
    public void readBitmask(int offsetX, int offsetY, int width, int height, final Term bitmaskTerm, final boolean[] bitmask, ProgressMonitor pm) throws IOException {
        RasterDataLoop loop = new RasterDataLoop(offsetX, offsetY, width, height, new Term[]{bitmaskTerm}, pm);
        loop.forEachPixel(new RasterDataLoop.Body(){

            @Override
            public void eval(RasterDataEvalEnv env, int pixelIndex) {
                bitmask[pixelIndex] = bitmaskTerm.evalB(env);
            }
        });
    }

    @Deprecated
    public synchronized void readBitmask(int offsetX, int offsetY, int width, int height, final Term bitmaskTerm, final byte[] bitmask, final byte trueValue, final byte falseValue, ProgressMonitor pm) throws IOException {
        RasterDataLoop loop = new RasterDataLoop(offsetX, offsetY, width, height, new Term[]{bitmaskTerm}, pm);
        loop.forEachPixel(new RasterDataLoop.Body(){

            @Override
            public void eval(RasterDataEvalEnv env, int pixelIndex) {
                bitmask[pixelIndex] = bitmaskTerm.evalB(env) ? trueValue : falseValue;
            }
        }, "Reading bitmask...");
    }

    private class VectorDataNodeProductNodeGroup
    extends ProductNodeGroup<VectorDataNode> {
        public VectorDataNodeProductNodeGroup() {
            super(Product.this, "vector_data", true);
        }

        @Override
        public boolean add(VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            VectorDataNode permanentNode = this.getPermanentNode(vectorDataNode.getName());
            if (permanentNode != null) {
                permanentNode.getFeatureCollection().addAll(vectorDataNode.getFeatureCollection());
                return false;
            }
            return super.add(vectorDataNode);
        }

        @Override
        public void add(int index, VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            VectorDataNode permanentNode = this.getPermanentNode(vectorDataNode.getName());
            if (permanentNode != null) {
                permanentNode.getFeatureCollection().addAll(vectorDataNode.getFeatureCollection());
                return;
            }
            super.add(index, vectorDataNode);
        }

        @Override
        public boolean remove(VectorDataNode vectorDataNode) {
            Assert.notNull((Object)((Object)vectorDataNode), (String)"node");
            return !vectorDataNode.isPermanent() && super.remove(vectorDataNode);
        }

        private VectorDataNode getPermanentNode(String nodeName) {
            VectorDataNode node = (VectorDataNode)((Object)this.get(nodeName));
            if (node != null && node.isPermanent()) {
                return node;
            }
            return null;
        }
    }

    private static class WildCardEntry
    implements Entry {
        private final WildcardMatcher wildcardMatcher;

        WildCardEntry(String group) {
            this.wildcardMatcher = new WildcardMatcher(group);
        }

        @Override
        public boolean matches(String name) {
            return this.wildcardMatcher.matches(name);
        }
    }

    private static class EntryImpl
    implements Entry {
        private final String group;

        EntryImpl(String group) {
            this.group = group;
        }

        @Override
        public boolean matches(String name) {
            return name.contains(this.group);
        }
    }

    static interface Entry {
        public boolean matches(String var1);
    }

    private static class AutoGroupingPath {
        private final String[] groups;
        private final Entry[] entries;

        AutoGroupingPath(String[] groups) {
            this.groups = groups;
            this.entries = new Entry[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                this.entries[i] = groups[i].contains("*") || groups[i].contains("?") ? new WildCardEntry(groups[i]) : new EntryImpl(groups[i]);
            }
        }

        boolean contains(String name) {
            for (Entry entry : this.entries) {
                if (entry.matches(name)) continue;
                return false;
            }
            return true;
        }

        String[] getInputPath() {
            return this.groups;
        }
    }

    private static class AutoGroupingImpl
    extends AbstractList<String[]>
    implements AutoGrouping {
        private static final String GROUP_SEPARATOR = "/";
        private static final String PATH_SEPARATOR = ":";
        private final AutoGroupingPath[] autoGroupingPaths;
        private final Index[] indexes;

        private AutoGroupingImpl(String[][] inputPaths) {
            this.autoGroupingPaths = new AutoGroupingPath[inputPaths.length];
            this.indexes = new Index[inputPaths.length];
            for (int i = 0; i < inputPaths.length; ++i) {
                AutoGroupingPath autoGroupingPath;
                this.autoGroupingPaths[i] = autoGroupingPath = new AutoGroupingPath(inputPaths[i]);
                this.indexes[i] = new Index(autoGroupingPath, i);
            }
            Arrays.sort(this.indexes, new Comparator<Index>(){

                @Override
                public int compare(Index o1, Index o2) {
                    String[] o1InputPath = o1.path.getInputPath();
                    String[] o2InputPath = o2.path.getInputPath();
                    for (int index = 0; index < o1InputPath.length && index < o2InputPath.length; ++index) {
                        String currentO1InputPathString = o1InputPath[index];
                        String currentO2InputPathString = o2InputPath[index];
                        if (currentO1InputPathString.length() == currentO2InputPathString.length()) continue;
                        return currentO2InputPathString.length() - currentO1InputPathString.length();
                    }
                    if (o1InputPath.length != o2InputPath.length) {
                        return o2InputPath.length - o1InputPath.length;
                    }
                    return o2InputPath[0].compareTo(o1InputPath[0]);
                }
            });
        }

        @Override
        public int indexOf(String name) {
            for (Index index : this.indexes) {
                int i = index.index;
                if (!index.path.contains(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String[] get(int index) {
            return this.autoGroupingPaths[index].getInputPath();
        }

        @Override
        public int size() {
            return this.autoGroupingPaths.length;
        }

        public static AutoGrouping parse(String text) {
            if (StringUtils.isNotNullAndNotEmpty(text)) {
                String[] pathTexts = StringUtils.toStringArray(text, PATH_SEPARATOR);
                String[][] paths = new String[pathTexts.length][];
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = StringUtils.toStringArray(pathTexts[i], GROUP_SEPARATOR);
                }
                return new AutoGroupingImpl(paths);
            }
            return null;
        }

        public String format() {
            if (this.autoGroupingPaths.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.autoGroupingPaths.length; ++i) {
                    if (i > 0) {
                        sb.append(PATH_SEPARATOR);
                    }
                    String[] path = this.autoGroupingPaths[i].getInputPath();
                    for (int j = 0; j < path.length; ++j) {
                        if (j > 0) {
                            sb.append(GROUP_SEPARATOR);
                        }
                        sb.append(path[j]);
                    }
                }
                return sb.toString();
            }
            return "";
        }

        @Override
        public String toString() {
            return this.format();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AutoGrouping) {
                AutoGrouping other = (AutoGrouping)o;
                if (other.size() != this.size()) {
                    return false;
                }
                for (int i = 0; i < this.autoGroupingPaths.length; ++i) {
                    String[] path = this.autoGroupingPaths[i].getInputPath();
                    if (ObjectUtils.equalObjects(path, other.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = 0;
            for (AutoGroupingPath autoGroupingPath : this.autoGroupingPaths) {
                String[] path = autoGroupingPath.getInputPath();
                code += path.hashCode();
            }
            return code;
        }

        private static class Index {
            final int index;
            final AutoGroupingPath path;

            private Index(AutoGroupingPath path, int index) {
                this.path = path;
                this.index = index;
            }
        }
    }

    public static interface AutoGrouping
    extends List<String[]> {
        public int indexOf(String var1);
    }
}

