/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;

public abstract class ProductData
implements Cloneable {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_INT8 = 10;
    public static final int TYPE_INT16 = 11;
    public static final int TYPE_INT32 = 12;
    public static final int TYPE_UINT8 = 20;
    public static final int TYPE_UINT16 = 21;
    public static final int TYPE_UINT32 = 22;
    public static final int TYPE_FLOAT32 = 30;
    public static final int TYPE_FLOAT64 = 31;
    public static final int TYPE_ASCII = 41;
    public static final int TYPE_UTC = 51;
    private final int _type;
    public static final String TYPESTRING_INT8 = "int8";
    public static final String TYPESTRING_INT16 = "int16";
    public static final String TYPESTRING_INT32 = "int32";
    public static final String TYPESTRING_UINT8 = "uint8";
    public static final String TYPESTRING_UINT16 = "uint16";
    public static final String TYPESTRING_UINT32 = "uint32";
    public static final String TYPESTRING_FLOAT32 = "float32";
    public static final String TYPESTRING_FLOAT64 = "float64";
    public static final String TYPESTRING_ASCII = "ascii";
    public static final String TYPESTRING_UTC = "utc";

    protected ProductData(int type) {
        this._type = type;
    }

    public static ProductData createInstance(int type) {
        return ProductData.createInstance(type, 1);
    }

    public static ProductData createInstance(int type, int numElems) {
        if (numElems < 1 && type != 51) {
            throw new IllegalArgumentException("numElems is less than one");
        }
        switch (type) {
            case 10: {
                return new Byte(numElems);
            }
            case 11: {
                return new Short(numElems);
            }
            case 12: {
                return new Int(numElems);
            }
            case 20: {
                return new UByte(numElems);
            }
            case 21: {
                return new UShort(numElems);
            }
            case 22: {
                return new UInt(numElems);
            }
            case 30: {
                return new Float(numElems);
            }
            case 31: {
                return new Double(numElems);
            }
            case 41: {
                return new ASCII(numElems);
            }
            case 51: {
                return new UTC();
            }
        }
        return null;
    }

    public static ProductData createInstance(int type, Object data) {
        switch (type) {
            case 10: {
                return new Byte((byte[])data);
            }
            case 11: {
                return new Short((short[])data);
            }
            case 12: {
                return new Int((int[])data);
            }
            case 20: {
                return new UByte((byte[])data);
            }
            case 21: {
                return new UShort((short[])data);
            }
            case 22: {
                return new UInt((int[])data);
            }
            case 30: {
                return new Float((float[])data);
            }
            case 31: {
                return new Double((double[])data);
            }
            case 41: {
                return new ASCII(data.toString());
            }
            case 51: {
                return new UTC((int[])data);
            }
        }
        return null;
    }

    public static ProductData createInstance(byte[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new Byte(elems);
    }

    public static ProductData createUnsignedInstance(byte[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new UByte(elems);
    }

    public static ProductData createInstance(short[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new Short(elems);
    }

    public static ProductData createUnsignedInstance(short[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new UShort(elems);
    }

    public static ProductData createInstance(int[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new Int(elems);
    }

    public static ProductData createUnsignedInstance(int[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new UInt(elems);
    }

    @Deprecated
    public static ProductData createInstance(long[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new UInt(elems);
    }

    public static ProductData createInstance(String strData) {
        Guardian.assertNotNull("strData", strData);
        return new ASCII(strData);
    }

    public static ProductData createInstance(float[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new Float(elems);
    }

    public static ProductData createInstance(double[] elems) {
        Guardian.assertNotNull("elems", elems);
        return new Double(elems);
    }

    public int getType() {
        return this._type;
    }

    public static int getElemSize(int type) {
        switch (type) {
            case 10: 
            case 20: 
            case 41: {
                return 1;
            }
            case 11: 
            case 21: {
                return 2;
            }
            case 12: 
            case 22: 
            case 30: 
            case 51: {
                return 4;
            }
            case 31: {
                return 8;
            }
        }
        throw new IllegalArgumentException("type is not supported");
    }

    public int getElemSize() {
        return ProductData.getElemSize(this.getType());
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 10: {
                return TYPESTRING_INT8;
            }
            case 11: {
                return TYPESTRING_INT16;
            }
            case 12: {
                return TYPESTRING_INT32;
            }
            case 20: {
                return TYPESTRING_UINT8;
            }
            case 21: {
                return TYPESTRING_UINT16;
            }
            case 22: {
                return TYPESTRING_UINT32;
            }
            case 30: {
                return TYPESTRING_FLOAT32;
            }
            case 31: {
                return TYPESTRING_FLOAT64;
            }
            case 41: {
                return TYPESTRING_ASCII;
            }
            case 51: {
                return TYPESTRING_UTC;
            }
        }
        return null;
    }

    public static int getType(String type) {
        if (TYPESTRING_INT8.equals(type)) {
            return 10;
        }
        if (TYPESTRING_INT16.equals(type)) {
            return 11;
        }
        if (TYPESTRING_INT32.equals(type)) {
            return 12;
        }
        if (TYPESTRING_UINT8.equals(type)) {
            return 20;
        }
        if (TYPESTRING_UINT16.equals(type)) {
            return 21;
        }
        if (TYPESTRING_UINT32.equals(type)) {
            return 22;
        }
        if (TYPESTRING_FLOAT32.equals(type)) {
            return 30;
        }
        if (TYPESTRING_FLOAT64.equals(type)) {
            return 31;
        }
        if (TYPESTRING_ASCII.equals(type)) {
            return 41;
        }
        if (TYPESTRING_UTC.equals(type)) {
            return 51;
        }
        return 0;
    }

    public String getTypeString() {
        return ProductData.getTypeString(this.getType());
    }

    public boolean isInt() {
        return ProductData.isIntType(this._type);
    }

    public static boolean isIntType(int type) {
        return type >= 10 && type < 30;
    }

    public boolean isSigned() {
        return !this.isUnsigned();
    }

    public boolean isUnsigned() {
        return ProductData.isUIntType(this._type);
    }

    public static boolean isUIntType(int type) {
        return type >= 20 && type < 30;
    }

    public static boolean isFloatingPointType(int type) {
        return type >= 30 && type < 40;
    }

    public boolean isScalar() {
        return this.getNumElems() == 1;
    }

    public abstract int getNumElems();

    public int getElemInt() {
        return this.getElemIntAt(0);
    }

    public long getElemUInt() {
        return this.getElemUIntAt(0);
    }

    public float getElemFloat() {
        return this.getElemFloatAt(0);
    }

    public double getElemDouble() {
        return this.getElemDoubleAt(0);
    }

    public String getElemString() {
        if (this.isScalar()) {
            return this.getElemStringAt(0);
        }
        StringBuffer sb = new StringBuffer(4 + 4 * this.getNumElems());
        for (int i = 0; i < this.getNumElems(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getElemStringAt(i));
        }
        return sb.toString();
    }

    public boolean getElemBoolean() {
        return this.getElemBooleanAt(0);
    }

    public abstract int getElemIntAt(int var1);

    public abstract long getElemUIntAt(int var1);

    public abstract float getElemFloatAt(int var1);

    public abstract double getElemDoubleAt(int var1);

    public abstract String getElemStringAt(int var1);

    public boolean getElemBooleanAt(int index) {
        return this.getElemIntAt(index) != 0;
    }

    public void setElemInt(int value) {
        this.setElemIntAt(0, value);
    }

    public void setElemUInt(long value) {
        this.setElemUIntAt(0, value);
    }

    public void setElemFloat(float value) {
        this.setElemFloatAt(0, value);
    }

    public void setElemDouble(double value) {
        this.setElemDoubleAt(0, value);
    }

    public void setElemString(String value) {
        this.setElemStringAt(0, value);
    }

    public void setElemBoolean(boolean value) {
        this.setElemBooleanAt(0, value);
    }

    public abstract void setElemIntAt(int var1, int var2);

    public abstract void setElemUIntAt(int var1, long var2);

    public abstract void setElemFloatAt(int var1, float var2);

    public abstract void setElemDoubleAt(int var1, double var2);

    public void setElemStringAt(int index, String value) {
        throw new IllegalStateException("not implemented");
    }

    public void setElemBooleanAt(int index, boolean value) {
        this.setElemIntAt(index, value ? 1 : 0);
    }

    public abstract Object getElems();

    public abstract void setElems(Object var1);

    public void readFrom(ImageInputStream input) throws IOException {
        this.readFrom(0, this.getNumElems(), input);
    }

    public void readFrom(int pos, ImageInputStream input) throws IOException {
        this.readFrom(pos, 1, input);
    }

    public abstract void readFrom(int var1, int var2, ImageInputStream var3) throws IOException;

    public void readFrom(int startPos, int numElems, ImageInputStream input, long inputPos) throws IOException {
        input.seek((long)this.getElemSize() * inputPos);
        this.readFrom(startPos, numElems, input);
    }

    public void writeTo(ImageOutputStream output) throws IOException {
        this.writeTo(0, this.getNumElems(), output);
    }

    public void writeTo(int pos, ImageOutputStream output) throws IOException {
        this.writeTo(pos, 1, output);
    }

    public abstract void writeTo(int var1, int var2, ImageOutputStream var3) throws IOException;

    public void writeTo(int startPos, int numElems, ImageOutputStream output, long outputPos) throws IOException {
        output.seek((long)this.getElemSize() * outputPos);
        this.writeTo(startPos, numElems, output);
    }

    public String toString() {
        return this.getElemString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public boolean equalElems(ProductData other) {
        return other == this || ObjectUtils.equalObjects(this.getElems(), other.getElems());
    }

    protected abstract ProductData createDeepClone();

    public abstract void dispose();

    public static class UTC
    extends UInt {
        public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        public static final String DATE_FORMAT_PATTERN = "dd-MMM-yyyy HH:mm:ss";
        private static final double SECONDS_PER_DAY = 86400.0;
        private static final double SECONDS_TO_DAYS = 1.1574074074074073E-5;
        private static final double MICROS_PER_SECOND = 1000000.0;
        private static final double MICROS_TO_SECONDS = 1.0E-6;

        public UTC() {
            super(3);
        }

        public UTC(int[] elems) {
            this(elems[0], elems[1], elems[2]);
        }

        public UTC(int days, int seconds, int microSeconds) {
            super(3);
            this.setElemIntAt(0, days);
            this.setElemIntAt(1, seconds);
            this.setElemIntAt(2, microSeconds);
        }

        public UTC(double mjd) {
            super(3);
            double microSeconds = mjd * 86400.0 * 1000000.0 % 1000000.0;
            double seconds = (mjd * 86400.0 - microSeconds * 1.0E-6) % 86400.0;
            double days = (int)mjd;
            this.setElemIntAt(0, (int)days);
            this.setElemIntAt(1, (int)seconds);
            this.setElemIntAt(2, (int)microSeconds);
        }

        public static UTC create(Date date, long micros) {
            Calendar calendar = UTC.createCalendar();
            long offset = calendar.getTimeInMillis();
            calendar.setTime(date);
            int millsPerSecond = 1000;
            int millisPerDay = 86400000;
            calendar.add(5, -((int)(offset / 86400000L)));
            calendar.add(14, -((int)(offset % 86400000L)));
            long mjd2000Millis = calendar.getTimeInMillis();
            long days = mjd2000Millis / 86400000L;
            long seconds = (mjd2000Millis - days * 86400000L) / 1000L;
            return new UTC((int)days, (int)seconds, (int)micros);
        }

        public static Calendar createCalendar() {
            Calendar calendar = GregorianCalendar.getInstance(UTC_TIME_ZONE, Locale.ENGLISH);
            calendar.clear();
            calendar.set(2000, 0, 1);
            return calendar;
        }

        public static DateFormat createDateFormat() {
            return UTC.createDateFormat(DATE_FORMAT_PATTERN);
        }

        public static DateFormat createDateFormat(String pattern) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
            dateFormat.setCalendar(UTC.createCalendar());
            return dateFormat;
        }

        public static UTC parse(String text) throws ParseException {
            return UTC.parse(text, DATE_FORMAT_PATTERN);
        }

        public static UTC parse(String text, String pattern) throws ParseException {
            return UTC.parse(text, UTC.createDateFormat(pattern));
        }

        public static UTC parse(String text, DateFormat dateFormat) throws ParseException {
            Guardian.assertNotNullOrEmpty("text", text);
            Guardian.assertNotNull("dateFormat", dateFormat);
            int dotPos = text.lastIndexOf(".");
            String noFractionString = text;
            long micros = 0L;
            if (dotPos > 0) {
                noFractionString = text.substring(0, dotPos);
                String fractionString = text.substring(dotPos + 1, text.length());
                if (fractionString.length() > 6) {
                    throw new ParseException("Unparseable date:" + text, dotPos);
                }
                try {
                    micros = Integer.parseInt(fractionString);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unparseable date:" + text, dotPos);
                }
                for (int i = fractionString.length(); i < 6; ++i) {
                    micros *= 10L;
                }
            }
            Date date = dateFormat.parse(noFractionString);
            return UTC.create(date, micros);
        }

        public String format() {
            Calendar calendar = UTC.createCalendar();
            calendar.add(5, this.getDaysFraction());
            calendar.add(13, (int)this.getSecondsFraction());
            DateFormat dateFormat = UTC.createDateFormat();
            Date time = calendar.getTime();
            String dateString = dateFormat.format(time);
            String microsString = String.valueOf(this.getMicroSecondsFraction());
            StringBuffer sb = new StringBuffer(dateString.toUpperCase());
            sb.append('.');
            for (int i = microsString.length(); i < 6; ++i) {
                sb.append('0');
            }
            sb.append(microsString);
            return sb.toString();
        }

        @Override
        public String getElemString() {
            return this.format();
        }

        @Override
        protected ProductData createDeepClone() {
            UTC data = new UTC();
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public String getTypeString() {
            return UTC.getTypeString(51);
        }

        public Calendar getAsCalendar() {
            Calendar calendar = UTC.createCalendar();
            calendar.add(5, this.getDaysFraction());
            calendar.add(13, (int)this.getSecondsFraction());
            calendar.add(14, (int)Math.round((double)this.getMicroSecondsFraction() / 1000.0));
            return calendar;
        }

        public Date getAsDate() {
            return this.getAsCalendar().getTime();
        }

        public double getMJD() {
            return (double)this.getDaysFraction() + 1.1574074074074073E-5 * ((double)this.getSecondsFraction() + 1.0E-6 * (double)this.getMicroSecondsFraction());
        }

        public int getDaysFraction() {
            return this.getElemIntAt(0);
        }

        public long getSecondsFraction() {
            return this.getElemIntAt(1);
        }

        public long getMicroSecondsFraction() {
            return this.getElemIntAt(2);
        }
    }

    public static class ASCII
    extends Byte {
        public ASCII(int length) {
            super(length, 41);
        }

        public ASCII(String data) {
            super(data.getBytes(), 41);
        }

        @Override
        public String getElemString() {
            return new String(this._array);
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String && ((String)data).length() > 0) {
                this._array = ((String)data).getBytes();
            } else if (data instanceof char[] && ((char[])data).length > 0) {
                this._array = String.valueOf((char[])data).getBytes();
            } else if (data instanceof byte[] && ((byte[])data).length > 0) {
                this._array = (byte[])data;
            } else {
                throw new IllegalArgumentException("data is not an instance of String, char[] or byte[]or the length is less than one");
            }
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf((char)this._array[index]);
        }

        @Override
        protected ProductData createDeepClone() {
            ASCII data = new ASCII(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public String getTypeString() {
            return ASCII.getTypeString(41);
        }
    }

    public static class Double
    extends ProductData {
        protected double[] _array;

        public Double(double[] array) {
            super(31);
            this._array = array;
        }

        public Double(int numElems) {
            super(31);
            this._array = new double[numElems];
        }

        @Override
        protected ProductData createDeepClone() {
            Double data = new Double(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getNumElems() {
            return this._array.length;
        }

        @Override
        public int getElemIntAt(int index) {
            return (int)Math.round(this._array[index]);
        }

        @Override
        public long getElemUIntAt(int index) {
            return Math.round(this._array[index]);
        }

        @Override
        public float getElemFloatAt(int index) {
            return (float)this._array[index];
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this._array[index];
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this._array[index]);
        }

        @Override
        public void setElemIntAt(int index, int value) {
            this._array[index] = value;
        }

        @Override
        public void setElemUIntAt(int index, long value) {
            this._array[index] = value;
        }

        @Override
        public void setElemFloatAt(int index, float value) {
            this._array[index] = value;
        }

        @Override
        public void setElemDoubleAt(int index, double value) {
            this._array[index] = value;
        }

        public final double[] getArray() {
            return this._array;
        }

        @Override
        public Object getElems() {
            return this._array;
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    this._array[i] = java.lang.Double.parseDouble(strings[i]);
                }
                return;
            }
            if (!(data instanceof double[]) || ((double[])data).length != this.getNumElems()) {
                throw new IllegalArgumentException("data is not a double[" + this.getNumElems() + "]");
            }
            System.arraycopy(data, 0, this._array, 0, this.getNumElems());
        }

        @Override
        public void readFrom(int startPos, int numElems, ImageInputStream source) throws IOException {
            source.readFully(this._array, startPos, numElems);
        }

        @Override
        public void writeTo(int sourceStartPos, int numSourceElems, ImageOutputStream destination) throws IOException {
            destination.writeDoubles(this._array, sourceStartPos, numSourceElems);
        }

        @Override
        public void dispose() {
            this._array = null;
        }
    }

    public static class Float
    extends ProductData {
        protected float[] _array;

        public Float(float[] array) {
            super(30);
            this._array = array;
        }

        public Float(int numElems) {
            super(30);
            this._array = new float[numElems];
        }

        @Override
        protected ProductData createDeepClone() {
            Float data = new Float(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getNumElems() {
            return this._array.length;
        }

        @Override
        public int getElemIntAt(int index) {
            return Math.round(this._array[index]);
        }

        @Override
        public long getElemUIntAt(int index) {
            return Math.round(this._array[index]);
        }

        @Override
        public float getElemFloatAt(int index) {
            return this._array[index];
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this._array[index];
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this._array[index]);
        }

        @Override
        public void setElemIntAt(int index, int value) {
            this._array[index] = value;
        }

        @Override
        public void setElemUIntAt(int index, long value) {
            this._array[index] = value;
        }

        @Override
        public void setElemFloatAt(int index, float value) {
            this._array[index] = value;
        }

        @Override
        public void setElemDoubleAt(int index, double value) {
            this._array[index] = (float)value;
        }

        public final float[] getArray() {
            return this._array;
        }

        @Override
        public Object getElems() {
            return this._array;
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    this._array[i] = java.lang.Float.parseFloat(strings[i]);
                }
                return;
            }
            if (!(data instanceof float[]) || ((float[])data).length != this.getNumElems()) {
                throw new IllegalArgumentException("data is not a float[" + this.getNumElems() + "]");
            }
            System.arraycopy(data, 0, this._array, 0, this.getNumElems());
        }

        @Override
        public void readFrom(int startPos, int numElems, ImageInputStream source) throws IOException {
            source.readFully(this._array, startPos, numElems);
        }

        @Override
        public void writeTo(int sourceStartPos, int numSourceElems, ImageOutputStream destination) throws IOException {
            destination.writeFloats(this._array, sourceStartPos, numSourceElems);
        }

        @Override
        public boolean equalElems(ProductData other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Float) {
                return Arrays.equals(this._array, ((Float)other).getArray());
            }
            return false;
        }

        @Override
        public void dispose() {
            this._array = null;
        }
    }

    public static class UInt
    extends Int {
        public UInt(int numElems) {
            super(numElems, true);
        }

        public UInt(int[] array) {
            super(array, true);
        }

        protected UInt(long[] elems) {
            this(elems.length);
            for (int i = 0; i < elems.length; ++i) {
                this._array[i] = (int)elems[i];
            }
        }

        @Override
        protected ProductData createDeepClone() {
            UInt data = new UInt(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index];
        }

        @Override
        public long getElemUIntAt(int index) {
            return (long)this._array[index] & 0xFFFFFFFFL;
        }

        @Override
        public float getElemFloatAt(int index) {
            return this.getElemUIntAt(index);
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this.getElemUIntAt(index);
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemUIntAt(index));
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    long longValue = Long.parseLong(strings[i]);
                    if (longValue > 0xFFFFFFFFL || longValue < 0L) {
                        throw new NumberFormatException("Value out of range. The value:'" + strings[i] + "' is not an unsigned int value.");
                    }
                    this._array[i] = (int)longValue;
                }
                return;
            }
            super.setElems(data);
        }
    }

    public static class Int
    extends ProductData {
        protected int[] _array;

        public Int(int numElems) {
            this(numElems, false);
        }

        protected Int(int numElems, boolean unsigned) {
            this(new int[numElems], unsigned);
        }

        public Int(int[] array) {
            this(array, false);
        }

        protected Int(int[] array, boolean unsigned) {
            super(unsigned ? 22 : 12);
            this._array = array;
        }

        @Override
        protected ProductData createDeepClone() {
            Int data = new Int(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getNumElems() {
            return this._array.length;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index];
        }

        @Override
        public long getElemUIntAt(int index) {
            return this._array[index];
        }

        @Override
        public float getElemFloatAt(int index) {
            return this._array[index];
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this._array[index];
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemIntAt(index));
        }

        @Override
        public void setElemIntAt(int index, int value) {
            this._array[index] = value;
        }

        @Override
        public void setElemUIntAt(int index, long value) {
            this._array[index] = (int)value;
        }

        @Override
        public void setElemFloatAt(int index, float value) {
            this._array[index] = Math.round(value);
        }

        @Override
        public void setElemDoubleAt(int index, double value) {
            this._array[index] = (int)Math.round(value);
        }

        public final int[] getArray() {
            return this._array;
        }

        @Override
        public Object getElems() {
            return this._array;
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    this._array[i] = Integer.parseInt(strings[i]);
                }
                return;
            }
            if (!(data instanceof int[]) || ((int[])data).length != this.getNumElems()) {
                throw new IllegalArgumentException("data is not an int[" + this.getNumElems() + "]");
            }
            System.arraycopy(data, 0, this._array, 0, this.getNumElems());
        }

        @Override
        public void readFrom(int startPos, int numElems, ImageInputStream source) throws IOException {
            source.readFully(this._array, startPos, numElems);
        }

        @Override
        public void writeTo(int sourceStartPos, int numSourceElems, ImageOutputStream destination) throws IOException {
            destination.writeInts(this._array, sourceStartPos, numSourceElems);
        }

        @Override
        public void dispose() {
            this._array = null;
        }
    }

    public static class UShort
    extends Short {
        public UShort(int numElems) {
            super(numElems, true);
        }

        public UShort(short[] array) {
            super(array, true);
        }

        @Override
        protected ProductData createDeepClone() {
            UShort data = new UShort(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index] & 0xFFFF;
        }

        @Override
        public long getElemUIntAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public float getElemFloatAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemIntAt(index));
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    int intValue = Integer.parseInt(strings[i]);
                    if (intValue > 65535 || intValue < 0) {
                        throw new NumberFormatException("Value out of range. The value:'" + strings[i] + "' is not an unsigned short value.");
                    }
                    this._array[i] = (short)intValue;
                }
                return;
            }
            super.setElems(data);
        }
    }

    public static class Short
    extends ProductData {
        protected short[] _array;

        public Short(int numElems) {
            this(numElems, false);
        }

        protected Short(int numElems, boolean unsigned) {
            this(new short[numElems], unsigned);
        }

        public Short(short[] array) {
            this(array, false);
        }

        protected Short(short[] array, boolean unsigned) {
            super(unsigned ? 21 : 11);
            this._array = array;
        }

        @Override
        protected ProductData createDeepClone() {
            Short data = new Short(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getNumElems() {
            return this._array.length;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index];
        }

        @Override
        public long getElemUIntAt(int index) {
            return this._array[index];
        }

        @Override
        public float getElemFloatAt(int index) {
            return this._array[index];
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this._array[index];
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemIntAt(index));
        }

        @Override
        public void setElemIntAt(int index, int value) {
            this._array[index] = (short)value;
        }

        @Override
        public void setElemUIntAt(int index, long value) {
            this._array[index] = (short)value;
        }

        @Override
        public void setElemFloatAt(int index, float value) {
            this._array[index] = (short)Math.round(value);
        }

        @Override
        public void setElemDoubleAt(int index, double value) {
            this._array[index] = (short)Math.round(value);
        }

        public final short[] getArray() {
            return this._array;
        }

        @Override
        public Object getElems() {
            return this._array;
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    this._array[i] = java.lang.Short.parseShort(strings[i]);
                }
                return;
            }
            if (!(data instanceof short[]) || ((short[])data).length != this.getNumElems()) {
                throw new IllegalArgumentException("data is not a short[" + this.getNumElems() + "]");
            }
            System.arraycopy(data, 0, this._array, 0, this.getNumElems());
        }

        @Override
        public void readFrom(int startPos, int numElems, ImageInputStream source) throws IOException {
            source.readFully(this._array, startPos, numElems);
        }

        @Override
        public void writeTo(int sourceStartPos, int numSourceElems, ImageOutputStream destination) throws IOException {
            destination.writeShorts(this._array, sourceStartPos, numSourceElems);
        }

        @Override
        public void dispose() {
            this._array = null;
        }
    }

    public static class UByte
    extends Byte {
        public UByte(int numElems) {
            super(numElems, true);
        }

        public UByte(byte[] array) {
            super(array, true);
        }

        @Override
        protected ProductData createDeepClone() {
            UByte data = new UByte(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index] & 0xFF;
        }

        @Override
        public long getElemUIntAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public float getElemFloatAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this.getElemIntAt(index);
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemIntAt(index));
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    short shortValue = java.lang.Short.parseShort(strings[i]);
                    if (shortValue > 255 || shortValue < 0) {
                        throw new NumberFormatException("Value out of range. The value:'" + strings[i] + "' is not an unsigned byte value.");
                    }
                    this._array[i] = (byte)shortValue;
                }
                return;
            }
            super.setElems(data);
        }
    }

    public static class Byte
    extends ProductData {
        protected byte[] _array;

        public Byte(int numElems) {
            this(numElems, false);
        }

        public Byte(byte[] array) {
            this(array, false);
        }

        protected Byte(int numElems, int type) {
            super(type);
            this._array = new byte[numElems];
        }

        protected Byte(int numElems, boolean unsigned) {
            this(new byte[numElems], unsigned);
        }

        protected Byte(byte[] array, boolean unsigned) {
            this(array, unsigned ? 20 : 10);
        }

        protected Byte(byte[] array, int type) {
            super(type);
            this._array = array;
        }

        @Override
        protected ProductData createDeepClone() {
            Byte data = new Byte(this._array.length);
            System.arraycopy(this._array, 0, data._array, 0, this._array.length);
            return data;
        }

        @Override
        public int getNumElems() {
            return this._array.length;
        }

        @Override
        public int getElemIntAt(int index) {
            return this._array[index];
        }

        @Override
        public long getElemUIntAt(int index) {
            return this._array[index];
        }

        @Override
        public float getElemFloatAt(int index) {
            return this._array[index];
        }

        @Override
        public double getElemDoubleAt(int index) {
            return this._array[index];
        }

        @Override
        public String getElemStringAt(int index) {
            return String.valueOf(this.getElemIntAt(index));
        }

        @Override
        public void setElemIntAt(int index, int value) {
            this._array[index] = (byte)value;
        }

        @Override
        public void setElemUIntAt(int index, long value) {
            this._array[index] = (byte)value;
        }

        @Override
        public void setElemFloatAt(int index, float value) {
            this._array[index] = (byte)Math.round(value);
        }

        @Override
        public void setElemDoubleAt(int index, double value) {
            this._array[index] = (byte)Math.round(value);
        }

        public final byte[] getArray() {
            return this._array;
        }

        @Override
        public Object getElems() {
            return this._array;
        }

        @Override
        public void setElems(Object data) {
            Guardian.assertNotNull("data", data);
            if (data instanceof String[] && ((String[])data).length == this.getNumElems()) {
                String[] strings = (String[])data;
                for (int i = 0; i < this.getNumElems(); ++i) {
                    this._array[i] = java.lang.Byte.parseByte(strings[i]);
                }
                return;
            }
            if (!(data instanceof byte[]) || ((byte[])data).length != this.getNumElems()) {
                throw new IllegalArgumentException("data is not a byte[" + this.getNumElems() + "]");
            }
            System.arraycopy(data, 0, this._array, 0, this.getNumElems());
        }

        @Override
        public void readFrom(int startPos, int numElems, ImageInputStream source) throws IOException {
            source.readFully(this._array, startPos, numElems);
        }

        @Override
        public void writeTo(int sourceStartPos, int numSourceElems, ImageOutputStream destination) throws IOException {
            destination.write(this._array, sourceStartPos, numSourceElems);
        }

        public Object clone() {
            Byte c = new Byte(this.getNumElems(), this.isUnsigned());
            c.setElems(this.getElems());
            return c;
        }

        @Override
        public void dispose() {
            this._array = null;
        }
    }
}

